/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.apache.commons.discovery.tools;

import com.bmc.thirdparty.org.apache.commons.discovery.jdk.JDKHooks;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class ManagedProperties {
    private static final HashMap propertiesCache = new HashMap();

    public static String getProperty(String propertyName) {
        return ManagedProperties.getProperty(ManagedProperties.getThreadContextClassLoader(), propertyName);
    }

    public static String getProperty(String propertyName, String dephault) {
        return ManagedProperties.getProperty(ManagedProperties.getThreadContextClassLoader(), propertyName, dephault);
    }

    public static String getProperty(ClassLoader classLoader, String propertyName) {
        Value val;
        String value = System.getProperty(propertyName);
        if (value == null && (val = ManagedProperties.getValueProperty(classLoader, propertyName)) != null) {
            value = val.value;
        }
        return value;
    }

    public static String getProperty(ClassLoader classLoader, String propertyName, String dephault) {
        String value = ManagedProperties.getProperty(classLoader, propertyName);
        return value == null ? dephault : value;
    }

    public static void setProperty(String propertyName, String value) {
        ManagedProperties.setProperty(propertyName, value, false);
    }

    public static void setProperty(String propertyName, String value, boolean isDefault) {
        if (propertyName != null) {
            HashMap hashMap = propertiesCache;
            synchronized (hashMap) {
                ClassLoader classLoader = ManagedProperties.getThreadContextClassLoader();
                HashMap<String, Value> properties = (HashMap<String, Value>)propertiesCache.get(classLoader);
                if (value == null) {
                    properties.remove(propertyName);
                } else {
                    if (properties == null) {
                        properties = new HashMap<String, Value>();
                        propertiesCache.put(classLoader, properties);
                    }
                    properties.put(propertyName, new Value(value, isDefault));
                }
            }
        }
    }

    public static void setProperties(Map newProperties) {
        ManagedProperties.setProperties(newProperties, false);
    }

    public static void setProperties(Map newProperties, boolean isDefault) {
        Iterator it = newProperties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ManagedProperties.setProperty(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()), isDefault);
        }
    }

    public static Enumeration propertyNames() {
        Hashtable allProps = new Hashtable();
        ClassLoader classLoader = ManagedProperties.getThreadContextClassLoader();
        while (true) {
            HashMap properties = null;
            HashMap hashMap = propertiesCache;
            synchronized (hashMap) {
                properties = (HashMap)propertiesCache.get(classLoader);
            }
            if (properties != null) {
                allProps.putAll(properties);
            }
            if (classLoader == null) break;
            classLoader = ManagedProperties.getParent(classLoader);
        }
        return allProps.keys();
    }

    public static Properties getProperties() {
        Properties p = new Properties();
        Enumeration names = ManagedProperties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            ((Hashtable)p).put(name, ManagedProperties.getProperty(name));
        }
        return p;
    }

    private static final Value getValueProperty(ClassLoader classLoader, String propertyName) {
        Value value = null;
        if (propertyName != null) {
            if (classLoader != null) {
                value = ManagedProperties.getValueProperty(ManagedProperties.getParent(classLoader), propertyName);
            }
            if (value == null || value.isDefault) {
                HashMap hashMap = propertiesCache;
                synchronized (hashMap) {
                    Value altValue;
                    HashMap properties = (HashMap)propertiesCache.get(classLoader);
                    if (properties != null && (altValue = (Value)properties.get(propertyName)) != null) {
                        value = altValue;
                    }
                }
            }
        }
        return value;
    }

    private static final ClassLoader getThreadContextClassLoader() {
        return JDKHooks.getJDKHooks().getThreadContextClassLoader();
    }

    private static final ClassLoader getParent(final ClassLoader classLoader) {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return classLoader.getParent();
            }
        });
    }

    private static class Value {
        final String value;
        final boolean isDefault;

        Value(String value, boolean isDefault) {
            this.value = value;
            this.isDefault = isDefault;
        }
    }
}

