/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.apache.commons.discovery.jdk;

import com.bmc.thirdparty.org.apache.commons.discovery.jdk.JDKHooks;
import com.bmc.thirdparty.org.apache.commons.discovery.jdk.PsuedoSystemClassLoader;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;

class JDK11Hooks
extends JDKHooks {
    private static final ClassLoader systemClassLoader = new PsuedoSystemClassLoader();

    JDK11Hooks() {
    }

    public ClassLoader getThreadContextClassLoader() {
        return null;
    }

    public ClassLoader getSystemClassLoader() {
        return systemClassLoader;
    }

    public Enumeration getResources(ClassLoader loader, String resourceName) throws IOException {
        final URL first = loader.getResource(resourceName);
        final Enumeration<URL> rest = loader.getResources(resourceName);
        return new Enumeration(){
            private boolean firstDone;
            private URL next;
            {
                this.firstDone = first == null;
                this.next = this.getNext();
            }

            public Object nextElement() {
                URL o = this.next;
                this.next = this.getNext();
                return o;
            }

            public boolean hasMoreElements() {
                return this.next != null;
            }

            private URL getNext() {
                URL n;
                if (!this.firstDone) {
                    this.firstDone = true;
                    n = first;
                } else {
                    n = null;
                    while (rest.hasMoreElements() && n == null) {
                        n = (URL)rest.nextElement();
                        if (first == null || n == null || !n.equals(first)) continue;
                        n = null;
                    }
                }
                return n;
            }
        };
    }
}

