/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.wsdlgen;

import com.bmc.arsys.ws.mapping.ARSMapping;
import com.bmc.arsys.ws.util.WsdlUtil;
import com.bmc.arsys.ws.wsdlgen.WsdlGenerator;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LiteralTypesGenerator {
    protected HashMap<String, Element> complexTypesHash = new HashMap();
    protected HashMap<String, Element> enumHash = new HashMap();
    protected Document typesDocumentHolder = null;
    protected Element wsdlTypesElem = null;
    protected Element schemaElem = null;
    protected String targetNamespace = null;
    protected String prefix = null;

    public LiteralTypesGenerator(String targetNamespace, String prefix) {
        this.targetNamespace = targetNamespace;
        this.prefix = prefix;
        this.typesDocumentHolder = WsdlUtil.newDocument();
        this.wsdlTypesElem = this.typesDocumentHolder.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:types");
        this.schemaElem = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:schema");
        this.wsdlTypesElem.appendChild(this.schemaElem);
        this.schemaElem.setAttributeNS(null, "targetNamespace", targetNamespace);
        this.schemaElem.setAttributeNS(null, "elementFormDefault", "qualified");
    }

    public Element getTypesElement() {
        return this.wsdlTypesElem;
    }

    public void writeTopLevelElement(String topElement, ARSMapping mapping) {
        Element elem = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:element");
        this.schemaElem.appendChild(elem);
        elem.setAttributeNS("http://www.w3.org/2001/XMLSchema", "name", topElement);
        elem.setAttributeNS("http://www.w3.org/2001/XMLSchema", "type", this.prefix + ":" + mapping.getName());
        this.writeMappingGlobalComplexType(mapping.getMappingElement(), mapping.getName());
    }

    protected Element writeLinkedTopLevelElement(String topElement, ARSMapping mapping, HashMap nsPrefixMap) {
        Element topElem = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:element");
        this.schemaElem.appendChild(topElem);
        topElem.setAttributeNS("http://www.w3.org/2001/XMLSchema", "name", topElement);
        if (mapping.getMappingMode() == 3) {
            String nsPrefix = (String)nsPrefixMap.get(mapping.getExternalNamespace());
            topElem.setAttributeNS(mapping.getExternalNamespace(), "type", nsPrefix + ":" + mapping.getExternalGlobalName());
            return null;
        }
        topElem.setAttributeNS("http://www.w3.org/2001/XMLSchema", "type", this.prefix + ":" + mapping.getName());
        Element complexElem = this.complexTypesHash.get(mapping.getName());
        if (complexElem != null) {
            return complexElem;
        }
        complexElem = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:complexType");
        complexElem.setAttributeNS("http://www.w3.org/2001/XMLSchema", "name", mapping.getName());
        this.schemaElem.appendChild(complexElem);
        this.complexTypesHash.put(mapping.getName(), complexElem);
        Element sequenceElem = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:sequence");
        complexElem.appendChild(sequenceElem);
        for (Node node = ARSMapping.skipToFirstMappingElement(mapping.getMappingElement(), true); node != null; node = node.getNextSibling()) {
            Element childElem;
            if (node.getNodeType() != 1 || !(childElem = node).getLocalName().equals("element")) continue;
            String namespaceURI = childElem.getAttribute("targetNamespace");
            String nsPrefix = (String)nsPrefixMap.get(namespaceURI);
            Element elem = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:element");
            elem.setAttributeNS("http://www.w3.org/2001/XMLSchema", "ref", nsPrefix + ":" + childElem.getAttribute("name"));
            sequenceElem.appendChild(elem);
        }
        return complexElem;
    }

    protected Element writeMappingGlobalComplexType(Element mappingElem, String name) {
        Element complexElem = this.complexTypesHash.get(name);
        if (complexElem == null) {
            complexElem = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:complexType");
            complexElem.setAttributeNS("http://www.w3.org/2001/XMLSchema", "name", name);
            this.schemaElem.appendChild(complexElem);
            this.complexTypesHash.put(name, complexElem);
            this.addChildrenToComplexElem(complexElem, null, mappingElem);
        }
        return complexElem;
    }

    protected Element writeMappingComplexType(Element mappingElem) {
        Element complexElem = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:complexType");
        Element parentElement = this.writeParentElem(complexElem, mappingElem);
        this.addChildrenToComplexElem(complexElem, parentElement, mappingElem);
        return complexElem;
    }

    protected Element writeAuthenticationElem() {
        Element elem = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:element");
        this.schemaElem.appendChild(elem);
        elem.setAttributeNS("http://www.w3.org/2001/XMLSchema", "name", WsdlGenerator.AUTH_ELEMENT_NAME);
        elem.setAttributeNS("http://www.w3.org/2001/XMLSchema", "type", this.prefix + ":" + WsdlGenerator.AUTH_TYPE_NAME);
        this.writeAuthenticationType();
        return elem;
    }

    protected Element writeAuthenticationType() {
        Element complexElem = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:complexType");
        complexElem.setAttributeNS("http://www.w3.org/2001/XMLSchema", "name", WsdlGenerator.AUTH_ELEMENT_NAME);
        this.schemaElem.appendChild(complexElem);
        Element sequenceElem = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:sequence");
        complexElem.appendChild(sequenceElem);
        this.addAuthenticationElement(sequenceElem, "userName", true);
        this.addAuthenticationElement(sequenceElem, "password", true);
        this.addAuthenticationElement(sequenceElem, "authentication", false);
        this.addAuthenticationElement(sequenceElem, "locale", false);
        this.addAuthenticationElement(sequenceElem, "timeZone", false);
        this.complexTypesHash.put(WsdlGenerator.AUTH_ELEMENT_NAME, complexElem);
        return complexElem;
    }

    protected void addAuthenticationElement(Element sequenceElem, String name, boolean required) {
        String type = "string";
        Element elem = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:element");
        elem.setAttributeNS("http://www.w3.org/2001/XMLSchema", "name", name);
        elem.setAttributeNS("http://www.w3.org/2001/XMLSchema", "type", "xsd:" + type);
        if (!required) {
            elem.setAttributeNS("http://www.w3.org/2001/XMLSchema", "minOccurs", "0");
        }
        sequenceElem.appendChild(elem);
    }

    protected void addOtherAttributes(Element mappingElem, Element elem) {
        if (mappingElem.getLocalName().equals("element")) {
            String defaultVal;
            String nillable;
            String maxOccurs;
            String minOccurs = mappingElem.getAttribute("minOccurs");
            if (minOccurs != null && !minOccurs.equals("") && !minOccurs.equals("1")) {
                elem.setAttributeNS("http://www.w3.org/2001/XMLSchema", "minOccurs", minOccurs);
            }
            if ((maxOccurs = mappingElem.getAttribute("maxOccurs")) != null && !maxOccurs.equals("") && !maxOccurs.equals("1")) {
                elem.setAttributeNS("http://www.w3.org/2001/XMLSchema", "maxOccurs", maxOccurs);
            }
            if ((nillable = mappingElem.getAttribute("nillable")) != null && (nillable.equals("1") || nillable.equals("true") || nillable.equals("True"))) {
                elem.setAttributeNS("http://www.w3.org/2001/XMLSchema", "nillable", "true");
            }
            if ((defaultVal = mappingElem.getAttribute("default")) != null && !defaultVal.equals("") && minOccurs.equals("0")) {
                elem.setAttributeNS("http://www.w3.org/2001/XMLSchema", "default", defaultVal);
            }
        } else if (mappingElem.getLocalName().equals("attribute")) {
            String defaultVal;
            String use = mappingElem.getAttribute("use");
            if (use != null && !use.equals("") && !use.equals("1")) {
                elem.setAttributeNS("http://www.w3.org/2001/XMLSchema", "use", use);
            }
            if ((defaultVal = mappingElem.getAttribute("default")) != null && !defaultVal.equals("") && !use.equals("required")) {
                elem.setAttributeNS("http://www.w3.org/2001/XMLSchema", "default", defaultVal);
            }
        }
    }

    protected Element writeMappingGlobalEnumType(Element mappingElem) {
        String enumValues = mappingElem.getAttribute("enumValues");
        Element enumSimpleType = this.enumHash.get(enumValues);
        if (enumSimpleType == null) {
            Element restriction = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:restriction");
            restriction.setAttributeNS("http://www.w3.org/2001/XMLSchema", "base", "xsd:string");
            StringTokenizer tokenizer = new StringTokenizer(enumValues, ",", false);
            while (tokenizer.hasMoreTokens()) {
                Element enumeration = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:enumeration");
                enumeration.setAttributeNS("http://www.w3.org/2001/XMLSchema", "value", tokenizer.nextToken());
                restriction.appendChild(enumeration);
            }
            enumSimpleType = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:simpleType");
            enumSimpleType.appendChild(restriction);
            enumSimpleType.setAttributeNS("http://www.w3.org/2001/XMLSchema", "name", mappingElem.getAttribute("name") + "Type");
            this.schemaElem.appendChild(enumSimpleType);
            this.enumHash.put(enumValues, enumSimpleType);
        }
        return enumSimpleType;
    }

    protected Element writeParentElem(Element complexElem, Element mappingElem) {
        Element parentElement = null;
        String all = mappingElem.getAttribute("all");
        parentElement = all != null && all.equals("true") ? this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:all") : this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:sequence");
        complexElem.appendChild(parentElement);
        return parentElement;
    }

    protected void addChildrenToComplexElem(Element complexElem, Element parentElement, Element mappingElem) {
        if (parentElement == null) {
            parentElement = this.writeParentElem(complexElem, mappingElem);
        }
        NodeList childNodes = mappingElem.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Element elem = null;
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element childElem = (Element)node;
            if (!childElem.getAttribute("name").equals("ROOT")) {
                if (childElem.getLocalName().equals("element")) {
                    elem = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:element");
                    elem.setAttributeNS("http://www.w3.org/2001/XMLSchema", "name", childElem.getAttribute("name"));
                    this.addOtherAttributes(childElem, elem);
                    parentElement.appendChild(elem);
                    this.writeMappingElement(elem, childElem);
                    continue;
                }
                if (childElem.getLocalName().equals("attribute")) {
                    elem = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:attribute");
                    elem.setAttributeNS("http://www.w3.org/2001/XMLSchema", "name", childElem.getAttribute("name"));
                    this.addOtherAttributes(childElem, elem);
                    complexElem.appendChild(elem);
                    this.writeMappingElement(elem, childElem);
                    continue;
                }
                if (childElem.getLocalName().equals("choice")) {
                    elem = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:choice");
                    parentElement.appendChild(elem);
                    this.addChildrenToComplexElem(complexElem, elem, childElem);
                    continue;
                }
            }
            this.addChildrenToComplexElem(complexElem, parentElement, childElem);
        }
    }

    protected void writeMappingElement(Element typesElem, Element mappingElem) {
        String type = mappingElem.getAttribute("dataType");
        String complexType = mappingElem.getAttribute("complexType");
        if (complexType != null && !complexType.equals("")) {
            this.writeMappingGlobalComplexType(mappingElem, complexType);
            typesElem.setAttributeNS("http://www.w3.org/2001/XMLSchema", "type", this.prefix + ":" + complexType);
        } else if (type == null || type.equals("")) {
            typesElem.appendChild(this.writeMappingComplexType(mappingElem));
        } else if (mappingElem.getAttribute("enumValues") != null && !mappingElem.getAttribute("enumValues").equals("")) {
            Element enumSimpleType = this.writeMappingGlobalEnumType(mappingElem);
            typesElem.setAttributeNS("http://www.w3.org/2001/XMLSchema", "type", this.prefix + ":" + enumSimpleType.getAttribute("name"));
        } else {
            typesElem.setAttributeNS("http://www.w3.org/2001/XMLSchema", "type", "xsd:" + type);
        }
    }

    public void createImports(HashMap externalNamespaces, boolean isLinked) {
        HashMap<String, String> uniqueNamespaces = new HashMap<String, String>();
        for (String uri : externalNamespaces.keySet()) {
            String namespace = (String)externalNamespaces.get(uri);
            if (namespace.equals(this.targetNamespace) || !isLinked && uniqueNamespaces.get(namespace) != null) continue;
            uniqueNamespaces.put(namespace, "");
            Element importElem = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:import");
            importElem.setAttributeNS("http://www.w3.org/2001/XMLSchema", "namespace", namespace);
            if (isLinked) {
                importElem.setAttributeNS("http://www.w3.org/2001/XMLSchema", "schemaLocation", uri);
            }
            this.schemaElem.insertBefore(importElem, this.schemaElem.getFirstChild());
        }
    }
}

