/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.report.schedule;

import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.plugins.report.schedule.Schedule;
import com.bmc.arsys.plugins.report.schedule.ScheduleJob;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;

public class Scheduler {
    public static Date calculateNextRun(ScheduleJob job, ARPluginContext context, ARPluginInfo pluginInfo) throws ParseException {
        int type = job.getType();
        switch (type) {
            case 0: {
                Calendar cal = Calendar.getInstance();
                cal.setTime(job.getStart());
                return cal.getTime();
            }
            case 1: {
                job.setHours(Scheduler.getHoursOfDay(job));
                return Scheduler.getNextTimeByMinute(job, context, pluginInfo).getTime();
            }
            case 2: {
                job.setHours(Scheduler.getHoursOfDay(job));
                return Scheduler.getNextTimeHourly(job, context, pluginInfo).getTime();
            }
            case 3: {
                return Scheduler.getNextTimeDaily(job, context, pluginInfo);
            }
            case 4: {
                return Scheduler.getNextTimeWeekly(job, context, pluginInfo);
            }
            case 5: {
                return Scheduler.getNextTimeMonthly(job, context, pluginInfo);
            }
        }
        return null;
    }

    public static int[] parseDays(String buf, ARPluginContext context, ARPluginInfo pluginInfo) throws ParseException {
        int[] days = null;
        int i = 0;
        if (buf == null) {
            context.logMessage(pluginInfo, 0, "ParseDays: buf was null");
            return new int[0];
        }
        StringTokenizer st = new StringTokenizer(buf.trim(), "-");
        String[] items = new String[st.countTokens()];
        while (st.hasMoreTokens()) {
            items[i] = st.nextToken().trim();
            ++i;
        }
        days = new int[items.length];
        for (i = 0; i < items.length; ++i) {
            days[i] = Integer.parseInt(items[i]);
        }
        return days;
    }

    public static final String displayIntArray(int[] array) {
        if (array == null) {
            return "";
        }
        StringBuffer tmp = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            tmp.append(array[i]);
            tmp.append(" ");
        }
        return tmp.toString();
    }

    private static Date getNextTimeDaily(ScheduleJob job, ARPluginContext context, ARPluginInfo pluginInfo) throws ParseException {
        if (job.getType() != 3) {
            throw new ParseException("schedule is not daily", -1);
        }
        Calendar now = Calendar.getInstance();
        Calendar cal = (Calendar)now.clone();
        Calendar next = null;
        Calendar start = Calendar.getInstance();
        start.setTime(job.getStart());
        if (job.getNextRun() != null) {
            next = (Calendar)now.clone();
            next.setTime(((Timestamp)job.getNextRun().getValue()).toDate());
        }
        if (next == null) {
            if (now.getTimeInMillis() < start.getTimeInMillis()) {
                cal.setTime(start.getTime());
            } else if (now.getTimeInMillis() > start.getTimeInMillis()) {
                cal = (Calendar)now.clone();
                Scheduler.resetTimeOnly(cal, job);
                if (cal.getTimeInMillis() < now.getTimeInMillis()) {
                    cal = Scheduler.getNextTimeDailyPart2(cal, job);
                }
            } else {
                cal = Scheduler.getNextTimeDailyPart2(start, job);
            }
        } else if (!job.isEscCall) {
            if (now.getTimeInMillis() < start.getTimeInMillis()) {
                cal.setTime(start.getTime());
            } else if (now.getTimeInMillis() > start.getTimeInMillis()) {
                cal = (Calendar)now.clone();
                Scheduler.resetTimeOnly(cal, job);
                if (cal.getTimeInMillis() < now.getTimeInMillis()) {
                    cal = Scheduler.getNextTimeDailyPart2(cal, job);
                }
            } else {
                cal = Scheduler.getNextTimeDailyPart2(start, job);
            }
        } else {
            cal = Scheduler.getNextTimeDailyPart2(next, job);
        }
        context.logMessage(pluginInfo, 0, "\nCollect time after adjustment is: " + now.getTime());
        return cal.getTime();
    }

    public static Calendar getNextTimeDailyPart2(Calendar cal, ScheduleJob job) {
        int days = new Integer((String)job.reccurParams.get("frequency"));
        cal.add(5, days);
        Scheduler.resetTimeOnly(cal, job);
        return cal;
    }

    private static Date getNextTimeWeekly(ScheduleJob job, ARPluginContext context, ARPluginInfo pluginInfo) throws ParseException {
        boolean useInitialTime;
        if (job.getType() != 4) {
            throw new ParseException("schedule is not weekly", -1);
        }
        Schedule alloc = Schedule.parse(3, new Integer((String)job.reccurParams.get("frequency")), null, Scheduler.parseDays((String)job.reccurParams.get("weekdays"), context, pluginInfo), null, null, null, job.getStart());
        Calendar next = null;
        Calendar cal = Calendar.getInstance();
        boolean bl = useInitialTime = job.getNextRun() == null;
        if (!useInitialTime) {
            Date nextrun = ((Timestamp)job.getNextRun().getValue()).toDate();
            Date now = new Date();
            if (nextrun.getTime() > now.getTime()) {
                useInitialTime = true;
            }
        }
        if (!job.isEscCall) {
            cal.setTime(alloc.initializeScheduleTimes(useInitialTime));
        } else if (job.getNextRun() != null) {
            next = Calendar.getInstance();
            next.setTime(((Timestamp)job.getNextRun().getValue()).toDate());
            cal.setTime(alloc.getNextTime(next.getTime(), useInitialTime));
            Calendar now = Calendar.getInstance();
            if (cal.getTimeInMillis() < now.getTimeInMillis()) {
                cal.setTime(alloc.initializeScheduleTimes(useInitialTime));
            }
        } else {
            cal.setTime(alloc.initializeScheduleTimes(useInitialTime));
        }
        return cal.getTime();
    }

    private static Date getNextTimeMonthly(ScheduleJob job, ARPluginContext context, ARPluginInfo pluginInfo) throws ParseException {
        boolean useInitialTime;
        if (job.getType() != 5) {
            throw new ParseException("schedule is not monthly", -1);
        }
        Integer dayofMonth = null;
        String monthdaystr = (String)job.reccurParams.get("dayofmonth");
        if (monthdaystr != null) {
            dayofMonth = new Integer(monthdaystr);
        }
        Integer weekofMonth = null;
        String weekofMonthstr = (String)job.reccurParams.get("weekofmonth");
        if (weekofMonthstr != null) {
            weekofMonth = new Integer(weekofMonthstr);
        }
        Schedule alloc = Schedule.parse(4, new Integer((String)job.reccurParams.get("frequency")), null, Scheduler.parseDays((String)job.reccurParams.get("weekdays"), context, pluginInfo), weekofMonth, null, dayofMonth, job.getStart());
        Calendar next = null;
        Calendar cal = Calendar.getInstance();
        boolean bl = useInitialTime = job.getNextRun() == null;
        if (!useInitialTime) {
            Date nextrun = ((Timestamp)job.getNextRun().getValue()).toDate();
            Date now = new Date();
            if (nextrun.getTime() > now.getTime()) {
                useInitialTime = true;
            }
        }
        if (!job.isEscCall) {
            cal.setTime(alloc.initializeScheduleTimes(useInitialTime));
        } else if (job.getNextRun() != null) {
            next = Calendar.getInstance();
            next.setTime(((Timestamp)job.getNextRun().getValue()).toDate());
            cal.setTime(alloc.getNextTime(next.getTime(), useInitialTime));
            Calendar now = Calendar.getInstance();
            if (cal.getTimeInMillis() < now.getTimeInMillis()) {
                cal.setTime(alloc.initializeScheduleTimes(useInitialTime));
            }
        } else {
            cal.setTime(alloc.initializeScheduleTimes(useInitialTime));
        }
        return cal.getTime();
    }

    protected static void resetHourOfDay(Calendar cal, ScheduleJob job) {
        Calendar c = Calendar.getInstance();
        c.setTime(job.getStart());
        cal.set(11, c.get(11));
    }

    protected static void resetMinuteOfHour(Calendar cal, ScheduleJob job) {
        Calendar c = Calendar.getInstance();
        c.setTime(job.getStart());
        cal.set(12, c.get(12));
    }

    protected static void resetSecondOfMinute(Calendar cal, ScheduleJob job) {
        Calendar c = Calendar.getInstance();
        c.setTime(job.getStart());
        cal.set(13, c.get(13));
    }

    protected static void resetMinute(Calendar cal, ScheduleJob job) {
        Calendar c = Calendar.getInstance();
        c.setTime(job.getStart());
        cal.set(12, c.get(12));
    }

    private static void resetTimeOnly(Calendar cal, ScheduleJob job) {
        Scheduler.resetHourOfDay(cal, job);
        Scheduler.resetMinuteOfHour(cal, job);
        Scheduler.resetSecondOfMinute(cal, job);
    }

    private static Calendar getNextTimeByMinute(ScheduleJob job, ARPluginContext context, ARPluginInfo pluginInfo) throws ParseException {
        boolean useInitialTime;
        if (job.getType() != 1) {
            throw new ParseException("schedule is not daily", -1);
        }
        Schedule alloc = Schedule.parse(0, new Integer((String)job.reccurParams.get("frequency")), job.getHours(), Scheduler.parseDays((String)job.reccurParams.get("weekdays"), context, pluginInfo), null, null, null, job.getStart());
        Calendar next = null;
        Calendar cal = Calendar.getInstance();
        boolean bl = useInitialTime = job.getNextRun() == null;
        if (!useInitialTime) {
            Date nextrun = ((Timestamp)job.getNextRun().getValue()).toDate();
            Date now = new Date();
            if (nextrun.getTime() > now.getTime()) {
                useInitialTime = true;
            }
        }
        if (!job.isEscCall) {
            cal.setTime(alloc.initializeScheduleTimes(useInitialTime));
        } else if (job.getNextRun() != null) {
            next = Calendar.getInstance();
            next.setTime(((Timestamp)job.getNextRun().getValue()).toDate());
            cal.setTime(alloc.getNextTime(next.getTime(), useInitialTime));
            Calendar now = Calendar.getInstance();
            if (cal.getTimeInMillis() < now.getTimeInMillis()) {
                cal.setTime(alloc.initializeScheduleTimes(useInitialTime));
            }
        } else {
            cal.setTime(alloc.initializeScheduleTimes(useInitialTime));
        }
        return cal;
    }

    private static int[] getHoursOfDay(ScheduleJob job) throws ParseException {
        String hoursString = (String)job.reccurParams.get("hours");
        String[] stringHours = hoursString.split("-");
        if (stringHours.length == 0) {
            throw new ParseException("Specify hours for By-Minute and Hourly type schedules", -1);
        }
        int len = stringHours.length;
        int[] intHours = new int[len];
        for (int i = 0; i < len; ++i) {
            intHours[i] = Integer.parseInt(stringHours[i]);
        }
        return intHours;
    }

    private static Calendar getNextTimeHourly(ScheduleJob job, ARPluginContext context, ARPluginInfo pluginInfo) throws ParseException {
        boolean useInitialTime;
        if (job.getType() != 2) {
            throw new ParseException("schedule is not hourly", -1);
        }
        Schedule alloc = Schedule.parse(1, new Integer((String)job.reccurParams.get("frequency")), job.getHours(), Scheduler.parseDays((String)job.reccurParams.get("weekdays"), context, pluginInfo), null, null, null, job.getStart());
        Calendar next = null;
        Calendar cal = Calendar.getInstance();
        boolean bl = useInitialTime = job.getNextRun() == null;
        if (!useInitialTime) {
            Date nextrun = ((Timestamp)job.getNextRun().getValue()).toDate();
            Date now = new Date();
            if (nextrun.getTime() > now.getTime()) {
                useInitialTime = true;
            }
        }
        if (!job.isEscCall) {
            cal.setTime(alloc.initializeScheduleTimes(useInitialTime));
        } else if (job.getNextRun() != null) {
            next = Calendar.getInstance();
            next.setTime(((Timestamp)job.getNextRun().getValue()).toDate());
            cal.setTime(alloc.getNextTime(next.getTime(), useInitialTime));
            Calendar now = Calendar.getInstance();
            if (cal.getTimeInMillis() < now.getTimeInMillis()) {
                cal.setTime(alloc.initializeScheduleTimes(useInitialTime));
            }
        } else {
            cal.setTime(alloc.initializeScheduleTimes(useInitialTime));
        }
        return cal;
    }
}

