/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.report.schedule;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARNativeAuthenticationInfo;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.arreporting.ARDataStructure;
import com.bmc.arsys.arreporting.Utilities;
import com.bmc.arsys.plugins.report.schedule.ScheduleJob;
import com.bmc.arsys.plugins.report.schedule.Scheduler;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class ReportSchedulerPlugin
extends ARFilterAPIPlugin {
    private final ARPluginInfo pluginInfo = new ARPluginInfo("ARSYS.ARF.REPORTSCHEDULER", (ARPluggable)this);
    private final String serverName = "localhost";
    private ARServerUser serverUser = null;

    public List<Value> filterAPICall(ARPluginContext context, List<Value> inValues) throws ARException {
        if (inValues.size() == 0 || inValues.size() < 6) {
            return null;
        }
        this.initServerUser(context);
        Timestamp startTime = (Timestamp)inValues.get(0).getValue();
        String recurrence = (String)inValues.get(1).getValue();
        Timestamp nextRun = (Timestamp)inValues.get(2).getValue();
        Integer jobType = (Integer)inValues.get(3).getValue();
        Timestamp prevRun = (Timestamp)inValues.get(4).getValue();
        Timestamp endTime = (Timestamp)inValues.get(5).getValue();
        boolean escCall = false;
        if (inValues.size() == 7) {
            escCall = true;
        }
        if (startTime == null) {
            startTime = new Timestamp(Calendar.getInstance().getTimeInMillis() / 1000L);
        }
        ScheduleJob job = new ScheduleJob();
        job.isEscCall = escCall;
        ArrayList<String> arrList = ARDataStructure.processAsList(recurrence);
        if (arrList.size() > 0) {
            for (int i = 0; i < arrList.size(); ++i) {
                HashMap<String, String> map;
                String val = (String)arrList.get(i);
                if (val == null || val.length() <= 0 || (map = ARDataStructure.processAsMap(val)).size() <= 0) continue;
                Set keys = map.keySet();
                for (String key : keys) {
                    job.reccurParams.put(key, map.get(key));
                }
            }
        }
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(startTime.getValue() * 1000L);
        job.setStart(c.getTime());
        if (nextRun != null) {
            job.setNextRun(inValues.get(2));
        }
        if (prevRun != null) {
            job.setPreviousRun(inValues.get(4));
        }
        job.setType(jobType);
        context.logMessage(this.pluginInfo, 0, "Type=" + job.getType() + "\ndRecurrence=" + recurrence + " \nstartDate=" + job.getStart());
        ArrayList<Value> list = new ArrayList<Value>();
        try {
            Value val = new Value(new Timestamp(Scheduler.calculateNextRun(job, context, this.pluginInfo)));
            list.add(val);
            if (nextRun != null && escCall) {
                list.add(new Value(nextRun));
            } else {
                list.add(inValues.get(4));
            }
            if (endTime != null && ((Timestamp)val.getValue()).getValue() > endTime.getValue() || job.getType() == 0 && escCall) {
                list.add(new Value(1));
            } else {
                list.add(new Value(0));
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return list;
    }

    private void initServerUser(ARPluginContext context) throws ARException {
        context.logMessage(0, "initServerUser()");
        if (this.serverUser == null) {
            this.serverUser = new ARServerUser((ARNativeAuthenticationInfo)context, "", "localhost");
            int port = Utilities.getIntegerValue(context.getARConfigEntry("TCD-Specific-Port"));
            this.serverUser.setPort(port);
            int rpcnumber = Utilities.getIntegerValue(context.getARConfigEntry("Plugin-Loopback-RPC-Socket"));
            if (rpcnumber > 0) {
                this.serverUser.usePrivateRpcQueue(rpcnumber);
            }
            this.serverUser.setVUIType(1);
        }
        this.serverUser.setUserContext((ARNativeAuthenticationInfo)context);
    }
}

