/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.report;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.CoreFieldId;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.Form;
import com.bmc.arsys.api.FormCriteria;
import com.bmc.arsys.api.OperandType;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.arreporting.ARDataStructure;
import com.bmc.arsys.arreporting.ReportConstants;
import com.bmc.arsys.plugins.processors.ServerContext;
import com.bmc.arsys.plugins.report.PublishReport;
import com.bmc.arsys.plugins.report.ReportForms;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.api.script.element.IDataSource;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.OdaDataSource;

public class RunReport {
    private static String reportForm = null;
    private static String reportDefinitionForm = null;
    private static String publishReportFormName = null;
    private static final QualifierInfo reportTypeQualInfo = new QualifierInfo(new RelationalOperationInfo(1, new ArithmeticOrRelationalOperand(2000011), new ArithmeticOrRelationalOperand(new Value("Web"))));
    private String localeInReportForm = null;
    private String formInReportForm = null;
    private StringBuffer formattedString = new StringBuffer();
    private ARServerUser serverUser = null;
    private StringBuffer statusMessage = new StringBuffer();
    ARPluginContext context = null;
    int STATUS_PROCESSING = 1;
    int STATUS_COMPLETED = 2;
    int STATUS_FAILURE = 3;
    int status = this.STATUS_PROCESSING;
    private static final int STATUS = 7;
    private static final int RESULT = 90104;
    private static final int RESULT_STATUS = 90109;
    private static final int STATUS_MESSAGE = 90108;
    private static final ArithmeticOrRelationalOperand INSTANCE_ID_OP = new ArithmeticOrRelationalOperand(OperandType.FIELDID, ReportConstants.INSTANCE_ID.toInt());

    public RunReport(ARPluginContext context) {
        this.context = context;
    }

    private byte[] executeReport(String reportName, String runAsUser, String reportParams, String timezone, Integer exportOptions, String webURL, String externalQual, Integer overrideQuery, int maxEntries) throws EngineException, ARException {
        int i;
        ArrayList<String> arrList;
        byte[] reportFile;
        this.context.logMessage(0, "executeReport()");
        IReportEngine engine = ReportForms.getDelegator().getBirtEngine().getReportEngine();
        String libDir = ReportForms.getDelegator().getProperties().getProperty("birt.libraries.dir");
        if (libDir != null) {
            engine.getConfig().setResourcePath(libDir.replace('\\', '/') + "/" + this.serverUser.getServer());
        }
        if ((reportFile = this.getReport(this.serverUser, reportName)) == null) {
            this.statusMessage.append("Report design file is null. Please check the report name: " + reportName + " is correct and entry in Report and Report definition forms exists.");
            return null;
        }
        this.context.logMessage(0, "Found Report Design file - " + reportName);
        ByteArrayInputStream stream = new ByteArrayInputStream(reportFile);
        ByteArrayOutputStream reportStream = new ByteArrayOutputStream();
        IReportRunnable design = engine.openReportDesign((InputStream)stream);
        IDataSource dataSource = this.getDataSource(design);
        OdaDataSetHandle dataSet = null;
        for (Object objItem : design.getDesignHandle().getModuleHandle().getDataSets()) {
            OdaDataSetHandle item;
            if (!(objItem instanceof OdaDataSetHandle) || !"com.bmc.arsys.oda.runtime.dataSet".equals((item = (OdaDataSetHandle)objItem).getExtensionID())) continue;
            dataSet = item;
            break;
        }
        String beforeOpen = null;
        if (dataSet != null) {
            beforeOpen = dataSet.getBeforeOpen();
            try {
                if (beforeOpen != null && beforeOpen.length() > 0 && beforeOpen.indexOf("params[\"midTierURL\"]") != -1 && beforeOpen.substring(0, 10).indexOf("if(params[") == -1) {
                    dataSet.setBeforeOpen("if(params[\"midTierURL\"]!=null && params[\"midTierURL\"].value!=null)return;" + beforeOpen);
                }
            }
            catch (SemanticException smx) {
                this.context.logMessage(2, "SemanticException occured on OdaDataSetHandle - " + dataSet.toString());
            }
        }
        try {
            if (dataSource != null) {
                dataSource.setPrivateDriverProperty("user", this.serverUser.getUser());
                dataSource.setPrivateDriverProperty("server", this.serverUser.getServer());
                if (this.serverUser.getPassword() == null || this.serverUser.getPassword() != null && this.serverUser.getPassword().length() == 0) {
                    dataSource.setPrivateDriverProperty("password", "AR_BIRT_NULL_PASSWORD");
                } else {
                    dataSource.setPrivateDriverProperty("password", this.serverUser.getPassword());
                }
                dataSource.setPrivateDriverProperty("port", Integer.toString(this.serverUser.getPort()));
                dataSource.setPrivateDriverProperty("authentication", this.serverUser.getAuthentication());
                if (runAsUser != null && !runAsUser.trim().equals("")) {
                    dataSource.setPrivateDriverProperty("impersonatedUser", runAsUser);
                }
                if (this.localeInReportForm != null) {
                    dataSource.setPrivateDriverProperty("locale", this.localeInReportForm);
                } else {
                    String locale = this.serverUser.getLocale();
                    if (locale == null || locale.length() == 0) {
                        locale = "en_US";
                    }
                    dataSource.setPrivateDriverProperty("locale", locale);
                }
                if (timezone != null) {
                    dataSource.setPrivateDriverProperty("timezone", timezone);
                }
            }
        }
        catch (ScriptException ex) {
            this.context.logMessage(2, "ScriptException occured on IDataSource - " + dataSource.toString());
            this.appendException(ex);
            return null;
        }
        IRunAndRenderTask task = engine.createRunAndRenderTask(design);
        task.getAppContext().put("PARENT_CLASSLOADER", PublishReport.class.getClassLoader());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("form", this.formInReportForm);
        hashMap.put("overrideQualification", overrideQuery != null ? overrideQuery : 0);
        hashMap.put("qualification", externalQual);
        hashMap.put("maxEntriesInFileReport", new Integer(maxEntries));
        this.context.logMessage(0, "Setting max Entries in a Report file to  - " + maxEntries);
        task.getAppContext().put("AR_SYSTEM_APP_CONTEXT", hashMap);
        if (reportParams != null && reportParams.length() > 0 && (arrList = ARDataStructure.processAsList(reportParams)).size() > 0) {
            for (i = 0; i < arrList.size(); ++i) {
                HashMap<String, String> map;
                String val = (String)arrList.get(i);
                if (val == null || val.length() <= 0 || (map = ARDataStructure.processAsMap(val)).size() <= 0 || map.size() != 3) continue;
                Iterator values = map.values().iterator();
                String key = (String)values.next();
                String value = (String)values.next();
                String dataType = (String)values.next();
                if (value.contains("$\\DATE$")) {
                    Date date = new Date(System.currentTimeMillis());
                    Calendar cal = Calendar.getInstance();
                    if (value.contains("+") || value.contains("-")) {
                        int numberOfDays;
                        String days;
                        if (value.contains("+")) {
                            days = value.substring(value.indexOf("+"));
                            numberOfDays = Integer.parseInt(days);
                            cal.add(5, numberOfDays);
                            task.setParameterValue(key, (Object)cal.getTime());
                            continue;
                        }
                        if (!value.contains("-")) continue;
                        days = value.substring(value.indexOf("-") + 1);
                        if (days != null) {
                            numberOfDays = Integer.parseInt(days.trim());
                            cal.add(5, -numberOfDays);
                        }
                        task.setParameterValue(key, (Object)cal.getTime());
                        continue;
                    }
                    task.setParameterValue(key, (Object)date);
                    continue;
                }
                if (value.contains("$\\TIMESTAMP$")) {
                    task.setParameterValue(key, (Object)(System.currentTimeMillis() / 1000L));
                }
                if (dataType == null) {
                    task.setParameterValue(key, (Object)value);
                    continue;
                }
                try {
                    task.setParameterValue(key, this.stringToObject(dataType, value));
                    continue;
                }
                catch (NumberFormatException e) {
                    this.appendException(e);
                    continue;
                }
                catch (BirtException e) {
                    this.appendException(e);
                }
            }
            task.validateParameters();
        }
        try {
            if (webURL != null) {
                task.setParameterValue("midTierURL", this.stringToObject("String", webURL + "servlet/ViewFormServlet?form=" + this.formInReportForm + "&server=" + this.serverUser.getServer() + "&eid="));
            }
        }
        catch (BirtException e) {
            this.appendException(e);
        }
        RenderOption options = new RenderOption();
        options.setOutputStream((OutputStream)reportStream);
        if (exportOptions != null) {
            if (exportOptions == 0) {
                options.setOutputFormat("pdf");
            } else if (exportOptions == 1) {
                options.setOutputFormat("doc");
            } else if (exportOptions == 2) {
                options.setOutputFormat("ppt");
            } else if (exportOptions == 3) {
                options.setOutputFormat("xls");
            } else if (exportOptions == 4) {
                options.setOutputFormat("html");
            }
        } else {
            options.setOutputFormat("pdf");
        }
        task.setRenderOption((IRenderOption)options);
        this.context.logMessage(0, "Starting generation of a report - " + reportName);
        try {
            task.run();
            if (task.getErrors() != null && task.getErrors().size() > 0) {
                for (i = 0; i < task.getErrors().size(); ++i) {
                    EngineException ee;
                    Throwable th = (Throwable)task.getErrors().get(i);
                    if (th instanceof EngineException && (ee = (EngineException)th).getCause() instanceof AdapterException && ee.getCause().getCause() instanceof DataException && ee.getCause().getCause().getCause().getCause() instanceof ARException) {
                        this.appendException(ee.getCause().getCause().getCause().getCause());
                    }
                    this.appendException(th);
                }
                return null;
            }
        }
        catch (Throwable th) {
            this.context.logMessage(2, "Error occured while generating report - " + reportName);
            this.appendException(th);
            task.close();
            return null;
        }
        task.close();
        return reportStream.toByteArray();
    }

    private IDataSource getDataSource(IReportRunnable report) throws ARException {
        IDataSource dataSource = null;
        SlotHandle dataSources = report.getDesignHandle().getModuleHandle().getDataSources();
        for (OdaDataSourceHandle slot : dataSources) {
            DesignElement slotElement = slot.getElement();
            if (!(slotElement instanceof OdaDataSource)) continue;
            dataSource = report.getDesignInstance().getDataSource(((OdaDataSource)slotElement).getName());
            break;
        }
        if (dataSource == null) {
            dataSource = report.getDesignInstance().getDataSource("adhoc_datasource");
        }
        if (dataSource == null) {
            throw new ARException(2, 3356, "Unable to find data source");
        }
        return dataSource;
    }

    protected Object stringToObject(String type, String value) throws BirtException {
        if (value == null) {
            return null;
        }
        if (type.equalsIgnoreCase("Boolean")) {
            return DataTypeUtil.toBoolean((Object)value);
        }
        if (type.equalsIgnoreCase("Date")) {
            return DataTypeUtil.toSqlDate((Object)value);
        }
        if (type.equalsIgnoreCase("Time")) {
            return DataTypeUtil.toSqlTime((Object)value);
        }
        if (type.equalsIgnoreCase("Date Time")) {
            return DataTypeUtil.toDate((Object)value);
        }
        if (type.equalsIgnoreCase("Decimal")) {
            return DataTypeUtil.toBigDecimal((Object)value);
        }
        if (type.equalsIgnoreCase("Float")) {
            return DataTypeUtil.toDouble((Object)value);
        }
        if (type.equalsIgnoreCase("String")) {
            return DataTypeUtil.toString((Object)value);
        }
        if (type.equalsIgnoreCase("Integer")) {
            return DataTypeUtil.toInteger((Object)value);
        }
        return null;
    }

    public void appendException(Throwable th) {
        StackTraceElement[] elements;
        this.statusMessage.append(th.getMessage() + "\n");
        for (StackTraceElement element : elements = th.getStackTrace()) {
            this.statusMessage.append(element.toString() + "\n");
        }
        this.status = this.STATUS_FAILURE;
    }

    private byte[] getReport(ARServerUser serverUser, String reportName) throws ARException {
        AttachmentValue attValue;
        List listReportDefinitionEntryObjects;
        Value value;
        Object formValue;
        this.context.logMessage(0, "calling getReport() for report - " + reportName);
        Entry reportEntry = this.getReportEntry(serverUser, reportName);
        Object localeValue = ((Value)reportEntry.get((Object)ReportConstants.LOCALE.toInt())).getValue();
        if (localeValue != null) {
            this.localeInReportForm = localeValue.toString();
        }
        if ((formValue = ((Value)reportEntry.get((Object)ReportConstants.FORM_NAME.toInt())).getValue()) != null) {
            this.formInReportForm = formValue.toString();
        }
        if (reportEntry != null && (value = (Value)((Entry)(listReportDefinitionEntryObjects = serverUser.getListEntryObjects(this.getReportDefinitionFormName(serverUser), this.getReportInstanceIDQualification(((Value)reportEntry.get((Object)ReportConstants.INSTANCE_ID.toInt())).getValue().toString()), 0, 0, new ArrayList(), new int[]{ReportConstants.REPORT_DEFINITION_FIELD.toInt()}, false, null)).get(0)).get((Object)ReportConstants.REPORT_DEFINITION_FIELD.toInt())) != null && value.getValue() != null && DataType.ATTACHMENT.equals((Object)value.getDataType()) && (attValue = (AttachmentValue)value.getValue()) != null) {
            attValue.setValue(new byte[0]);
            return serverUser.getEntryBlob(this.getReportDefinitionFormName(serverUser), ((Entry)listReportDefinitionEntryObjects.get(0)).getEntryId(), ReportConstants.REPORT_DEFINITION_FIELD.toInt());
        }
        return null;
    }

    public Entry getReportEntry(ARServerUser context, String reportName) throws ARException {
        List listEntryObjects = context.getListEntryObjects(this.getReportFormName(context), this.getReportNameQualification(reportName), 0, 0, new ArrayList(), new int[]{ReportConstants.REPORT_NAME.toInt(), ReportConstants.INSTANCE_ID.toInt(), ReportConstants.LOCALE.toInt(), ReportConstants.REPORT_TYPE.toInt(), ReportConstants.REPORT_DEFINITION.toInt(), 2, ReportConstants.FORM_NAME.toInt()}, false, null);
        if (listEntryObjects != null && !listEntryObjects.isEmpty()) {
            return (Entry)listEntryObjects.get(0);
        }
        return null;
    }

    private QualifierInfo getReportNameQualification(String reportName) {
        ArithmeticOrRelationalOperand left = new ArithmeticOrRelationalOperand(2010005);
        ArithmeticOrRelationalOperand right = new ArithmeticOrRelationalOperand(new Value(reportName));
        return new QualifierInfo(1, new QualifierInfo(new RelationalOperationInfo(1, left, right)), reportTypeQualInfo);
    }

    private QualifierInfo getReportInstanceIDQualification(String instanceId) {
        ArithmeticOrRelationalOperand left = new ArithmeticOrRelationalOperand(179);
        ArithmeticOrRelationalOperand right = new ArithmeticOrRelationalOperand(new Value(instanceId));
        return new QualifierInfo(new RelationalOperationInfo(1, left, right));
    }

    public StringBuffer getFormattedString() {
        return this.formattedString;
    }

    public void setFormattedString(StringBuffer formattedString) {
        this.formattedString = formattedString;
    }

    public void runReport(String reportName, String runAsUser, String reportParams, String timezone, Integer exportOptions, String GUID, String webURL, String externalQual, Integer overrideQuery, int maxEntriesInFileReport) {
        this.context.logMessage(0, "Received run report request with following details - \n\t\tReport Name\t\t\t\t\t- " + reportName + "\n\t\tRun As User\t\t\t\t\t- " + runAsUser + "\n\t\tReport Parameters\t\t\t- " + reportParams + "\n\t\tTimezone\t\t\t\t\t\t- " + timezone + "\n\t\tExport Options\t\t\t\t- " + exportOptions + "\n\t\tGUID\t\t\t\t\t\t\t- " + GUID + "\n\t\tWeb URL\t\t\t\t\t\t- " + webURL + "\n\t\tExternal Qualification\t\t- " + externalQual + "\n\t\tOverride Query\t\t\t\t- " + overrideQuery + "\n\t\tMax Entries In File Report\t- " + maxEntriesInFileReport);
        String extention = "pdf";
        if (exportOptions != null) {
            if (exportOptions == 0) {
                extention = "pdf";
            } else if (exportOptions == 1) {
                extention = "doc";
            } else if (exportOptions == 2) {
                extention = "ppt";
            } else if (exportOptions == 3) {
                extention = "xls";
            } else if (exportOptions == 4) {
                extention = "html";
            }
        }
        byte[] reportResult = null;
        try {
            this.serverUser = ServerContext.getServerUser();
            reportResult = this.executeReport(reportName, runAsUser, reportParams, timezone, exportOptions, webURL, externalQual, overrideQuery, maxEntriesInFileReport);
            this.context.logMessage(0, "Completed report generation for report request with GUID - " + GUID);
        }
        catch (Throwable th) {
            this.context.logMessage(2, "Error occured while generating report for report request with GUID - " + GUID + " Exception stacktrace is - " + th);
            this.appendException(th);
        }
        Value resultFile = null;
        try {
            if (reportResult != null) {
                AttachmentValue a = new AttachmentValue(reportName + "." + extention);
                a.setOriginalSize((long)reportResult.length);
                a.setValue(reportResult);
                resultFile = new Value(a);
            } else {
                resultFile = null;
            }
        }
        catch (Throwable th) {
            this.context.logMessage(2, "Error occured creating AttachmentValue for generated report for report request with GUID - " + GUID + " Exception stacktrace is - " + th);
            this.appendException(th);
        }
        try {
            this.context.logMessage(0, "Now updating entry with GUID - " + GUID);
            Entry e = this.getPublishReportEntry(this.serverUser, GUID);
            e.put(Integer.valueOf(CoreFieldId.Status.getFieldId()), new Value("Done"));
            e.put(Integer.valueOf(90104), resultFile);
            if (this.status == this.STATUS_FAILURE) {
                e.put(Integer.valueOf(90109), new Value("Failure"));
                e.put(Integer.valueOf(90108), new Value(this.statusMessage.toString()));
            } else {
                e.put(Integer.valueOf(90109), new Value("Success"));
                e.put(Integer.valueOf(90108), new Value(this.statusMessage.toString()));
            }
            this.serverUser.setEntry(this.getPublishReportFormName(this.serverUser), e.getEntryId(), e, new Timestamp(), 1);
            this.context.logMessage(0, "Entry updated with GUID - " + GUID);
        }
        catch (ARException e) {
            this.context.logMessage(2, "Error occured updating entry in the Publish Report form with GUID - " + GUID + " - Exception - " + (Object)((Object)e));
            this.appendException(e);
        }
    }

    private Entry getPublishReportEntry(ARServerUser serverUser, String GUID) throws ARException {
        QualifierInfo qualInfo = this.buildPublishReportQualifier(GUID);
        List entries = serverUser.getListEntryObjects(this.getPublishReportFormName(serverUser), qualInfo, 0, 0, new ArrayList(), new int[]{7, 90104, 90109, 90108}, false, null);
        if (entries != null && entries.size() > 0) {
            Iterator itrEntry = entries.iterator();
            Entry oEntry = null;
            Value avalue = null;
            if (itrEntry.hasNext() && (avalue = (Value)(oEntry = (Entry)itrEntry.next()).get((Object)CoreFieldId.EntryId.getFieldId())) != null) {
                return oEntry;
            }
        }
        return null;
    }

    private synchronized QualifierInfo buildPublishReportQualifier(String GUID) {
        RelationalOperationInfo guidOp = new RelationalOperationInfo(1, INSTANCE_ID_OP, new ArithmeticOrRelationalOperand(new Value(GUID)));
        QualifierInfo qualifier = new QualifierInfo(guidOp);
        return qualifier;
    }

    private String getReportFormName(ARServerUser serverUser) throws ARException {
        if (reportForm == null) {
            this.context.logMessage(0, "Getting Report Form Name");
            FormCriteria criteria = new FormCriteria();
            criteria.setPropertiesToRetrieve(FormCriteria.NAME);
            int formType = 1025;
            List formList = serverUser.getListFormObjects(0L, formType, null, new int[]{ReportConstants.REPORT_ATTACHMENT_POOL.toInt(), ReportConstants.REPORT_NAME.toInt(), ReportConstants.REPORT_TYPE.toInt(), ReportConstants.FORM_NAME.toInt()}, criteria);
            if (formList != null && formList.size() > 0) {
                reportForm = ((Form)formList.get(0)).getName();
            }
            this.context.logMessage(0, "Found Report Form Name as - " + reportForm);
        }
        if (reportForm == null) {
            this.context.logMessage(0, "Didn't find Report Form Name. So setting it to default as - 'Report'");
            reportForm = "Report";
        }
        return reportForm;
    }

    private String getReportDefinitionFormName(ARServerUser serverUser) throws ARException {
        if (reportDefinitionForm == null) {
            this.context.logMessage(0, "Getting Report Definition Form Name");
            FormCriteria criteria = new FormCriteria();
            criteria.setPropertiesToRetrieve(FormCriteria.NAME);
            int formType = 1025;
            List formList = serverUser.getListFormObjects(0L, formType, null, new int[]{ReportConstants.REPORT_PARAMETERS.toInt(), ReportConstants.SERVICE_TYPE.toInt()}, criteria);
            if (formList != null && formList.size() > 0) {
                reportDefinitionForm = ((Form)formList.get(0)).getName();
            }
            this.context.logMessage(0, "Found Report Definition Form Name as - " + reportDefinitionForm);
        }
        if (reportDefinitionForm == null) {
            reportDefinitionForm = "Report Definition";
            this.context.logMessage(0, "Didn't find Report Definition Form Name. So setting it to default as - " + reportDefinitionForm);
        }
        return reportDefinitionForm;
    }

    private String getPublishReportFormName(ARServerUser serverUser) throws ARException {
        if (publishReportFormName == null) {
            this.context.logMessage(0, "Getting Publish Report Form Name");
            FormCriteria criteria = new FormCriteria();
            criteria.setPropertiesToRetrieve(FormCriteria.NAME);
            int formType = 1025;
            int[] mPublishReportListFieldIds = new int[]{ReportConstants.PUBLISH_REPORT_PANEL_ID.toInt()};
            List formList = serverUser.getListFormObjects(0L, formType, null, mPublishReportListFieldIds, criteria);
            if (formList != null && formList.size() > 0) {
                publishReportFormName = ((Form)formList.get(0)).getName();
            }
            this.context.logMessage(0, "Found Publish Report Form Name as - " + publishReportFormName);
        }
        if (publishReportFormName == null) {
            this.context.logMessage(0, "Didn't find Publish Report Form Name. So setting it to default as - 'AR System Publish Report'");
            publishReportFormName = "AR System Publish Report";
        }
        return publishReportFormName;
    }
}

