/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.report;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARNativeAuthenticationInfo;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.arreporting.ARDataStructure;
import com.bmc.arsys.arreporting.Utilities;
import com.bmc.arsys.plugins.report.ReportForms;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IParameterDefnBase;
import org.eclipse.birt.report.engine.api.IParameterGroupDefn;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IScalarParameterDefn;
import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.api.script.element.IDataSource;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.OdaDataSource;

public class ParseParameters
extends ARFilterAPIPlugin {
    private StringBuffer formattedString = new StringBuffer();
    private final ARPluginInfo pluginInfo = new ARPluginInfo("ARSYS.ARF.PARSEPARAMETERS", (ARPluggable)this);
    private String serverName = "localhost";
    private ARServerUser serverUser = null;
    private StringBuffer statusMessage = new StringBuffer();
    private final int REPORT_DEFINITION_FILE = 2010012;
    private final int REPORT_ADHOC = 2010008;
    private static final String AR_BIRT_NULL_PASSWORD = "AR_BIRT_NULL_PASSWORD";
    private static final String AUTHENTICATION = "authentication";
    private static final String REPORT_LOCALE = "locale";
    private static final String PORT = "port";
    private static final String SERVER = "server";
    private static final String PASSWORD = "password";
    private static final String USER = "user";

    public void initialize(ARPluginContext context) throws ARException {
        try {
            int i;
            String[] args = context.getCmdLineArgs();
            String message = "initialize method was invoked with args = ";
            if (args.length >= 0) {
                for (i = 0; i < args.length; ++i) {
                    message = message + " " + args[i];
                }
            }
            context.logMessage(this.pluginInfo, 0, message);
            for (i = 0; i < args.length; ++i) {
                if (!args[i].equals("-x")) continue;
                this.serverName = args[i + 1];
                i = args.length;
            }
            context.logMessage(this.pluginInfo, 0, "Server name = " + this.serverName);
        }
        catch (Throwable th) {
            context.logMessage(1, th.getMessage());
        }
    }

    private void initServerUser(ARPluginContext context) throws ARException {
        context.logMessage(0, "initServerUser()");
        if (this.serverUser == null) {
            this.serverUser = new ARServerUser((ARNativeAuthenticationInfo)context, "", this.serverName);
            int port = Utilities.getIntegerValue(context.getARConfigEntry("TCD-Specific-Port"));
            this.serverUser.setPort(port);
            int rpcnumber = Utilities.getIntegerValue(context.getARConfigEntry("Plugin-Loopback-RPC-Socket"));
            if (rpcnumber > 0) {
                this.serverUser.usePrivateRpcQueue(rpcnumber);
            }
            this.serverUser.setVUIType(1);
        }
        this.serverUser.setUserContext((ARNativeAuthenticationInfo)context);
    }

    private IDataSource getDataSource(IReportRunnable report) {
        IDataSource dataSource = null;
        SlotHandle dataSources = report.getDesignHandle().getModuleHandle().getDataSources();
        for (OdaDataSourceHandle slot : dataSources) {
            DesignElement slotElement = slot.getElement();
            if (!(slotElement instanceof OdaDataSource)) continue;
            dataSource = report.getDesignInstance().getDataSource(((OdaDataSource)slotElement).getName());
            break;
        }
        if (dataSource == null) {
            dataSource = report.getDesignInstance().getDataSource("adhoc_datasource");
        }
        return dataSource;
    }

    private void parseReportParameters(InputStream stream) throws EngineException {
        HashMap<String, HashMap<String, Serializable>> parmDetails = new HashMap<String, HashMap<String, Serializable>>();
        IReportEngine engine = ReportForms.getDelegator().getBirtEngine().getReportEngine();
        IReportRunnable design = null;
        try {
            if (stream != null) {
                design = engine.openReportDesign(stream);
            }
        }
        catch (Throwable th) {
            this.appendException(th);
        }
        IDataSource dataSource = this.getDataSource(design);
        try {
            if (dataSource != null) {
                dataSource.setPrivateDriverProperty(USER, this.serverUser.getUser());
                dataSource.setPrivateDriverProperty(SERVER, this.serverUser.getServer());
                if (this.serverUser.getPassword() == null || this.serverUser.getPassword() != null && this.serverUser.getPassword().length() == 0) {
                    dataSource.setPrivateDriverProperty(PASSWORD, AR_BIRT_NULL_PASSWORD);
                } else {
                    dataSource.setPrivateDriverProperty(PASSWORD, this.serverUser.getPassword());
                }
                dataSource.setPrivateDriverProperty(PORT, Integer.toString(this.serverUser.getPort()));
                dataSource.setPrivateDriverProperty(AUTHENTICATION, this.serverUser.getAuthentication());
                String locale = "en_US";
                dataSource.setPrivateDriverProperty(REPORT_LOCALE, locale);
            }
        }
        catch (ScriptException sx) {
            this.appendException(sx);
        }
        IGetParameterDefinitionTask task = engine.createGetParameterDefinitionTask(design);
        Collection params = task.getParameterDefns(true);
        for (IParameterDefnBase param : params) {
            if (param instanceof IParameterGroupDefn) {
                IParameterGroupDefn group = (IParameterGroupDefn)param;
                Iterator i2 = group.getContents().iterator();
                this.getFormattedString().append("\"");
                while (i2.hasNext()) {
                    IScalarParameterDefn scalar = (IScalarParameterDefn)i2.next();
                    parmDetails.put(scalar.getName(), this.loadParameterDetails(task, scalar, design, group));
                }
                this.getFormattedString().append("\";");
                continue;
            }
            IScalarParameterDefn scalar = (IScalarParameterDefn)param;
            this.getFormattedString().append("\"");
            parmDetails.put(scalar.getName(), this.loadParameterDetails(task, scalar, design, null));
            this.getFormattedString().append("\";");
        }
        System.out.println(this.getFormattedString().toString());
    }

    public void appendException(Throwable th) {
        StackTraceElement[] elements;
        this.statusMessage.append(th.getMessage() + "\n");
        for (StackTraceElement element : elements = th.getStackTrace()) {
            this.statusMessage.append(element.toString());
        }
    }

    private HashMap<String, Serializable> loadParameterDetails(IGetParameterDefinitionTask task, IScalarParameterDefn scalar, IReportRunnable report, IParameterGroupDefn group) {
        HashMap<String, Serializable> parameter = new HashMap<String, Serializable>();
        parameter.put("Parameter Group", (Serializable)((Object)(group == null ? "Default" : group.getName())));
        parameter.put("Name", (Serializable)((Object)scalar.getName()));
        parameter.put("Help Text", (Serializable)((Object)scalar.getHelpText()));
        parameter.put("Display Name", (Serializable)((Object)scalar.getDisplayName()));
        parameter.put("Display Format", (Serializable)((Object)scalar.getDisplayFormat()));
        parameter.put("Hidden", (Serializable)((Object)(scalar.isHidden() ? "Yes" : "No")));
        parameter.put("Allow Blank", (Serializable)((Object)(scalar.allowBlank() ? "Yes" : "No")));
        parameter.put("Allow Null", (Serializable)((Object)(scalar.allowNull() ? "Yes" : "No")));
        parameter.put("Conceal Entry", (Serializable)((Object)(scalar.isValueConcealed() ? "Yes" : "No")));
        switch (scalar.getControlType()) {
            case 0: {
                parameter.put("Type", (Serializable)((Object)"Text Box"));
                break;
            }
            case 1: {
                parameter.put("Type", (Serializable)((Object)"List Box"));
                break;
            }
            case 2: {
                parameter.put("Type", (Serializable)((Object)"List Box"));
                break;
            }
            case 3: {
                parameter.put("Type", (Serializable)((Object)"List Box"));
                break;
            }
            default: {
                parameter.put("Type", (Serializable)((Object)"Text Box"));
            }
        }
        switch (scalar.getDataType()) {
            case 1: {
                parameter.put("Data Type", (Serializable)((Object)"String"));
                break;
            }
            case 2: {
                parameter.put("Data Type", (Serializable)((Object)"Float"));
                break;
            }
            case 3: {
                parameter.put("Data Type", (Serializable)((Object)"Decimal"));
                break;
            }
            case 4: {
                parameter.put("Data Type", (Serializable)((Object)"Date Time"));
                break;
            }
            case 5: {
                parameter.put("Data Type", (Serializable)((Object)"Boolean"));
                break;
            }
            case 6: {
                parameter.put("Data Type", (Serializable)((Object)"Integer"));
                break;
            }
            case 7: {
                parameter.put("Data Type", (Serializable)((Object)"Date"));
                break;
            }
            case 8: {
                parameter.put("Data Type", (Serializable)((Object)"Time"));
                break;
            }
            default: {
                parameter.put("Data Type", (Serializable)((Object)"Any"));
            }
        }
        ReportDesignHandle reportHandle = (ReportDesignHandle)report.getDesignHandle();
        ScalarParameterHandle parameterHandle = (ScalarParameterHandle)reportHandle.findParameter(scalar.getName());
        parameter.put("Default Value", (Serializable)((Object)parameterHandle.getDefaultValue()));
        parameter.put("Prompt Text", (Serializable)((Object)parameterHandle.getPromptText()));
        parameter.put("Data Set Expression", (Serializable)((Object)parameterHandle.getValueExpr()));
        if (scalar.getControlType() != 0) {
            if (parameterHandle.getContainer() instanceof CascadingParameterGroupHandle) {
                if (parameterHandle.getContainer() instanceof CascadingParameterGroupHandle) {
                    int index = parameterHandle.getContainerSlotHandle().findPosn((DesignElementHandle)parameterHandle);
                    Object[] keyValue = new Object[index];
                    for (int i = 0; i < index; ++i) {
                        ScalarParameterHandle handle = (ScalarParameterHandle)((CascadingParameterGroupHandle)parameterHandle.getContainer()).getParameters().get(i);
                        keyValue[i] = handle.getDefaultValue();
                    }
                    String groupName = parameterHandle.getContainer().getName();
                    task.evaluateQuery(groupName);
                    Collection sList = task.getSelectionListForCascadingGroup(groupName, keyValue);
                    HashMap<Object, String> dynamicList = new HashMap<Object, String>();
                    for (IParameterSelectionChoice iParameterSelectionChoice : sList) {
                        Object value = iParameterSelectionChoice.getValue();
                        String label = iParameterSelectionChoice.getLabel();
                        dynamicList.put(value, label);
                    }
                    parameter.put("Selection List", dynamicList);
                }
            } else {
                Collection selectionList = task.getSelectionList(scalar.getName());
                if (selectionList != null) {
                    HashMap<Object, String> dynamicList = new HashMap<Object, String>();
                    for (IParameterSelectionChoice selectionItem : selectionList) {
                        Object value = selectionItem.getValue();
                        String label = selectionItem.getLabel();
                        dynamicList.put(value, label);
                    }
                    parameter.put("Selection List", dynamicList);
                }
            }
        }
        for (Map.Entry entry : parameter.entrySet()) {
            String name = (String)entry.getKey();
            ArrayList<String> allowedNames = new ArrayList<String>();
            allowedNames.add("Allow Null");
            allowedNames.add("Default Value");
            allowedNames.add("Type");
            allowedNames.add("Hidden");
            allowedNames.add("Name");
            allowedNames.add("Display Name");
            allowedNames.add("Help Text");
            allowedNames.add("Data Type");
            allowedNames.add("Display Format");
            allowedNames.add("Selection List");
            if (!allowedNames.contains(name) || name.equals("Hidden") && ((Serializable)entry.getValue()).toString().trim().equals("Yes")) continue;
            if (name.equals("Selection List")) {
                this.getFormattedString().append(name.replace(" ", "") + "=");
                this.getFormattedString().append("\"\"");
                HashMap selList = (HashMap)entry.getValue();
                for (Map.Entry entry2 : selList.entrySet()) {
                    this.getFormattedString().append(entry2.getKey() + "=" + entry2.getValue() + ";");
                }
                this.getFormattedString().append("\"\";");
                continue;
            }
            this.getFormattedString().append(name.replace(" ", "") + "=" + entry.getValue() + ";");
        }
        return parameter;
    }

    public StringBuffer getFormattedString() {
        return this.formattedString;
    }

    public void setFormattedString(StringBuffer formattedString) {
        this.formattedString = formattedString;
    }

    public static void main(String[] args) {
        try {
            ParseParameters parser = new ParseParameters();
            parser.parseReportParameters(null);
            ArrayList<String> arrList = ARDataStructure.processAsList(parser.getFormattedString().toString());
            if (arrList.size() > 0) {
                for (int i = 0; i < arrList.size(); ++i) {
                    HashMap<String, String> map;
                    String val = (String)arrList.get(i);
                    System.out.println("---- Parameter Start ---- ");
                    if (val != null && val.length() > 0 && (map = ARDataStructure.processAsMap(val)).size() > 0) {
                        Set keys = map.keySet();
                        for (String key : keys) {
                            System.out.println(key + "=" + (String)map.get(key));
                        }
                    }
                    System.out.println("---- Parameter End ---- \n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Value> filterAPICall(ARPluginContext context, List<Value> inValues) throws ARException {
        boolean isWebReport;
        if (inValues.size() == 0) {
            return null;
        }
        ReportForms.init(context);
        this.initServerUser(context);
        Entry reportEntry = ReportForms.getDelegator().getReportEntryByGUID(this.serverUser, (String)inValues.get(2).getValue());
        if (reportEntry != null && (isWebReport = ReportForms.getDelegator().isWebReport(reportEntry))) {
            return null;
        }
        Object file = inValues.get(0).getValue();
        if (file == null) {
            return null;
        }
        ArrayList<Value> outValues = new ArrayList<Value>();
        try {
            if (file instanceof AttachmentValue) {
                ByteArrayInputStream stream = null;
                AttachmentValue attachment = (AttachmentValue)file;
                if (attachment.getContent() != null) {
                    stream = new ByteArrayInputStream(attachment.getContent());
                } else {
                    byte[] content = this.serverUser.getEntryBlob("Report Definition", (String)inValues.get(1).getValue(), 2010012);
                    stream = new ByteArrayInputStream(content);
                }
                ParseParameters parser = new ParseParameters();
                parser.parseReportParameters(stream);
                String parameters = parser.getFormattedString().toString();
                if (parameters != null) {
                    if (parameters.contains("midTierURL")) {
                        outValues.add(new Value(""));
                    } else {
                        outValues.add(new Value(parameters));
                    }
                }
            }
        }
        catch (Throwable th) {
            this.appendException(th);
        }
        return outValues;
    }
}

