/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.processors;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.plugins.processors.IProcessor;
import com.bmc.arsys.plugins.processors.Job;
import com.bmc.arsys.plugins.processors.JobService;
import com.bmc.arsys.plugins.processors.SchedulerException;
import com.bmc.arsys.plugins.processors.ServerContext;
import com.bmc.arsys.plugins.processors.impl.ExecFactory;
import com.bmc.arsys.plugins.processors.impl.ProcessingThread;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ARScheduleProcessorFilter
implements ARFilterAPIPluggable {
    private ARPluginInfo pluginInfo = new ARPluginInfo("ARSYS.FILTERAPI.ARSCHEDULEPROCESSOR", (ARPluggable)this);
    private BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
    private ThreadPoolExecutor executor = null;

    public List<Value> filterAPICall(ARPluginContext context, List<Value> pInValues) throws ARException {
        context.logMessage(this.pluginInfo, 0, "filterAPICall()");
        if (pInValues.size() == 0) {
            context.logMessage(this.pluginInfo, 2, "Error: Invalid number of arguments passed!");
            return null;
        }
        String szJobMessage = "";
        int state = 1;
        try {
            this.handleRequests(context, pInValues);
        }
        catch (SchedulerException e) {
            szJobMessage = e.getMessage();
            state = 3;
        }
        ArrayList<Value> outValues = new ArrayList<Value>();
        Value oValState = new Value(state);
        Value oValJobMessage = new Value(szJobMessage);
        outValues.add(oValState);
        outValues.add(oValJobMessage);
        return outValues;
    }

    public void initialize(ARPluginContext context) throws ARException {
        context.logMessage(this.pluginInfo, 0, "ARSYS.FILTERAPI.ARSCHEDULEPROCESSOR - initialize()");
        ServerContext.initializeServerUser(context);
        try {
            ExecFactory.loadProcessors(context);
        }
        catch (SchedulerException e) {
            context.logMessage(this.pluginInfo, 2, "Error loading processors " + e.toString());
        }
        this.executor = new ThreadPoolExecutor(5, 5, Integer.MAX_VALUE, TimeUnit.SECONDS, this.queue);
    }

    public void onEvent(ARPluginContext context, int arg1) throws ARException {
    }

    public void terminate(ARPluginContext context) throws ARException {
        context.logMessage(this.pluginInfo, 0, "terminate()");
        this.executor.shutdown();
        try {
            context.logMessage(this.pluginInfo, 0, "Waiting before termination so that the remaining tasks can complete...");
            this.executor.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void handleRequests(ARPluginContext context, List<Value> pInValues) throws SchedulerException {
        Iterator<Value> itValues = pInValues.iterator();
        String szJobId = null;
        String szGUID = null;
        Value valJobId = itValues.next();
        if (valJobId.getDataType() == DataType.CHAR) {
            szJobId = (String)valJobId.getValue();
        }
        context.logMessage(this.pluginInfo, 0, "szJobId - " + szJobId);
        Value valGUID = itValues.next();
        if (valGUID.getDataType() == DataType.CHAR) {
            szGUID = (String)valGUID.getValue();
        }
        context.logMessage(this.pluginInfo, 0, "szGUID - " + szGUID);
        JobService oJobService = new JobService(context);
        try {
            Job oJob = oJobService.getJobDetails(szJobId);
            oJob.setPendingGUID(szGUID);
            context.logMessage(this.pluginInfo, 0, "szJobType - " + oJob.getType());
            IProcessor oProcessor = ExecFactory.getProcessorInstance(oJob.getType());
            if (oProcessor == null) {
                context.logMessage(this.pluginInfo, 2, "Invalid Job Type. No Processor present for this job type - " + oJob.getType());
                throw new SchedulerException("Invalid Job Type. No Processor present for this job type - " + oJob.getType());
            }
            this.executor.submit(new ProcessingThread(context, oProcessor, oJob));
        }
        catch (ARException e) {
            context.logMessage(this.pluginInfo, 2, "Internal Error - " + e.getMessage());
            throw new SchedulerException("Internal Error - " + e.getMessage());
        }
    }
}

