/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.jreflect;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.plugins.jreflect.JavaMethodInvoker;
import com.bmc.arsys.plugins.util.ScriptInvocationData;
import com.bmc.arsys.plugins.util.ValueConverter;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class JavaReflectionPlugin
extends ARFilterAPIPlugin {
    public static int[] supportedDataTypes = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 10, 11, 12, 13, 14, 40};

    public List<Value> filterAPICall(ARPluginContext context, List<Value> inArgs) throws ARException {
        String className;
        String[] languageNames;
        List<Value> results = null;
        Object[] args = ValueConverter.convertFromAR(inArgs, supportedDataTypes);
        ScriptInvocationData sid = new ScriptInvocationData(args, languageNames = new String[]{"Java"});
        String scriptSnippet = sid.getSourceSnippet();
        if (scriptSnippet == null || scriptSnippet.length() <= 0) {
            throw new ARException(2, 5555, "JAVAREFLECTION_PLUGIN_ERR_NOMETHOD: Method not defined.");
        }
        String ctrPrototype = null;
        String methodPrototype = null;
        String workingStr = scriptSnippet;
        int sepAt = workingStr.lastIndexOf(".");
        if (sepAt == -1) {
            throw new ARException(2, 5555, String.format("JAVAREFLECTION_PLUGIN_ERR_METHOD: Method not defined correctly. (%s)", scriptSnippet));
        }
        String methodName = workingStr.substring(sepAt + 1);
        if (methodName.contains("(") && methodName.contains(")")) {
            methodPrototype = methodName;
            methodName = methodName.substring(0, methodName.indexOf("("));
        }
        if ((className = workingStr.substring(0, sepAt)).contains(".NEW_INSTANCE")) {
            sepAt = className.indexOf(".NEW_INSTANCE");
            ctrPrototype = className.substring(sepAt + ".NEW_INSTANCE".length());
            className = className.substring(0, sepAt);
            if (ctrPrototype != null && ctrPrototype.length() > 0) {
                ctrPrototype = className.concat(ctrPrototype);
            }
        }
        Object[] actualArgs = sid.getActualArgs();
        Object scriptResult = null;
        try {
            Class<?> clazz = Class.forName(className);
            JavaMethodInvoker jmi = new JavaMethodInvoker(clazz);
            scriptResult = jmi.invoke(ctrPrototype, methodPrototype, methodName, actualArgs);
        }
        catch (ClassNotFoundException e) {
            throw new ARException(2, 5555, "JAVAREFLECTION_PLUGIN_ERR_FAILED: Couldn't invoke method.\n>>>>>>>begin>>>>>>>>\n" + scriptSnippet + "\n<<<<<<<end<<<<<<<<<<\n");
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        results = ValueConverter.convertToAR(scriptResult);
        return results;
    }

    public JavaReflectionPlugin() {
    }

    public JavaReflectionPlugin(int i, String j) {
        System.out.println("'JavaReflectionPlugin(int, String)' is called");
    }

    public void performSomeWorkToo(int i, int j) {
        System.out.println(" " + i + " " + j);
    }
}

