/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.arealdap;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.plugins.arealdap.AREALdapConfig;
import com.bmc.arsys.plugins.arealdap.LDAPProps;
import com.bmc.arsys.plugins.customssl.ARLDAPSSLFactory;
import com.bmc.arsys.pluginsvr.plugins.AREAPlugin;
import com.bmc.arsys.pluginsvr.plugins.AREAResponse;
import com.bmc.arsys.pluginsvr.plugins.ARPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import java.util.List;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class AREALdapPlugin
extends AREAPlugin {
    private ARPluginInfo pluginInfo = new ARPluginInfo("AREA.LDAP", (ARPluggable)this);
    private AREALdapConfig areaConfig = null;

    public void initialize(ARPluginContext context) throws ARException {
        context.logMessage(0, "Initialising AREA LDAP plugin.");
    }

    public boolean areaNeedSync(ARPluginContext context) throws ARException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AREAResponse areaVerifyLogin(ARPluginContext pluginContext, String user, String password, String networkAddress, String authString) throws ARException {
        this.logInfoMessage(pluginContext, "areaVerifyLogin()");
        AREAResponse resp = new AREAResponse();
        resp.setLoginStatus(2);
        if (this.isEmpty(password)) {
            return this.generateErrorResponse(pluginContext, resp, "Password cannot be empty for external authentication");
        }
        AREALdapConfig configProps = this.getAreaLdapConfig(pluginContext);
        List<LDAPProps> areaCfg = configProps.AREALdapCfg;
        if (areaCfg == null || areaCfg.isEmpty()) {
            return this.generateErrorResponse(pluginContext, resp, "Missing AREA LDAP configuration! Need LDAP directory server name, bind credentials!");
        }
        Context ctx = null;
        for (LDAPProps ldapConfigInfo : areaCfg) {
            String sslLog = "";
            try {
                Properties env = this.configurePlainLdapProps(pluginContext, ldapConfigInfo);
                if (ldapConfigInfo.useSSL()) {
                    sslLog = "(Using " + env.getProperty("java.naming.security.protocol") + ")";
                }
                this.logInfoMessage(pluginContext, "Connecting to LDAP: " + sslLog + ldapConfigInfo.getURL());
                this.logInfoMessage(pluginContext, "Bind User: " + ldapConfigInfo.getBindUser());
                ctx = new InitialDirContext(env);
                this.logInfoMessage(pluginContext, "Successully bound to LDAP Server");
                this.logInfoMessage(pluginContext, "connect timeout used: " + ldapConfigInfo.getTimeout());
                String search = this.replaceKeywords(ldapConfigInfo.getUserBase(), null, user, authString, networkAddress);
                String filter = this.replaceKeywords(ldapConfigInfo.getUserFilter(), null, user, authString, networkAddress);
                this.logInfoMessage(pluginContext, "User base:" + search);
                this.logInfoMessage(pluginContext, "User Filter:" + filter);
                SearchControls constraints = new SearchControls();
                constraints.setSearchScope(2);
                NamingEnumeration<SearchResult> results = this.searchLdapEntries((DirContext)ctx, search, constraints, filter, ldapConfigInfo.getChaseReferral());
                String dn = this.populateUserDetails(pluginContext, results, resp, ldapConfigInfo, user, password);
                if (dn != null) {
                    if (password != null) {
                        resp.setLoginStatus(0);
                        resp.setMessageText(null);
                        this.logInfoMessage(pluginContext, "Found valid user : " + user);
                        this.setGroup(dn, ldapConfigInfo, user, password, networkAddress, authString, constraints, (DirContext)ctx, pluginContext, resp);
                        break;
                    }
                    resp.setLoginStatus(2);
                    resp.setMessageText(null);
                    this.logInfoMessage(pluginContext, "Found user but password is bad!");
                    continue;
                }
                resp.setLoginStatus(1);
                resp.setMessageText(null);
                this.logInfoMessage(pluginContext, "We do not know the user:" + user);
            }
            catch (Throwable e) {
                this.logErrorMessage(pluginContext, "Ldap Authentication failed!" + e.toString());
                resp.setLoginStatus(2);
            }
            finally {
                if (ctx == null) continue;
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    this.logWarnMessage(pluginContext, e.getMessage());
                }
                ctx = null;
            }
        }
        this.logAREAResponse(pluginContext, resp);
        return resp;
    }

    private void setGroup(String dn, LDAPProps ldapConfigInfo, String user, String password, String networkAddress, String authString, SearchControls constraints, DirContext ctx, ARPluginContext pluginContext, AREAResponse resp) {
        if (dn != null && ldapConfigInfo.getUseGroups() == 1) {
            if (ldapConfigInfo.getGroupBase() != null && ldapConfigInfo.getGroupFilter() != null) {
                String groupName = "cn";
                String groupBase = this.replaceKeywords(ldapConfigInfo.getGroupBase(), dn, user, authString, networkAddress);
                String groupFilter = this.replaceKeywords(ldapConfigInfo.getGroupFilter(), dn, user, authString, networkAddress);
                this.logInfoMessage(pluginContext, "Group Base DN:" + groupBase);
                this.logInfoMessage(pluginContext, "Group Filter:" + groupFilter);
                try {
                    NamingEnumeration<SearchResult> groupResults = this.searchLdapEntries(ctx, groupBase, constraints, groupFilter, ldapConfigInfo.getChaseReferral());
                    if (groupResults != null) {
                        StringBuffer groupsString = new StringBuffer();
                        while (groupResults.hasMoreElements()) {
                            SearchResult currentResult = groupResults.next();
                            Attribute groups = currentResult.getAttributes().get(groupName);
                            for (int i = 0; i < groups.size(); ++i) {
                                groupsString.append(";" + groups.get(i));
                            }
                        }
                        String groupNms = groupsString.toString();
                        if (!groupNms.isEmpty()) {
                            this.logInfoMessage(pluginContext, "Found groups:" + groupNms);
                            resp.setGroups(groupNms);
                        }
                    }
                }
                catch (NamingException ne) {
                    this.logWarnMessage(pluginContext, "Error in finding user Groups!" + ne);
                }
            }
            if (resp.getGroups() == null && ldapConfigInfo.getDefaultGroups() != null) {
                String defaultGroup = ldapConfigInfo.getDefaultGroups();
                if (!defaultGroup.startsWith(";")) {
                    // empty if block
                }
                defaultGroup = ";" + defaultGroup;
                this.logInfoMessage(pluginContext, "Using default Groups:" + defaultGroup);
                resp.setGroups(defaultGroup);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String populateUserDetails(ARPluginContext pluginContext, NamingEnumeration<SearchResult> results, AREAResponse resp, LDAPProps props, String user, String password) throws NamingException, ARException {
        String dn = null;
        if (results != null) {
            while (results.hasMoreElements()) {
                Attributes attributes;
                block49: {
                    String licenseRes1AttribName;
                    block48: {
                        block47: {
                            String notifyMethAttribName;
                            SearchResult currentResult = results.next();
                            dn = currentResult.getNameInNamespace();
                            Properties env = this.configurePlainLdapProps(pluginContext, props);
                            env.setProperty("java.naming.security.principal", dn);
                            env.setProperty("java.naming.security.credentials", password);
                            InitialDirContext dirCtx = null;
                            try {
                                dirCtx = new InitialDirContext(env);
                            }
                            finally {
                                if (dirCtx != null) {
                                    dirCtx.close();
                                    dirCtx = null;
                                }
                            }
                            attributes = currentResult.getAttributes();
                            String email = null;
                            String emailAttr = props.getEmailAttribName();
                            if (emailAttr != null && attributes.get(emailAttr) != null) {
                                String userEmail = (String)attributes.get(emailAttr).get();
                                email = this.isEmpty(userEmail) ? this.replaceKeywords(props.getDefaultEmail(), null, user, null, null) : userEmail.toUpperCase();
                            }
                            if (email == null) {
                                email = this.replaceKeywords(props.getDefaultEmail(), null, user, null, null);
                            }
                            resp.setEmail(email);
                            int useGroups = props.getUseGroups();
                            String rolesAttribName = props.getRolesAttribName();
                            if (useGroups == 0 && rolesAttribName != null) {
                                if (attributes.get(rolesAttribName) != null) {
                                    Attribute roles = attributes.get(rolesAttribName);
                                    StringBuffer rolesString = new StringBuffer();
                                    for (int i = 0; i < roles.size(); ++i) {
                                        rolesString.append(";" + roles.get(i));
                                    }
                                    if (roles.size() > 0) {
                                        resp.setGroups(rolesString.toString());
                                    } else {
                                        resp.setGroups(props.getDefaultRoles());
                                    }
                                } else {
                                    resp.setGroups(props.getDefaultRoles());
                                }
                            }
                            if ((notifyMethAttribName = props.getNotifyMeth()) != null) {
                                if (attributes.get(notifyMethAttribName) != null) {
                                    try {
                                        int notifyMech = Integer.parseInt((String)attributes.get(notifyMethAttribName).get());
                                        if (notifyMech < 3) {
                                            resp.setNotifyMech(notifyMech);
                                            break block47;
                                        }
                                        resp.setNotifyMech(0);
                                    }
                                    catch (NumberFormatException ne) {
                                        resp.setNotifyMech(props.getDefaultNotifyMech());
                                        this.logWarnMessage(pluginContext, "Invalid Notify Mechanism value, Setting it to default:" + props.getDefaultNotifyMech());
                                    }
                                } else {
                                    resp.setNotifyMech(props.getDefaultNotifyMech());
                                }
                            } else {
                                resp.setNotifyMech(props.getDefaultNotifyMech());
                            }
                        }
                        String licenseMaskAttribName = props.getLicenseMaskAttribName();
                        if (licenseMaskAttribName != null) {
                            if (attributes.get(licenseMaskAttribName) != null) {
                                String val = null;
                                try {
                                    val = (String)attributes.get(licenseMaskAttribName).get();
                                    int licenseMask = Integer.parseInt(val);
                                    resp.setLicenseMask(licenseMask);
                                }
                                catch (NumberFormatException ne) {
                                    this.logInfoMessage(pluginContext, "Invalid attribute value for attribute '" + licenseMaskAttribName + "':" + val);
                                }
                            } else {
                                resp.setLicenseMask(props.getDefaultLicenseMask());
                            }
                        } else {
                            resp.setLicenseMask(props.getDefaultLicenseMask());
                        }
                        String licenseTypeAttribName = props.getLicenseTypeAttribName();
                        if (licenseTypeAttribName != null) {
                            if (attributes.get(licenseTypeAttribName) != null) {
                                try {
                                    int licenseType = Integer.parseInt((String)attributes.get(licenseTypeAttribName).get());
                                    if (licenseType == 3 || licenseType == 2) {
                                        resp.setLicenseWrite(licenseType);
                                        break block48;
                                    }
                                    resp.setLicenseWrite(0);
                                }
                                catch (NumberFormatException ne) {
                                    resp.setLicenseWrite(0);
                                }
                            } else {
                                resp.setLicenseWrite(props.getDefaultLicenseType());
                            }
                        } else {
                            resp.setLicenseWrite(props.getDefaultLicenseType());
                        }
                    }
                    String licenseFTSAttribName = props.getLicenseFTSAttribName();
                    if (licenseFTSAttribName != null && attributes.get(licenseFTSAttribName) != null) {
                        try {
                            int licenseFTS = Integer.parseInt((String)attributes.get(licenseFTSAttribName).get());
                            if (licenseFTS == 3) {
                                resp.setLicenseFTS(licenseFTS);
                            } else {
                                resp.setLicenseFTS(0);
                            }
                        }
                        catch (NumberFormatException ne) {
                            resp.setLicenseFTS(0);
                        }
                    }
                    if ((licenseRes1AttribName = props.getLicenseRes1AttribName()) != null && attributes.get(licenseRes1AttribName) != null) {
                        try {
                            int licenseRes1 = Integer.parseInt((String)attributes.get(licenseRes1AttribName).get());
                            if (licenseRes1 == 3) {
                                resp.setLicenseRes1(licenseRes1);
                                break block49;
                            }
                            resp.setLicenseRes1(0);
                        }
                        catch (NumberFormatException ne) {
                            resp.setLicenseRes1(0);
                        }
                    } else {
                        resp.setLicenseRes1(props.getDefaultReservedLicense());
                    }
                }
                String licenseAppAttribName = props.getLicenseAppAttribName();
                if (licenseAppAttribName != null) {
                    if (attributes.get(licenseAppAttribName) != null) {
                        String licenseApp = (String)attributes.get(licenseAppAttribName).get();
                        resp.setLicenseApps(licenseApp);
                        continue;
                    }
                    resp.setLicenseApps(props.getDefaultLicenseApp());
                    continue;
                }
                resp.setLicenseApps(props.getDefaultLicenseApp());
            }
        }
        return dn;
    }

    private void logErrorMessage(ARPluginContext pluginContext, String message) {
        pluginContext.logMessage(this.pluginInfo, 2, message);
    }

    private void logInfoMessage(ARPluginContext pluginContext, String message) {
        pluginContext.logMessage(this.pluginInfo, 0, message);
    }

    private void logWarnMessage(ARPluginContext pluginContext, String message) {
        pluginContext.logMessage(this.pluginInfo, 1, message);
    }

    private Properties configurePlainLdapProps(ARPluginContext pluginContext, LDAPProps props) throws ARException {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", props.getURL());
        env.put("java.naming.security.authentication", "simple");
        if (props.getBindUser() != null && !props.getBindUser().isEmpty()) {
            env.put("java.naming.security.principal", props.getBindUser());
            if (props.getBindPasswd() != null) {
                env.put("java.naming.security.credentials", props.getBindPasswd());
            }
        } else {
            this.logInfoMessage(pluginContext, "AREA LDAP Bind user is not configured so trying anonymous access!");
        }
        if (props.useSSL()) {
            String certDb = props.getCertKeyStore();
            if (certDb == null || certDb.isEmpty()) {
                throw new ARException(2, 3377, "SSL/TLS is enabled but No certificate keystore provided!");
            }
            ARLDAPSSLFactory.setKeyStorePath(certDb);
            env.put("java.naming.security.protocol", "tls");
            this.logInfoMessage(pluginContext, "Protocol: " + env.getProperty("java.naming.security.protocol"));
            env.put("java.naming.ldap.factory.socket", "com.bmc.arsys.plugins.customssl.ARLDAPSSLFactory");
        } else {
            env.put("com.sun.jndi.ldap.connect.timeout", Integer.toString(props.getTimeout() * 1000));
        }
        return env;
    }

    private AREALdapConfig getAreaLdapConfig(ARPluginContext pluginContext) throws ARException {
        if (this.areaConfig == null) {
            this.areaConfig = this.initLdapProps(pluginContext);
        }
        return this.areaConfig;
    }

    private AREALdapConfig initLdapProps(ARPluginContext pluginContext) throws ARException {
        AREALdapConfig configProps = new AREALdapConfig();
        try {
            configProps.init(pluginContext);
        }
        catch (AREncryptionException e) {
            throw new ARException(2, e.getErrorNum(), e.toString());
        }
        return configProps;
    }

    private boolean isEmpty(String password) {
        return password == null || password.equals("");
    }

    private String replaceKeywords(String src, String dn, String user, String authString, String networkAddress) {
        if (src == null) {
            return null;
        }
        if (dn != null) {
            src = src.replace("$\\DN$", dn);
        }
        if (user != null) {
            src = src.replace("$\\USER$", user);
        }
        if (authString != null) {
            src = src.replace("$\\AUTHSTRING$", authString);
        }
        if (networkAddress != null) {
            src = src.replace("$\\NETWORKADDR$", networkAddress);
        }
        return src;
    }

    private NamingEnumeration<SearchResult> searchLdapEntries(DirContext ctx, String base, SearchControls scope, String filter, String chaseReferral) throws NamingException {
        return ctx.search(base, filter, scope);
    }

    private void logAREAResponse(ARPluginContext pluginContext, AREAResponse resp) {
        StringBuilder sb = new StringBuilder("AREA Response[");
        sb.append("Login Code:" + resp.getLoginStatus()).append(",Login Message:" + resp.getMessageText());
        if (resp.getLoginStatus() == 0) {
            sb.append(",Lic Mask:").append(resp.getLicenseMask()).append(", Write Lic:").append(resp.getLicenseWrite()).append(", Res Lic:").append(resp.getLicenseRes1()).append(", App Lic:").append(resp.getLicenseApps()).append(", email:").append(resp.getEmail()).append(", Notify Mech:").append(resp.getNotifyMech()).append(", Groups:").append(resp.getGroups());
        }
        sb.append("]");
        this.logInfoMessage(pluginContext, "Returning:" + sb.toString());
    }

    private AREAResponse generateErrorResponse(ARPluginContext pluginContext, AREAResponse resp, String errMgs) {
        pluginContext.logMessage(this.pluginInfo, 1, errMgs);
        pluginContext.logMessage(this.pluginInfo, 0, "Return Code:1");
        resp.setLoginStatus(1);
        return resp;
    }
}

