/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.ardbcldap;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.plugins.ardbcldap.ARDBCLDAPContext;
import com.bmc.arsys.plugins.ardbcldap.ARDBCUtils;
import com.bmc.arsys.pluginsvr.plugins.ARVendorField;
import java.util.List;
import java.util.Locale;

public class LDAPFilterExprGenerator {
    public static String getFilterExpression(QualifierInfo qInfo, List<ARVendorField> fieldsList, ARDBCLDAPContext ldapCtx, Locale locale) throws ARException {
        String filterExpr = null;
        if (!LDAPFilterExprGenerator.isQualifierInfoEmpty(qInfo)) {
            if (LDAPFilterExprGenerator.getRelationalOperationInfo(qInfo) != null) {
                filterExpr = LDAPFilterExprGenerator.getFilterExpression(qInfo.getRelationalOperationInfo(), fieldsList, ldapCtx, locale);
            } else {
                String leftExpr = LDAPFilterExprGenerator.getFilterExpression(qInfo.getLeftOperand(), fieldsList, ldapCtx, locale);
                String rightExpr = LDAPFilterExprGenerator.getFilterExpression(qInfo.getRightOperand(), fieldsList, ldapCtx, locale);
                int operation = qInfo.getOperation();
                filterExpr = LDAPFilterExprGenerator.prepareLogicalExpression(operation, leftExpr, rightExpr);
            }
        }
        return filterExpr;
    }

    private static String prepareLogicalExpression(int operation, String leftExpr, String rightExpr) throws ARException {
        String lExpression = leftExpr == null ? "" : leftExpr;
        String rExpression = rightExpr == null ? "" : rightExpr;
        switch (operation) {
            case 1: {
                if (lExpression.isEmpty()) {
                    if (rExpression.isEmpty()) {
                        return null;
                    }
                    return rExpression;
                }
                if (rExpression.isEmpty()) {
                    return lExpression;
                }
                return "(&" + lExpression + rExpression + ")";
            }
            case 2: {
                if (lExpression.isEmpty()) {
                    if (rExpression.isEmpty()) {
                        return null;
                    }
                    return rExpression;
                }
                if (rExpression.isEmpty()) {
                    return lExpression;
                }
                return "(|" + lExpression + rExpression + ")";
            }
            case 3: {
                String retString = lExpression.isEmpty() ? "" : "(!" + lExpression + ")";
                return retString;
            }
        }
        throw new ARException(2, 3377, "Unsupported Logical Operation type in  Qualification :'" + operation + "'");
    }

    private static String getFilterExpression(RelationalOperationInfo relInfo, List<ARVendorField> fieldsList, ARDBCLDAPContext ldapCtx, Locale locale) throws ARException {
        if (relInfo.getOperation() != 0) {
            ArithmeticOrRelationalOperand leftOprnd = relInfo.getLeftOperand();
            ArithmeticOrRelationalOperand rightOprnd = relInfo.getRightOperand();
            String leftExpr = LDAPFilterExprGenerator.getArithmeticOrRelationalOperandValue(leftOprnd, fieldsList, ldapCtx, locale);
            String rightExpr = LDAPFilterExprGenerator.getArithmeticOrRelationalOperandValue(rightOprnd, fieldsList, ldapCtx, locale);
            if (rightOprnd.getType().toInt() == 1 && leftOprnd.getType().toInt() != 1) {
                return LDAPFilterExprGenerator.getRelExpression(LDAPFilterExprGenerator.reverseRelOp(relInfo.getOperation()), rightExpr, leftExpr);
            }
            return LDAPFilterExprGenerator.getRelExpression(relInfo.getOperation(), leftExpr, rightExpr);
        }
        return null;
    }

    private static String getArithmeticOrRelationalOperandValue(ArithmeticOrRelationalOperand oprnd, List<ARVendorField> fieldsList, ARDBCLDAPContext ldapCtx, Locale locale) throws ARException {
        switch (oprnd.getType().toInt()) {
            case 1: {
                Integer fieldId = (Integer)oprnd.getValue();
                return LDAPFilterExprGenerator.getFieldMappedAttributeName(fieldId, fieldsList);
            }
            case 2: {
                Value val = (Value)oprnd.getValue();
                if (val == null || val.getValue() == null) break;
                if (val.getDataType().toInt() == 13 || val.getDataType().toInt() == 7) {
                    String format = null;
                    if (ldapCtx != null) {
                        format = ldapCtx.getDbcLdapProps().getTimeFormat();
                    }
                    return ARDBCUtils.getLDAPDateRepresentation(format, val);
                }
                return val.getValue().toString();
            }
            default: {
                throw new ARException(2, 3377, "Unsupported Qualification Operand type :" + oprnd.getType().toInt());
            }
        }
        return null;
    }

    private static String getFieldMappedAttributeName(int fieldId, List<ARVendorField> fieldsList) throws ARException {
        for (ARVendorField fld : fieldsList) {
            if (fld.getFieldId() != fieldId) continue;
            return fld.getName();
        }
        throw new ARException(2, 3377, "Vendor form list does not contains field definition for field ID:" + fieldId);
    }

    private static String getRelExpression(int relOp, String leftExpr, String rightExpr) throws ARException {
        String expr = null;
        switch (relOp) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                expr = "(" + leftExpr + LDAPFilterExprGenerator.getRelationOperationType(relOp) + rightExpr + ")";
                break;
            }
            case 6: {
                expr = "(!(" + leftExpr + "=" + rightExpr + "))";
                break;
            }
            case 7: {
                rightExpr = rightExpr.replaceAll("%", "*");
                expr = "(" + leftExpr + "=" + rightExpr + ")";
                break;
            }
            default: {
                throw new ARException(2, 3377, "Unsupported relation Operation in  Qualification :'" + LDAPFilterExprGenerator.getRelationOperationType(relOp) + "'");
            }
        }
        return expr;
    }

    private static String getRelationOperationType(int opType) throws ARException {
        switch (opType) {
            case 1: {
                return "=";
            }
            case 2: {
                return ">";
            }
            case 3: {
                return ">=";
            }
            case 4: {
                return "<";
            }
            case 5: {
                return "<=";
            }
            case 6: {
                return "!";
            }
            case 7: {
                return "*";
            }
        }
        throw new ARException(2, 3377, "Unsupported relation Operation Type Qualification :" + opType);
    }

    private static RelationalOperationInfo getRelationalOperationInfo(QualifierInfo qInfo) {
        try {
            return qInfo.getRelationalOperationInfo();
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    private static boolean isQualifierInfoEmpty(QualifierInfo qInfo) {
        if (qInfo == null) {
            return true;
        }
        try {
            if (qInfo.getRelationalOperationInfo() != null) {
                return false;
            }
            if (qInfo.getLeftOperand() != null && qInfo.getRightOperand() != null) {
                return false;
            }
        }
        catch (ClassCastException cce) {
            return false;
        }
        return true;
    }

    private static int reverseRelOp(int relOp) {
        if (relOp == 2) {
            return 4;
        }
        if (relOp == 3) {
            return 5;
        }
        if (relOp == 4) {
            return 2;
        }
        if (relOp == 5) {
            return 3;
        }
        return relOp;
    }
}

