/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.ardbcldap;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.StatisticsResultInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.VendorForm;
import com.bmc.arsys.plugins.ardbcldap.ARDBCLDAPContext;
import com.bmc.arsys.plugins.ardbcldap.ARDBCUtils;
import com.bmc.arsys.plugins.ardbcldap.DBCLdapProperties;
import com.bmc.arsys.plugins.ardbcldap.LDAPFilterExprGenerator;
import com.bmc.arsys.plugins.ardbcldap.LDAPUrl;
import com.bmc.arsys.plugins.ardbcldap.LDAPVendorField;
import com.bmc.arsys.plugins.ardbcldap.RootDSE;
import com.bmc.arsys.pluginsvr.plugins.ARDBCPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARVendorField;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;

public class ARDBCLDAPPlugin
extends ARDBCPlugin {
    public static final String NAMING_CONTEXTS = "namingContexts";
    public static final String DEFAULT_NAMING_CONTEXT = "defaultNamingContext";
    public static final String SUBSCHEMA_SUBENTRY = "subschemaSubentry";
    ARDBCLDAPContext ldapcontext = new ARDBCLDAPContext();

    public void initialize(ARPluginContext context) throws ARException {
        this.ldapcontext.populateProperties(context);
    }

    public void terminate(ARPluginContext context) throws ARException {
    }

    public String createEntry(ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, Entry entry) throws ARException {
        context.logMessage(context.getPluginInfo(), 0, "+createEntry");
        context.logMessage(context.getPluginInfo(), 0, " tableName:" + tableName);
        context.logMessage(context.getPluginInfo(), 0, "entry:" + entry);
        ARVendorField entryIDField = this.getEntryIdAttrib(fieldsList);
        String entryId = null;
        HashMap<Integer, LDAPVendorField> idVsMap = new HashMap<Integer, LDAPVendorField>();
        HashMap<String, LDAPVendorField> nameVsMap = new HashMap<String, LDAPVendorField>();
        ARDBCUtils.populateFieldMaps(idVsMap, nameVsMap, fieldsList);
        ARVendorField dnField = ARDBCUtils.getDNField(nameVsMap);
        if (dnField == null) {
            context.logMessage(context.getPluginInfo(), 2, "Cannot create entry because 'distinguishedname' or 'dn' attribute is not mapped to any vendor form field!");
            throw new ARException(2, 3378);
        }
        Value dnValue = (Value)entry.get((Object)dnField.getFieldId());
        String dn = null;
        if (dnValue == null || dnValue.getValue() == null || !dnValue.getDataType().equals((Object)DataType.CHAR)) {
            context.logMessage(context.getPluginInfo(), 2, "Cannot create because value of Distinguished field is null or empty! " + dnField.getFieldId());
            String msgBuf = "field " + dnField.getFieldId();
            throw new ARException(2, 3379, msgBuf);
        }
        dn = (String)dnValue.getValue();
        BasicAttributes attribs = new BasicAttributes();
        for (Map.Entry currEntry : entry.entrySet()) {
            Integer fieldId = (Integer)currEntry.getKey();
            LDAPVendorField fld = (LDAPVendorField)((Object)idVsMap.get(fieldId));
            if (fld != null) {
                String fieldName = fld.getName();
                if (fieldName == null || fieldName.equalsIgnoreCase("dn") || fieldName.equalsIgnoreCase("distinguishedname") || fieldId == 1) continue;
                if (fld.getDataType() == 13 || fld.getDataType() == 7) {
                    ARDBCUtils.setDateAttributeValue(attribs, this.ldapcontext.getDbcLdapProps().getTimeFormat(), fld, (Value)currEntry.getValue());
                    continue;
                }
                ARDBCUtils.setAttributeValue(attribs, fld, (Value)currEntry.getValue());
                continue;
            }
            context.logMessage(context.getPluginInfo(), 2, "Error in createEntry:Supplied Vendor fields does not contains field id :" + fieldId);
            throw new ARException(2, 3377, "Supplied Vendor fields does not contains field id :" + fieldId);
        }
        LdapContext initialContext = null;
        try {
            initialContext = this.ldapcontext.getInitialContext(context);
            context.logMessage(context.getPluginInfo(), 0, "Create LDAP Entry with DN:" + dn);
            context.logMessage(context.getPluginInfo(), 0, "Entry Attributes:" + attribs);
            initialContext.createSubcontext(dn, (Attributes)attribs);
            SearchControls sCntrl = new SearchControls();
            sCntrl.setReturningAttributes(new String[]{entryIDField.getName()});
            sCntrl.setSearchScope(2);
            NamingEnumeration<SearchResult> enm = initialContext.search(dn, "(objectclass=*)", sCntrl);
            if (enm.hasMoreElements()) {
                SearchResult searchResult = (SearchResult)enm.nextElement();
                Attributes attributes = searchResult.getAttributes();
                NamingEnumeration<? extends Attribute> attrEnum = attributes.getAll();
                while (attrEnum.hasMoreElements()) {
                    Attribute nextElement = (Attribute)attrEnum.nextElement();
                    if (!nextElement.getID().equals(entryIDField.getName())) continue;
                    entryId = nextElement.get().toString();
                }
            }
            context.logMessage(context.getPluginInfo(), 0, "-createEntry");
            String string = entryId;
            return string;
        }
        catch (Exception e) {
            context.logMessage(context.getPluginInfo(), 2, "Error in createEntry:" + e.toString());
            throw new ARException(2, 3377, e.toString());
        }
        finally {
            this.releaseLdapConnection(initialContext);
        }
    }

    public Entry getEntry(ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, String entryId, int[] idList) throws ARException {
        context.logMessage(context.getPluginInfo(), 0, "+getEntry:");
        context.logMessage(context.getPluginInfo(), 0, "Look up Entry with entry Id:" + entryId);
        LDAPUrl url = ARDBCUtils.parseURL(tableName);
        ARVendorField entryIDField = this.getEntryIdAttrib(fieldsList);
        Object actEntryId = null;
        boolean entryIdIsDN = false;
        if (!entryId.contains(":-:") && entryId.contains(",")) {
            entryIdIsDN = true;
        }
        String filter = this.createLDAPFilter(context, entryId, url, entryIDField);
        context.logMessage(context.getPluginInfo(), 0, "Filter expression for getEntry :" + filter);
        HashMap<Integer, LDAPVendorField> idVsMap = new HashMap<Integer, LDAPVendorField>();
        HashMap<String, LDAPVendorField> nameVsMap = new HashMap<String, LDAPVendorField>();
        ARDBCUtils.populateFieldMaps(idVsMap, nameVsMap, fieldsList);
        String[] attrs = nameVsMap.keySet().toArray(new String[0]);
        SearchControls sCntrl = new SearchControls();
        sCntrl.setReturningAttributes(attrs);
        sCntrl.setSearchScope(2);
        LdapContext initialContext = null;
        try {
            Attributes attributes = null;
            HashMap<Integer, Value> valueMap = new HashMap<Integer, Value>();
            initialContext = this.ldapcontext.getInitialContext(context);
            if (entryIdIsDN) {
                attributes = initialContext.getAttributes(entryId, attrs);
            } else {
                NamingEnumeration<SearchResult> enm = initialContext.search(url.getBaseName(), filter, sCntrl);
                if (enm.hasMoreElements()) {
                    SearchResult searchResult = (SearchResult)enm.nextElement();
                    ARVendorField dnField = (ARVendorField)nameVsMap.get("dn");
                    if (dnField != null) {
                        valueMap.put(dnField.getFieldId(), new Value(searchResult.getNameInNamespace(), DataType.toDataType((int)dnField.getDataType())));
                    }
                    attributes = searchResult.getAttributes();
                }
            }
            if (attributes != null) {
                NamingEnumeration<? extends Attribute> attrEnum = attributes.getAll();
                while (attrEnum.hasMoreElements()) {
                    Attribute nextElement = (Attribute)attrEnum.nextElement();
                    LDAPVendorField field = (LDAPVendorField)((Object)nameVsMap.get(nextElement.getID()));
                    if (field == null) {
                        context.logMessage(context.getPluginInfo(), 2, "Vendor field definition missing:" + nextElement.getID());
                        throw new ARException(2, 3377, "Vendor field definition missing:" + nextElement.getID());
                    }
                    Object elmValue = null;
                    try {
                        elmValue = ARDBCUtils.getAttributeValue(nextElement, field);
                    }
                    catch (ParseException e) {
                        context.logMessage(context.getPluginInfo(), 1, e.toString());
                    }
                    Value value = new Value(elmValue, DataType.toDataType((int)field.getDataType()));
                    valueMap.put(field.getFieldId(), value);
                    if (!field.getName().equals(entryIDField.getName())) continue;
                    valueMap.put(entryIDField.getFieldId(), value);
                }
            }
            Entry entry = new Entry(valueMap);
            context.logMessage(context.getPluginInfo(), 0, "Returning Entry:" + entry);
            context.logMessage(context.getPluginInfo(), 0, "-getEntry:");
            Entry entry2 = entry;
            this.releaseLdapConnection(initialContext);
            return entry2;
        }
        catch (Exception e) {
            try {
                context.logMessage(context.getPluginInfo(), 2, "Error in getEntry:" + e.toString());
                throw new ARException(2, 3377, e.toString());
            }
            catch (Throwable throwable) {
                this.releaseLdapConnection(initialContext);
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String createLDAPFilter(ARPluginContext context, String entryId, LDAPUrl url, ARVendorField entryIDField) throws ARException {
        String actEntryId = null;
        if (entryId.contains(":-:")) {
            context.logMessage(context.getPluginInfo(), 0, "EntryID contains embedded baseDN");
            String[] splitArray = entryId.split("\\:-:");
            if (splitArray.length != 2) throw new ARException(2, 3377, "Separator Pattern <:-:> occurs more than once in the passed entryID");
            url.setBaseName(splitArray[0]);
            actEntryId = splitArray[1];
            context.logMessage(context.getPluginInfo(), 0, "ActEntryID = " + actEntryId);
        } else if (entryId.contains(",")) {
            // empty if block
        }
        String filter = new StringBuffer("(").append(entryIDField.getName()).append("=").append(actEntryId == null ? entryId : actEntryId).append(")").toString();
        if (filter == null) return url.getFilter();
        if (filter.length() == 0) return url.getFilter();
        return "(&" + url.getFilter() + filter + ")";
    }

    public void setEntry(ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, String entryId, Entry entry, Timestamp getTimestamp) throws ARException {
        context.logMessage(context.getPluginInfo(), 0, "+setEntry:");
        context.logMessage(context.getPluginInfo(), 0, " Entry Id:" + entryId);
        context.logMessage(context.getPluginInfo(), 0, "Update Entry:" + entry);
        LDAPUrl url = ARDBCUtils.parseURL(tableName);
        ARVendorField entryIDField = this.getEntryIdAttrib(fieldsList);
        String filter = this.createLDAPFilter(context, entryId, url, entryIDField);
        HashMap<String, LDAPVendorField> nameVsMap = new HashMap<String, LDAPVendorField>();
        HashMap<Integer, LDAPVendorField> idVsMap = new HashMap<Integer, LDAPVendorField>();
        ARDBCUtils.populateFieldMaps(idVsMap, nameVsMap, fieldsList);
        String[] attrs = nameVsMap.keySet().toArray(new String[0]);
        SearchControls sCntrl = new SearchControls();
        sCntrl.setReturningAttributes(attrs);
        sCntrl.setSearchScope(2);
        LdapContext initialContext = null;
        try {
            initialContext = this.ldapcontext.getInitialContext(context);
            NamingEnumeration<SearchResult> enm = initialContext.search(url.getBaseName(), filter, sCntrl);
            if (enm.hasMoreElements()) {
                SearchResult searchResult = (SearchResult)enm.nextElement();
                String dn = searchResult.getNameInNamespace();
                BasicAttributes modAttrs = new BasicAttributes();
                Iterator iterator = entry.keySet().iterator();
                while (iterator.hasNext()) {
                    int key = (Integer)iterator.next();
                    if (key == 1) continue;
                    LDAPVendorField field = (LDAPVendorField)((Object)idVsMap.get(key));
                    if (field != null) {
                        Value value = (Value)entry.get((Object)key);
                        if (value == null) continue;
                        if (field.getDataType() == 13 || field.getDataType() == 7) {
                            ARDBCUtils.setDateAttributeValue(modAttrs, this.ldapcontext.getDbcLdapProps().getTimeFormat(), field, value);
                            continue;
                        }
                        ARDBCUtils.setAttributeValue(modAttrs, field, value);
                        continue;
                    }
                    context.logMessage(context.getPluginInfo(), 1, "Ignoring field since, No vendor Field defined for field Id" + key);
                }
                context.logMessage(context.getPluginInfo(), 0, "Update LDAP with DN:" + dn);
                context.logMessage(context.getPluginInfo(), 0, "Updating attributes:" + modAttrs);
                initialContext.modifyAttributes(dn, 2, (Attributes)modAttrs);
            }
            context.logMessage(context.getPluginInfo(), 0, "-setEntry:");
        }
        catch (Exception e) {
            context.logMessage(context.getPluginInfo(), 2, "Error in setEntry:" + e.toString());
            throw new ARException(2, 3377, e.toString());
        }
        finally {
            this.releaseLdapConnection(initialContext);
        }
    }

    public void deleteEntry(ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, String entryId) throws ARException {
        context.logMessage(context.getPluginInfo(), 0, "+deleteEntry:");
        context.logMessage(context.getPluginInfo(), 0, "Delete entry id:" + entryId);
        LDAPUrl url = ARDBCUtils.parseURL(tableName);
        ARVendorField entryIDField = this.getEntryIdAttrib(fieldsList);
        String filter = this.createLDAPFilter(context, entryId, url, entryIDField);
        SearchControls sCntrl = new SearchControls();
        sCntrl.setSearchScope(2);
        LdapContext initialContext = null;
        try {
            initialContext = this.ldapcontext.getInitialContext(context);
            NamingEnumeration<SearchResult> enm = initialContext.search(url.getBaseName(), filter, sCntrl);
            if (enm.hasMoreElements()) {
                SearchResult searchResult = (SearchResult)enm.nextElement();
                String dn = searchResult.getNameInNamespace();
                context.logMessage(context.getPluginInfo(), 0, "Delete LDAP entry with DN :" + dn);
                initialContext.destroySubcontext(dn);
            }
            context.logMessage(context.getPluginInfo(), 0, "-deleteEntry:");
        }
        catch (Exception e) {
            context.logMessage(context.getPluginInfo(), 2, "Error in deleteEntry:" + e.toString());
            throw new ARException(2, 3377, e.toString());
        }
        finally {
            this.releaseLdapConnection(initialContext);
        }
    }

    public AttachmentValue getBLOB(ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, String entryId, int fieldId) throws ARException {
        throw new UnsupportedOperationException("This operation is not supported.");
    }

    public void setBLOB(ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, String entryId, int fieldId, AttachmentValue info) throws ARException {
        throw new UnsupportedOperationException("This operation is not supported.");
    }

    public List<Entry> getListEntryWithFields(ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, QualifierInfo qualifier, List<SortInfo> sortList, List<EntryListFieldInfo> getListFields, int startAt, int maxRetrieve, OutputInteger numMatches) throws ARException {
        context.logMessage(context.getPluginInfo(), 0, "+getListEntryWithFields:");
        LDAPUrl url = ARDBCUtils.parseURL(tableName);
        ARVendorField entryIDField = this.getEntryIdAttrib(fieldsList);
        String filter = this.createFilter(qualifier, fieldsList, this.ldapcontext, null, url);
        filter = filter != null && filter.length() != 0 ? "(&" + url.getFilter() + filter + ")" : url.getFilter();
        context.logMessage(context.getPluginInfo(), 0, "getListEntryWithFields: Base URL:" + url.getBaseName());
        context.logMessage(context.getPluginInfo(), 0, "getListEntryWithFields: Query Filter:" + filter);
        HashMap<Integer, LDAPVendorField> idVsMap = new HashMap<Integer, LDAPVendorField>();
        HashMap<String, LDAPVendorField> nameVsMap = new HashMap<String, LDAPVendorField>();
        ARDBCUtils.populateFieldMaps(idVsMap, nameVsMap, fieldsList);
        String[] attrs = new String[getListFields.size()];
        for (int i = 0; i < getListFields.size(); ++i) {
            LDAPVendorField field = (LDAPVendorField)((Object)idVsMap.get(getListFields.get(i).getFieldId()));
            if (field != null) {
                attrs[i] = field.getName();
                continue;
            }
            context.logMessage(context.getPluginInfo(), 1, "No vendor Field defined for field Id" + getListFields.get(i).getFieldId());
        }
        SearchControls sCntrl = new SearchControls();
        sCntrl.setReturningAttributes(attrs);
        if (url.getScope() == 1) {
            context.logMessage(context.getPluginInfo(), 0, "getListEntryWithFields: ONELEVEL_SCOPE");
            sCntrl.setSearchScope(1);
        } else {
            context.logMessage(context.getPluginInfo(), 0, "getListEntryWithFields: SUBTREE_SCOPE");
            sCntrl.setSearchScope(2);
        }
        sCntrl.setCountLimit(maxRetrieve);
        int pageSize = this.ldapcontext.getDbcLdapProps().getPageSize();
        byte[] cookie = null;
        ArrayList<Entry> entryList = new ArrayList<Entry>();
        LdapContext initialContext = null;
        try {
            Object enm;
            initialContext = this.ldapcontext.getInitialContext(context);
            if (maxRetrieve != 0 && pageSize > maxRetrieve) {
                pageSize = maxRetrieve;
                initialContext.setRequestControls(new Control[]{new PagedResultsControl(pageSize, true)});
            }
            do {
                enm = initialContext.search(url.getBaseName(), filter, sCntrl);
                while (enm.hasMoreElements()) {
                    SearchResult searchResult = (SearchResult)enm.nextElement();
                    context.logMessage(context.getPluginInfo(), 0, searchResult.getNameInNamespace());
                    HashMap<Integer, Value> valueMap = new HashMap<Integer, Value>();
                    Attributes attributes = searchResult.getAttributes();
                    NamingEnumeration<? extends Attribute> attrEnum = attributes.getAll();
                    Value requestIdValue = null;
                    while (attrEnum.hasMoreElements()) {
                        Attribute nextElement = (Attribute)attrEnum.nextElement();
                        LDAPVendorField field = (LDAPVendorField)((Object)nameVsMap.get(nextElement.getID()));
                        Object obj = null;
                        try {
                            obj = ARDBCUtils.getAttributeValue(nextElement, field);
                        }
                        catch (ParseException e) {
                            context.logMessage(context.getPluginInfo(), 1, e.toString());
                        }
                        Value value = new Value(obj, DataType.toDataType((int)field.getDataType()));
                        valueMap.put(field.getFieldId(), value);
                        if (!field.getName().equals(entryIDField.getName())) continue;
                        requestIdValue = value;
                    }
                    if (requestIdValue != null) {
                        valueMap.put(entryIDField.getFieldId(), new Value(url.getBaseName() + ":-:" + requestIdValue.toString(), DataType.toDataType((int)4)));
                    } else {
                        valueMap.put(entryIDField.getFieldId(), new Value(searchResult.getNameInNamespace(), DataType.toDataType((int)entryIDField.getDataType())));
                    }
                    entryList.add(new Entry(valueMap));
                }
                Control[] controls = initialContext.getResponseControls();
                if (controls != null) {
                    for (int i = 0; i < controls.length; ++i) {
                        if (!(controls[i] instanceof PagedResultsResponseControl)) continue;
                        PagedResultsResponseControl prrc = (PagedResultsResponseControl)controls[i];
                        cookie = prrc.getCookie();
                    }
                }
                initialContext.setRequestControls(new Control[]{new PagedResultsControl(pageSize, cookie, true)});
            } while (cookie != null && entryList.size() < maxRetrieve);
            if (numMatches != null) {
                numMatches.setValue(entryList.size());
            }
            context.logMessage(context.getPluginInfo(), 0, "-getListEntryWithFields:");
            enm = entryList;
            return enm;
        }
        catch (Exception e) {
            context.logMessage(context.getPluginInfo(), 2, "Error in getListEntryWithFields:" + e.toString());
            throw new ARException(2, 3377, e.toString());
        }
        finally {
            this.releaseLdapConnection(initialContext);
        }
    }

    private String extractSearchBaseDn(QualifierInfo qualifier) {
        String baseName = null;
        switch (qualifier.getOperation()) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                baseName = this.extractSearchBaseDn(qualifier.getLeftOperand());
                if (baseName != null) break;
                baseName = this.extractSearchBaseDn(qualifier.getRightOperand());
                break;
            }
            case 3: {
                baseName = this.extractSearchBaseDn(qualifier.getNotOperand());
                break;
            }
            case 4: {
                if (qualifier.getRelationalOperationInfo().getOperation() != 7 || qualifier.getRelationalOperationInfo().getLeftOperand().getType().toInt() == 0 || qualifier.getRelationalOperationInfo().getLeftOperand().getType().toInt() + 12 >= 50 || (Integer)qualifier.getRelationalOperationInfo().getLeftOperand().getValue() != 4000 || qualifier.getRelationalOperationInfo().getRightOperand().getType().toInt() != 2 || !(qualifier.getRelationalOperationInfo().getRightOperand().getValue() instanceof Value) || ((Value)qualifier.getRelationalOperationInfo().getRightOperand().getValue()).getDataType().toInt() != 4) break;
                baseName = ((Value)qualifier.getRelationalOperationInfo().getRightOperand().getValue()).getValue().toString();
                baseName = baseName.substring(1, baseName.length() - 1);
                qualifier.getRelationalOperationInfo().setLeftOperand(null);
                qualifier.getRelationalOperationInfo().setRightOperand(null);
                qualifier.getRelationalOperationInfo().setOperation(0);
            }
        }
        return baseName;
    }

    private String createFilter(QualifierInfo qualifier, List<ARVendorField> fieldsList, ARDBCLDAPContext ldapCtx, Locale locale, LDAPUrl url) throws ARException {
        String baseName = this.extractSearchBaseDn(qualifier);
        if (baseName != null) {
            url.setBaseName(baseName);
        }
        return LDAPFilterExprGenerator.getFilterExpression(qualifier, fieldsList, ldapCtx, locale);
    }

    private ARVendorField getEntryIdAttrib(List<ARVendorField> fieldsList) {
        ARVendorField entryIDField = null;
        for (int i = 0; i < fieldsList.size(); ++i) {
            ARVendorField currField = fieldsList.get(i);
            if (currField.getFieldId() != 1) continue;
            entryIDField = currField;
            break;
        }
        return entryIDField;
    }

    public void commit(ARPluginContext context, long transId) throws ARException {
    }

    public void rollback(ARPluginContext context, long transId) throws ARException {
    }

    public void cancel(ARPluginContext context, long transId) throws ARException {
    }

    public List<VendorForm> getListForms(ARPluginContext context) throws ARException {
        context.logMessage(context.getPluginInfo(), 0, "+getListForms:");
        DBCLdapProperties props = this.ldapcontext.getDbcLdapProps();
        int portNumber = props.getPortNumber();
        StringBuilder ldapURL = new StringBuilder();
        LdapContext initialContext = null;
        try {
            initialContext = this.ldapcontext.getInitialContext(context);
            RootDSE rootDSE = this.ldapcontext.getBaseName(initialContext);
            if (!props.isUseSSL()) {
                if (portNumber == 389) {
                    ldapURL.append("ldap://").append(props.getResolvedHost()).append("/");
                } else {
                    ldapURL.append("ldap://").append(props.getResolvedHost()).append(":").append(portNumber).append("/");
                }
            } else if (portNumber == 636) {
                ldapURL.append("ldaps://").append(props.getResolvedHost()).append("/");
            } else {
                ldapURL.append("ldaps://").append(props.getResolvedHost()).append(":").append(portNumber).append("/");
            }
            List<VendorForm> forms = this.ldapcontext.getTableNames(context, initialContext, ldapURL, rootDSE);
            context.logMessage(context.getPluginInfo(), 0, "-getListForms:");
            List<VendorForm> list = forms;
            return list;
        }
        catch (Exception e) {
            context.logMessage(context.getPluginInfo(), 2, "Error in getListForms:" + e.toString());
            throw new ARException(2, 3377, e.toString());
        }
        finally {
            this.releaseLdapConnection(initialContext);
        }
    }

    public List<ARVendorField> getMultipleFields(ARPluginContext context, VendorForm schema) throws ARException {
        context.logMessage(context.getPluginInfo(), 0, "+getMultipleFields:");
        if (schema == null) {
            return null;
        }
        ArrayList<ARVendorField> fieldList = new ArrayList();
        String tableName = schema.getTableName();
        LdapContext initialContext = null;
        try {
            initialContext = this.ldapcontext.getInitialContext(context);
            RootDSE rootDSE = this.ldapcontext.getBaseName(initialContext);
            fieldList = this.ldapcontext.getObjectAttributes(tableName, rootDSE, initialContext);
        }
        catch (Exception e) {
            context.logMessage(context.getPluginInfo(), 2, "Error in getMultipleFields:" + e.toString());
            throw new ARException(2, 3377, e.toString());
        }
        finally {
            this.releaseLdapConnection(initialContext);
        }
        context.logMessage(context.getPluginInfo(), 0, "-getMultipleFields:");
        return fieldList;
    }

    public List<StatisticsResultInfo> getEntryStatistics(ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, QualifierInfo qualifier, ArithmeticOrRelationalOperand target, int statistic, int[] groupByList) throws ARException {
        return null;
    }

    private void releaseLdapConnection(LdapContext initialContext) {
        if (initialContext != null) {
            try {
                initialContext.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            initialContext = null;
        }
    }
}

