/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.fts.impl.lucene;

import com.bmc.arsys.fts.FTSService;
import com.bmc.arsys.fts.FTSServiceException;
import com.bmc.arsys.fts.impl.lucene.FTSSearcherManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public final class FTSSearcherManagerFactory {
    private static final String FTS_SEARCHER_MANAGER_REFRESHER_THREAD = "FTSSearcherManager-RefresherThread";
    private static final Logger LOGGER = Logger.getLogger(FTSSearcherManagerFactory.class);
    private static final int DEFAULT_REFRESH_PERIOD = 2000;
    private static final int INIT_CAPACITY = 50;
    private final String baseIndexDir;
    private static volatile FTSSearcherManagerFactory me;
    private volatile ConcurrentMap<String, SearcherManager> schemaSearcherManagerMap = new ConcurrentHashMap<String, SearcherManager>(50);
    private volatile boolean keepRunning = true;
    private volatile long refreshDelay = 2000L;

    public static synchronized FTSSearcherManagerFactory getInstance(String collectionDir) {
        if (me != null) {
            return me;
        }
        me = new FTSSearcherManagerFactory(collectionDir);
        return me;
    }

    private FTSSearcherManagerFactory(String collectionDir) {
        this.baseIndexDir = collectionDir;
        this.refreshPeriodically();
    }

    public FTSSearcherManager getSearcherManager(List<FTSService.QuerySchemas> querySchemasList) throws FTSServiceException {
        if (querySchemasList == null || querySchemasList.size() == 0) {
            return null;
        }
        FTSSearcherManager searcherManager = this.createSearcherManager(querySchemasList);
        return searcherManager;
    }

    public FTSSearcherManager getSearcherManager(String schemaId) throws FTSServiceException {
        FTSSearcherManager searcherManager = this.createSearcherManager(schemaId);
        return searcherManager;
    }

    private FTSSearcherManager createSearcherManager(String schemaId) throws FTSServiceException {
        FTSSearcherManager multiReaderSearcherManager = null;
        try {
            SearcherManager tmpSm = this.createIndexReaderIfAbsent(schemaId);
            if (tmpSm != null) {
                multiReaderSearcherManager = new FTSSearcherManager(tmpSm);
            }
        }
        catch (IOException ioE) {
            throw new FTSServiceException(this.getClass().getName() + " getIndexSearcher: Error getting index searcher.  Likely cause is index does not exist", ioE);
        }
        return multiReaderSearcherManager;
    }

    public void close(String schemaId) throws IOException {
        SearcherManager searcherManager = (SearcherManager)this.schemaSearcherManagerMap.remove(schemaId);
        if (searcherManager != null) {
            searcherManager.close();
        }
    }

    public synchronized void closeAll() throws IOException {
        this.stopRefresherThread();
        for (SearcherManager sm : this.schemaSearcherManagerMap.values()) {
            sm.close();
        }
        this.schemaSearcherManagerMap.clear();
    }

    public long getRefreshDelay() {
        return this.refreshDelay;
    }

    public synchronized void setRefreshDelay(long tmpRefreshDelay) {
        this.refreshDelay = tmpRefreshDelay;
    }

    private FTSSearcherManager createSearcherManager(List<FTSService.QuerySchemas> querySchemasList) throws FTSServiceException {
        FTSSearcherManager multiReaderSearcherManager = null;
        try {
            ArrayList<SearcherManager> schemaSeacherManagers = new ArrayList<SearcherManager>(querySchemasList.size());
            for (FTSService.QuerySchemas querySchemas : querySchemasList) {
                SearcherManager tmpSm = this.createIndexReaderIfAbsent(querySchemas.schemaId);
                if (tmpSm == null) continue;
                schemaSeacherManagers.add(tmpSm);
            }
            multiReaderSearcherManager = new FTSSearcherManager(schemaSeacherManagers);
        }
        catch (IOException ioE) {
            throw new FTSServiceException(this.getClass().getName() + " getIndexSearcher: Error getting index searcher.  Likely cause is index does not exist", ioE);
        }
        return multiReaderSearcherManager;
    }

    private void refreshPeriodically() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                while (FTSSearcherManagerFactory.this.keepRunning) {
                    try {
                        FTSSearcherManagerFactory.this.maybeRefresh();
                        Thread.sleep(FTSSearcherManagerFactory.this.refreshDelay);
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)"Problem refreshing SearcherManager", (Throwable)e);
                    }
                }
                LOGGER.debug((Object)"refreshPeriodically(): Stopping the refresh thread ...");
            }
        }, FTS_SEARCHER_MANAGER_REFRESHER_THREAD);
        t.start();
    }

    private void maybeRefresh() throws IOException {
        for (SearcherManager sm : this.schemaSearcherManagerMap.values()) {
            try {
                sm.maybeRefresh();
            }
            catch (AlreadyClosedException e) {
                LOGGER.debug((Object)"SM is already closed so ignore it.");
            }
        }
        LOGGER.debug((Object)"maybeRefresh() called ...");
    }

    private synchronized SearcherManager createIndexReaderIfAbsent(String schemaId) throws IOException {
        if (this.schemaSearcherManagerMap.containsKey(schemaId)) {
            return (SearcherManager)this.schemaSearcherManagerMap.get(schemaId);
        }
        File dir = this.getSchemaCollectionDir(schemaId);
        if (dir == null) {
            return null;
        }
        FSDirectory fsDir = FSDirectory.open((File)dir);
        SearcherManager searcherManager = new SearcherManager((Directory)fsDir, null);
        this.schemaSearcherManagerMap.put(schemaId, searcherManager);
        return searcherManager;
    }

    private void stopRefresherThread() {
        this.keepRunning = false;
        try {
            Thread.sleep(this.refreshDelay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private File getSchemaCollectionDir(String schemaId) throws IOException {
        String schemaCollectionDir = this.baseIndexDir + FileSystems.getDefault().getSeparator() + schemaId;
        File f = new File(schemaCollectionDir);
        if (!f.exists()) {
            f = null;
        }
        return f;
    }
}

