/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.fts.impl.DocHandler;

import com.bmc.arsys.fts.DocumentHandler;
import com.bmc.arsys.fts.FileHandler;
import com.bmc.arsys.fts.impl.DocHandler.DocumentHandlerException;
import com.bmc.arsys.fts.impl.DocHandler.FileHandlerException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Properties;

public class ExtensionFileHandler
implements FileHandler {
    private Properties m_props;

    public ExtensionFileHandler(Properties props) {
        this.m_props = props;
    }

    @Override
    public String getText(File file) throws FileHandlerException {
        try {
            DocumentHandler handler = this.getDocumentHandler(file.getName());
            return handler.getText(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new FileHandlerException("File not found: " + file.getAbsolutePath(), e);
        }
        catch (DocumentHandlerException e) {
            throw new FileHandlerException("Document cannot be handled: " + file.getAbsolutePath(), e);
        }
    }

    public String getText(String fileName, byte[] fileContent) throws DocumentHandlerException {
        DocumentHandler handler = this.getDocumentHandler(fileName);
        return handler.getText(new ByteArrayInputStream(fileContent));
    }

    private DocumentHandler getDocumentHandler(String fileName) throws DocumentHandlerException {
        String handlerClassName = null;
        int dotIndex = fileName.indexOf(".");
        if (dotIndex > 0 && dotIndex < fileName.length()) {
            String ext = fileName.substring(dotIndex + 1, fileName.length());
            handlerClassName = this.m_props.getProperty(ext);
        }
        if (handlerClassName == null) {
            handlerClassName = this.m_props.getProperty("txt");
        }
        try {
            Class<?> handlerClass = Class.forName(handlerClassName);
            return (DocumentHandler)handlerClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new DocumentHandlerException("Cannot create instance of : " + handlerClassName, e);
        }
        catch (InstantiationException e) {
            throw new DocumentHandlerException("Cannot create instance of : " + handlerClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new DocumentHandlerException("Cannot create instance of : " + handlerClassName, e);
        }
    }
}

