/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arreporting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ARDataStructure {
    private static final Pattern ARRAY_PATTERN = Pattern.compile("((\\s*+([^\";]+\\\"[^\"]*+\\\"[^\";]*+)+\\s*+)|(\\s*+\\\"(([^\"]|(\"\"))*+)\\\"\\s*+)|([^;]+))(;|$)");
    private static final Pattern MAP_PATTERN = Pattern.compile("\\s*+([^=\\s;]+)\\s*+=((\\s*+([^\";]+\\\"[^\"]*+\\\"[^\";]*+)*+\\s*+)|(\\s*+\\\"(([^\"]|(\"\"))*+)\\\"\\s*+)|([^;]*+))(;|$)");

    public static ArrayList<String> processAsList(String listValue) {
        ArrayList<String> list = new ArrayList<String>();
        if (listValue == null || listValue.length() == 0) {
            return list;
        }
        Matcher mt1 = ARRAY_PATTERN.matcher(listValue);
        while (mt1.find()) {
            String val = mt1.group(2) != null && mt1.group(2).length() > 0 ? mt1.group(2) : (mt1.group(3) != null && mt1.group(3).length() > 0 ? mt1.group(3) : (mt1.group(5) != null && mt1.group(5).length() > 0 ? (mt1.group(7) != null && mt1.group(7).length() > 0 ? mt1.group(5).replaceAll("\"\"", "\"") : mt1.group(5)) : mt1.group(8)));
            if (val == null || val.length() <= 0) continue;
            list.add(val);
        }
        return list;
    }

    public static HashMap<String, String> processAsMap(String mapValue) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (mapValue == null || mapValue.length() == 0) {
            return map;
        }
        Matcher matcher = MAP_PATTERN.matcher(mapValue);
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = matcher.group(3) != null && matcher.group(3).length() > 0 ? matcher.group(3) : (matcher.group(4) != null && matcher.group(4).length() > 0 ? matcher.group(4) : (matcher.group(6) != null && matcher.group(6).length() > 0 ? (matcher.group(8) != null && matcher.group(8).length() > 0 ? matcher.group(6).replaceAll("\"\"", "\"") : matcher.group(6)) : matcher.group(9)));
            if (value == null || value.length() <= 0) continue;
            map.put(key, value);
        }
        return map;
    }
}

