/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.server;

import java.io.IOException;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcPortmapClient;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.XdrEncodingStream;
import org.acplt.oncrpc.server.OncRpcCallInformation;
import org.acplt.oncrpc.server.OncRpcDispatchable;
import org.acplt.oncrpc.server.OncRpcServerReplyMessage;
import org.acplt.oncrpc.server.OncRpcServerTransportRegistrationInfo;

public abstract class OncRpcServerTransport {
    protected OncRpcDispatchable dispatcher;
    protected int port;
    protected OncRpcServerTransportRegistrationInfo[] info;

    protected OncRpcServerTransport(OncRpcDispatchable dispatcher, int port, OncRpcServerTransportRegistrationInfo[] info) {
        this.dispatcher = dispatcher;
        this.port = port;
        this.info = info;
    }

    public abstract void register() throws OncRpcException;

    public void unregister() throws OncRpcException {
        try {
            OncRpcPortmapClient portmapper = new OncRpcPortmapClient(InetAddress.getLocalHost());
            int size = this.info.length;
            for (int idx = 0; idx < size; ++idx) {
                portmapper.unsetPort(this.info[idx].program, this.info[idx].version);
            }
        }
        catch (IOException e) {
            throw new OncRpcException(16);
        }
    }

    public void unregister(String hostName) throws OncRpcException {
        try {
            OncRpcPortmapClient portmapper = new OncRpcPortmapClient(InetAddress.getByName(hostName));
            int size = this.info.length;
            for (int idx = 0; idx < size; ++idx) {
                portmapper.unsetPort(this.info[idx].program, this.info[idx].version);
            }
        }
        catch (IOException e) {
            throw new OncRpcException(16);
        }
    }

    public abstract void close();

    public abstract void listen();

    public int getPort() {
        return this.port;
    }

    public abstract void setCharacterEncoding(String var1);

    public abstract String getCharacterEncoding();

    protected abstract void retrieveCall(XdrAble var1) throws OncRpcException, IOException;

    protected abstract XdrDecodingStream getXdrDecodingStream();

    protected abstract void endDecoding() throws OncRpcException, IOException;

    protected abstract XdrEncodingStream getXdrEncodingStream();

    protected abstract void beginEncoding(OncRpcCallInformation var1, OncRpcServerReplyMessage var2) throws OncRpcException, IOException;

    protected abstract void endEncoding() throws OncRpcException, IOException;

    protected abstract void reply(OncRpcCallInformation var1, OncRpcServerReplyMessage var2, XdrAble var3) throws OncRpcException, IOException;
}

