/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.security;

public class ChallengeRequest {
    private static final String APPLICATION_PREFIX = "Application ";
    String location;
    String authenticationScheme;
    String authenticationParameters;

    public ChallengeRequest(String location, String challenge) {
        if (location == null) {
            throw new NullPointerException("location");
        }
        if (challenge == null) {
            return;
        }
        if (challenge.startsWith(APPLICATION_PREFIX)) {
            challenge = challenge.substring(APPLICATION_PREFIX.length());
        }
        this.location = location;
        this.authenticationParameters = null;
        int space = challenge.indexOf(32);
        if (space == -1) {
            this.authenticationScheme = challenge;
        } else {
            this.authenticationScheme = challenge.substring(0, space);
            if (challenge.length() > space + 1) {
                this.authenticationParameters = challenge.substring(space + 1);
            }
        }
    }

    public String getLocation() {
        return this.location;
    }

    public String getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    public String getAuthenticationParameters() {
        return this.authenticationParameters;
    }

    public String toString() {
        return String.format("%s: %s: %s %s", super.toString(), this.location, this.authenticationScheme, this.authenticationParameters);
    }
}

