/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.scheduling.annotation;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.aop.support.AopUtils;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanFactoryAware;
import com.bmc.thirdparty.org.springframework.beans.factory.DisposableBean;
import com.bmc.thirdparty.org.springframework.beans.factory.ListableBeanFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.NoSuchBeanDefinitionException;
import com.bmc.thirdparty.org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import com.bmc.thirdparty.org.springframework.beans.factory.SmartInitializingSingleton;
import com.bmc.thirdparty.org.springframework.beans.factory.config.BeanPostProcessor;
import com.bmc.thirdparty.org.springframework.context.ApplicationContext;
import com.bmc.thirdparty.org.springframework.context.EmbeddedValueResolverAware;
import com.bmc.thirdparty.org.springframework.core.Ordered;
import com.bmc.thirdparty.org.springframework.core.annotation.AnnotationUtils;
import com.bmc.thirdparty.org.springframework.scheduling.TaskScheduler;
import com.bmc.thirdparty.org.springframework.scheduling.annotation.Scheduled;
import com.bmc.thirdparty.org.springframework.scheduling.annotation.Schedules;
import com.bmc.thirdparty.org.springframework.scheduling.annotation.SchedulingConfigurer;
import com.bmc.thirdparty.org.springframework.scheduling.config.CronTask;
import com.bmc.thirdparty.org.springframework.scheduling.config.IntervalTask;
import com.bmc.thirdparty.org.springframework.scheduling.config.ScheduledTaskRegistrar;
import com.bmc.thirdparty.org.springframework.scheduling.support.CronTrigger;
import com.bmc.thirdparty.org.springframework.scheduling.support.ScheduledMethodRunnable;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.ReflectionUtils;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import com.bmc.thirdparty.org.springframework.util.StringValueResolver;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;

public class ScheduledAnnotationBeanPostProcessor
implements BeanPostProcessor,
Ordered,
EmbeddedValueResolverAware,
BeanFactoryAware,
SmartInitializingSingleton,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Object scheduler;
    private StringValueResolver embeddedValueResolver;
    private BeanFactory beanFactory;
    private final ScheduledTaskRegistrar registrar = new ScheduledTaskRegistrar();
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setScheduler(Object scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Deprecated
    public void setApplicationContext(ApplicationContext applicationContext) {
        if (this.beanFactory == null) {
            this.beanFactory = applicationContext;
        }
    }

    @Override
    public void afterSingletonsInstantiated() {
        if (this.scheduler != null) {
            this.registrar.setScheduler(this.scheduler);
        }
        if (this.beanFactory instanceof ListableBeanFactory) {
            Map<String, SchedulingConfigurer> configurers = ((ListableBeanFactory)this.beanFactory).getBeansOfType(SchedulingConfigurer.class);
            for (SchedulingConfigurer configurer : configurers.values()) {
                configurer.configureTasks(this.registrar);
            }
        }
        if (this.registrar.hasTasks() && this.registrar.getScheduler() == null) {
            Assert.state(this.beanFactory != null, "BeanFactory must be set to find scheduler by type");
            try {
                this.registrar.setScheduler(this.beanFactory.getBean(TaskScheduler.class));
            }
            catch (NoUniqueBeanDefinitionException ex) {
                throw new IllegalStateException("More than one TaskScheduler exists within the context. Remove all but one of the beans; or implement the SchedulingConfigurer interface and call ScheduledTaskRegistrar#setScheduler explicitly within the configureTasks() callback.", ex);
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.logger.debug("Could not find default TaskScheduler bean", ex);
                try {
                    this.registrar.setScheduler(this.beanFactory.getBean(ScheduledExecutorService.class));
                }
                catch (NoUniqueBeanDefinitionException ex2) {
                    throw new IllegalStateException("More than one ScheduledExecutorService exists within the context. Remove all but one of the beans; or implement the SchedulingConfigurer interface and call ScheduledTaskRegistrar#setScheduler explicitly within the configureTasks() callback.", ex);
                }
                catch (NoSuchBeanDefinitionException ex2) {
                    this.logger.debug("Could not find default ScheduledExecutorService bean", ex);
                }
            }
        }
        this.registrar.afterPropertiesSet();
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(final Object bean, String beanName) {
        if (!this.nonAnnotatedClasses.contains(bean.getClass())) {
            final LinkedHashSet annotatedMethods = new LinkedHashSet(1);
            Class<?> targetClass = AopUtils.getTargetClass(bean);
            ReflectionUtils.doWithMethods(targetClass, new ReflectionUtils.MethodCallback(){

                @Override
                public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                    for (Scheduled scheduled : AnnotationUtils.getRepeatableAnnotation(method, Schedules.class, Scheduled.class)) {
                        ScheduledAnnotationBeanPostProcessor.this.processScheduled(scheduled, method, bean);
                        annotatedMethods.add(method);
                    }
                }
            });
            if (annotatedMethods.isEmpty()) {
                this.nonAnnotatedClasses.add(bean.getClass());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("No @Scheduled annotations found on bean class: " + bean.getClass());
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug(annotatedMethods.size() + " @Scheduled methods processed on bean '" + beanName + "': " + annotatedMethods);
            }
        }
        return bean;
    }

    protected void processScheduled(Scheduled scheduled, Method method, Object bean) {
        try {
            String fixedRateString;
            long fixedRate;
            String fixedDelayString;
            long fixedDelay;
            String cron;
            Assert.isTrue(Void.TYPE.equals(method.getReturnType()), "Only void-returning methods may be annotated with @Scheduled");
            Assert.isTrue(method.getParameterTypes().length == 0, "Only no-arg methods may be annotated with @Scheduled");
            if (AopUtils.isJdkDynamicProxy(bean)) {
                try {
                    method = bean.getClass().getMethod(method.getName(), method.getParameterTypes());
                }
                catch (SecurityException ex) {
                    ReflectionUtils.handleReflectionException(ex);
                }
                catch (NoSuchMethodException ex) {
                    throw new IllegalStateException(String.format("@Scheduled method '%s' found on bean target class '%s' but not found in any interface(s) for a dynamic proxy. Either pull the method up to a declared interface or switch to subclass (CGLIB) proxies by setting proxy-target-class/proxyTargetClass to 'true'", method.getName(), method.getDeclaringClass().getSimpleName()));
                }
            } else if (AopUtils.isCglibProxy(bean) && Modifier.isPrivate(method.getModifiers())) {
                throw new IllegalStateException(String.format("@Scheduled method '%s' found on CGLIB proxy for target class '%s' but cannot be delegated to target bean. Switch its visibility to package or protected.", method.getName(), method.getDeclaringClass().getSimpleName()));
            }
            ScheduledMethodRunnable runnable = new ScheduledMethodRunnable(bean, method);
            boolean processedSchedule = false;
            String errorMessage = "Exactly one of the 'cron', 'fixedDelay(String)', or 'fixedRate(String)' attributes is required";
            long initialDelay = scheduled.initialDelay();
            String initialDelayString = scheduled.initialDelayString();
            if (StringUtils.hasText(initialDelayString)) {
                Assert.isTrue(initialDelay < 0L, "Specify 'initialDelay' or 'initialDelayString', not both");
                if (this.embeddedValueResolver != null) {
                    initialDelayString = this.embeddedValueResolver.resolveStringValue(initialDelayString);
                }
                try {
                    initialDelay = Integer.parseInt(initialDelayString);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Invalid initialDelayString value \"" + initialDelayString + "\" - cannot parse into integer");
                }
            }
            if (StringUtils.hasText(cron = scheduled.cron())) {
                Assert.isTrue(initialDelay == -1L, "'initialDelay' not supported for cron triggers");
                processedSchedule = true;
                String zone = scheduled.zone();
                if (this.embeddedValueResolver != null) {
                    cron = this.embeddedValueResolver.resolveStringValue(cron);
                    zone = this.embeddedValueResolver.resolveStringValue(zone);
                }
                TimeZone timeZone = StringUtils.hasText(zone) ? StringUtils.parseTimeZoneString(zone) : TimeZone.getDefault();
                this.registrar.addCronTask(new CronTask((Runnable)runnable, new CronTrigger(cron, timeZone)));
            }
            if (initialDelay < 0L) {
                initialDelay = 0L;
            }
            if ((fixedDelay = scheduled.fixedDelay()) >= 0L) {
                Assert.isTrue(!processedSchedule, errorMessage);
                processedSchedule = true;
                this.registrar.addFixedDelayTask(new IntervalTask(runnable, fixedDelay, initialDelay));
            }
            if (StringUtils.hasText(fixedDelayString = scheduled.fixedDelayString())) {
                Assert.isTrue(!processedSchedule, errorMessage);
                processedSchedule = true;
                if (this.embeddedValueResolver != null) {
                    fixedDelayString = this.embeddedValueResolver.resolveStringValue(fixedDelayString);
                }
                try {
                    fixedDelay = Integer.parseInt(fixedDelayString);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Invalid fixedDelayString value \"" + fixedDelayString + "\" - cannot parse into integer");
                }
                this.registrar.addFixedDelayTask(new IntervalTask(runnable, fixedDelay, initialDelay));
            }
            if ((fixedRate = scheduled.fixedRate()) >= 0L) {
                Assert.isTrue(!processedSchedule, errorMessage);
                processedSchedule = true;
                this.registrar.addFixedRateTask(new IntervalTask(runnable, fixedRate, initialDelay));
            }
            if (StringUtils.hasText(fixedRateString = scheduled.fixedRateString())) {
                Assert.isTrue(!processedSchedule, errorMessage);
                processedSchedule = true;
                if (this.embeddedValueResolver != null) {
                    fixedRateString = this.embeddedValueResolver.resolveStringValue(fixedRateString);
                }
                try {
                    fixedRate = Integer.parseInt(fixedRateString);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Invalid fixedRateString value \"" + fixedRateString + "\" - cannot parse into integer");
                }
                this.registrar.addFixedRateTask(new IntervalTask(runnable, fixedRate, initialDelay));
            }
            Assert.isTrue(processedSchedule, errorMessage);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException("Encountered invalid @Scheduled method '" + method.getName() + "': " + ex.getMessage());
        }
    }

    @Override
    public void destroy() {
        this.registrar.destroy();
    }
}

