/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.qual;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ArithmeticOperationInfo;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.ByteListValue;
import com.bmc.arsys.api.CurrencyFieldLimit;
import com.bmc.arsys.api.CurrencyPartInfo;
import com.bmc.arsys.api.CurrencyValue;
import com.bmc.arsys.api.DateInfo;
import com.bmc.arsys.api.DecimalFieldLimit;
import com.bmc.arsys.api.DiaryListValue;
import com.bmc.arsys.api.EnumItem;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.FieldLimit;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.api.OperandType;
import com.bmc.arsys.api.RealFieldLimit;
import com.bmc.arsys.api.SelectionField;
import com.bmc.arsys.api.SelectionFieldLimit;
import com.bmc.arsys.api.StatusHistoryValueIndicator;
import com.bmc.arsys.api.Time;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.qual.ARParseFormatInfo;
import com.bmc.arsys.utils.LocaleUtil;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public abstract class Formatter {
    static final Logger logger = Logger.getLogger(Formatter.class);
    protected ARParseFormatInfo formatInfo;

    public ARParseFormatInfo getFormatInfo() {
        return this.formatInfo;
    }

    public void setFormatInfo(ARParseFormatInfo formatInfo) {
        this.formatInfo = formatInfo;
    }

    protected String formatConditionalOperator(int operator) throws ARException {
        if (operator < 0 || operator > 5) {
            logger.error("Unknown Conditional Operand type " + operator);
            throw new ARException(2, 142, "Operation " + operator);
        }
        String frmtdOpr = null;
        switch (operator) {
            case 0: 
            case 4: {
                frmtdOpr = "";
                break;
            }
            case 1: {
                frmtdOpr = " AND ";
                break;
            }
            case 2: {
                frmtdOpr = " OR ";
                break;
            }
            case 3: {
                frmtdOpr = " NOT ";
                break;
            }
            case 5: {
                frmtdOpr = "EXTERNAL";
                break;
            }
        }
        return frmtdOpr;
    }

    protected String formatRelationalOperator(int operator) throws ARException {
        if (operator < 1 || operator > 9) {
            logger.error("Unknown Relational Operand type " + operator);
            throw new ARException(2, 142, "Operation " + operator);
        }
        String frmtdOpr = null;
        switch (operator) {
            case 1: {
                frmtdOpr = " = ";
                break;
            }
            case 2: {
                frmtdOpr = " > ";
                break;
            }
            case 3: {
                frmtdOpr = " >= ";
                break;
            }
            case 8: {
                frmtdOpr = " IN ";
                break;
            }
            case 4: {
                frmtdOpr = " < ";
                break;
            }
            case 5: {
                frmtdOpr = " <= ";
                break;
            }
            case 7: {
                frmtdOpr = " LIKE ";
                break;
            }
            case 6: {
                frmtdOpr = " != ";
                break;
            }
        }
        return frmtdOpr;
    }

    protected String formatArithmeticOperationInfo(ArithmeticOperationInfo arithOpnInfo) throws ARException {
        String formatedARoperand = null;
        StringBuffer roiS = new StringBuffer();
        ArithmeticOrRelationalOperand aroLeft = arithOpnInfo.getLeftOperand();
        try {
            formatedARoperand = this.formatArithmeticOrRelationalOperand(aroLeft);
        }
        catch (ARException e) {
            logger.error("could not format the Arithmetic Relational Operand", e);
            throw e;
        }
        if (this.formatInfo.includeParanthesis()) {
            roiS.append("(");
        }
        roiS.append(formatedARoperand);
        switch (arithOpnInfo.getOperation()) {
            case 1: {
                roiS.append(" + ");
                break;
            }
            case 2: {
                roiS.append(" - ");
                break;
            }
            case 3: {
                roiS.append(" * ");
                break;
            }
            case 4: {
                roiS.append(" / ");
                break;
            }
            case 5: {
                roiS.append(" % ");
                break;
            }
            case 6: {
                roiS.append(" -");
                break;
            }
            default: {
                throw new ARException(2, 312, "Operation" + arithOpnInfo.getOperation());
            }
        }
        ArithmeticOrRelationalOperand aroRight = arithOpnInfo.getRightOperand();
        try {
            formatedARoperand = this.formatArithmeticOrRelationalOperand(aroRight);
        }
        catch (ARException e) {
            logger.error("could not format the Arithmetic Relational Operand", e);
            throw e;
        }
        roiS.append(formatedARoperand);
        if (this.formatInfo.includeParanthesis()) {
            roiS.append(")");
        }
        return roiS.toString();
    }

    protected String formatValue(Value obj) throws ARException {
        StringBuffer sbVal = new StringBuffer();
        Field field = this.formatInfo.getOtherOperandField();
        int dataType = obj.getDataType().toInt();
        if (field != null) {
            Field parentField;
            if (field.getDataType() == 6 && dataType == 2) {
                dataType = 6;
            }
            if (field.getDataType() == 34 && (dataType == 6 || dataType == 2) && (parentField = this.formatInfo.getDataField(field)) != null) {
                field = parentField;
                if (parentField.getDataType() == 6) {
                    dataType = 6;
                } else if (parentField.getDataType() == 2) {
                    dataType = 2;
                }
            }
        }
        block0 : switch (dataType) {
            case 0: {
                sbVal.append("$NULL$");
                break;
            }
            case 1: {
                Keyword kw = (Keyword)obj.getValue();
                sbVal.append(kw.toString());
                break;
            }
            case 2: {
                if (field != null) {
                    sbVal.append(this.formatValue((Number)obj.getValue(), field.getFieldLimit()));
                    break;
                }
                sbVal.append(((Integer)obj.getValue()).toString());
                break;
            }
            case 40: {
                Long lg = (Long)obj.getValue();
                sbVal.append(lg);
                break;
            }
            case 10: {
                if (field != null) {
                    sbVal.append(this.formatValue((Number)obj.getValue(), field.getFieldLimit()));
                    break;
                }
                sbVal.append(obj.getValue().toString());
                break;
            }
            case 3: {
                if (field != null) {
                    sbVal.append(this.formatValue((Number)obj.getValue(), field.getFieldLimit()));
                    break;
                }
                sbVal.append(((Double)obj.getValue()).toString());
                break;
            }
            case 4: 
            case 42: 
            case 43: {
                sbVal.append("\"" + obj.getValue().toString().replaceAll("\"", "\"\"") + "\"");
                break;
            }
            case 5: {
                String diaryVal;
                if (obj.getValue() instanceof DiaryListValue) {
                    DiaryListValue dlv = (DiaryListValue)obj.getValue();
                    diaryVal = dlv.encode();
                } else {
                    diaryVal = obj.getValue().toString();
                }
                sbVal.append("\"" + diaryVal + "\"");
                break;
            }
            case 6: 
            case 34: {
                Integer enumValue = (Integer)obj.getValue();
                boolean matchFound = false;
                if (field != null && field.getDataType() != 31 && field.getDataType() != 32 && field.getDataType() != 33 && field instanceof SelectionField && field.getFieldLimit() != null && field.getFieldLimit().getDataType() == dataType) {
                    SelectionFieldLimit selectionFieldLimit = (SelectionFieldLimit)((SelectionField)field).getFieldLimit();
                    List<EnumItem> listEnumItem = selectionFieldLimit.getValues();
                    for (EnumItem item : listEnumItem) {
                        if (enumValue.intValue() != item.getEnumItemNumber()) continue;
                        sbVal.append("\"" + item.getEnumItemName() + "\"");
                        matchFound = true;
                        break;
                    }
                }
                if (matchFound) break;
                sbVal.append(enumValue);
                break;
            }
            case 9: {
                ByteListValue blv = (ByteListValue)obj.getValue();
                sbVal.append(blv.getValue());
                break;
            }
            case 11: {
                sbVal.append("\"" + obj.getValue() + "\"");
                break;
            }
            case 7: {
                String date = LocaleUtil.formatDateTime(Formatter.getDateFromObject(obj.getValue()));
                sbVal.append("\"" + date + "\"");
                break;
            }
            case 13: {
                sbVal.append("\"" + this.formatDate(obj) + "\"");
                break;
            }
            case 14: {
                sbVal.append("\"" + this.formatTime(obj) + "\"");
                break;
            }
            case 12: {
                switch (obj.getDataType().toInt()) {
                    case 4: {
                        sbVal.append("\"" + obj.getValue() + "\"");
                        break block0;
                    }
                    case 7: {
                        sbVal.append("\"" + this.formatDateTime(obj) + "\"");
                        break block0;
                    }
                    case 3: {
                        sbVal.append(new DecimalFormat("###.000000").format(obj.getValue()));
                        break block0;
                    }
                }
                CurrencyValue cv = (CurrencyValue)obj.getValue();
                sbVal.append("\"" + cv.getValueString() + " " + cv.getCurrencyCode() + "\"");
                break;
            }
            case 8: 
            case 30: 
            case 35: 
            case 36: 
            case 37: 
            case 41: 
            case 100: {
                sbVal.append("\"" + obj.getValue() + "\"");
            }
        }
        return sbVal.toString();
    }

    protected String formatValue(Number number, FieldLimit limit) {
        if (limit == null) {
            if (number == null) {
                return null;
            }
            return number.toString();
        }
        int precision = 0;
        switch (limit.getDataType()) {
            case 3: {
                precision = ((RealFieldLimit)limit).getPrecision();
                break;
            }
            case 10: {
                precision = ((DecimalFieldLimit)limit).getPrecision();
                return number.toString();
            }
            case 12: {
                precision = ((CurrencyFieldLimit)limit).getPrecision();
                return number.toString();
            }
            case 0: {
                return number.toString();
            }
        }
        DecimalFormat format = (DecimalFormat)NumberFormat.getInstance(this.formatInfo.getLocale());
        format.setMaximumFractionDigits(precision);
        format.setMinimumFractionDigits(precision);
        String pattern = format.toPattern();
        if (pattern.indexOf(44) > 0) {
            String newPattern = pattern.replace(",", "");
            format.applyPattern(newPattern);
        }
        return format.format(number);
    }

    protected String formatDate(Value value) throws ARException {
        return LocaleUtil.formatDate(Formatter.getDateFromObject(value.getValue()));
    }

    protected String formatDateTime(Value value) throws ARException {
        return LocaleUtil.formatDateTime(Formatter.getDateFromObject(value.getValue()));
    }

    protected String formatTime(Value obj) throws ARException {
        if (obj.getValue() instanceof Time) {
            return ((Time)obj.getValue()).toString();
        }
        return LocaleUtil.formatTime(Formatter.getDateFromObject(obj.getValue()));
    }

    protected String formatCurrencyField(CurrencyPartInfo curField, Field fld) {
        String str = "";
        if (curField != null) {
            int part = curField.getPartTag();
            int fieldId = curField.getFieldId();
            String code = curField.getCurrencyCode().trim();
            String name = null;
            String partTag = null;
            if (fld != null) {
                name = fld.getName();
                name = name.replaceAll("'", "''");
            } else {
                name = Integer.toString(fieldId);
            }
            switch (part) {
                case 0: {
                    str = name;
                    break;
                }
                case 1: {
                    partTag = "VALUE";
                    str = name + "." + partTag;
                    break;
                }
                case 2: {
                    partTag = "TYPE";
                    str = name + "." + partTag;
                    break;
                }
                case 3: {
                    partTag = "DATE";
                    str = name + "." + partTag;
                    break;
                }
                case 4: {
                    str = name + "." + code;
                    break;
                }
                default: {
                    str = name;
                }
            }
        }
        return str;
    }

    protected String formatArithmeticOrRelationalOperand(ArithmeticOrRelationalOperand aropnd) throws ARException {
        StringBuffer aro = new StringBuffer();
        OperandType ot = null;
        CurrencyPartInfo partInfo = null;
        Field fld = null;
        int fieldId = 0;
        int typeOfOperand = -1;
        String strFldFmt = null;
        if (aropnd == null) {
            return "";
        }
        ot = aropnd.getType();
        if (ot != null) {
            typeOfOperand = ot.toInt();
        }
        switch (typeOfOperand) {
            case 1: {
                fieldId = (Integer)aropnd.getValue();
                if (fieldId == 0) break;
                fld = this.formatInfo.getRemoteField(aropnd.getValue().toString());
                if (fld != null) {
                    this.formatInfo.setOtherOperandField(fld);
                    strFldFmt = fld.getName();
                    strFldFmt = strFldFmt.replaceAll("'", "''");
                } else {
                    strFldFmt = String.valueOf(fieldId);
                }
                aro.append("'" + strFldFmt + "'");
                break;
            }
            case 6: {
                partInfo = (CurrencyPartInfo)aropnd.getValue();
                fld = this.formatInfo.getRemoteField(Integer.toString(partInfo.getFieldId()));
                if (fld != null) {
                    this.formatInfo.setOtherOperandField(fld);
                    aro.append("'" + this.formatCurrencyField(partInfo, fld) + "'");
                    break;
                }
                aro.append("'" + partInfo.getFieldId() + "'");
                break;
            }
            case 50: {
                fieldId = (Integer)aropnd.getValue();
                fld = this.formatInfo.getLocalField(aropnd.getValue().toString());
                if (fld != null) {
                    this.formatInfo.setOtherOperandField(fld);
                }
                String string = strFldFmt = fld != null ? fld.getName() : String.valueOf(fieldId);
                if (!this.formatInfo.isEscalation()) {
                    aro.append("'TR." + strFldFmt + "'");
                    break;
                }
                aro.append("'" + strFldFmt + "'");
                break;
            }
            case 54: {
                partInfo = (CurrencyPartInfo)aropnd.getValue();
                fld = this.formatInfo.getLocalField(Integer.toString(partInfo.getFieldId()));
                if (fld != null) {
                    this.formatInfo.setOtherOperandField(fld);
                    if (!this.formatInfo.isEscalation()) {
                        aro.append("'TR." + this.formatCurrencyField(partInfo, fld) + "'");
                        break;
                    }
                    aro.append("'" + this.formatCurrencyField((CurrencyPartInfo)aropnd.getValue(), fld) + "'");
                    break;
                }
                aro.append("'" + partInfo.getFieldId() + "'");
                break;
            }
            case 51: {
                fieldId = (Integer)aropnd.getValue();
                fld = this.formatInfo.getLocalField(aropnd.getValue().toString());
                if (fld != null) {
                    this.formatInfo.setOtherOperandField(fld);
                }
                String string = strFldFmt = fld != null ? fld.getName() : String.valueOf(fieldId);
                if (!this.formatInfo.isEscalation()) {
                    aro.append("'DB." + strFldFmt + "'");
                    break;
                }
                aro.append("'" + strFldFmt + "'");
                break;
            }
            case 55: {
                partInfo = (CurrencyPartInfo)aropnd.getValue();
                fld = this.formatInfo.getLocalField(Integer.toString(partInfo.getFieldId()));
                if (fld != null) {
                    this.formatInfo.setOtherOperandField(fld);
                    if (!this.formatInfo.isEscalation()) {
                        aro.append("'DB." + this.formatCurrencyField((CurrencyPartInfo)aropnd.getValue(), fld) + "'");
                        break;
                    }
                    aro.append("'" + this.formatCurrencyField((CurrencyPartInfo)aropnd.getValue(), fld) + "'");
                    break;
                }
                aro.append("'" + partInfo.getFieldId() + "'");
                break;
            }
            case 2: {
                String formatedVal = null;
                Value val = (Value)aropnd.getValue();
                try {
                    formatedVal = this.formatValue(val);
                }
                catch (ARException e) {
                    logger.error("Error formating Value", e);
                    throw e;
                }
                aro.append(formatedVal);
                break;
            }
            case 3: {
                String formatedAoi = null;
                ArithmeticOperationInfo aoi = (ArithmeticOperationInfo)aropnd.getValue();
                try {
                    formatedAoi = this.formatArithmeticOperationInfo(aoi);
                }
                catch (ARException e) {
                    logger.error("Error formating the Arithmetic Operation Info", e);
                    throw e;
                }
                aro.append(formatedAoi);
                break;
            }
            case 56: {
                partInfo = (CurrencyPartInfo)aropnd.getValue();
                fld = this.formatInfo.getLocalField(Integer.toString(partInfo.getFieldId()));
                this.formatInfo.setOtherOperandField(fld);
                if (this.formatInfo.getLocation() == 2 || this.formatInfo.getLocation() == 3) {
                    aro.append("'" + this.formatCurrencyField(partInfo, fld) + "'");
                    break;
                }
                aro.append("$" + this.formatCurrencyField(partInfo, fld) + "$");
                break;
            }
            case 99: {
                fieldId = (Integer)aropnd.getValue();
                if (this.formatInfo.getLocation() == 4) {
                    fld = this.formatInfo.getLocalField(aropnd.getValue().toString());
                    if (fld != null) {
                        this.formatInfo.setOtherOperandField(fld);
                    }
                    aro.append("$" + fieldId + "$");
                    break;
                }
                fld = this.formatInfo.getLocalField(aropnd.getValue().toString());
                if (fld != null) {
                    this.formatInfo.setOtherOperandField(fld);
                }
                strFldFmt = fld != null ? fld.getName() : String.valueOf(fieldId);
                strFldFmt = strFldFmt.replaceAll("'", "''");
                if (this.formatInfo.getLocation() == 2 || this.formatInfo.getLocation() == 3) {
                    aro.append("'" + strFldFmt + "'");
                    break;
                }
                aro.append("$" + strFldFmt + "$");
                break;
            }
            case 4: {
                StatusHistoryValueIndicator sh = (StatusHistoryValueIndicator)aropnd.getValue();
                String stat = this.formatStatusHistroryField(sh);
                aro.append("'" + stat + "'");
                break;
            }
            case 5: {
                ArrayList valSet = (ArrayList)aropnd.getValue();
                try {
                    for (Value tempVal : valSet) {
                        String formatedVal = this.formatValue(tempVal);
                        aro.append(formatedVal).append(" , ");
                    }
                    if (valSet.size() > 0) {
                        aro.delete(aro.length() - 3, aro.length());
                    }
                    aro.insert(0, "(").append(")");
                    break;
                }
                catch (ARException e) {
                    logger.error("Error formating Value", e);
                    throw e;
                }
            }
            case 52: {
                aro.append("'" + aropnd.getValue().toString() + "'");
                break;
            }
            case 53: {
                aro.append(aropnd.getValue().toString());
                break;
            }
            default: {
                logger.error("Invalid operand tag for Arithmetic operation info");
                throw new ARException(2, 146, "Operation " + typeOfOperand);
            }
        }
        return aro.toString();
    }

    protected String replaceFieldNamesForIds(String str) throws ARException {
        return this.replaceFieldNamesForIds(str, 0);
    }

    protected String replaceFieldNamesForIds(String str, int error) throws ARException {
        if (str == null || str.trim().equals("")) {
            return null;
        }
        Pattern pattern = Pattern.compile("(\\$[\\w,\\s\\p{P}]*\\$)");
        Matcher matcher = pattern.matcher(str);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String matchedString = matcher.group();
            Keyword keyword = Keyword.toKeyword(matchedString);
            if (keyword != null) {
                String kwStr = keyword.toString();
                matcher.appendReplacement(result, "\\$" + kwStr.substring(1, kwStr.length() - 1) + "\\$");
                continue;
            }
            Field field = this.formatInfo.getLocalField(matchedString.substring(1, matchedString.length() - 1));
            if (field != null) {
                matcher.appendReplacement(result, "\\$" + field.getName() + "\\$");
                continue;
            }
            if (error == 0) {
                matcher.appendReplacement(result, "\\$" + matchedString.substring(1, matchedString.length() - 1) + "\\$");
                continue;
            }
            throw new ARException(2, error, str);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    protected String checkAndGetKeyWord(String token) {
        String format;
        Keyword keyword;
        if (token != null && (keyword = Keyword.toKeyword(format = "$" + token + "$")) != null) {
            return keyword.toString();
        }
        return null;
    }

    protected String formatStatusHistroryField(StatusHistoryValueIndicator sh) {
        String statFieldId = "";
        String statHistoryFId = "";
        StringBuffer sb = new StringBuffer();
        statFieldId = Integer.toString(7);
        statHistoryFId = Integer.toString(15);
        Field statusHistoryField = this.formatInfo.getRemoteField(statHistoryFId);
        String statusHistLabel = statusHistoryField != null ? statusHistoryField.getName() : statHistoryFId;
        String enumValue = Integer.toString(sh.getEnumValue());
        Field statusField = this.formatInfo.getRemoteField(statFieldId);
        if (statusField != null) {
            SelectionFieldLimit limit = (SelectionFieldLimit)statusField.getFieldLimit();
            switch (limit.getListStyle()) {
                default: 
            }
            List<EnumItem> items = limit.getValues();
            if (items != null) {
                for (int i = 0; i < items.size(); ++i) {
                    if (items.get(i).getEnumItemNumber() != sh.getEnumValue()) continue;
                    enumValue = items.get(i).getEnumItemName();
                    break;
                }
            }
        }
        if (sh.isTime()) {
            sb.append(statusHistLabel + "." + enumValue + "." + "TIME");
        }
        if (sh.isUser()) {
            sb.append(statusHistLabel + "." + enumValue + "." + "USER");
        }
        return sb.toString();
    }

    private static Date getDateFromObject(Object obj) {
        if (obj instanceof Integer) {
            return new Date(((Integer)obj).intValue());
        }
        if (obj instanceof Long) {
            return new Date((Long)obj);
        }
        if (obj instanceof Timestamp) {
            return ((Timestamp)obj).toDate();
        }
        if (obj instanceof DateInfo) {
            GregorianCalendar gc = ((DateInfo)obj).GetDate();
            return new Date(gc.getTimeInMillis());
        }
        return new Date();
    }
}

