/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.qual;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.AssignInfo;
import com.bmc.arsys.api.DDEAction;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.qual.ARAssignFormatter;
import com.bmc.arsys.qual.ARParseFormatInfo;
import com.bmc.arsys.qual.ARParseFormatInfoImpl;
import com.bmc.arsys.qual.ARQualifierFormatter;
import com.bmc.arsys.qual.AssignParseFormatInfo;
import com.bmc.arsys.qual.AssignParseFormatInfoImpl;
import com.bmc.arsys.qual.ParserException;
import com.bmc.arsys.qual.antlr.ast.ASTAssignTreeWalker;
import com.bmc.arsys.qual.antlr.ast.ASTQualTreeWalker;
import com.bmc.arsys.qual.antlr.parser.ARAssignLexer;
import com.bmc.arsys.qual.antlr.parser.ARAssignParser;
import com.bmc.arsys.qual.antlr.parser.ARQualLexer;
import com.bmc.arsys.qual.antlr.parser.ARQualParser;
import com.bmc.thirdparty.org.antlr.runtime.ANTLRStringStream;
import com.bmc.thirdparty.org.antlr.runtime.CommonTokenStream;
import com.bmc.thirdparty.org.antlr.runtime.RecognitionException;
import com.bmc.thirdparty.org.antlr.runtime.tree.CommonTree;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ARQualificationHelper {
    private static final Logger logger = Logger.getLogger(ARQualificationHelper.class);
    private static final String PROCESS_TOKEN = "$PROCESS$";
    private static final String DDE_TOKEN = "$DDE$";
    private static final String DDE_PARAM_SEP = ";";

    private static CommonTree parseQual(String qualStr) throws ARException {
        return ARQualificationHelper.parseQual(qualStr, null);
    }

    private static CommonTree parseQual(String qualStr, Locale locale) throws ARException {
        logger.debug("> Compile Qualification Query String : " + qualStr);
        ARQualLexer lexer = new ARQualLexer(new ANTLRStringStream(qualStr));
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        ARQualParser parser = new ARQualParser(tokens);
        CommonTree tree = null;
        try {
            tree = (CommonTree)parser.expression().getTree();
        }
        catch (ParserException e) {
            logger.error(e.getCause());
            ParserException.reportError((RecognitionException)e.getCause(), locale);
        }
        catch (Exception e) {
            logger.error(e);
            ParserException.reportError(e, locale);
        }
        logger.debug("< Compile Qualification Query String : " + qualStr);
        return tree;
    }

    public static QualifierInfo parseQualification(String qualStr, List<Field> fieldList) throws ARException {
        logger.debug("> Qualification Parsing for query Sting : \"" + qualStr + "\"");
        ARParseFormatInfoImpl info = null;
        QualifierInfo qualInfo = null;
        ASTQualTreeWalker treeWalker = null;
        CommonTree tree = ARQualificationHelper.parseQual(qualStr);
        try {
            info = new ARParseFormatInfoImpl(fieldList, 0, "", null);
            treeWalker = new ASTQualTreeWalker(tree, info);
            qualInfo = treeWalker.createQualifierInfo(tree);
        }
        catch (Exception e) {
            logger.error("Qualification Failed for query String : " + qualStr + ". with the following error");
            logger.error(e);
            throw new ARException(2, 0, e.getMessage());
        }
        logger.debug("Qualification Parser for \"" + qualStr + "\"returned : ");
        logger.debug(qualInfo);
        logger.debug("< Qualification Parsing for query Sting : \"" + qualStr + "\"");
        return qualInfo;
    }

    public static QualifierInfo parseQualification(String qualStr, ARParseFormatInfo formatInfo) throws ARException {
        if (qualStr != null && !qualStr.trim().equals("")) {
            return new ASTQualTreeWalker(formatInfo).createQualifierInfo(ARQualificationHelper.parseQual(qualStr, formatInfo.getLocale()));
        }
        return null;
    }

    private static CommonTree parseAssign(String assignStr) throws ARException {
        logger.debug("> Compile Assignment String : " + assignStr);
        ARAssignLexer lexer = new ARAssignLexer(new ANTLRStringStream(assignStr));
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        ARAssignParser parser = new ARAssignParser(tokens);
        CommonTree tree = null;
        try {
            tree = (CommonTree)parser.expression().getTree();
        }
        catch (ParserException e) {
            logger.error(e.getCause());
            ParserException.reportError((RecognitionException)e.getCause());
        }
        catch (Exception e) {
            logger.error(e);
            ParserException.reportError(e);
        }
        logger.debug("< Compile Assignment String : " + assignStr);
        return tree;
    }

    public static AssignInfo parseAssignment(String assignString, AssignParseFormatInfo info) throws ARException {
        AssignInfo asgnInfo = ARQualificationHelper.preprocessAssign(assignString, info);
        if (asgnInfo == null) {
            asgnInfo = new ASTAssignTreeWalker(info).createAssignInfo(ARQualificationHelper.parseAssign(assignString));
        }
        return asgnInfo;
    }

    public static String formatQualifierInfo(ARServerUser context, QualifierInfo qf, List<Field> localFieldList, List<Field> remoteFieldList, String locale, int queryContext, boolean isEscalation, boolean isRightChild) throws ARException {
        logger.debug("> Formatting QualifierInfo");
        ARParseFormatInfoImpl info = new ARParseFormatInfoImpl(localFieldList, 0, "", remoteFieldList, locale, queryContext, isEscalation, isRightChild);
        info.setContext(context);
        info.setIncludeParanthesis(true);
        ARQualifierFormatter formater = new ARQualifierFormatter(info);
        StringBuffer sbf = new StringBuffer(formater.formatQualifierInfo(qf));
        if (sbf.length() > 2 && sbf.charAt(0) == '(' && sbf.charAt(sbf.length() - 1) == ')') {
            sbf.replace(0, 1, "");
            sbf.replace(sbf.length() - 1, sbf.length(), "");
        }
        logger.debug("< formatQualifierInfo returning \"" + sbf + "\"");
        return sbf.toString();
    }

    public static String formatAssignInfo(AssignInfo assign, List<Field> fieldList, String locale, Field assignField, boolean topLevel) throws ARException {
        logger.debug("> Formatting AssignInfo");
        boolean includeParanthesis = false;
        String formattedString = null;
        if (!topLevel) {
            includeParanthesis = true;
        }
        AssignParseFormatInfoImpl info = new AssignParseFormatInfoImpl(fieldList, locale, assignField, includeParanthesis);
        ARAssignFormatter formater = new ARAssignFormatter(info);
        formattedString = formater.formatAssignInfo(assign);
        logger.debug("< formatAssignInfo returning \"" + formattedString + "\"");
        return formattedString;
    }

    public static AssignInfo preprocessAssign(String assignString, AssignParseFormatInfo info) throws ARException {
        AssignInfo result = ARQualificationHelper.parseProcess(assignString, info);
        if (result == null) {
            result = ARQualificationHelper.parseDDEAction(assignString, info);
        }
        return result;
    }

    private static AssignInfo parseDDEAction(String assignString, AssignParseFormatInfo info) throws ARException {
        String ddeStr;
        if (assignString == null || assignString.length() <= 0) {
            return null;
        }
        String ddeData = assignString.trim();
        String string = ddeStr = DDE_TOKEN.length() < ddeData.length() ? ddeData.substring(0, DDE_TOKEN.length()) : null;
        if (!(ddeData.startsWith(DDE_TOKEN) || ddeStr != null && ddeStr.equalsIgnoreCase(DDE_TOKEN))) {
            return null;
        }
        ddeData = ddeData.substring(DDE_TOKEN.length());
        String[] tokens = ddeData.split(DDE_PARAM_SEP);
        if (tokens.length < 4) {
            throw new ARException(2, 237, ddeData);
        }
        String item = ARQualificationHelper.replaceFieldIdsForNames(tokens[3], info, 237);
        String service = ARQualificationHelper.replaceFieldIdsForNames(tokens[0], info, 0);
        String topic = ARQualificationHelper.replaceFieldIdsForNames(tokens[1], info, 0);
        String pathToPrg = ARQualificationHelper.replaceFieldIdsForNames(tokens[2], info, 0);
        DDEAction ddeAction = new DDEAction();
        ddeAction.setAction(3);
        ddeAction.setServiceName(service.trim());
        ddeAction.setTopic(topic.trim());
        ddeAction.setPathToProgram(pathToPrg.trim());
        ddeAction.setItem(item.trim());
        return new AssignInfo(ddeAction);
    }

    private static AssignInfo parseProcess(String assignString, AssignParseFormatInfo info) throws ARException {
        String processStr;
        if (assignString == null || assignString.length() <= 0) {
            return null;
        }
        AssignInfo object = null;
        assignString = assignString.trim();
        String string = processStr = PROCESS_TOKEN.length() < assignString.length() ? assignString.substring(0, PROCESS_TOKEN.length()) : null;
        if (assignString.startsWith(PROCESS_TOKEN) || processStr != null && processStr.equalsIgnoreCase(PROCESS_TOKEN)) {
            if (PROCESS_TOKEN.length() == assignString.length()) {
                throw new ARException(193, 117);
            }
            assignString = assignString.substring(PROCESS_TOKEN.length() + 1);
            object = new AssignInfo();
            object.setAssignType(3);
            Pattern pattern = Pattern.compile("(\\$[\\w,\\s\\p{P}]*\\$)");
            Matcher matcher = pattern.matcher(assignString);
            StringBuffer result = new StringBuffer();
            while (matcher.find()) {
                String matchedString = matcher.group();
                Keyword keyword = Keyword.toKeyword(matchedString);
                if (keyword != null) {
                    matcher.appendReplacement(result, "\\$-" + keyword.toInt() + "\\$");
                    continue;
                }
                Field field = info.getLocalField(matchedString.substring(1, matchedString.length() - 1));
                if (field == null) continue;
                matcher.appendReplacement(result, "\\$" + field.getFieldID() + "\\$");
            }
            matcher.appendTail(result);
            object.setProcess(result.toString());
        }
        return object;
    }

    private static String replaceFieldIdsForNames(String input, AssignParseFormatInfo info, int error) throws ARException {
        Pattern pattern = Pattern.compile("\\$[\\w,\\s]*\\$");
        Matcher matcher = pattern.matcher(input);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String matchedString = matcher.group();
            Keyword keyword = Keyword.toKeyword(matchedString);
            if (keyword != null) {
                matcher.appendReplacement(result, "\\$-" + keyword.toInt() + "\\$");
                continue;
            }
            Field field = info.getLocalField(matchedString.substring(1, matchedString.length() - 1));
            if (field != null) {
                matcher.appendReplacement(result, "\\$" + field.getFieldID() + "\\$");
                continue;
            }
            if (error == 0) {
                matcher.appendReplacement(result, "\\$" + matchedString + "\\$");
                continue;
            }
            throw new ARException(2, error, input);
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

