/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arencrypt;

import com.bmc.arsys.arencrypt.AREncEnginePool;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.ARFips;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;

class AREncKeyBase {
    private String encType;
    private String encAlgorithmStr;
    private int encAlgorithm;
    private String encXForm;
    private int encMode;
    private byte[] iv;
    private byte[] key;
    protected int keySize;
    protected String provider;
    protected static ARFips arFips;
    protected boolean keyMasked = false;
    protected boolean ivMasked = false;
    protected boolean obfuscated = !"AREncKeyBase".equals(AREncKeyBase.class.getSimpleName());
    private boolean engineCachable = true;

    AREncKeyBase() {
        this.initFips();
    }

    protected AREncKeyBase(String encType, String encAlgorithmStr) {
        this.encType = encType;
        this.encAlgorithmStr = encAlgorithmStr;
        this.initFips();
    }

    private void initFips() {
        if (arFips != null) {
            return;
        }
        if (ARFips.checkIfFIPSProviderRegistered()) {
            arFips = new ARFips();
        }
    }

    protected String getEncAlgorithmStr() {
        return this.encAlgorithmStr;
    }

    protected void setEncAlgorithmStr(String encAlgorithmStr) {
        this.encAlgorithmStr = encAlgorithmStr;
    }

    protected int getEncAlgorithm() {
        return this.encAlgorithm;
    }

    protected void setEncAlgorithm(int encAlgorithm) {
        this.encAlgorithm = encAlgorithm;
    }

    public byte[] getKey() {
        return this.key;
    }

    public void setKey(byte[] key) {
        this.key = key;
    }

    protected int getKeySize() {
        return this.keySize;
    }

    protected void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    protected int getEncMode() {
        return this.encMode;
    }

    protected void setEncMode(int encMode) {
        this.encMode = encMode;
    }

    protected String getEncType() {
        return this.encType;
    }

    protected void setEncType(String encType) {
        this.encType = encType;
    }

    protected byte[] getIv() {
        return this.iv;
    }

    protected void setIv(byte[] iv) {
        this.iv = iv;
    }

    protected String getEncXForm() {
        return this.encXForm;
    }

    protected void setEncXForm(String encXForm) {
        this.encXForm = encXForm;
    }

    protected boolean isEngineCacheable() {
        return this.engineCachable;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.encAlgorithmStr != null) {
            sb.append(this.encAlgorithmStr).append("_").append(this.encAlgorithm);
        }
        if (!this.obfuscated) {
            if (this.encXForm != null) {
                sb.append("_").append(this.encXForm);
            }
            if (this.encType != null) {
                sb.append("_").append(this.encType);
            }
        }
        sb.append("_").append(this.encMode);
        if (this.provider != null) {
            sb.append("_").append(this.provider);
        }
        return sb.toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.encAlgorithmStr).append(this.encXForm).append(this.encType).append(this.encMode).append(this.provider).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AREncEnginePool)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        AREncKeyBase rhs = (AREncKeyBase)obj;
        return new EqualsBuilder().append(this.encAlgorithmStr, rhs.encAlgorithmStr).append(this.encXForm, rhs.encAlgorithmStr).append(this.encType, rhs.encAlgorithmStr).append((Object)this.encMode, rhs.encAlgorithmStr).append(this.provider, rhs.encAlgorithmStr).isEquals();
    }

    protected boolean checkValidDataEncAlgorithm(int alg, int encryptPolicy) throws AREncryptionException {
        return false;
    }

    protected boolean checkValidKeyEncAlgorithm(int alg) throws AREncryptionException {
        return false;
    }

    boolean checkValidEncAlgorithm(int alg) throws AREncryptionException {
        return this.checkValidKeyEncAlgorithm(alg) || this.checkValidDataEncAlgorithm(alg, -1);
    }

    String getProvider() {
        return this.provider;
    }

    void setProvider(String provider) {
        this.provider = provider;
    }

    boolean isKeyMasked() {
        return this.keyMasked;
    }

    void setKeyMasked(boolean keyMasked) {
        this.keyMasked = keyMasked;
    }

    boolean isIvMasked() {
        return this.ivMasked;
    }

    void setIvMasked(boolean ivMasked) {
        this.ivMasked = ivMasked;
    }
}

