/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.session;

import com.bmc.arsys.apitransport.ApiProxyI;
import com.bmc.arsys.apitransport.ApiProxyType;
import com.bmc.arsys.apitransport.ApiUserContextBase;
import com.bmc.arsys.apitransport.chunking.IARChunkable;
import com.bmc.arsys.arthreadlocal.ARThreadLocalHandler;
import com.bmc.arsys.arthreadlocal.ARThreadLocalStorable;
import com.bmc.arsys.utils.LocaleInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ApiThreadLocalStorageBlock
implements ARThreadLocalStorable {
    private static Logger logger = Logger.getLogger(ApiThreadLocalStorageBlock.class);
    private static final ARThreadLocalHandler apiThreadLocal = new ARThreadLocalHandler();
    private static ClassLoader cl = Thread.currentThread().getContextClassLoader();
    private Object internalChunkingObj;
    private IARChunkable chunkProcessor;
    private int currentObj;
    private String currentOp;
    private ArrayList<Object> m_bulkEntryTxnArgs;
    private int rpcType;
    private String rpcClazzName;
    private Class<? extends ApiProxyI> rpcClazz;
    private int initConnectTimeout = 120;
    private boolean ignoreCMTHandle;
    private LocaleInfo localeInfo;
    private Map<Object, Object> apiThreadInfo;

    protected static ARThreadLocalHandler getArThreadLocalHandler() {
        return apiThreadLocal;
    }

    public static boolean isTLBExist() {
        ARThreadLocalStorable tl = ApiThreadLocalStorageBlock.getArThreadLocalHandler().getTLB();
        return tl != null;
    }

    public static void createTLB() {
        if (!ApiThreadLocalStorageBlock.isTLBExist()) {
            ApiThreadLocalStorageBlock tlb = new ApiThreadLocalStorageBlock();
            tlb.init(Thread.currentThread());
            ApiThreadLocalStorageBlock.registerTLB(tlb);
        }
    }

    public static ApiThreadLocalStorageBlock getTLB() {
        if (!ApiThreadLocalStorageBlock.isTLBExist()) {
            ApiThreadLocalStorageBlock.createTLB();
        }
        return (ApiThreadLocalStorageBlock)ApiThreadLocalStorageBlock.getArThreadLocalHandler().getTLB();
    }

    public static void registerTLB(ApiThreadLocalStorageBlock tlb) {
        ApiThreadLocalStorageBlock.getArThreadLocalHandler().setTLB(tlb);
    }

    @Override
    public void init(Object t) {
        this.initChunkingVariables();
    }

    @Override
    public void cleanUp() {
        this.resetChunkingVariables();
        this.setApiThreadInfo(null);
    }

    public void initChunkingVariables() {
        this.setInternalChunkingObj(null);
        this.setChunkProcessor(null);
    }

    public void resetChunkingVariables() {
        this.setInternalChunkingObj(null);
        this.resetChunkingProcessor();
    }

    public void resetChunkingProcessor() {
        IARChunkable curChunkProcessor = this.getChunkProcessor();
        if (curChunkProcessor != null) {
            curChunkProcessor.end();
        }
        this.setChunkProcessor(null);
    }

    public Object getInternalChunkingObj() {
        return this.internalChunkingObj;
    }

    public void setInternalChunkingObj(Object internalObj) {
        this.internalChunkingObj = internalObj;
    }

    public IARChunkable getChunkProcessor() {
        return this.chunkProcessor;
    }

    public void setChunkProcessor(IARChunkable chunkProcessor) {
        this.chunkProcessor = chunkProcessor;
    }

    public String getCurrentOp() {
        return this.currentOp;
    }

    public void setCurrentOp(String op) {
        this.currentOp = op;
    }

    public int getCurrentObj() {
        return this.currentObj;
    }

    public void setCurrentObj(int currentObj) {
        this.currentObj = currentObj;
    }

    public int getRpcType() {
        return this.rpcType;
    }

    public String getRpcClazzName() {
        return this.rpcClazzName;
    }

    public void setRpcType(ApiUserContextBase context, String cmd, String proxyJRpcClazzName) {
        this.rpcClazz = null;
        if (proxyJRpcClazzName != null) {
            if (ApiProxyType.isARJRpcProxyName(context, proxyJRpcClazzName)) {
                this.rpcType = 1;
                this.rpcClazzName = proxyJRpcClazzName;
            } else if (ApiProxyType.isCMDBProxyName(context, proxyJRpcClazzName)) {
                this.rpcType = 3;
                this.rpcClazzName = proxyJRpcClazzName;
            } else if (ApiProxyType.isARJniProxyName(context, proxyJRpcClazzName)) {
                this.rpcType = 2;
                this.rpcClazzName = proxyJRpcClazzName;
            } else {
                this.rpcType = 1;
                this.rpcClazzName = "com.bmc.arsys.api.ProxyJRpc";
                logger.error("call " + cmd + " passed in unknow proxy class name " + proxyJRpcClazzName + ". Use AR JRpc instead.");
            }
        } else {
            this.rpcType = 1;
            this.rpcClazzName = "com.bmc.arsys.api.ProxyJRpc";
        }
    }

    public void setRpcTypeWithProxyClass(ApiUserContextBase context, String cmd, Class<? extends ApiProxyI> proxyJRpcClazz, ApiProxyType proxyType) {
        if (proxyJRpcClazz != null) {
            this.rpcType = proxyType.getProxyType();
            if (this.rpcType == 0) {
                this.rpcType = 3;
            }
            this.rpcClazz = proxyJRpcClazz;
            this.rpcClazzName = null;
            if (!cl.equals(Thread.currentThread().getContextClassLoader()) && logger.isDebugEnabled()) {
                logger.debug("CMDB load in a child class loader. set rpcClassName = null to avoid invocation conflict.");
            }
        } else {
            this.rpcClazz = null;
            this.rpcType = 1;
            this.rpcClazzName = "com.bmc.arsys.api.ProxyJRpc";
        }
    }

    public Class<? extends ApiProxyI> getRpcClazz() {
        return this.rpcClazz;
    }

    public boolean isCMDBCall() {
        return 3 == this.rpcType;
    }

    public boolean isBulkEntryTxnActive() {
        return this.m_bulkEntryTxnArgs != null;
    }

    public void activateBulkEntryTxn(boolean activate) {
        this.m_bulkEntryTxnArgs = activate ? new ArrayList() : null;
    }

    public void addBulkEntryTxnArgs(Object obj) {
        if (this.m_bulkEntryTxnArgs != null) {
            this.m_bulkEntryTxnArgs.add(obj);
        }
    }

    public List<Object> getBulkEntryTxnArgs() {
        return this.m_bulkEntryTxnArgs;
    }

    public int getInitConnectTimeout() {
        return this.initConnectTimeout;
    }

    public void setInitConnectTimeout(int timeout) {
        this.initConnectTimeout = timeout;
    }

    public void setIgnoreCMTHandle(boolean ignoreCMTHandle) {
        this.ignoreCMTHandle = ignoreCMTHandle;
    }

    public boolean isIgnoreCMTHandle() {
        return this.ignoreCMTHandle;
    }

    public LocaleInfo getLocaleInfo() {
        return this.localeInfo;
    }

    public void setLocaleInfo(LocaleInfo localeInfo) {
        this.localeInfo = localeInfo;
    }

    public void setApiThreadInfo(Map<Object, Object> apiThreadInfo) {
        this.apiThreadInfo = apiThreadInfo;
    }

    public Map<Object, Object> getApiThreadInfo() {
        if (this.apiThreadInfo == null) {
            this.apiThreadInfo = new HashMap<Object, Object>();
        }
        return this.apiThreadInfo;
    }
}

