/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.connection;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTimeUnit;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.ProxyManager;
import com.bmc.arsys.apitransport.ApiConfig;
import com.bmc.arsys.apitransport.ApiConfigI;
import com.bmc.arsys.apitransport.ApiProxyBase;
import com.bmc.arsys.apitransport.ApiProxyI;
import com.bmc.arsys.apitransport.ApiProxyType;
import com.bmc.arsys.apitransport.ApiUserContextBase;
import com.bmc.arsys.apitransport.ApiUserContextI;
import com.bmc.arsys.apitransport.ApiWebSocketConfig;
import com.bmc.arsys.apitransport.connection.ApiCMTProxyPool;
import com.bmc.arsys.apitransport.connection.ApiProxyFactory;
import com.bmc.arsys.apitransport.connection.ApiProxyManagerI;
import com.bmc.arsys.apitransport.connection.ApiProxyManagerTask;
import com.bmc.arsys.apitransport.connection.ApiProxyPool;
import com.bmc.arsys.apitransport.connection.ApiProxyPoolI;
import com.bmc.arsys.apitransport.session.ApiThreadLocalStorageBlock;
import com.bmc.arsys.utils.ProcessUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public abstract class ApiProxyManager
implements ApiProxyManagerI {
    protected static ApiProxyManagerI currentManager = null;
    private ApiProxyFactory proxyFactory = new ApiProxyFactory();
    private static Logger logger = Logger.getLogger(ApiProxyManager.class);
    protected static boolean useConnectionPooling = Config.getInstance().isProxyPoolingOn();
    protected ConcurrentHashMap<String, ApiProxyPoolI> serverProxyPools;
    private static List<ApiUserContextI> arServerUserRegistry = Collections.synchronizedList(new ArrayList());
    ApiProxyManagerTask proxyCleanUpTask = null;
    private volatile long lastCleaned;
    static final long cleanUpDelayMS = 100L;
    protected static volatile long connectionTimeout = Config.getInstance().getTimeUnit().toMillis(Config.getInstance().getConnectionTimeout());
    protected static volatile int idleConnectionsPerServer = Config.getInstance().getIdleConnectionsPerServer();
    protected static volatile int maxProxiesPerServer = Config.getInstance().getMaxProxiesPerServer();
    protected static long connectionLifespan = Config.getInstance().getTimeUnit().toMillis(Config.getInstance().getConnectionLifespan());
    static Map<String, Integer> poolsWaterMark = new HashMap<String, Integer>();
    private static int maxConnectedServerCMTAllowed = 0;
    private static int serverCmtTimeout = 0;
    private final ReentrantLock mainLock = new ReentrantLock();
    private static long prevPeriod = 0L;
    private static final ReentrantLock cleanUpLock = new ReentrantLock();
    private static final ReentrantLock userRegistryLock = new ReentrantLock();
    private ApiCMTProxyPool cmtPool = new ApiCMTProxyPool();

    public ApiProxyManager() {
        this(useConnectionPooling);
    }

    public ApiProxyManager(boolean proxyPoolingFlag) {
        logger.trace("create new ProxyManager instance for proxyPoolingFlag : " + proxyPoolingFlag);
        useConnectionPooling = proxyPoolingFlag;
        this.serverProxyPools = new ConcurrentHashMap();
        this.lastCleaned = System.currentTimeMillis();
        poolsWaterMark.clear();
        this.checkCleanUpTimer();
    }

    public ApiProxyManager(int maxProxiesPerServerSize, int idleConnectionsPerServerSize, long connectionTimeoutT, long connectionLifespanT, ARTimeUnit unit) {
        connectionTimeout = unit == null ? connectionTimeout : unit.toMillis(connectionTimeoutT);
        connectionLifespan = unit == null ? connectionLifespanT : unit.toMillis(connectionLifespanT);
        idleConnectionsPerServer = idleConnectionsPerServerSize;
        maxProxiesPerServer = maxProxiesPerServerSize;
        this.serverProxyPools = new ConcurrentHashMap();
        this.lastCleaned = System.currentTimeMillis();
        poolsWaterMark.clear();
        this.checkCleanUpTimer();
    }

    @Override
    public ApiProxyI getProxy(ApiUserContextI context, String proxyJRpcClazzName, String apiCmdName, ApiProxyType rpcType) throws ARException {
        ApiProxyI apiProxyI = null;
        if (context instanceof ApiUserContextBase) {
            this.setGenericUserSessionInfo(context);
            ApiThreadLocalStorageBlock.getTLB().setRpcType((ApiUserContextBase)context, apiCmdName, proxyJRpcClazzName);
            if (context instanceof ARServerUser) {
                String transactionHandle;
                if (rpcType != null) {
                    rpcType.setProxyType(ApiThreadLocalStorageBlock.getTLB().getRpcType());
                }
                if ((transactionHandle = ((ARServerUser)context).getTransactionHandle()) != null && (apiProxyI = this.getCMTProxyFromCMTPool(transactionHandle, context, proxyJRpcClazzName, apiCmdName, rpcType)) != null && logger.isTraceEnabled()) {
                    logger.trace("getCMTProxy for " + apiCmdName + " getProxy " + apiProxyI + " " + ((ApiProxyBase)apiProxyI).getSocket(context) + " for ctx class name " + proxyJRpcClazzName + " w rpc type " + (rpcType == null ? null : Integer.valueOf(rpcType.getProxyType())));
                }
            }
            if (apiProxyI == null) {
                apiProxyI = this.getProxy(context);
                if (logger.isTraceEnabled()) {
                    logger.trace(apiCmdName + " getProxy " + apiProxyI + " " + ((ApiProxyBase)apiProxyI).getSocket(context) + " for ctx class name " + proxyJRpcClazzName + " w rpc type " + (rpcType == null ? null : Integer.valueOf(rpcType.getProxyType())));
                }
            }
        }
        return apiProxyI;
    }

    @Override
    public ApiProxyI getProxy(ApiUserContextI context, Class<? extends ApiProxyI> proxyJRpcClazz, String apiCmdName, ApiProxyType rpcType) throws ARException {
        ApiProxyI apiProxyI = null;
        if (context instanceof ApiUserContextBase) {
            this.setGenericUserSessionInfo(context);
            ApiThreadLocalStorageBlock.getTLB().setRpcTypeWithProxyClass((ApiUserContextBase)context, apiCmdName, proxyJRpcClazz, rpcType);
            apiProxyI = this.getProxy(context);
            if (rpcType != null) {
                rpcType.setProxyType(ApiThreadLocalStorageBlock.getTLB().getRpcType());
            }
            if (logger.isTraceEnabled()) {
                logger.trace(apiCmdName + " getProxy " + apiProxyI + " for ctx CMDB Proxy w rpc type " + (rpcType == null ? null : Integer.valueOf(rpcType.getProxyType())));
            }
        }
        return apiProxyI;
    }

    @Override
    public ApiProxyI getProxy(ApiUserContextI context) throws ARException {
        if (context instanceof ApiUserContextBase && !((ApiUserContextBase)context).isProxyInMultiThreadTransaction()) {
            ((ApiUserContextBase)context).proxyILock.lock();
        }
        ApiProxyI proxy = null;
        try {
            boolean isCMDBCall = ApiThreadLocalStorageBlock.getTLB().isCMDBCall();
            if (context.isProxyInContext() && !isCMDBCall) {
                proxy = context.getProxyI();
            } else if (isCMDBCall && context.isCMDBProxyInContext()) {
                proxy = context.getCMDBProxyI();
            } else {
                ApiProxyPoolI pool = this.getServerPool(context);
                proxy = pool.get(context);
            }
            proxy.setProxyProperties(context);
        }
        catch (ARException e) {
            if (!context.isProxyInContext() && proxy != null) {
                String msg = "For server " + this.getKeyForServer(context);
                logger.error(msg + " Exception in Proxy retrival. Release " + proxy, e);
                this.releaseProxy(proxy, context);
            }
            throw e;
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseProxy(ApiProxyI proxy, ApiUserContextI context, Class<? extends ApiProxyI> proxyJRpcClazz, String apiCmdName, ApiProxyType rpcType) {
        if (proxyJRpcClazz == null) {
            throw new RuntimeException("CMDB call did not pass in CMDBProxy class!");
        }
        if (context instanceof ApiUserContextBase) {
            try {
                ApiThreadLocalStorageBlock.getTLB().setRpcTypeWithProxyClass((ApiUserContextBase)context, apiCmdName, proxyJRpcClazz, rpcType);
                this.releaseProxy(proxy, context);
                if (logger.isTraceEnabled()) {
                    logger.trace(apiCmdName + " releaseProxy " + proxy + " for ctx CMDB Proxy w rpc type w rpcType " + rpcType.getProxyType());
                }
            }
            finally {
                ApiThreadLocalStorageBlock.getTLB().setRpcType((ApiUserContextBase)context, apiCmdName, "com.bmc.arsys.api.ProxyJRpc");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseProxy(ApiProxyI proxy, ApiUserContextI context, String proxyJRpcClazzName, String apiCmdName, ApiProxyType rpcType) {
        block9: {
            boolean needToRelease = true;
            if (proxyJRpcClazzName == null) {
                proxyJRpcClazzName = "com.bmc.arsys.api.ProxyJRpc";
            }
            if (context instanceof ApiUserContextBase) {
                String transactionHandle = null;
                try {
                    ApiThreadLocalStorageBlock.getTLB().setRpcType((ApiUserContextBase)context, apiCmdName, proxyJRpcClazzName);
                    if (!ApiThreadLocalStorageBlock.getTLB().isIgnoreCMTHandle() && context instanceof ARServerUser && (transactionHandle = ((ARServerUser)context).getTransactionHandle()) != null) {
                        needToRelease = this.releaseCMTProxyInCMTPool(transactionHandle, proxy, context, proxyJRpcClazzName, apiCmdName, rpcType);
                    }
                    if (!needToRelease) break block9;
                    if (logger.isTraceEnabled() && proxy != null) {
                        Object so = null;
                        try {
                            so = ((ApiProxyBase)proxy).getSocket(context);
                        }
                        catch (ARException e) {
                            logger.trace("TRACE with Error: getSocket failed", e);
                        }
                        logger.trace(apiCmdName + " releaseProxy " + proxy + " " + so + " for ctx class name " + proxyJRpcClazzName + " w rpcType " + rpcType.getProxyType());
                    }
                    this.releaseProxy(proxy, context);
                }
                finally {
                    ApiThreadLocalStorageBlock.getTLB().setRpcType((ApiUserContextBase)context, apiCmdName, "com.bmc.arsys.api.ProxyJRpc");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseProxy(ApiProxyI proxy, ApiUserContextI context) {
        try {
            if (proxy != null) {
                boolean isCMDBProxy = ApiThreadLocalStorageBlock.getTLB().isCMDBCall();
                boolean isCMDBProxyInContext = context.isCMDBProxyInContext();
                boolean isARProxyInContext = context.isProxyInContext();
                long connectionLifespan = ApiProxyManager.getConnectionLifespanMilliSec();
                long establishedTime = proxy.getEstablishTime();
                long c = System.currentTimeMillis();
                long liveTime = c - establishedTime;
                String str = null;
                String proxyId = null;
                String ctxInfo = "";
                ApiProxyPoolI pool = null;
                if (ApiProxyManager.isUseConnectionPooling()) {
                    pool = this.getServerPool(context, proxy);
                    pool.setLastUsed(c);
                    ctxInfo = pool.getPoolName();
                }
                if (logger.isDebugEnabled()) {
                    proxyId = proxy.toString();
                    str = " for load balance after established for " + liveTime + " (" + ProcessUtil.getElapsedTimeToFormatedString(liveTime) + ")";
                }
                if (ApiProxyManager.isUseConnectionPooling() && (!isARProxyInContext && !isCMDBProxy || isCMDBProxy && !isCMDBProxyInContext)) {
                    proxy.setLastUsed(c);
                    if (connectionLifespan > 0L) {
                        proxy = this.checkAndTerminateProxyIfNeededForLoadBalance(pool, proxy, context, connectionLifespan);
                    }
                    if (proxy != null && pool != null) {
                        pool.put(proxy);
                        if (logger.isTraceEnabled() && connectionLifespan > 0L) {
                            logger.trace("checked " + proxyId + " in pool " + ctxInfo);
                        } else if (logger.isTraceEnabled() && connectionLifespan > 0L) {
                            logger.trace(proxy + " is put back in pool " + pool);
                        }
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("terminated connection " + proxyId + " for " + ctxInfo + str);
                    }
                } else if (!ApiProxyManager.isUseConnectionPooling() && proxy != null && proxy instanceof ApiProxyPool && connectionLifespan > 0L) {
                    if (logger.isInfoEnabled()) {
                        ctxInfo = " for " + context.getContextInfoStr();
                    }
                    if (logger.isInfoEnabled()) {
                        proxyId = proxy.toString();
                    }
                    if ((proxy = this.checkAndTerminateProxyIfNeededForLoadBalance(null, proxy, context, connectionLifespan)) == null) {
                        if (isARProxyInContext) {
                            context.setProxyI(proxy);
                            if (logger.isDebugEnabled()) {
                                logger.debug("terminated an AR connection " + proxyId + ctxInfo + str);
                            }
                        } else if (isCMDBProxy) {
                            context.setCMDBProxyI(proxy);
                            if (logger.isDebugEnabled()) {
                                logger.debug("terminated an CMDB connection " + proxyId + ctxInfo + str);
                            }
                        }
                    } else if (logger.isTraceEnabled()) {
                        logger.trace("kept " + proxyId + ctxInfo);
                    }
                }
            }
        }
        catch (ARException e) {
            logger.debug("should not come here.");
            return;
        }
        finally {
            int cnt;
            if (context instanceof ApiUserContextBase && (cnt = ((ApiUserContextBase)context).proxyILock.getHoldCount()) > 0) {
                ((ApiUserContextBase)context).proxyILock.unlock();
            }
        }
    }

    protected void terminateProxy(ApiProxyI proxy, ApiUserContextI context) {
        if (proxy != null) {
            try {
                proxy.ARTermination(null);
            }
            catch (ARException e) {
                logger.debug(e.getLocalizedMessage());
            }
        }
    }

    public String getKeyForServer(ApiUserContextI context) {
        String serverKey = context.getServer();
        int serverPort = context.getPort();
        if (serverPort != 0) {
            serverKey = serverKey + ":" + serverPort;
        }
        if (ApiThreadLocalStorageBlock.getTLB().isCMDBCall()) {
            serverKey = serverKey + "_CMDB";
        }
        return serverKey;
    }

    protected String getKeyForServerNoPort(ApiUserContextI context) {
        return context.getServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ageOutIdlePools() {
        if (!ApiProxyManager.isUseConnectionPooling() || connectionTimeout <= 0L) {
            return;
        }
        ReentrantLock runLock = this.mainLock;
        if (runLock.tryLock()) {
            HashSet<String> removeList = new HashSet<String>();
            try {
                String ageOutMsg = null;
                Object curIdleTimeStr = null;
                for (String key : this.serverProxyPools.keySet()) {
                    ApiProxyPoolI tp = this.serverProxyPools.get(key);
                    String poolName = tp.getPoolName();
                    long t = this.getLastUsed(poolName, tp);
                    long c = System.currentTimeMillis();
                    long poolBeenIdle = c - t;
                    if (logger.isDebugEnabled()) {
                        curIdleTimeStr = " been idle " + poolBeenIdle + " ms (" + ProcessUtil.getElapsedTimeToFormatedString(poolBeenIdle) + ")";
                    }
                    if (idleConnectionsPerServer == 0 && connectionTimeout > 0L && poolBeenIdle > connectionTimeout) {
                        removeList.add(key);
                        if (logger.isDebugEnabled()) {
                            ageOutMsg = " time out after " + (String)curIdleTimeStr;
                            logger.debug("Pool " + key + ageOutMsg);
                        }
                        if (tp instanceof ApiProxyPool) {
                            ((ApiProxyPool)tp).interruptIdleWorkers();
                            continue;
                        }
                        tp.clear();
                        continue;
                    }
                    if (connectionTimeout <= 0L) continue;
                    ((ApiProxyPool)tp).ageOutIdleProxy();
                }
            }
            finally {
                try {
                    if (removeList.size() > 0) {
                        int orgPoolSize = this.serverProxyPools.size();
                        for (String name : removeList) {
                            this.serverProxyPools.remove(name);
                            logger.debug("removed inactive pool " + name);
                        }
                        if (logger.isTraceEnabled()) {
                            String msg = "internal Ps count reduced from " + orgPoolSize + " to " + this.serverProxyPools.size() + "(It is normal if this internal number is bigger than Midtier displays, such as double the ones with port.)";
                            logger.trace(msg);
                        }
                    }
                }
                catch (Throwable e) {
                    logger.trace(e.getLocalizedMessage());
                }
                finally {
                    runLock.unlock();
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Skip. all pools are busy this time");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recycleConnectionForInactiveARServerUser() {
        if (ApiProxyManager.isUseConnectionPooling() || connectionLifespan <= 0L) {
            return;
        }
        if (connectionLifespan > 0L) {
            int userN = arServerUserRegistry.size();
            if (logger.isTraceEnabled()) {
                logger.trace("InactiveARServerUser none pooling connection recycle evaluating among " + userN + " ARServerUser instances.");
            }
            userRegistryLock.lock();
            try {
                for (ApiUserContextI context : arServerUserRegistry) {
                    if (!(context instanceof ApiUserContextBase) || ((ApiUserContextBase)context).isProxyInMultiThreadTransaction() || !((ApiUserContextBase)context).proxyILock.tryLock()) continue;
                    try {
                        long livetime;
                        ApiProxyI proxy;
                        String ctxInfo = null;
                        if (logger.isDebugEnabled()) {
                            ctxInfo = context.getContextInfoStr();
                        }
                        long c = System.currentTimeMillis();
                        if (context.isProxyInContext()) {
                            proxy = context.getProxyI();
                            livetime = c - proxy.getEstablishTime();
                            if (this.isInactiveNoneProxyPoolUser(proxy) && this.isProxyNeedToRebalanced(proxy, connectionLifespan)) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("recycle an AR connection " + proxy + " for " + ctxInfo + " after established for " + livetime + " ms (" + ProcessUtil.getElapsedTimeToFormatedString(livetime) + ")");
                                }
                                this.terminateProxy(proxy, context);
                                context.setProxyI(null);
                            }
                        }
                        if (!context.isCMDBProxyInContext()) continue;
                        proxy = context.getCMDBProxyI();
                        livetime = c - proxy.getEstablishTime();
                        if (!this.isInactiveNoneProxyPoolUser(proxy) || !this.isProxyNeedToRebalanced(proxy, connectionLifespan)) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug("recycle an CMDB connection " + proxy + " for " + ctxInfo + " after established for " + livetime + " ms (" + ProcessUtil.getElapsedTimeToFormatedString(livetime) + ")");
                        }
                        this.terminateProxy(proxy, context);
                        context.setCMDBProxyI(null);
                    }
                    finally {
                        int cnt = ((ApiUserContextBase)context).proxyILock.getHoldCount();
                        if (cnt <= 0) continue;
                        ((ApiUserContextBase)context).proxyILock.unlock();
                    }
                }
            }
            finally {
                if (userRegistryLock.getHoldCount() > 0) {
                    userRegistryLock.unlock();
                }
            }
        }
    }

    private boolean isInactiveNoneProxyPoolUser(ApiProxyI proxy) {
        boolean flag = false;
        long c = System.currentTimeMillis();
        if (!ApiProxyManager.isUseConnectionPooling() && connectionLifespan > 0L && c - proxy.getLastUsed() > connectionLifespan) {
            flag = true;
        }
        return flag;
    }

    protected ApiProxyI checkAndTerminateProxyIfNeededForLoadBalance(ApiProxyPoolI pool, ApiProxyI proxy, ApiUserContextI context, long connectionLifespan) {
        if (connectionLifespan <= 0L || context instanceof ApiUserContextBase && ((ApiUserContextBase)context).isProxyInMultiThreadTransaction()) {
            return proxy;
        }
        if (this.isProxyNeedToRebalanced(proxy, connectionLifespan)) {
            if (logger.isDebugEnabled()) {
                long c = System.currentTimeMillis();
                logger.debug("an connection " + proxy + " for " + context.getContextInfoStr() + " will be terminated for load_balance after established for " + (c - proxy.getEstablishTime()) + " ms (" + ProcessUtil.getElapsedTimeToFormatedString(c - proxy.getEstablishTime()) + ")");
            }
            if (pool != null) {
                this.deRecodeProxy(pool, proxy);
            }
            this.terminateProxy(proxy, context);
            proxy = null;
        }
        return proxy;
    }

    public void deRecodeProxy(ApiProxyPoolI pool, ApiProxyI proxy) {
        if (logger.isDebugEnabled()) {
            logger.debug("will deRecodeProxy " + proxy + " in pool " + pool.getPoolName());
        }
        ((ApiProxyPool)pool).deRecodeProxy(proxy);
        if (logger.isDebugEnabled()) {
            logger.debug("done deRecodeProxy " + proxy + " from pool " + pool.getPoolName() + ". Will terminate the proxy ");
        }
    }

    protected boolean isProxyNeedToRebalanced(ApiProxyI proxy, long connectionLifespan) {
        boolean flag = false;
        if (proxy != null) {
            long st = System.currentTimeMillis();
            long sp = st - proxy.getEstablishTime();
            if (connectionLifespan > 0L && sp > connectionLifespan) {
                if (logger.isTraceEnabled()) {
                    logger.trace(proxy + " established= " + sp + " millisec; connectionLifespan= " + connectionLifespan + " millisec");
                }
                flag = true;
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLastUsed(String poolName, ApiProxyPoolI p) {
        ReentrantLock runLock;
        long lastUsed = p.getLastUsed();
        if (poolName.contains(":") && (runLock = this.mainLock).tryLock()) {
            try {
                for (ApiProxyPoolI pool : this.serverProxyPools.values()) {
                    if (!poolName.equals(pool.getPoolName()) || pool.getLastUsed() <= lastUsed) continue;
                    logger.trace("updating last used for pool " + poolName);
                    lastUsed = pool.getLastUsed();
                    p.setLastUsed(lastUsed);
                }
            }
            finally {
                runLock.unlock();
            }
        }
        return lastUsed;
    }

    @Override
    public void clear() {
        this.mainLock.lock();
        try {
            for (ApiProxyPoolI pool : this.serverProxyPools.values()) {
                pool.clear();
            }
            this.serverProxyPools.clear();
        }
        finally {
            this.mainLock.unlock();
        }
    }

    protected ConcurrentHashMap<String, ApiProxyPoolI> getServerProxyPools() {
        return this.serverProxyPools;
    }

    protected void setServerProxyPools(ConcurrentHashMap<String, ApiProxyPoolI> serverProxyPools) {
        this.serverProxyPools = serverProxyPools;
    }

    private String getKeyForServer(ApiUserContextI context, ApiProxyI proxy) {
        String serverKey = this.getKeyForServer(context);
        if (proxy != null) {
            boolean keyContainCMDB = serverKey.contains("_CMDB");
            boolean CMDBProxy = proxy.getClass().getName().toLowerCase().contains("cmdbproxy");
            if (!keyContainCMDB && CMDBProxy) {
                serverKey = serverKey + "_CMDB";
                if (logger.isTraceEnabled()) {
                    logger.trace(proxy + " will be enforced to released to " + serverKey);
                }
            } else if (keyContainCMDB && !CMDBProxy) {
                int idx = serverKey.indexOf("_CMDB");
                serverKey = serverKey.substring(0, idx);
                if (logger.isTraceEnabled()) {
                    logger.trace(proxy + " will be enforced to released to " + serverKey);
                }
            }
        }
        return serverKey;
    }

    protected ApiProxyPoolI getServerPool(ApiUserContextI context) throws ARException {
        return this.getServerPool(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ApiProxyPoolI getServerPool(ApiUserContextI context, ApiProxyI proxy) throws ARException {
        ApiProxyPoolI pool;
        block9: {
            if (context.getServer() == null || context.getServer().length() == 0) {
                throw new ARException(2, 150);
            }
            String serverKey = this.getKeyForServer(context, proxy);
            pool = this.serverProxyPools.get(serverKey);
            try {
                if (pool != null) break block9;
                this.mainLock.lock();
                try {
                    pool = this.serverProxyPools.get(serverKey);
                    if (pool == null) {
                        pool = this.createNewPool(serverKey, ApiProxyManager.getMaxProxiesPerServer());
                        this.serverProxyPools.put(serverKey, pool);
                        if (!ApiThreadLocalStorageBlock.getTLB().isCMDBCall()) {
                            serverKey = this.getKeyForServerNoPort(context);
                            this.getServerProxyPools().put(serverKey, pool);
                        }
                    }
                }
                finally {
                    this.mainLock.unlock();
                }
            }
            finally {
                pool.setLastUsed(System.currentTimeMillis());
            }
        }
        return pool;
    }

    protected abstract ApiProxyPoolI createNewPool(String var1, int var2);

    @Override
    public abstract ApiProxyI createProxy(ApiUserContextI var1) throws ARException;

    protected static long getConnectionTimeout(ARTimeUnit unit) {
        return unit == null ? connectionTimeout : unit.convert(connectionTimeout, ARTimeUnit.MILLISECONDS);
    }

    public static int getMaxProxiesPerServer() {
        return maxProxiesPerServer;
    }

    public static int getIdleConnectionsPerServer() {
        return idleConnectionsPerServer;
    }

    public static long getConnectionTimeoutMilliSec() {
        return connectionTimeout;
    }

    public static long getConnectionLifespanMilliSec() {
        return connectionLifespan;
    }

    public static void setConnectionLifespan(long newConnectionLifespan, ARTimeUnit unit) {
        connectionLifespan = unit == null ? newConnectionLifespan : unit.toMillis(newConnectionLifespan);
        logger.trace("set new connectionLifespan = " + connectionLifespan);
        if (currentManager != null) {
            ((ApiProxyManager)currentManager).checkCleanUpTimer();
        }
    }

    protected static boolean isUseConnectionPooling() {
        return useConnectionPooling;
    }

    protected long getLastCleaned() {
        return this.lastCleaned;
    }

    protected void setLastCleaned(long lastCleaned) {
        logger.trace("Pools cleaning ");
        this.lastCleaned = lastCleaned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustProxyPoolVariables(int maxProxyPerServerSize, int minIdleProxySize, long connectionTimeout2, ARTimeUnit unit) {
        this.mainLock.lock();
        try {
            maxProxiesPerServer = maxProxyPerServerSize;
            idleConnectionsPerServer = minIdleProxySize;
            connectionTimeout = unit == null ? connectionTimeout2 : unit.toMillis(connectionTimeout2);
            for (ApiProxyPool apiProxyPool : this.serverProxyPools.values()) {
                apiProxyPool.adjustPoolParameters(maxProxyPerServerSize, minIdleProxySize);
            }
        }
        finally {
            this.mainLock.unlock();
            this.checkCleanUpTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCleanUpTimer() {
        long period = ApiProxyManagerTask.caculateTimePeriod();
        if (logger.isTraceEnabled()) {
            logger.trace("evaluating cleanUp timer newPeriod = " + period + " milliSec; prevPeriod = " + prevPeriod + " milliSec");
        }
        if (period != prevPeriod && cleanUpLock.tryLock()) {
            try {
                if (period != prevPeriod) {
                    if (this.proxyCleanUpTask != null) {
                        if (this.proxyCleanUpTask.cleanUpTimer != null) {
                            this.proxyCleanUpTask.cleanUpTimer.cancel();
                            this.proxyCleanUpTask.cleanUpTimer = null;
                        }
                        this.proxyCleanUpTask.cancel();
                        this.proxyCleanUpTask = null;
                        logger.info("cleanUp timer canceled previous task for connection pooling: " + ApiProxyManager.isUseConnectionPooling());
                    }
                    if (period > 0L) {
                        long delay = 0L;
                        this.proxyCleanUpTask = new ApiProxyManagerTask();
                        logger.info("set timer period " + period + " milliSec (" + ProcessUtil.getElapsedTimeToFormatedString(period) + ")");
                        this.proxyCleanUpTask.cleanUpTimer.scheduleAtFixedRate((TimerTask)this.proxyCleanUpTask, delay, period);
                    }
                    prevPeriod = period;
                }
            }
            finally {
                if (cleanUpLock.getHoldCount() > 0) {
                    cleanUpLock.unlock();
                }
            }
        }
    }

    protected ApiProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public static void registerARServerUserCheck(ApiUserContextI arServerUser) {
        if (!arServerUserRegistry.contains(arServerUser)) {
            userRegistryLock.lock();
            try {
                if (!arServerUserRegistry.contains(arServerUser)) {
                    arServerUserRegistry.add(arServerUser);
                    if (logger.isTraceEnabled()) {
                        logger.trace(arServerUser.getContextInfoStr() + " is registered. total registered: " + arServerUserRegistry.size());
                    }
                }
            }
            finally {
                if (userRegistryLock.getHoldCount() > 0) {
                    userRegistryLock.unlock();
                }
            }
        }
    }

    public static void deRegisterARServerUser(ApiUserContextI apiUserContextBase) {
        if (arServerUserRegistry.contains(apiUserContextBase)) {
            userRegistryLock.lock();
            try {
                if (arServerUserRegistry.contains(apiUserContextBase)) {
                    arServerUserRegistry.remove(apiUserContextBase);
                    if (logger.isTraceEnabled()) {
                        logger.trace(apiUserContextBase.getContextInfoStr() + " is deregistered. total registered: " + arServerUserRegistry.size());
                    }
                }
            }
            finally {
                if (userRegistryLock.getHoldCount() > 0) {
                    userRegistryLock.unlock();
                }
            }
        }
    }

    public static long getConnectionLifespan(ARTimeUnit unit) {
        return unit == null ? connectionLifespan : unit.convert(connectionLifespan, ARTimeUnit.MILLISECONDS);
    }

    void loadBalanceForInactiveProxyInPool() {
        if (!ApiProxyManager.isUseConnectionPooling() || connectionLifespan <= 0L) {
            return;
        }
        for (String key : this.serverProxyPools.keySet()) {
            ApiProxyPoolI tp = this.serverProxyPools.get(key);
            if (!(tp instanceof ApiProxyPool)) continue;
            ((ApiProxyPool)tp).terminateProxyForLoadBalancer();
        }
    }

    public void deRecodeProxy(ApiUserContextI context, ApiProxyI t) {
        if (ProxyManager.isUseConnectionPooling() && t != null) {
            try {
                ApiProxyPoolI pool = this.getServerPool(context);
                if (pool != null && pool instanceof ApiProxyPool) {
                    ((ApiProxyPool)pool).deRecodeProxy(t);
                }
            }
            catch (Exception e) {
                logger.trace("not able to de-recode proxy " + t + " " + e.getLocalizedMessage());
            }
        }
    }

    public void addCMTProxyInCMTPool(String mTransactionHandle, ApiProxyI apiProxyI, ApiUserContextI apiUserContextI, String arProxyName, String cmd, ApiProxyType proxyType) throws ARException {
        this.cmtPool.addCMTProxyInCMTPool(mTransactionHandle, apiProxyI, apiUserContextI, arProxyName, cmd, proxyType);
    }

    public boolean removeCMTProxyFromCMTPool(String mTransactionHandle, ApiProxyI apiProxyI, ApiUserContextI apiUserContextI, String arProxyName, String cmd, ApiProxyType proxyType) throws ARException {
        return this.cmtPool.removeCMTProxyFromCMTPool(mTransactionHandle, apiProxyI, apiUserContextI, arProxyName, cmd, proxyType);
    }

    ApiProxyI getCMTProxyFromCMTPool(String mTransactionHandle, ApiUserContextI apiUserContextI, String arProxyName, String cmd, ApiProxyType proxyType) throws ARException {
        return this.cmtPool.getCMTProxyFromCMTPool(mTransactionHandle, apiUserContextI, arProxyName, cmd, proxyType);
    }

    private boolean releaseCMTProxyInCMTPool(String mTransactionHandle, ApiProxyI apiProxyI, ApiUserContextI apiUserContextI, String arProxyName, String cmd, ApiProxyType proxyType) {
        return this.cmtPool.releaseCMTProxyBackInCMTPool(mTransactionHandle, apiProxyI, apiUserContextI, arProxyName, cmd, proxyType);
    }

    boolean isCmtPoolEmpty() {
        return this.cmtPool.isCmtPoolEmpty();
    }

    void cleanUpTimeoutCMTFromCMTPool() {
        this.cmtPool.cleanUpTimeoutCMTFromCMTPool();
    }

    public static int getMaxConnectedServerCMTAllowed() {
        return maxConnectedServerCMTAllowed;
    }

    public static void setMaxConnectedServerCMTAllowed(int newMaxConnectedServerCMTAllowed) {
        if (newMaxConnectedServerCMTAllowed > maxConnectedServerCMTAllowed) {
            maxConnectedServerCMTAllowed = newMaxConnectedServerCMTAllowed;
        }
    }

    public static void setServerCmtTimeout(int newServerCmtTimeout) {
        if (newServerCmtTimeout > serverCmtTimeout) {
            serverCmtTimeout = newServerCmtTimeout;
        }
    }

    public static int getServerCmtTimeout() {
        return serverCmtTimeout;
    }

    public void setGenericUserSessionInfo(ApiUserContextI context) {
        if (context instanceof ApiUserContextBase) {
            String url;
            ApiWebSocketConfig config;
            ApiConfigI apiConfig;
            Map<Object, Object> userSessionInfo = ((ApiUserContextBase)context).getUserGenericSessionMap();
            ApiThreadLocalStorageBlock.getTLB().setApiThreadInfo(userSessionInfo);
            if (!this.isWebSocketSet(userSessionInfo) && (apiConfig = context.getApiConfig()) instanceof ApiConfig && (config = ((ApiConfig)apiConfig).getWebSocket_config(context.getServer())) != null && (url = config.getURL()) != null && url.length() > 0) {
                Map<Object, Object> apiThreadInfo = ApiThreadLocalStorageBlock.getTLB().getApiThreadInfo();
                if (apiThreadInfo == null) {
                    apiThreadInfo = new HashMap<Object, Object>();
                }
                apiThreadInfo.put("webSocket.server", config.getServer());
                apiThreadInfo.put("webSocket.URL", url);
                apiThreadInfo.put("webSocket.login", config.getLogin());
                apiThreadInfo.put("webSocket.password", config.getPassword());
                ApiThreadLocalStorageBlock.getTLB().setApiThreadInfo(apiThreadInfo);
            }
        }
    }

    private boolean isWebSocketSet(Map<Object, Object> networkSessionInfo) {
        boolean flag = false;
        flag = networkSessionInfo != null && networkSessionInfo.size() != 0 && networkSessionInfo.get("webSocket.URL") != null && ((String)networkSessionInfo.get("webSocket.URL")).length() != 0;
        return flag;
    }
}

