/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.arxdrenc;

import com.bmc.arsys.apitransport.arxdrenc.ArXdrEncryptRPCSvrToCnt;
import com.bmc.arsys.apitransport.session.ArRpcCallContext;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.NetworkDataEncryption;
import com.bmc.arsys.arrpc.rpcext.ArFlexXdrTcpDecodingStream;
import java.io.IOException;
import org.acplt.oncrpc.ArNetworkSocket;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrBufferDecodingStream;
import org.acplt.oncrpc.XdrDecodingStream;
import org.apache.log4j.Logger;

class ArUnXdrDecryptDecode
extends ArFlexXdrTcpDecodingStream {
    private transient ArRpcCallContext _callCtx;
    private static Logger logger = Logger.getLogger(ArUnXdrDecryptDecode.class);

    ArUnXdrDecryptDecode(Object sessionEncNode, ArNetworkSocket streamingSocket, int bufferSize) throws IOException {
        super(streamingSocket, bufferSize);
        this._callCtx = (ArRpcCallContext)sessionEncNode;
    }

    @Override
    protected byte[] arEncBeforeUnXdrDecoding(byte[] bufToDecode) throws OncRpcException, IOException {
        byte[] rst = bufToDecode;
        if (this.isArEncryptionOn() && this._callCtx != null) {
            ArXdrEncryptRPCSvrToCnt arXdrEnc = null;
            XdrDecodingStream xdr = null;
            try {
                arXdrEnc = new ArXdrEncryptRPCSvrToCnt(bufToDecode, bufToDecode.length + 4);
                xdr = new XdrBufferDecodingStream(bufToDecode, bufToDecode.length + 4);
                xdr.beginDecoding();
                arXdrEnc.xdrDecode(xdr);
                byte[] encryptedXdrData = arXdrEnc.getOut();
                NetworkDataEncryption dataEnc = new NetworkDataEncryption(false, false);
                rst = dataEnc.decryption(this._callCtx.getEncCtx().getClintKeyInfo(), encryptedXdrData);
            }
            catch (AREncryptionException e) {
                logger.error("Rpc decryption error", e);
                throw new OncRpcException(16, e, "Rpc decryption error");
            }
            finally {
                if (xdr != null) {
                    try {
                        xdr.endDecoding();
                        xdr.close();
                        xdr = null;
                    }
                    catch (Exception exception) {}
                }
            }
        }
        rst = super.arEncBeforeUnXdrDecoding(bufToDecode);
        return rst;
    }

    @Override
    protected boolean isDecodingProcessReady() {
        boolean flag = false;
        if (this._callCtx != null) {
            flag = true;
        }
        return flag;
    }
}

