/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport;

import com.bmc.arsys.api.ARTimeUnit;
import com.bmc.arsys.api.ConfigKey;
import com.bmc.arsys.apitransport.ApiConfigI;
import com.bmc.arsys.apitransport.ApiConfigLogger;
import com.bmc.arsys.apitransport.ApiConfigManager;
import com.bmc.arsys.apitransport.ApiWebSocketConfig;
import com.bmc.thirdparty.org.apache.commons.configuration.CombinedConfiguration;
import com.bmc.thirdparty.org.apache.commons.configuration.Configuration;
import com.bmc.thirdparty.org.apache.commons.configuration.ConfigurationException;
import com.bmc.thirdparty.org.apache.commons.configuration.DefaultConfigurationBuilder;
import com.bmc.thirdparty.org.apache.commons.configuration.HierarchicalConfiguration;
import com.bmc.thirdparty.org.apache.commons.configuration.XMLConfiguration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public abstract class ApiConfig
implements ApiConfigI {
    private static Logger log = Logger.getLogger(ApiConfig.class);
    public static final String PROPERTY_NAME = "APICONFIG";
    public static final String MAINCONFIG_NAME = "ARApiConfig";
    private String configName;
    private String fileName;
    private String rpcClientStubType;
    protected boolean jrpcMode;
    protected boolean jrpcModeSet;
    protected int clientRpcVersion;
    protected int minimumSupportedServerRpcVersion;
    protected boolean useConnectionPooling = true;
    protected int maxProxiesPerServer;
    protected int idleConnectionsPerServer;
    protected long connectionTimeout;
    protected long connectionLifespan;
    protected String timeUnitStr;
    ARTimeUnit timeUnit = ARTimeUnit.MINUTES;
    protected int connectionMaxRetries;
    protected int timeLagBetweenRetriesMillSec;
    protected int apiRecordingMode;
    protected int jniLoadMode;
    protected Configuration config;
    protected Map<String, ApiWebSocketConfig> webSocket_config = new HashMap<String, ApiWebSocketConfig>();
    private static final String WEBSOCKET_NODE_KEY = "webSockets.webSocket";
    private XMLConfiguration xmlConfig = null;
    private final ReadWriteLock configLock = new ReentrantReadWriteLock();

    public ApiConfig(String configName, String file) {
        this.initializeLogger();
        this.setConfigName(configName);
        this.setConfigFileName(file);
        try {
            this.applyDefaults();
        }
        catch (Exception e) {
            log.error("Can not initialize Config defaults", e);
        }
        try {
            this.setConfiguration(file);
            this.applyConfigFileSettings();
        }
        catch (ConfigurationException e) {
            log.error("Default settings are used since we could not load the config from file " + e.getLocalizedMessage());
        }
        catch (Exception e) {
            log.warn("Default settings are used since we can not initialize Config from file" + e.getLocalizedMessage());
        }
    }

    protected void initializeLogger() {
        try {
            Logger.class.getMethod("getAllAppenders", new Class[0]);
            ApiConfigLogger.initializeLogging();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setConfiguration(String fileName) throws ConfigurationException {
        DefaultConfigurationBuilder factory = new DefaultConfigurationBuilder(fileName);
        factory.clearErrorListeners();
        this.config = factory.getConfiguration();
    }

    protected Configuration getConfiguration() {
        return this.config;
    }

    protected void applyDefaults() {
        this.setJrpcMode(Boolean.parseBoolean(ConfigKey.JrpcMode.getDefaultValue()));
        this.jrpcModeSet = false;
        this.setDefaultConnectionSettings();
        this.setClientRpcVersion(Integer.parseInt(ConfigKey.ClientRpcVersion.getDefaultValue()));
        this.setMinimumSupportedServerRpcVersion(Integer.parseInt(ConfigKey.MinimumSupportedServerRpcVersion.getDefaultValue()));
        this.setRpcClientStubType(ConfigKey.RpcClientStubType.getDefaultValue());
        this.setConnectionMaxRetries(Integer.parseInt(ConfigKey.ConnectionMaxRetries.getDefaultValue()));
        this.setTimeLagBetweenRetriesMillSec(Integer.parseInt(ConfigKey.TimeLagBetweenRetriesMillSec.getDefaultValue()));
        this.setApiRecordingMode(Integer.parseInt(ConfigKey.ApiRecordingMode.getDefaultValue()));
        this.setJniLoadMode(Integer.parseInt(ConfigKey.JniLoadMode.getDefaultValue()));
    }

    protected void applyConfigFileSettings() {
        this.setJrpcMode(this.config);
        this.setClientRpcVersion(this.config.getInt(ConfigKey.ClientRpcVersion.getKey(), this.clientRpcVersion));
        this.setRpcClientStubType(this.config.getString(ConfigKey.RpcClientStubType.getKey(), this.rpcClientStubType));
        this.setMinimumSupportedServerRpcVersion(this.config.getInt(ConfigKey.MinimumSupportedServerRpcVersion.getKey(), this.minimumSupportedServerRpcVersion));
        this.setConnectionSettings(this.config);
        this.setConnectionMaxRetries(this.config.getInt(ConfigKey.ConnectionMaxRetries.getKey(), this.connectionMaxRetries));
        this.setTimeLagBetweenRetriesMillSec(this.config.getInt(ConfigKey.TimeLagBetweenRetriesMillSec.getKey(), this.timeLagBetweenRetriesMillSec));
        this.setApiRecordingMode(this.config.getInt(ConfigKey.ApiRecordingMode.getKey(), this.apiRecordingMode));
        this.setJniLoadMode(this.config.getInt(ConfigKey.JniLoadMode.getKey(), this.jniLoadMode));
        this.setWebSocketSettings();
    }

    private void setWebSocketSettings() {
        CombinedConfiguration comConfig = (CombinedConfiguration)this.config;
        for (int i = 0; i < comConfig.getNumberOfConfigurations(); ++i) {
            if (!(comConfig.getConfiguration(i) instanceof XMLConfiguration)) continue;
            this.xmlConfig = (XMLConfiguration)comConfig.getConfiguration(i);
            break;
        }
        Object prop = this.xmlConfig.getProperty("webSockets.webSocket.URL");
        int size = 0;
        if (prop instanceof Collection) {
            size = ((Collection)prop).size();
        } else if (prop != null) {
            size = 1;
        }
        log.debug("Number of webSockets: " + size);
        for (int i = 0; i < size; ++i) {
            String idx = "webSockets.webSocket(" + i + ").";
            String webSocket_server = (String)this.xmlConfig.getProperty(idx + "server");
            if (webSocket_server == null || webSocket_server.length() == 0) {
                webSocket_server = "default";
            }
            this.webSocket_config.put(webSocket_server, new ApiWebSocketConfig((String)this.xmlConfig.getProperty(idx + "server"), (String)this.xmlConfig.getProperty(idx + "URL"), "", ""));
        }
    }

    protected void setDefaultConnectionSettings() {
        this.useConnectionPooling = Boolean.parseBoolean(ConfigKey.UseConnectionPooling.getDefaultValue());
        this.maxProxiesPerServer = Integer.parseInt(ConfigKey.MaxProxiesPerServer.getDefaultValue());
        this.idleConnectionsPerServer = Integer.parseInt(ConfigKey.idleConnectionsPerServer.getDefaultValue());
        this.timeUnitStr = ConfigKey.TimeUnit.getDefaultValue();
        this.connectionTimeout = Long.parseLong(ConfigKey.ConnectionTimeout.getDefaultValue());
        this.connectionLifespan = Long.parseLong(ConfigKey.ConnectionLifespan.getDefaultValue());
    }

    protected void setConnectionSettings(Configuration config) {
        this.useConnectionPooling = config.getBoolean(ConfigKey.UseConnectionPooling.getKey(), this.useConnectionPooling);
        this.maxProxiesPerServer = config.getInt(ConfigKey.MaxProxiesPerServer.getKey(), this.maxProxiesPerServer);
        this.idleConnectionsPerServer = config.getInt(ConfigKey.idleConnectionsPerServer.getKey(), this.idleConnectionsPerServer);
        if (this.idleConnectionsPerServer > this.maxProxiesPerServer) {
            this.idleConnectionsPerServer = this.maxProxiesPerServer / 2;
            log.debug("idleConnectionsPerServer value cannot more than maxProxiesPerServer. Value reverted to " + this.idleConnectionsPerServer);
        }
        this.timeUnitStr = config.getString(ConfigKey.TimeUnit.getKey(), this.timeUnitStr);
        this.timeUnit = ARTimeUnit.convert(this.timeUnitStr);
        this.connectionTimeout = config.getLong(ConfigKey.ConnectionTimeout.getKey(), this.connectionTimeout);
        this.connectionLifespan = config.getLong(ConfigKey.ConnectionLifespan.getKey(), this.connectionLifespan);
        if (log.isDebugEnabled()) {
            log.debug("From Config xml: useConnectionPooling = " + this.useConnectionPooling);
            log.debug("From Config xml: idleConnectionsPerServer = " + this.idleConnectionsPerServer + " maximumPoolSize = " + this.maxProxiesPerServer + " connectionTimeout = " + this.connectionTimeout + " connectionLifespan = " + this.connectionLifespan + " timeUnit = " + this.timeUnitStr);
        }
    }

    protected void setConfigName(String name) {
        this.configName = name;
    }

    public String getConfigName() {
        return this.configName;
    }

    protected void setConfigFileName(String fileName) {
        this.fileName = fileName;
    }

    protected String getConfigFileName() {
        return this.fileName;
    }

    public static void register(ApiConfig config) {
        ApiConfigManager.getInstance().register(config.getConfigName(), config);
    }

    public void setJrpcMode(Configuration config) {
        if (!this.jrpcModeSet) {
            this.setJrpcMode(config.getBoolean(ConfigKey.JrpcMode.getKey(), this.jrpcMode));
            log.info("jrpcMode: " + this.jrpcMode);
        }
    }

    @Override
    public void setJrpcMode(boolean jrpcMode) {
        this.jrpcMode = jrpcMode;
    }

    @Override
    public boolean getJrpcMode() {
        return this.jrpcMode;
    }

    @Override
    public void setClientRpcVersion(int clientRpcVersion) {
        this.clientRpcVersion = clientRpcVersion;
    }

    @Override
    public int getClientRpcVersion() {
        return this.clientRpcVersion;
    }

    @Override
    public void setJniLoadMode(int jniLoadMode) {
        this.jniLoadMode = jniLoadMode;
    }

    @Override
    public int getJniLoadMode() {
        return this.jniLoadMode;
    }

    @Override
    public void setApiRecordingMode(int apiRecording) {
        this.apiRecordingMode = apiRecording;
    }

    @Override
    public int getApiRecording() {
        return this.apiRecordingMode;
    }

    @Override
    public void setMinimumSupportedServerRpcVersion(int minimumSupportedServerRpcVersion) {
        this.minimumSupportedServerRpcVersion = minimumSupportedServerRpcVersion;
    }

    @Override
    public int getMinimumSupportedServerRpcVersion() {
        return this.minimumSupportedServerRpcVersion;
    }

    @Override
    public void setConnectionMaxRetries(int connectionMaxRetries) {
        this.connectionMaxRetries = connectionMaxRetries;
    }

    @Override
    public int getConnectionMaxRetries() {
        return this.connectionMaxRetries;
    }

    @Override
    public void setTimeLagBetweenRetriesMillSec(int timeLagBetweenRetriesMillSec) {
        this.timeLagBetweenRetriesMillSec = timeLagBetweenRetriesMillSec;
    }

    @Override
    public int getTimeLagBetweenRetriesMillSec() {
        return this.timeLagBetweenRetriesMillSec;
    }

    public boolean isProxyPoolingOn() {
        return this.useConnectionPooling;
    }

    public int getMaxProxiesPerServer() {
        return this.maxProxiesPerServer;
    }

    public int getIdleConnectionsPerServer() {
        return this.idleConnectionsPerServer;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public long getConnectionLifespan() {
        return this.connectionLifespan;
    }

    public String getTimeUnitStr() {
        return this.timeUnitStr;
    }

    public ARTimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public void setRpcClientStubType(String rpcClientStubType) {
        this.rpcClientStubType = rpcClientStubType;
    }

    @Override
    public String getRpcClientStubType() {
        return this.rpcClientStubType;
    }

    public ApiWebSocketConfig getWebSocket_config(String server) {
        if (server == null) {
            return null;
        }
        ApiWebSocketConfig config = this.webSocket_config.get(server.toLowerCase());
        if (config == null) {
            config = this.webSocket_config.get("default");
        }
        return config;
    }

    public void setWebSocketConfig(List<ApiWebSocketConfig> configList) {
        if (configList == null || configList.size() < 1) {
            return;
        }
        for (ApiWebSocketConfig config : configList) {
            if (config == null || config.getServer() == null || config.equals(this.webSocket_config.get(config.getServer()))) continue;
            this.webSocket_config.put(config.getServer(), config);
        }
    }

    public void updateWebSocketSettingsInXml(Map<String, ApiWebSocketConfig> updateConfigs) {
        Set<Map.Entry<String, ApiWebSocketConfig>> entrySet;
        Iterator<Map.Entry<String, ApiWebSocketConfig>> itr;
        if (updateConfigs == null || updateConfigs.size() == 0) {
            return;
        }
        CombinedConfiguration comConfig = (CombinedConfiguration)this.config;
        for (int i = 0; i < comConfig.getNumberOfConfigurations(); ++i) {
            if (!(comConfig.getConfiguration(i) instanceof XMLConfiguration)) continue;
            this.xmlConfig = (XMLConfiguration)comConfig.getConfiguration(i);
            break;
        }
        List<HierarchicalConfiguration> webSockets = this.xmlConfig.configurationsAt(WEBSOCKET_NODE_KEY);
        log.debug("updating webSockets : " + updateConfigs);
        if (updateConfigs != null && updateConfigs.size() > 0 && webSockets != null && (itr = (entrySet = updateConfigs.entrySet()).iterator()).hasNext()) {
            ApiWebSocketConfig newConfig = itr.next().getValue();
            this.webSocket_config.put(newConfig.getServer(), newConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiWebSocketConfig get(String serverName) {
        ApiWebSocketConfig value = null;
        this.configLock.readLock().lock();
        try {
            HierarchicalConfiguration nodeConfig = this.getWebSocketConfiguration(serverName);
            if (nodeConfig != null) {
                value = new ApiWebSocketConfig(serverName, nodeConfig.getString("URL"), nodeConfig.getString("login"), nodeConfig.getString("password"));
            }
        }
        finally {
            this.configLock.readLock().unlock();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String serverName, ApiWebSocketConfig updatingConfig) {
        HierarchicalConfiguration existingConfig = this.getWebSocketConfiguration(serverName);
        this.configLock.writeLock().lock();
        try {
            if (existingConfig == null) {
                this.xmlConfig.configurationsAt("webSockets");
                Object prop = this.xmlConfig.getProperty("webSockets.webSocket.server");
                int size = 0;
                if (prop instanceof Collection) {
                    size = ((Collection)prop).size();
                } else if (prop != null) {
                    size = 1;
                }
                HierarchicalConfiguration newNodeConfig = null;
                int newIndex = 0;
                while (newNodeConfig == null && newIndex++ < size) {
                    String nextNew = "server" + newIndex;
                    newNodeConfig = this.getWebSocketConfiguration(nextNew);
                }
                if (newNodeConfig != null) {
                    newNodeConfig.setProperty("server", serverName);
                    newNodeConfig.setProperty("URL", updatingConfig.getURL());
                    newNodeConfig.setProperty("login", updatingConfig.getLogin());
                    newNodeConfig.setProperty("password", updatingConfig.getPassword());
                } else {
                    log.debug("Creating configuration for websocket node: " + serverName);
                    this.xmlConfig.configurationsAt(WEBSOCKET_NODE_KEY);
                    this.xmlConfig.addProperty("webSockets.webSocket(-1).server", serverName);
                    this.xmlConfig.addProperty("webSockets.webSocket.URL", updatingConfig.getURL());
                    this.xmlConfig.addProperty("webSockets.webSocket.login", updatingConfig.getLogin());
                    this.xmlConfig.addProperty("webSockets.webSocket.password", updatingConfig.getPassword());
                }
            } else {
                existingConfig.setProperty("URL", updatingConfig.getURL());
                existingConfig.setProperty("login", updatingConfig.getLogin());
                existingConfig.setProperty("password", updatingConfig.getPassword());
            }
            try {
                this.xmlConfig.save();
            }
            catch (ConfigurationException e) {
                log.error("Error saving websocket configuration : " + serverName, e);
            }
        }
        finally {
            this.configLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HierarchicalConfiguration getWebSocketConfiguration(String serverName) {
        HierarchicalConfiguration existingConfig;
        block4: {
            existingConfig = null;
            this.configLock.readLock().lock();
            try {
                List<HierarchicalConfiguration> subConfigs = this.xmlConfig.configurationsAt(WEBSOCKET_NODE_KEY);
                if (subConfigs == null) break block4;
                for (HierarchicalConfiguration sub : subConfigs) {
                    String subName = sub.getString("server");
                    if (subName == null || !subName.equals(serverName)) continue;
                    this.xmlConfig.configurationsAt("webSockets.webSocketserver");
                    existingConfig = sub;
                    break;
                }
            }
            finally {
                this.configLock.readLock().unlock();
            }
        }
        return existingConfig;
    }
}

