/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARSetGetEntryException;
import com.bmc.arsys.api.ActiveLink;
import com.bmc.arsys.api.ActiveLinkAction;
import com.bmc.arsys.api.AlertMessageInfo;
import com.bmc.arsys.api.ArchiveInfo;
import com.bmc.arsys.api.ArithOpAssignInfo;
import com.bmc.arsys.api.ArithmeticOperationInfo;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.AssignFieldInfo;
import com.bmc.arsys.api.AssignInfo;
import com.bmc.arsys.api.AssignSQLInfo;
import com.bmc.arsys.api.Association;
import com.bmc.arsys.api.AssociationSelectionType;
import com.bmc.arsys.api.AssociationTag;
import com.bmc.arsys.api.AssociationsToFollow;
import com.bmc.arsys.api.AttachmentFieldLimit;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.AuditInfo;
import com.bmc.arsys.api.BulkEntryReturn;
import com.bmc.arsys.api.ByteListValue;
import com.bmc.arsys.api.COMMethodInfo;
import com.bmc.arsys.api.COMMethodParmInfo;
import com.bmc.arsys.api.COMValueInfo;
import com.bmc.arsys.api.CallGuideAction;
import com.bmc.arsys.api.ChangeFieldAction;
import com.bmc.arsys.api.CharacterFieldLimit;
import com.bmc.arsys.api.CloseWindowAction;
import com.bmc.arsys.api.ColumnFieldLimit;
import com.bmc.arsys.api.Container;
import com.bmc.arsys.api.ContainerOwner;
import com.bmc.arsys.api.ContainerType;
import com.bmc.arsys.api.CoordinateInfo;
import com.bmc.arsys.api.CurrencyDetail;
import com.bmc.arsys.api.CurrencyFieldLimit;
import com.bmc.arsys.api.CurrencyPartInfo;
import com.bmc.arsys.api.CurrencyValue;
import com.bmc.arsys.api.DDEAction;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DayInfo;
import com.bmc.arsys.api.DecimalFieldLimit;
import com.bmc.arsys.api.DiaryFieldLimit;
import com.bmc.arsys.api.DiaryItem;
import com.bmc.arsys.api.DiaryListValue;
import com.bmc.arsys.api.DirectAssociation;
import com.bmc.arsys.api.DirectSqlAction;
import com.bmc.arsys.api.DisplayFieldLimit;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryKey;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.EntryListInfo;
import com.bmc.arsys.api.EntryPointInfo;
import com.bmc.arsys.api.EntryReturn;
import com.bmc.arsys.api.EnumItem;
import com.bmc.arsys.api.Escalation;
import com.bmc.arsys.api.EscalationInterval;
import com.bmc.arsys.api.EscalationTime;
import com.bmc.arsys.api.EscalationTimeCriteria;
import com.bmc.arsys.api.ExitGuideAction;
import com.bmc.arsys.api.ExtFieldCandidatesInfo;
import com.bmc.arsys.api.ExtFormCandidatesInfo;
import com.bmc.arsys.api.ExternalReference;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.FieldAssignInfo;
import com.bmc.arsys.api.FieldKey;
import com.bmc.arsys.api.FieldLimit;
import com.bmc.arsys.api.FieldMapping;
import com.bmc.arsys.api.FileMenu;
import com.bmc.arsys.api.Filter;
import com.bmc.arsys.api.FilterAction;
import com.bmc.arsys.api.FilterMessageAction;
import com.bmc.arsys.api.Form;
import com.bmc.arsys.api.FormAliasInfo;
import com.bmc.arsys.api.FuncCurrencyInfo;
import com.bmc.arsys.api.FunctionAssignInfo;
import com.bmc.arsys.api.GotoAction;
import com.bmc.arsys.api.GotoGuideLabelAction;
import com.bmc.arsys.api.GroupInfo;
import com.bmc.arsys.api.IQuerySource;
import com.bmc.arsys.api.Image;
import com.bmc.arsys.api.IndexInfo;
import com.bmc.arsys.api.IndirectAssociation;
import com.bmc.arsys.api.IntegerFieldLimit;
import com.bmc.arsys.api.JoinFieldMapping;
import com.bmc.arsys.api.JoinForm;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.api.LicenseInfo;
import com.bmc.arsys.api.LicenseValidInfo;
import com.bmc.arsys.api.ListMenu;
import com.bmc.arsys.api.LogAction;
import com.bmc.arsys.api.MacroParmInfo;
import com.bmc.arsys.api.Menu;
import com.bmc.arsys.api.MenuItem;
import com.bmc.arsys.api.MessageAction;
import com.bmc.arsys.api.NotifyAction;
import com.bmc.arsys.api.ObjectOperationTimes;
import com.bmc.arsys.api.ObjectPropertyMap;
import com.bmc.arsys.api.OleAutomationAction;
import com.bmc.arsys.api.OpenWindowAction;
import com.bmc.arsys.api.OperandType;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.OverlayPropInfo;
import com.bmc.arsys.api.PKFKMapping;
import com.bmc.arsys.api.PermissionInfo;
import com.bmc.arsys.api.ProcessResult;
import com.bmc.arsys.api.PropInfo;
import com.bmc.arsys.api.PropertyMap;
import com.bmc.arsys.api.PushFieldsAction;
import com.bmc.arsys.api.PushFieldsInfo;
import com.bmc.arsys.api.QualifierFromFieldInfo;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.QueryInfo;
import com.bmc.arsys.api.QueryMenu;
import com.bmc.arsys.api.RealFieldLimit;
import com.bmc.arsys.api.Reference;
import com.bmc.arsys.api.ReferenceType;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.RoleInfo;
import com.bmc.arsys.api.RunMacroAction;
import com.bmc.arsys.api.RunProcessAction;
import com.bmc.arsys.api.SQLResult;
import com.bmc.arsys.api.SelectionFieldLimit;
import com.bmc.arsys.api.ServerInfo;
import com.bmc.arsys.api.SetFieldsAction;
import com.bmc.arsys.api.SetFieldsFromCurrentScreen;
import com.bmc.arsys.api.SetFieldsFromCurrentTransaction;
import com.bmc.arsys.api.SetFieldsFromFilterAPI;
import com.bmc.arsys.api.SetFieldsFromForm;
import com.bmc.arsys.api.SetFieldsFromSQL;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.SqlMenu;
import com.bmc.arsys.api.StatisticsResultInfo;
import com.bmc.arsys.api.StatusHistoryItem;
import com.bmc.arsys.api.StatusHistoryValue;
import com.bmc.arsys.api.StatusHistoryValueIndicator;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.SupportFile;
import com.bmc.arsys.api.SupportFileKey;
import com.bmc.arsys.api.TableFieldLimit;
import com.bmc.arsys.api.Time;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.UserInfo;
import com.bmc.arsys.api.UserLicenseInfo;
import com.bmc.arsys.api.ValidateFormCacheInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.VendorFieldMapping;
import com.bmc.arsys.api.VendorForm;
import com.bmc.arsys.api.View;
import com.bmc.arsys.api.ViewFieldLimit;
import com.bmc.arsys.api.ViewFieldMapping;
import com.bmc.arsys.api.ViewForm;
import com.bmc.arsys.api.WaitAction;
import com.bmc.arsys.api.WfdBreakpoint;
import com.bmc.arsys.api.WfdDebugLocation;
import com.bmc.arsys.api.WfdUserContext;
import com.bmc.arsys.api.XMLEntryReturn;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class ObjectPrinter {
    static String tab = "    ";

    public abstract void printResult(String var1);

    public void printResultHeader(String functionName) {
        this.printResult("\n\t" + functionName + " results\n");
    }

    public void printBoolean(String indent, String header, boolean val, String newLine) {
        if (val) {
            this.printResult(indent + header + "  TRUE" + newLine);
        } else {
            this.printResult(indent + header + "  FALSE" + newLine);
        }
    }

    public void printLong(long value) {
        this.printResult("" + value);
    }

    public void printString(String prompt) {
        StringTokenizer tokens = new StringTokenizer(prompt, "\r\n\f", true);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            this.printResult(token);
        }
    }

    public void printStringWithoutNewLine(String prompt) {
        StringTokenizer tokens = new StringTokenizer(prompt, "\r\n\f", false);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            this.printResult(token);
        }
    }

    public void printARException(ARException e) {
        List<StatusInfo> statusList = e.getLastStatus();
        if (statusList != null) {
            this.printStatusInfoList("", "   Results", statusList);
            return;
        }
        String message = e.toString();
        if (message != null && message.length() > 0) {
            this.printResult(message);
        } else {
            this.printResult("No Error Message...");
        }
        this.printNewLine();
    }

    public void printByte(byte value) {
        this.printResult("" + value);
    }

    public void printFloat(float value) {
        this.printResult("" + value);
    }

    public void printNewLine() {
        this.printResult("\n");
    }

    public void printHeader(String indent, String header, String newLine) {
        if (header == null) {
            return;
        }
        this.printResult(indent + header + newLine);
    }

    public void printInt(String indent, String header, int value, String newLine) {
        this.printResult(indent + header + value + newLine);
    }

    public void printFloat(String indent, String header, float value, String newLine) {
        if (newLine != null) {
            this.printResult(indent + header + value + "\n");
        } else {
            this.printResult(indent + header + value);
        }
    }

    public void printByte(String indent, String header, byte value, String newLine) {
        if (newLine != null) {
            this.printResult(indent + header + value + "\n");
        } else {
            this.printResult(indent + header + value);
        }
    }

    public void printLong(String indent, String header, long value, String newLine) {
        if (newLine != null) {
            this.printResult(indent + header + value + "\n");
        } else {
            this.printResult(indent + header + value);
        }
    }

    public void printULong(String indent, String header, String value, String newLine) {
        if (newLine != null) {
            this.printResult(indent + header + value + "\n");
        } else {
            this.printResult(indent + header + value);
        }
    }

    public void printDecimal(String indent, String header, BigDecimal value) {
        this.printResult(indent + header + "\n");
        if (value == null) {
            this.printResult(" Null Decimal value....");
        } else {
            this.printResult(value.toString());
        }
        this.printNewLine();
    }

    public void printInteger(String indent, String header, Integer value) {
        this.printString(indent + header);
        if (value == null) {
            this.printString(" Null Integer value....");
            return;
        }
        this.printString("" + value);
        this.printNewLine();
    }

    public void printInteger(String indent, String header, OutputInteger value) {
        this.printString(indent + header);
        if (value == null) {
            this.printString(" Null Integer value....");
            return;
        }
        this.printString("" + value.intValue());
        this.printNewLine();
    }

    public void printDouble(String indent, String header, Double value) {
        this.printString(indent + header);
        if (value == null) {
            this.printString(" Null Double value....");
            return;
        }
        this.printString(value.toString());
        this.printNewLine();
    }

    public void printEnum(String indent, String header, Integer value) {
        this.printStringWithoutNewLine(indent + header);
        if (value == null) {
            this.printString(" Null Enum value...");
            return;
        }
        this.printString(value.toString());
        this.printNewLine();
    }

    public void printString(String indent, String header, String value, String newLine) {
        if (value == null) {
            value = "  <NULL> ";
        }
        this.printString(indent + header + value);
        this.printNewLine();
    }

    public void printTimeOfDay(String indent, String header, Time value) {
        this.printHeader(indent, header, "\n");
        if (value != null) {
            this.printLong(indent, "Value: ", value.getValue(), "\n");
        } else {
            this.printHeader(indent, "    Null TimeOfDay value", "\n");
        }
    }

    public void printTimestamp(String indent, String header, Timestamp value) {
        this.printHeader(indent, header, "\n");
        if (value != null) {
            this.printLong(indent, "Value: ", value.getValue(), "\n");
        } else {
            this.printHeader(indent, "    Null TimeStamp value", "\n");
        }
    }

    public void printTimestampList(String indent, String header, Timestamp[] value) {
    }

    public void printFieldKeyList(String indent, String header, FieldKey[] keyList) {
        this.printHeader(indent, header, "\n");
        if (keyList == null) {
            return;
        }
        this.printInt(indent + tab, "Number of FieldKeys: ", keyList.length, "\n");
        for (int i = 0; i < keyList.length; ++i) {
            this.printString(indent + tab, "Form Name: ", keyList[i].getFormName(), "\n");
            this.printInt(indent + tab, "Field ID: ", keyList[i].getFieldID(), "\n");
        }
        this.printNewLine();
    }

    public void printEntryIdList(String indent, String header, String[] value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Number of values: ", value.length, "\n");
        for (int i = 0; i < value.length; ++i) {
            this.printString(indent + tab, "Entry ID: ", value[i], "\n");
        }
        this.printNewLine();
    }

    public void printEntry(String indent, String header, Entry entry) {
        this.printHeader(indent, header, "\n");
        if (entry == null) {
            this.printHeader(indent + tab, " Entry does not exist....", "\n");
            return;
        }
        this.print(indent + tab, "(Field Id, Value): ", entry);
        this.printNewLine();
    }

    public void printObjectOperationTimes(String indent, String header, Map<Integer, ObjectOperationTimes> opTimes) {
        this.printHeader(indent, header, "\n");
        if (opTimes == null) {
            this.printHeader(indent + tab, " OperationTimes is null....", "\n");
            return;
        }
        this.printInt(indent + tab, "Number of objects: ", opTimes.size(), "\n");
        for (Map.Entry<Integer, ObjectOperationTimes> e : opTimes.entrySet()) {
            Integer key = e.getKey();
            ObjectOperationTimes times = e.getValue();
            this.printString("Object: " + this.getObjectType(key) + "\tLast Create " + times.getCreateTime().toString() + "\tLast Change " + times.getChangeTime().toString() + "\tLast Delete " + times.getDeleteTime().toString());
            this.printNewLine();
        }
    }

    public void printImage(String indent, String header, Image image) {
        this.printHeader(indent, header, "\n");
        if (image == null) {
            this.printHeader(indent + tab, "Null Image...", "\n");
            return;
        }
        if (image.getName() != null) {
            this.printString(indent + tab, "Name: ", image.getName(), "\n");
        } else {
            this.printString(indent + tab + "Name: <null>\n");
        }
        if (image.getImageData() != null) {
            this.printInt(indent + tab, "Size: ", image.getImageData().getSize(), "\n");
        } else {
            this.printString(indent + tab + "Size: <null>\n");
        }
        if (image.getType() != null) {
            this.printString(indent + tab, "Type: ", image.getType(), "\n");
        } else {
            this.printString(indent + tab + "Type: <null>\n");
        }
        if (image.getCheckSum() != null) {
            this.printString(indent + tab, "CheckSum: ", image.getCheckSum(), "\n");
        } else {
            this.printString(indent + tab + "CheckSum: <null>\n");
        }
        if (image.getDescription() != null) {
            this.printString(indent + tab, "Description: ", image.getDescription(), "\n");
        } else {
            this.printString(indent + tab + "Description: <null>\n");
        }
        if (image.getHelpText() != null) {
            this.printString(indent + tab, "Help Text: ", image.getHelpText(), "\n");
        } else {
            this.printString(indent + tab + "HelpText: <null>\n");
        }
        if (image.getLastUpdateTime() != null) {
            this.printString(indent + tab + "Last Update Time:" + image.getLastUpdateTime().getValue());
            this.printNewLine();
        } else {
            this.printString(indent + tab + "Last Update Time: <null>\n");
        }
        if (image.getOwner() != null) {
            this.printString(indent + tab, "Owner: ", image.getOwner(), "\n");
        } else {
            this.printString(indent + tab + "Owner: null\n");
        }
        if (image.getLastChangedBy() != null) {
            this.printString(indent + tab + "Last Changed: ", image.getLastChangedBy(), "\n");
        } else {
            this.printString(indent + tab + "Last Changed: <null>\n");
        }
        if (image.getDiary() != null) {
            this.printDiaryList(indent + tab, "Change DiaryList: ", image.getDiary());
        } else {
            this.printString(indent + tab + "Change DiaryList: <null>\n");
        }
        this.printPropertyMap(indent + tab, "Properties List: ", image.getProperties());
        this.printNewLine();
    }

    public void printImageList(String indent, String header, List<String> imageList) {
        this.printHeader(indent, header, "\n");
        if (imageList == null) {
            this.printHeader(indent + tab, "Null Image list..", "\n");
            return;
        }
        this.printInt(indent + tab, "Number of Images: ", imageList.size(), "\n");
        for (int i = 0; i < imageList.size(); ++i) {
            this.printString(indent + tab, "Image Name " + i + " :", imageList.get(i));
        }
        this.printNewLine();
    }

    public void printIntList(String indent, String header, int[] value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Number of values: ", value.length, "\n");
        for (int i = 0; i < value.length; ++i) {
            this.printInt(indent + tab, "Value: ", value[i], "\n");
        }
        this.printNewLine();
    }

    public void printIntList(String indent, String header, List<Integer> value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Number of values: ", value.size(), "\n");
        for (int i = 0; i < value.size(); ++i) {
            this.printInt(indent + tab, "Value: ", value.get(i), "\n");
        }
        this.printNewLine();
    }

    public void printStatusInfo(String indent, String header, StatusInfo value) {
        this.printHeader(indent, header, "\n");
        this.printHeader(indent + tab, "Message type : ", "");
        int messageType = value.getMessageType();
        this.printReturnCodeInfo(messageType);
        this.printLong(indent + tab, "Message number : ", value.getMessageNum(), "\n");
        this.printString(indent + tab, "Message:  ", value.getMessageText(), "\n");
        this.printString(indent + tab, "Appended: ", value.getAppendedText(), "\n");
    }

    private void printReturnCodeInfo(int messageType) {
        switch (messageType) {
            case 0: {
                this.printHeader("", "NOTE", "\n");
                break;
            }
            case 1: {
                this.printHeader("", "WARNING", "\n");
                break;
            }
            case 2: {
                this.printHeader("", "ERROR", "\n");
                break;
            }
            case 3: {
                this.printHeader("", "FATAL", "\n");
                break;
            }
            case 5: {
                this.printHeader("", "PROMPT", "\n");
                break;
            }
            case 6: {
                this.printHeader("", "ACCESSIBLE", "\n");
                break;
            }
            case 7: {
                this.printHeader("", "TOOLTIP", "\n");
                break;
            }
            default: {
                this.printInt("", "<Unknown Type>: ", messageType, "\n");
            }
        }
    }

    public void printStatusInfoList(String indent, String header, StatusInfo[] value) {
        this.printHeader(indent, header, "\n");
        if (value == null || value.length == 0) {
            this.printHeader(indent, "ReturnCode:  OK", "\n");
            this.printHeader(indent, "Status List : 0 items", "\n");
            return;
        }
        int messageType = value[0].getMessageType();
        this.printHeader(indent, "ReturnCode:  ", "");
        this.printReturnCodeInfo(messageType);
        this.printHeader(indent, "Status List : " + value.length + " items", "\n");
        for (int i = 0; i < value.length; ++i) {
            this.printStatusInfo(indent, "Status Struct :", value[i]);
        }
        this.printNewLine();
    }

    public void printStatusInfoList(String indent, String header, List<StatusInfo> value) {
        if (value != null) {
            this.printStatusInfoList(indent, header, value.toArray(new StatusInfo[0]));
        }
    }

    public void printMultiStatusInfoList(String indent, String header, List<List<StatusInfo>> value) {
        this.printHeader(indent, header, "\n");
        if (value == null || value.size() == 0 || value.get(0).size() == 0) {
            this.printHeader(indent, "ReturnCode:  OK", "\n");
            this.printHeader(indent, "Status List : 0 items", "\n");
            return;
        }
        int messageType = value.get(0).get(0).getMessageType();
        this.printHeader(indent, "ReturnCode:  ", "");
        this.printReturnCodeInfo(messageType);
        this.printHeader(indent, "Status List : " + value.size() + " items", "\n");
        for (int i = 0; i < value.size(); ++i) {
            List<StatusInfo> currInfo = value.get(i);
            for (int j = 0; j < currInfo.size(); ++j) {
                this.printStatusInfo(indent, "Status Struct :", currInfo.get(j));
            }
        }
        this.printNewLine();
    }

    public void printByteListInfo(String indent, String header, ByteListValue value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        byte[] byteList = value.getValue();
        if (byteList == null) {
            this.printHeader(indent + tab, "Null byte list..", "\n");
            return;
        }
        switch (value.getType()) {
            case 1: {
                this.printString(indent + tab + "Type - WIN30_BITMAP");
                break;
            }
            case 2: {
                this.printString(indent + tab + "Type - JPEG");
                break;
            }
            case 3: {
                this.printString(indent + tab + "Type - TIFF");
                break;
            }
            case 4: {
                this.printString(indent + tab + "Type - TARGA");
                break;
            }
            case 9: {
                this.printString(indent + tab + "Type - GIF");
                break;
            }
            case 10: {
                this.printString(indent + tab + "Type - PNG");
                break;
            }
            default: {
                this.printString(indent + tab + "Type - < unknown" + value.getType() + "  >");
            }
        }
        this.printInt(indent + tab, "Number of values: ", byteList.length, "\n");
        for (int i = 0; i < byteList.length; ++i) {
            if (i % 20 == 0) {
                if (i != 0) {
                    this.printNewLine();
                }
                this.printHeader(indent, tab, "");
            }
            String hexaString = this.convertToHexadecimalString(byteList[i]);
            this.printStringWithoutNewLine(hexaString);
        }
        this.printNewLine();
    }

    public void printCoordinateInfoList(String indent, String header, CoordinateInfo[] value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Number of values: ", value.length, "\n");
        for (int i = 0; i < value.length; ++i) {
            this.printString(indent + tab + tab, "x: " + value[i].getXCoordinate(), ",  y:" + value[i].getYCoordinate(), "\n");
        }
        this.printNewLine();
    }

    public void printAttachmentInfo(String indent, String header, AttachmentValue value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent, " Null AttachementInfo....", "\n");
            return;
        }
        if (value.getName() != null) {
            this.printHeader(indent, "Name            : " + value.getName(), "\n");
        } else {
            this.printHeader(indent, "Name: <null>", "\n");
        }
        this.printLong(indent, "Original size   : ", value.getOriginalSize(), "\n");
        this.printLong(indent, "Compressed size : ", value.getCompressedSize(), "\n");
        this.printNewLine();
    }

    public void printCurrencyInfo(String indent, String header, CurrencyValue value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent, " Null CurrencyInfo....", "\n");
            return;
        }
        if (value.getValue() == null) {
            this.printString(indent, "Value          : ", "<null>", "\n");
        } else {
            this.printString(indent, "Value          : ", value.getValueString(), "\n");
        }
        this.printString(indent, "Currency Code  : ", value.getCurrencyCode(), "\n");
        this.printLong(indent, "Conversion Date: ", value.getConversionDate().getValue(), "\n");
        List<FuncCurrencyInfo> functional = value.getFuncCurrencyList();
        int funcListCount = functional == null ? 0 : functional.size();
        this.printHeader(indent, "Functional Currency List: " + funcListCount + " items", "\n");
        for (int i = 0; i < funcListCount; ++i) {
            this.printHeader(indent, "Functional Currency Item " + i + " :", "\n");
            if (functional.get(i).getValue() == null) {
                this.printString(indent + tab, "  Value        : ", "<null>", "\n");
            } else {
                this.printString(indent + tab, "  Value        : ", functional.get(i).getValueString(), "\n");
            }
            this.printString(indent + tab, "  Currency Code: ", functional.get(i).getCurrencyCode(), "\n");
        }
        this.printNewLine();
    }

    public void printDataType(String indent, String header, DataType value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        switch (value.toInt()) {
            case 1: {
                this.printHeader(indent + tab, "KEYWORD", "\n");
                break;
            }
            case 2: {
                this.printHeader(indent + tab, "INTEGER", "\n");
                break;
            }
            case 3: {
                this.printHeader(indent + tab, "REAL", "\n");
                break;
            }
            case 4: {
                this.printHeader(indent + tab, "CHAR", "\n");
                break;
            }
            case 5: {
                this.printHeader(indent + tab, "DIARY", "\n");
                break;
            }
            case 6: {
                this.printHeader(indent + tab, "ENUM", "\n");
                break;
            }
            case 7: {
                this.printHeader(indent + tab, "TIME", "\n");
                break;
            }
            case 8: {
                this.printHeader(indent + tab, "BITMASK", "\n");
                break;
            }
            case 9: {
                this.printHeader(indent + tab, "BYTES", "\n");
                break;
            }
            case 10: {
                this.printHeader(indent + tab, "DECIMAL", "\n");
                break;
            }
            case 11: {
                this.printHeader(indent + tab, "ATTACHMENT", "\n");
                break;
            }
            case 12: {
                this.printHeader(indent + tab, "CURRENCY", "\n");
                break;
            }
            case 30: {
                this.printHeader(indent + tab, "JOIN", "\n");
                break;
            }
            case 31: {
                this.printHeader(indent + tab, "TRIM", "\n");
                break;
            }
            case 32: {
                this.printHeader(indent + tab, "CONTROL", "\n");
                break;
            }
            case 33: {
                this.printHeader(indent + tab, "TABLE", "\n");
                break;
            }
            case 34: {
                this.printHeader(indent + tab, "COLUMN", "\n");
                break;
            }
            case 35: {
                this.printHeader(indent + tab, "PAGE", "\n");
                break;
            }
            case 36: {
                this.printHeader(indent + tab, "PAGE_HOLDER", "\n");
                break;
            }
            case 40: {
                this.printHeader(indent + tab, "ULONG", "\n");
                break;
            }
            case 41: {
                this.printHeader(indent + tab, "COORDS", "\n");
                break;
            }
            default: {
                this.printInt(indent + tab, "UnKnown Type: ", value.toInt(), "\n");
            }
        }
        this.printNewLine();
    }

    public void printKeyword(String indent, String header, Keyword value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Value: ", value.toInt(), "\n");
        this.printNewLine();
    }

    public void printBitMask(String indent, String header, Long value) {
        this.printStringWithoutNewLine(indent + header);
        if (value == null) {
            this.printString(" Null BitMask value....");
            return;
        }
        this.printString(value.toString());
        this.printNewLine();
    }

    public void printDiaryList(String indent, String header, DiaryListValue value) {
        this.printString(indent + header);
        if (value == null) {
            this.printString(" Null DiaryList value...");
            return;
        }
        int i = 0;
        for (DiaryItem di : value) {
            this.printHeader(indent, "DiaryList Item " + i + " :", "\n");
            if (di.getUser() != null) {
                this.printString(indent + tab, "User: ", di.getUser(), "\n");
            } else {
                this.printString(indent + tab, "Null User Name ID", "  ", "\n");
            }
            this.printTimestamp(indent + tab, "Time stamp: ", di.getTimestamp());
            this.printString(indent + tab, "DiaryList String: ", di.getText(), "\n");
            this.printNewLine();
        }
        this.printNewLine();
    }

    public void printValue(String indent, String header, Value value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        DataType type = value.getDataType();
        if (type == null) {
            this.printString(indent + tab, "getDataType method returns null value", " ", "\n");
            return;
        }
        switch (type.toInt()) {
            case 1: {
                this.printKeyword(indent + tab, "Type : KEYWORD - ", (Keyword)value.getValue());
                break;
            }
            case 2: {
                this.printInt(indent + tab, "Type : INTEGER - ", (Integer)value.getValue(), "\n");
                break;
            }
            case 3: {
                this.printString(indent + tab + "Type: REAL - " + ((Double)value.getValue()).toString());
                break;
            }
            case 4: {
                this.printString(indent + tab, "Type: CHAR - ", (String)value.getValue(), "\n");
                break;
            }
            case 5: {
                this.printString(indent + tab, "Type: DIARY - ", "   ", "\n");
                if (value.getValue() == null) {
                    this.printString(" Null DiaryList value...");
                    break;
                }
                if (value.getValue() instanceof DiaryListValue) {
                    this.printDiaryList(indent + tab, "Type: DIARY - ", (DiaryListValue)value.getValue());
                    break;
                }
                this.printString(indent + tab, "Type: DIARY - ", (String)value.getValue());
                break;
            }
            case 6: {
                this.printEnum(indent + tab, "Type: ENUM - ", (Integer)value.getValue());
                break;
            }
            case 7: {
                this.printTimestamp(indent + tab, "Type: TIME - ", (Timestamp)value.getValue());
                break;
            }
            case 8: {
                this.printBitMask(indent + tab, "Type: BITMASK - ", (Long)value.getValue());
                break;
            }
            case 9: {
                this.printByteListInfo(indent + tab, "Type: BYTES - ", (ByteListValue)value.getValue());
                break;
            }
            case 10: {
                this.printDecimal(indent + tab, "Type: DECIMAL - ", (BigDecimal)value.getValue());
                break;
            }
            case 11: {
                this.printAttachmentInfo(indent + tab, "Type: ATTACHMENT - ", (AttachmentValue)value.getValue());
                break;
            }
            case 12: {
                this.printCurrencyInfo(indent + tab, "Type: CURRENCY - ", (CurrencyValue)value.getValue());
                break;
            }
            case 13: {
                this.printString(indent + tab, "Type: DATE - ", value.toString(), "\n");
                break;
            }
            case 14: {
                this.printString(indent + tab, "Type: TIME - ", value.toString(), "\n");
                break;
            }
            case 30: {
                this.printString(indent + tab, "Type: JOIN - ", "", "\n");
                break;
            }
            case 31: {
                this.printString(indent + tab, "Type : TRIM - ", " ", "\n");
                break;
            }
            case 32: {
                this.printString(indent + tab, "Type: CONTROL - ", " ", "\n");
                break;
            }
            case 33: {
                this.printString(indent + tab, "Type: TABLE - ", " ", "\n");
                break;
            }
            case 34: {
                this.printString(indent + tab, "Type: COLUMN - ", " ", "\n");
                break;
            }
            case 35: {
                this.printString(indent + tab, "Type: PAGE - ", " ", "\n");
                break;
            }
            case 36: {
                this.printString(indent + tab, "Type: PAGE_HOLDER - ", " ", "\n");
                break;
            }
            case 40: {
                this.printLong(indent + tab, "Type: ULONG - ", (Long)value.getValue(), "\n");
                break;
            }
            case 41: {
                this.print(indent + tab, "Type: COORDS - ", value.getValue());
                break;
            }
            case 42: {
                this.printString(indent + tab, "Type: VIEW - ", (String)value.getValue(), "\n");
                break;
            }
            case 43: {
                this.printString(indent + tab, "Type: DISPLAY - ", (String)value.getValue(), "\n");
                break;
            }
            default: {
                this.printInt(indent + tab, "Type : Undefined(", type.toInt(), ") : " + (value != null ? value.toString() : "(null)") + "\n");
            }
        }
    }

    public void printValueList(String indent, String header, List<Value> valList) {
        this.printHeader(indent, header, "\n");
        if (valList == null) {
            return;
        }
        this.printInt(indent + tab, "Number of values: ", valList.size(), "\n");
        for (int i = 0; i < valList.size(); ++i) {
            this.printValue(indent, "Value: ", valList.get(i));
        }
        this.printNewLine();
    }

    public void printIndexInfo(String indent, String header, IndexInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + "     ", " Null IndexInfo....", "\n");
            return;
        }
        if (value.getIndexName() != null) {
            this.printString(indent + tab, "Name : ", value.getIndexName(), "\n");
        } else {
            this.printString(indent + tab, "Name : ", "<null String>", "\n");
        }
        this.printBoolean(indent + tab, "Unique: ", value.isUnique(), "\n");
        this.printIntList(indent + tab, "Index Field List: ", value.getIndexFields());
        this.printNewLine();
    }

    public void printIndexInfoList(String indent, String header, List<IndexInfo> value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + tab, "Null Index Info List", "\n");
            return;
        }
        this.printInt(indent + tab, "Number of values: ", value.size(), "\n");
        for (int i = 0; i < value.size(); ++i) {
            this.printIndexInfo(indent + tab, "", value.get(i));
        }
        this.printNewLine();
    }

    public void printArchiveInfo(String indent, String header, ArchiveInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + "     ", " Null ArchiveInfo....", "\n");
            return;
        }
        this.printBoolean(indent + tab, "Enable: ", value.isEnable(), "\n");
        this.printString(indent + tab, "Description: ", value.getDescription(), "\n");
        this.printInt(indent + tab, "ArchiveType: ", value.getArchiveType(), "\n");
        if (value.getArchiveType() == 1 || value.getArchiveType() == 3) {
            this.printString(indent + tab, " Archive Dest: ", value.getArchiveDest(), "\n");
        }
        this.printQualifierInfo(indent + tab, "Qualifier Info: ", value.getQualifier());
        this.printEscalationTime(indent + tab, "Archive Date: ", value.getArchiveTmInfo());
        this.printBoolean(indent + tab, "Appear In Archive Policy If Unscheduled: ", value.isAppearInArchivePolicy(), "\n");
        if (value.getArchiveFrom() != null) {
            this.printString(indent + tab, " Archive From: ", value.getArchiveFrom(), "\n");
        } else {
            this.printHeader(indent + tab, " Archive From: null", "\n");
        }
    }

    public void printAuditInfo(String indent, String header, AuditInfo value) {
        this.printHeader(indent, header, "\n");
        if (value != null) {
            this.printBoolean(indent + tab, "Enable: ", value.isEnable(), "\n");
            this.printInt(indent + tab, "Style: ", value.getAuditStyle(), "\n");
            if (value.getAuditFrom() != null) {
                this.printString(indent + tab, "Audit From: ", value.getAuditFrom(), "\n");
            } else {
                this.printHeader(indent + tab, "Audit From: null", "\n");
            }
        }
    }

    public void printEntryListFieldInfo(String indent, String header, EntryListFieldInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + "     ", " Null EntryListFieldInfo....", "\n");
            return;
        }
        this.printInt(indent + tab, "Field Id : ", value.getFieldId(), "\n");
        this.printInt(indent + tab, "Column Width: ", value.getColumnWidth(), "\n");
        this.printString(indent + tab, "Separator: ", value.getSeparator(), "\n");
        this.printNewLine();
    }

    public void printEntryListFieldInfoList(String indent, String header, List<EntryListFieldInfo> value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Number of values: ", value.size(), "\n");
        for (int i = 0; i < value.size(); ++i) {
            this.printEntryListFieldInfo(indent, "EntryListFieldInfo: ", value.get(i));
        }
        this.printNewLine();
    }

    public void printSortInfo(String indent, String header, SortInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + "     ", " Null SortInfo....", "\n");
            return;
        }
        this.printInt(indent + tab, "Field Id :", value.getFieldID(), "\n");
        switch (value.getSortOrder()) {
            case 1: {
                this.printHeader(indent + tab, "Sort Order: ASCENDING", "\n");
                break;
            }
            case 2: {
                this.printHeader(indent + tab, "Sort Order: DESCENDING", "\n");
                break;
            }
            default: {
                this.printInt(indent + tab, "Sort Order: undefined  value = ", value.getSortOrder(), "\n");
            }
        }
        this.printNewLine();
    }

    public void printEntryListInfo(String indent, String header, EntryListInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + "     ", " Null EntryListInfo....", "\n");
            return;
        }
        this.printString(indent + tab, "Entry Id : ", value.getEntryID(), "\n");
        this.printString(indent + tab, "Short Description :", value.getDescription(), "\n");
        this.printNewLine();
    }

    public void printEntryListInfoList(String indent, String header, EntryListInfo[] value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Number of values: ", value.length, "\n");
        for (int i = 0; i < value.length; ++i) {
            this.printEntryListInfo(indent, "EntryListInfo " + i + " : ", value[i]);
        }
        this.printNewLine();
    }

    public void printArithOpAssignInfo(String indent, String header, ArithOpAssignInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        switch (value.getOperation()) {
            case 1: {
                this.printHeader(indent + tab, "Operation: ADD", "\n");
                break;
            }
            case 2: {
                this.printHeader(indent + tab, "Operation: SUBTRACT", "\n");
                break;
            }
            case 3: {
                this.printHeader(indent + tab, "Operation: MULTIPLY", "\n");
                break;
            }
            case 4: {
                this.printHeader(indent + tab, "Operation: DIVIDE", "\n");
                break;
            }
            case 5: {
                this.printHeader(indent + tab, "Operation: MODULO", "\n");
                break;
            }
            case 6: {
                this.printHeader(indent + tab, "Operation: NEGATE (unary minus)", "\n");
                break;
            }
            default: {
                this.printLong(indent + tab, " Operation: Undefined -  ", value.getOperation(), "\n");
            }
        }
        this.printAssignInfo(indent + tab, "LeftOperand :", value.getOperandLeft());
        this.printAssignInfo(indent + tab, "RightOperand :", value.getOperandRight());
        this.printNewLine();
    }

    public void printArithmeticOperationInfo(String indent, String header, ArithmeticOperationInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        int operation = value.getOperation();
        this.printInt(indent + tab, "Operation: ", operation, "\n");
        this.printArithmeticOrRelationalOperand(indent + tab, "Left Operand: ", value.getLeftOperand());
        this.printArithmeticOrRelationalOperand(indent + tab, "Right Operand: ", value.getRightOperand());
        this.printNewLine();
    }

    public void printQueryInfo(String indent, String header, QueryInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "FieldID: ", value.getFieldID(), "\n");
        this.printLong(indent + tab, "Match Mode: ", value.getMatchMode(), "\n");
        this.printString(indent + tab, "Form ID: ", value.getFormID(), "\n");
        this.printString(indent + tab, "Server Name: ", value.getServerName(), "\n");
        this.printQualifierInfo(indent + tab, "Qualifier Info: ", value.getQualifierInfo());
    }

    public void printArithmeticOrRelationalOperand(String indent, String header, ArithmeticOrRelationalOperand value) {
        if (value == null) {
            return;
        }
        OperandType opType = value.getType();
        int operation = opType.toInt();
        Object objVal = value.getValue();
        if (OperandType.FIELDID.equals(opType)) {
            this.printHeader(indent + tab, "Type: FIELDID", "\n");
            int fieldId = (Integer)objVal;
            this.printInt(indent + tab, "FieldId : ", fieldId, "\n");
        } else if (OperandType.VALUE.equals(opType)) {
            this.printHeader(indent + tab, "Type: VALUE", "\n");
            Value val = (Value)objVal;
            this.printValue(indent + tab, "Value: ", val);
        } else if (OperandType.ARITHMETIC_OP.equals(opType)) {
            this.printHeader(indent + tab, "Type: ARITHMETIC_OP", "\n");
            ArithmeticOperationInfo arInfo = (ArithmeticOperationInfo)objVal;
            this.printArithmeticOperationInfo(indent + tab, "ArithmeticOperationInfo: ", arInfo);
        } else if (OperandType.STATUS_HISTORY.equals(opType)) {
            this.printHeader(indent + tab, "Type: STATUS_HISTORY", "\n");
            StatusHistoryValueIndicator stHistoryVal = (StatusHistoryValueIndicator)objVal;
            this.printStatusHistoryValue(indent + tab, "StatusHistoryValue ", stHistoryVal);
        } else if (OperandType.VALUE_SET.equals(opType)) {
            this.printHeader(indent + tab, "Type: VALUE_SET", "\n");
            this.printValueList(indent + tab, "Value List: ", (List)value.getValue());
        } else if (OperandType.FIELDID_TRANSACTION.equals(opType)) {
            this.printHeader(indent + tab, "Type: FIELDID_TRANSACTION", "\n");
            int fieldIdTransaction = (Integer)objVal;
            this.printLong(indent + tab, "FieldId : ", fieldIdTransaction, "\n");
        } else if (OperandType.FIELDID_DB.equals(opType)) {
            this.printHeader(indent + tab, "Type: FIELDID_DB", "\n");
            int fieldIdDB = (Integer)objVal;
            this.printLong(indent + tab, "FieldId : ", fieldIdDB, "\n");
        } else if (OperandType.LOCAL_VARIABLE.equals(opType)) {
            this.printHeader(indent + tab, "Type: LOCAL_VARIABLE", "\n");
            Integer variable = (Integer)value.getValue();
            this.printHeader(indent + tab, "Local Variable Number: " + variable, "\n");
        } else if (OperandType.QUERY_INFO.equals(opType)) {
            this.printHeader(indent + tab, "Type: QUERY_INFO", "\n");
            QueryInfo qInfo = (QueryInfo)value.getValue();
            this.printQueryInfo(indent + tab, " QueryInfo: ", qInfo);
        } else if (OperandType.FIELDID_CURRENT.equals(opType)) {
            this.printHeader(indent + tab, "Type: FIELDID_CURRENT", "\n");
            int fieldIdCurrent = (Integer)objVal;
            this.printLong(indent + tab, "FieldId : ", fieldIdCurrent, "\n");
        } else if (OperandType.CURRENCY_FLD.equals(opType)) {
            this.printHeader(indent + tab, "Type: CURRENCY_FLD", "\n");
            CurrencyPartInfo currencyPart = (CurrencyPartInfo)objVal;
            this.printString(indent + tab, "Currency Part Info: ", currencyPart.toString(), "\n");
        } else if (OperandType.CURRENCY_FLD_TRAN.equals(opType)) {
            this.printHeader(indent + tab, "Type: CURRENCY_FLD_TRAN", "\n");
            CurrencyPartInfo currencyPart = (CurrencyPartInfo)objVal;
            this.printString(indent + tab, "Currency Part Info: ", currencyPart.toString(), "\n");
        } else if (OperandType.CURRENCY_FLD_DB.equals(opType)) {
            this.printHeader(indent + tab, "Type: CURRENCY_FLD_DB", "\n");
            CurrencyPartInfo currencyPart = (CurrencyPartInfo)objVal;
            this.printString(indent + tab, "Currency Part Info: ", currencyPart.toString(), "\n");
        } else if (OperandType.CURRENCY_FLD_CURRENT.equals(opType)) {
            this.printHeader(indent + tab, "Type: CURRENCY_FLD_CURRENT", "\n");
            CurrencyPartInfo currencyPart = (CurrencyPartInfo)objVal;
            this.printString(indent + tab, "Currency Part Info: ", currencyPart.toString(), "\n");
        } else {
            this.printInt(indent + tab, "Type : Invalid Operation - ", operation, "\n");
        }
    }

    public void printRelationalOperationInfo(String indent, String header, RelationalOperationInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Operation Code :", value.getOperation(), "\n");
        this.printArithmeticOrRelationalOperand(indent + tab, "Left Operand : ", value.getLeftOperand());
        this.printArithmeticOrRelationalOperand(indent + tab, "Right Operand : ", value.getRightOperand());
        this.printNewLine();
    }

    public void printQualifierOperationCode(String indent, String header, int operationCode) {
        switch (operationCode) {
            case 0: {
                this.printString(indent + tab + header + " : <Operation code none>");
                break;
            }
            case 1: {
                this.printString(indent + tab + header + " : < AND Operation (" + 1 + ") >");
                break;
            }
            case 2: {
                this.printString(indent + tab + header + " : < OR Operation (" + 2 + ") >");
                break;
            }
            case 3: {
                this.printString(indent + tab + header + " : < NOT Operation (" + 3 + ") >");
                break;
            }
            case 4: {
                this.printString(indent + tab + header + " : < RELATIONAL Operation (" + 4 + ") >");
                break;
            }
            case 5: {
                this.printString(indent + tab + header + " : < FROMFIELD Operation (" + 5 + ") >");
                break;
            }
            default: {
                this.printString(indent + tab + "Invalid Operation code..." + operationCode);
            }
        }
    }

    public void printQualifierInfo(String indent, String header, QualifierInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printQualifierOperationCode(indent + tab, "Operation Code : ", value.getOperation());
        switch (value.getOperation()) {
            case 0: {
                this.printString(indent + tab + " No operation mentioned...");
                break;
            }
            case 1: 
            case 2: {
                this.printQualifierInfo(indent + tab, "Left Operand: ", value.getLeftOperand());
                this.printQualifierInfo(indent + tab, "Right Operand: ", value.getRightOperand());
                break;
            }
            case 3: {
                this.printQualifierInfo(indent + tab, "Right Operand: ", value.getNotOperand());
                break;
            }
            case 4: {
                this.printRelationalOperationInfo(indent + tab, "Relational Operation Info: ", value.getRelationalOperationInfo());
                break;
            }
            case 5: {
                QualifierFromFieldInfo fromfid = value.getFromFieldInfo();
                this.printString(indent + tab, "From Field: ", fromfid.toString(), "\n");
                break;
            }
            default: {
                this.printString(indent + tab + "Invalid Operation code...");
            }
        }
        this.printNewLine();
    }

    public void printPropertyTag(String indent, String header, int propertyTag) {
        this.printHeader(indent, header + "< " + propertyTag + " >", "");
        switch (propertyTag) {
            case 1: {
                this.printString("TRIM TYPE");
                break;
            }
            case 2: {
                this.printString("CNTL TYPE");
                break;
            }
            case 3: {
                this.printString("BBOX");
                break;
            }
            case 4: {
                this.printString("VISIBLE");
                break;
            }
            case 5: {
                this.printString("ENABLE");
                break;
            }
            case 6: {
                this.printString("HELP");
                break;
            }
            case 7: {
                this.printString("Z ORDER");
                break;
            }
            case 8: {
                this.printString("COLOR FILL");
                break;
            }
            case 9: {
                this.printString("DEPTH EFFECT");
                break;
            }
            case 10: {
                this.printString("DEPTH AMOUNT");
                break;
            }
            case 11: {
                this.printString("COLOR LINE");
                break;
            }
            case 12: {
                this.printString("COLOR TEXT");
                break;
            }
            case 13: {
                this.printString("PROMPT");
                break;
            }
            case 20: {
                this.printString("LABEL");
                break;
            }
            case 21: {
                this.printString("LABEL BBOX");
                break;
            }
            case 22: {
                this.printString("LABEL FONT STYLE");
                break;
            }
            case 23: {
                this.printString("LABEL FONT SIZE");
                break;
            }
            case 24: {
                this.printString("LABEL COLOR TEXT");
                break;
            }
            case 25: {
                this.printString("LABEL JUSTIFY");
                break;
            }
            case 26: {
                this.printString("LABEL ALIGN");
                break;
            }
            case 27: {
                this.printString("LABEL POS SECTOR");
                break;
            }
            case 28: {
                this.printString("LABEL POS JUSTIFY");
                break;
            }
            case 29: {
                this.printString("LABEL POS ALIGN");
                break;
            }
            case 30: {
                this.printString("LABEL COLOR FILL");
                break;
            }
            case 31: {
                this.printString("LABEL COLOR LINE");
                break;
            }
            case 40: {
                this.printString("COORDS");
                break;
            }
            case 41: {
                this.printString("LINE WIDTH");
                break;
            }
            case 42: {
                this.printString("LINE PATTERN");
                break;
            }
            case 43: {
                this.printString("JOINT STYLE");
                break;
            }
            case 44: {
                this.printString("ENDCAP START");
                break;
            }
            case 45: {
                this.printString("ENDCAP END");
                break;
            }
            case 60: {
                this.printString("DATA ROWS");
                break;
            }
            case 61: {
                this.printString("DATA COLS");
                break;
            }
            case 62: {
                this.printString("DATA SPIN");
                break;
            }
            case 63: {
                this.printString("DATA MENU");
                break;
            }
            case 64: {
                this.printString("DATA RADIO");
                break;
            }
            case 65: {
                this.printString("MENU BBOX");
                break;
            }
            case 66: {
                this.printString("EXPAND BBOX");
                break;
            }
            case 80: {
                this.printString("TEXT");
                break;
            }
            case 81: {
                this.printString("TEXT FONT STYLE");
                break;
            }
            case 82: {
                this.printString("TEXT FONT SIZE");
                break;
            }
            case 90: {
                this.printString("JUSTIFY");
                break;
            }
            case 91: {
                this.printString("ALIGN");
                break;
            }
            case 100: {
                this.printString("IMAGE");
                break;
            }
            case 101: {
                this.printString("PUSH BUTTON IMAGE");
                break;
            }
            case 110: {
                this.printString("BUTTON TEXT");
                break;
            }
            case 111: {
                this.printString("BUTTON 2D");
                break;
            }
            case 112: {
                this.printString("BUTTON IMAGE POSITION");
                break;
            }
            case 113: {
                this.printString("BUTTON SCALE IMAGE");
                break;
            }
            case 114: {
                this.printString("BUTTON MAINTAIN RATIO");
                break;
            }
            case 120: {
                this.printString("MENU TEXT");
                break;
            }
            case 121: {
                this.printString("MENU POS");
                break;
            }
            case 122: {
                this.printString("MENU MODE");
                break;
            }
            case 123: {
                this.printString("MENU PARENT");
                break;
            }
            case 124: {
                this.printString("MENU HELP");
                break;
            }
            case 130: {
                this.printString("TOOLTIP");
                break;
            }
            case 131: {
                this.printString("TOOLBAR POS");
                break;
            }
            case 132: {
                this.printString("TOOLBAR MODE");
                break;
            }
            case 133: {
                this.printString("TOOLBAR TEXT");
                break;
            }
            case 140: {
                this.printString("TAB MODE");
                break;
            }
            case 141: {
                this.printString("TAB COORD");
                break;
            }
            case 142: {
                this.printString("TAB TEXT");
                break;
            }
            case 143: {
                this.printString("TAB ORDER");
                break;
            }
            case 144: {
                this.printString("DATETIME POPUP");
                break;
            }
            case 145: {
                this.printString("BACKGROUND MODE");
                break;
            }
            case 150: {
                this.printString("TAB NEXT");
                break;
            }
            case 151: {
                this.printString("DATA BBOX");
                break;
            }
            case 160: {
                this.printString("VIEW GRID BBOX");
                break;
            }
            case 161: {
                this.printString("VUI DEFAULT");
                break;
            }
            case 162: {
                this.printString("PANE LAYOUT");
                break;
            }
            case 163: {
                this.printString("DETAIL PANE VISIBILITY");
                break;
            }
            case 164: {
                this.printString("PROMPT PANE VISIBILITY");
                break;
            }
            case 165: {
                this.printString("RESULT PANE VISIBILITY");
                break;
            }
            case 166: {
                this.printString("DETAIL PANE COLOR");
                break;
            }
            case 167: {
                this.printString("DETAIL PANE IMAGE");
                break;
            }
            case 168: {
                this.printString("IMAGE ALIGN");
                break;
            }
            case 169: {
                this.printString("IMAGE JUSTIFY");
                break;
            }
            case 170: {
                this.printString("DISPLAY PARENT");
                break;
            }
            case 180: {
                this.printString("PAGE ORDER");
                break;
            }
            case 190: {
                this.printString("PAGE LABEL DISPLAY");
                break;
            }
            case 191: {
                this.printString("PAGE ARRANGEMENT");
                break;
            }
            case 192: {
                this.printString("DEFAULT PAGE");
                break;
            }
            case 200: {
                this.printString("TITLE BAR ICON IMAGE");
                break;
            }
            case 201: {
                this.printString("DETAIL PANE WIDTH");
                break;
            }
            case 202: {
                this.printString("DETAIL PANE HEIGHT");
                break;
            }
            case 203: {
                this.printString("DETAIL BANNER VISIBILITY");
                break;
            }
            case 204: {
                this.printString("PROMPT BANNER VISIBILITY");
                break;
            }
            case 205: {
                this.printString("RESULT BANNER VISIBILITY");
                break;
            }
            case 206: {
                this.printString("ALIAS SINGULAR ");
                break;
            }
            case 207: {
                this.printString("ALIAS PLURAL");
                break;
            }
            case 208: {
                this.printString("ALIAS SHORT SINGULAR ");
                break;
            }
            case 209: {
                this.printString("ALIAS SHORT PLURAL");
                break;
            }
            case 210: {
                this.printString("ALIAS ABBREV SINGULAR ");
                break;
            }
            case 211: {
                this.printString("ALIAS ABBREV PLURAL");
                break;
            }
            case 212: {
                this.printString("NAMED SEARCHES");
                break;
            }
            case 213: {
                this.printString("MENU ACCESS");
                break;
            }
            case 214: {
                this.printString("PANE VISIBILITY OPTION");
                break;
            }
            case 215: {
                this.printString("REQUEST IDENTIFIER");
                break;
            }
            case 216: {
                this.printString("QUERY LIST COLOR");
                break;
            }
            case 220: {
                this.printString("COLUMN WIDTH");
                break;
            }
            case 221: {
                this.printString("COLUMN ORDER");
                break;
            }
            case 222: {
                this.printString("COLUMN SORT SEQUENCE");
                break;
            }
            case 223: {
                this.printString("COLUMN SORT DIRECTION");
                break;
            }
            case 224: {
                this.printString("DRILL DOWN");
                break;
            }
            case 225: {
                this.printString("REFRESH");
                break;
            }
            case 226: {
                this.printString("AUTO REFRESH");
                break;
            }
            case 227: {
                this.printString("AUTOFIT COLUMNS");
                break;
            }
            case 228: {
                this.printString("APPLY DIRTY");
                break;
            }
            case 229: {
                this.printString("IMAGE CACHE");
                break;
            }
            case 230: {
                this.printString("DISPLAY LABELS");
                break;
            }
            case 60001: {
                this.printString("VENDOR NAME");
                break;
            }
            case 60002: {
                this.printString("VENDOR PRODUCT");
                break;
            }
            case 60003: {
                this.printString("VENDOR VERSION");
                break;
            }
            case 60004: {
                this.printString("GUID");
                break;
            }
            case 60005: {
                this.printString("COPYRIGHT");
                break;
            }
            case 60006: {
                this.printString("SCC LOCKED BY");
                break;
            }
            case 60007: {
                this.printString("SCC VERSION");
                break;
            }
            case 60008: {
                this.printString("SCC TIMESTAMP");
                break;
            }
            case 60009: {
                this.printString("SCC USER");
                break;
            }
            case 60010: {
                this.printString("SCC LOCATION");
                break;
            }
            case 60011: {
                this.printString("SCC DATA LOCKED BY");
                break;
            }
            case 60012: {
                this.printString("SCC DATA VERSION");
                break;
            }
            case 60013: {
                this.printString("SCC DATA TIMESTAMP");
                break;
            }
            case 60014: {
                this.printString("SCC DATA USER");
                break;
            }
            case 60015: {
                this.printString("SCC DATA LOCATION");
                break;
            }
            case 60039: {
                this.printString("Static Permission Inheritance");
                break;
            }
            case 60040: {
                this.printString("Dynamic Permission Inheritance");
                break;
            }
            case 60045: {
                this.printString("MULTI-FORM SEARCH OPTION MASK\n");
                break;
            }
            case 60048: {
                this.printString("MULTI-FORM SEARCH WEIGHTED RELEVANCY FIELDS\n");
                break;
            }
            case 60056: {
                this.printString("MULTI-FORM SEARCH TABLE FIELD INDEXED\n");
                break;
            }
            case 90015: {
                this.printString("OVERLAY PROPERTY\n");
                break;
            }
            case 60069: {
                this.printString("OVERLAY EXTEND MASK\n");
                break;
            }
            case 60070: {
                this.printString("OVERLAY INHERIT MASK\n");
                break;
            }
            case 90016: {
                this.printString("OVERLAY GROUP\n");
                break;
            }
            case 60065: {
                this.printString("FILTER USE FTS\n");
                break;
            }
            case 60023: {
                this.printString("NEXT ID BLOCK SIZE\n");
                break;
            }
            case 60025: {
                this.printString("CORE FIELDS OPTION MASK\n");
                break;
            }
            case 60036: {
                this.printString("CACHE DISPLAY PROPERTIES\n");
                break;
            }
            case 60046: {
                this.printString("FORM ALLOW DELETE\n");
                break;
            }
            case 60050: {
                this.printString("LOCALIZE FORM VIEWS\n");
                break;
            }
            case 60051: {
                this.printString("LOCALIZE FORM DATA\n");
                break;
            }
            case 60052: {
                this.printString("LOCALIZE FIELD DATA\n");
                break;
            }
            case 60059: {
                this.printString("OVERLAY DESIGN GROUP\n");
                break;
            }
            case 60060: {
                this.printString("OVERLAY\n");
                break;
            }
            case 60058: {
                this.printString("OVERLAY GROUPNAME\n");
                break;
            }
            case 60062: {
                this.printString("DRILL DOWN IN WEB REPORTS\n");
                break;
            }
            case 60064: {
                this.printString("DISPLAY FORM SINGLETON\n");
                break;
            }
            case 60067: {
                this.printString("OVERLAY VIEW CHANGED FIELD LIST\n");
                break;
            }
            case 60068: {
                this.printString("OVERLAY GRANULAR MODE\n");
                break;
            }
            default: {
                this.printString("   <undefined property >");
            }
        }
    }

    public void printPropInfo(String indent, String header, PropInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printPropertyTag(indent + tab, "Property Tag : ", value.getPropertyTag());
        this.printNewLine();
        this.printValue(indent + tab, "Property Value : ", value.getPropertyValue());
        this.printNewLine();
    }

    public void printPropInfoList(String indent, String header, PropInfo[] value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Number of values: ", value.length, "\n");
        for (int i = 0; i < value.length; ++i) {
            this.printPropInfo(indent + tab, "PropInfo: ", value[i]);
        }
        this.printNewLine();
    }

    public void printPropertyMap(String indent, String header, PropertyMap value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Number of values: ", value.size(), "\n");
        for (Integer i : value.keySet()) {
            this.printPropertyTag(indent + tab, "Property Tag : ", i);
            this.printNewLine();
            this.printValue(indent + tab, "Property Value : ", (Value)value.get(i));
            this.printNewLine();
        }
    }

    public void printAssignFieldInfo(String indent, String header, AssignFieldInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printString(indent + tab, "Server: ", value.getServer(), "\n");
        this.printString(indent + tab, "Form: ", value.getForm(), "\n");
        this.printLong(indent + tab, "Tag : ", value.getTag(), "\n");
        switch (value.getTag()) {
            case 1: {
                this.printLong(indent + tab, "FieldID : ", value.getFieldId(), "\n");
                break;
            }
            case 6: {
                this.printString(indent + tab, "Currency Part: ", value.getCurrencyPart().toString(), "\n");
                break;
            }
        }
        this.printLong(indent + tab, "FieldID : ", value.getFieldId(), "\n");
        this.printQualifierInfo(indent + tab, "QualifierInfo: ", value.getQualifier());
        this.printLong(indent + tab, "No Match Option : ", value.getNoMatchOption(), "\n");
        this.printLong(indent + tab, "Multi Match Option : ", value.getMultiMatchOption(), "\n");
        this.printStatusHistoryValue(indent + tab, "Status History: ", value.getStatHistory());
        this.printNewLine();
    }

    public void printStatusHistoryValue(String indent, String header, StatusHistoryValueIndicator value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printBoolean(indent + tab, "Time : ", value.isTime(), "\n");
        this.printInt(indent + tab, "Value : ", value.getEnumValue(), "\n");
        this.printNewLine();
    }

    public void printAssignSQLInfo(String indent, String header, AssignSQLInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printString(indent + tab, "Server: ", value.getServer(), "\n");
        if (value.getSqlCommand() == null) {
            this.printHeader(indent + tab, "SQL Command: NULL", "\n");
        } else {
            this.printString(indent + tab, "SQL Command: ", value.getSqlCommand(), "\n");
        }
        this.printLong(indent + tab, "Value Index: ", value.getValueIndex(), "\n");
        this.printLong(indent + tab, "No Match Option : ", value.getNoMatchOption(), "\n");
        this.printLong(indent + tab, "Multi Match Option : ", value.getMultiMatchOption(), "\n");
        this.printNewLine();
    }

    public void printAssignInfo(String indent, String header, AssignInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        if (value.getAssignmentAsString() != null) {
            this.printString(indent + tab, "AssignInfo (as string) : ", value.getAssignmentAsString(), "/n");
        }
        this.printLong(indent + tab, "Assign Type : ", value.getAssignType(), "\n");
        this.printArithOpAssignInfo(indent + tab, "AssignInfo :", value.getArithOp());
        this.printAssignFieldInfo(indent + tab, "AssignFieldInfo :", value.getField());
        this.printFunctionAssignInfo(indent + tab, "Function Assign Info :", value.getFunction());
        this.printAssignSQLInfo(indent + tab, "Assign SQL Info :", value.getSql());
        this.printString(indent + tab, "Process :", value.getProcess(), "\n");
        this.printDDEAction(indent + tab, "DDE Info :", value.getDde());
        this.printValue(indent + tab, "Value :", value.getValue());
        this.printNewLine();
    }

    public void printAssignInfoList(String indent, String header, AssignInfo[] value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Number of values: ", value.length, "\n");
        for (int i = 0; i < value.length; ++i) {
            this.printAssignInfo(indent + tab, "AssignInfoInfo: ", value[i]);
        }
        this.printNewLine();
    }

    public void printFieldAssignInfo(String indent, String header, FieldAssignInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Field Id : ", value.getFieldId(), "\n");
        if (value.getAssignmentAsString() != null) {
            this.printString(indent + tab, " AssignInfo (as string) : ", value.getAssignmentAsString(), "/n");
        }
        this.printAssignInfo(indent + tab, " AssignInfo : ", value.getAssignment());
        this.printNewLine();
    }

    public void printSetFieldsActionInfo(String indent, String header, SetFieldsAction value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        if (!(value instanceof SetFieldsFromCurrentScreen) && !(value instanceof SetFieldsFromCurrentTransaction)) {
            if (value instanceof SetFieldsFromForm) {
                this.printString(indent, "Sample Server: ", ((SetFieldsFromForm)value).getSampleServer(), "/n");
                this.printString(indent, "Sample Form: ", ((SetFieldsFromForm)value).getSampleForm(), "/n");
            } else if (value instanceof SetFieldsFromFilterAPI) {
                this.print(indent, "Input Value List:", ((SetFieldsFromFilterAPI)value).getInputAssignList());
            } else if (value instanceof SetFieldsFromSQL) {
                this.printString(indent, "Sql Command: ", ((SetFieldsFromSQL)value).getSqlCommand(), "/n");
                this.printInt(indent, "No Match Option: ", ((SetFieldsFromSQL)value).getNoMatchOption(), "/n");
                this.printInt(indent, "Multi Match Option: ", ((SetFieldsFromSQL)value).getMultiMatchOption(), "/n");
            }
        }
        this.print(indent, "Set Fields: ", value.getSetFieldsList());
    }

    public void printFunctionAssignInfo(String indent, String header, FunctionAssignInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printLong(indent + tab, "Function Code : ", value.getFunctionCode(), "\n");
        this.printLong(indent + tab, "Number of items : ", value.getNumItems(), "\n");
        this.print(indent + tab, "Parameters List :", value.getParameterList());
        this.printNewLine();
    }

    public void printNotifyActionInfo(String indent, String header, NotifyAction value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + tab, "Null NotifyActionInfo....", "\n");
            return;
        }
        this.printLong(indent + tab, "Notify Mechanism: ", value.getNotifyMechanism(), "\n");
        this.printLong(indent + tab, "Notify Priority: ", value.getNotifyPriority(), "\n");
        this.printInt(indent + tab, "Notify Mechanism X Ref: ", value.getNotifyMechanismXRef(), "\n");
        this.printString(indent + tab, "User: ", value.getUser(), "\n");
        this.printString(indent + tab, "Notify Text: ", value.getNotifyText(), "\n");
        this.printString(indent + tab, "Subject Text: ", value.getSubjectText(), "\n");
        this.printLong(indent + tab, "FieldIdListType: ", value.getFieldIdListType(), "\n");
        this.printIntList(indent + tab, "Field ID List: ", value.getFieldIdList());
        this.printNewLine();
    }

    public void printFilterActionInfoList(String indent, String header, FilterAction[] actionList) {
        this.printHeader(indent, header, "\n");
        if (actionList == null) {
            return;
        }
        this.printInt(indent + tab, "Number of actions: ", actionList.length, "\n");
        for (int i = 0; i < actionList.length; ++i) {
            this.printFilterAction(indent + tab, "FilterAction " + i + " : ", actionList[i]);
        }
        this.printNewLine();
    }

    public void printFilterActionName(String indent, String header, long value) {
        switch ((int)value) {
            case 4: {
                this.printString(indent + "Action Name: SET FIELDS");
                break;
            }
            case 5: {
                this.printString(indent + "Action Name: PROCESS");
                break;
            }
            case 2: {
                this.printString(indent + "Action Name: MESSAGE");
                break;
            }
            case 6: {
                this.printString(indent + "Action Name: PUSH FIELDS");
                break;
            }
            case 7: {
                this.printString(indent + "Action Name: DIRECT SQL");
                break;
            }
            case 9: {
                this.printString(indent + "Action Name: CALL GUIDE");
                break;
            }
            case 3: {
                this.printString(indent + "Action Name: LOG TO FILE");
                break;
            }
            case 1: {
                this.printString(indent + "Action Name: NOTIFY");
                break;
            }
            case 8: {
                this.printString(indent + "Action Name: GOTO");
                break;
            }
            default: {
                this.printString(indent + "Action Name:    <undefined action > " + value);
            }
        }
        this.printNewLine();
    }

    public void printFilterAction(String indent, String header, FilterAction value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printString(indent + tab, "Action : ", value.getClass().getSimpleName());
        if (value instanceof CallGuideAction) {
            this.printCallGuideInfo(indent + tab, "Call Guide : ", (CallGuideAction)value);
        } else if (value instanceof DirectSqlAction) {
            this.printSQLInfo(indent + tab, "SQL Command: ", (DirectSqlAction)value);
        } else if (value instanceof GotoAction) {
            this.printGotoActionInfo(indent + tab, "Goto : ", (GotoAction)value);
        } else if (value instanceof LogAction) {
            this.printString(indent + tab, "Log To File : ", ((LogAction)value).getFilePath(), "\n");
        } else if (value instanceof FilterMessageAction) {
            this.printFilterStatusInfo(indent + tab, "Message: ", (FilterMessageAction)value);
        } else if (value instanceof NotifyAction) {
            this.printNotifyActionInfo(indent + tab, "Notify: ", (NotifyAction)value);
        } else if (value instanceof PushFieldsAction) {
            this.printPushFieldsAction(indent + tab, "Push Fields: ", (PushFieldsAction)value);
        } else if (value instanceof RunProcessAction) {
            this.printString(indent + tab, "Run Process : ", ((RunProcessAction)value).getCommandLine(), "\n");
        } else if (value instanceof SetFieldsAction) {
            this.printSetFieldsActionInfo(indent + tab, "Set Fields: ", (SetFieldsAction)value);
        }
        this.printNewLine();
    }

    public void printFilterStatusInfo(String indent, String header, FilterMessageAction value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printLong(indent + tab, "   Message type : ", value.getMessageType(), "\n");
        this.printLong(indent + tab, "   Message number : ", value.getMessageNum(), "\n");
        this.printString(indent + tab, "   Message Text : ", value.getMessageText(), "\n");
        this.printNewLine();
    }

    public void printPushFieldsInfo(String indent, String header, PushFieldsInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printAssignFieldInfo(indent + tab, "Assign Field Info: ", value.getField());
        this.printAssignInfo(indent + tab, "Assign Info: ", value.getAssignment());
        this.printNewLine();
    }

    public void printPushFieldsInfoList(String indent, String header, PushFieldsInfo[] value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Number of values: ", value.length, "\n");
        for (int i = 0; i < value.length; ++i) {
            this.printPushFieldsInfo(indent + tab, "PushFieldsInfo: ", value[i]);
        }
        this.printNewLine();
    }

    public void printPushFieldsAction(String indent, String header, PushFieldsAction value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printString(indent, "Sample Server: ", value.getSampleServer(), "/n");
        this.printString(indent, "Sample Form: ", value.getSampleForm(), "/n");
        this.print(indent, "Push Fields: ", value.getPushFieldsList());
    }

    public void printSQLInfo(String indent, String header, DirectSqlAction value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        if (value.getServer() != null) {
            this.printString(indent + tab, " Server: ", value.getServer(), "\n");
        } else {
            this.printHeader(indent + tab, "Server: <NULL> ", "\n");
        }
        if (value.getCommand() != null) {
            this.printString(indent + tab, "SQL Command: ", value.getCommand(), "\n");
        } else {
            this.printHeader(indent + tab, "SQL Command: NULL", "\n");
        }
        this.printNewLine();
    }

    public void printGotoActionInfo(String indent, String header, GotoAction value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printLong(indent + tab, "Tag: ", value.getTag(), "\n");
        this.printLong(indent + tab, "FieldID or Value : ", value.getFieldIdOrValue(), "\n");
        this.printNewLine();
    }

    public void printMacroParmInfo(String indent, String header, MacroParmInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printString(indent + tab, "Name: ", value.getName(), "\n");
        this.printString(indent + tab, "Value: ", value.getValue(), "\n");
        this.printNewLine();
    }

    public void printMacroParmInfoList(String indent, String header, Map<String, String> value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Number of values: ", value.size(), "\n");
        for (String key : value.keySet()) {
            this.printString(indent + tab, "Name: ", key, "\n");
            this.printString(indent + tab, "Value: ", value.get(key), "\n");
        }
        this.printNewLine();
    }

    public void printRunMacroAction(String indent, String header, RunMacroAction value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printString(indent + tab, "Macro name: ", value.getMacroName(), "\n");
        this.printString(indent + tab, "Macro text: ", value.getMacroText(), "\n");
        this.printMacroParmInfoList(indent + tab, "Macro Param List :", value.getMacroParms());
        this.printNewLine();
    }

    public void printMessageInfo(String indent, String header, MessageAction value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printLong(indent + tab, "Message type : ", value.getMessageType(), "\n");
        this.printLong(indent + tab, "Message number : ", value.getMessageNum(), "\n");
        if (value.getMessageText() != null) {
            this.printString(indent + tab, "Message: ", value.getMessageText(), "\n");
        } else {
            this.printHeader(indent + tab, "Message: <NULL>", "\n");
        }
        this.printBoolean(indent + tab, "Use Prompting Pane : ", value.isUsePromptingPane(), "\n");
        this.printNewLine();
    }

    public void printChangeFieldAction(String indent, String header, ChangeFieldAction value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Option: ", value.getOption(), "\n");
        this.printInt(indent + tab, "Field Id: ", value.getFieldId(), "\n");
        this.printLong(indent + tab, "Reset Focus:", value.getFocus(), "\n");
        this.printLong(indent + tab, "Access option:", value.getAccessOption(), "\n");
        if (value.getCharMenu() == null) {
            this.printHeader(indent + tab, "Char menu: NULL", "\n");
        } else {
            this.printString(indent + tab, "Char menu: ", value.getCharMenu(), "\n");
        }
        this.printPropertyMap(indent + tab, "Properties :", value.getProps());
        this.printNewLine();
    }

    public void printDDEAction(String indent, String header, DDEAction value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        if (value.getServiceName() != null) {
            this.printString(indent + tab, "Service name:", value.getServiceName(), "\n");
        } else {
            this.printHeader(indent + tab, "Service name: < NULL >", "\n");
        }
        if (value.getTopic() != null) {
            this.printString(indent + tab, "Topic:", value.getTopic(), "\n");
        } else {
            this.printHeader(indent + tab, "Topic: < NULL >", "\n");
        }
        this.printLong(indent + tab, "Action: ", value.getAction(), "\n");
        if (value.getPathToProgram() != null) {
            this.printString(indent + tab, "Path to Program:", value.getPathToProgram(), "\n");
        } else {
            this.printHeader(indent + tab, "Path to Program:< NULL >", "\n");
        }
        if (value.getCommand() != null) {
            this.printString(indent + tab, "Command: ", value.getCommand(), "\n");
        } else {
            this.printHeader(indent + tab, "Command: <NULL> ", "\n");
        }
        if (value.getItem() != null) {
            this.printString(indent + tab, "Item:", value.getItem(), "\n");
        } else {
            this.printHeader(indent + tab, "Item:", "\n");
        }
        this.printNewLine();
    }

    public void printOleAutomationAction(String indent, String header, OleAutomationAction value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printString(indent + tab, "Auto Server name:", value.getAutoServerName(), "\n");
        this.printBoolean(indent + tab, "Automation Server Showing flag :", value.isVisible(), "\n");
        this.printString(indent + tab, "Class Id:", value.getClsId(), "\n");
        this.printString(indent + tab, "Automation Action: ", value.getAction(), "\n");
        this.print(indent + tab, "Com methods list: ", value.getMethodList());
        this.printNewLine();
    }

    public void printCOMValueInfo(String indent, String header, COMValueInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "FieldId: ", value.getFieldId(), "\n");
        this.printInt(indent + tab, "TransientId: ", value.getTransId(), "\n");
        this.printLong(indent + tab, "Value Type: ", value.getValueType(), "\n");
        this.printString(indent + tab, "ValueId: ", value.getValueIId(), "\n");
        this.printValue(indent + tab, "value: ", value.getValue());
        this.printNewLine();
    }

    public void printCOMMethodInfoList(String indent, String header, COMMethodInfo[] value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Number of Items : ", value.length, "\n");
        for (int i = 0; i < value.length; ++i) {
            this.printCOMMethodInfo(indent + tab, null, value[i]);
        }
        this.printNewLine();
    }

    public void printCOMMethodInfo(String indent, String header, COMMethodInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printString(indent + tab, "Method Name: ", value.getMethodName(), "\n");
        this.printString(indent + tab, "Method Interface Id: ", value.getMethodIId(), "\n");
        this.printLong(indent + tab, "Method Type: ", value.getMethodType(), "\n");
        this.printCOMValueInfo(indent + tab, "Method:", value.getMethodValue());
        this.printCOMMethodParmInfoList(indent + tab, " Parameter List: \n", value.getParameterList());
        this.printNewLine();
    }

    public void printCOMMethodParmInfoList(String indent, String header, List<COMMethodParmInfo> value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Number of Items : ", value.size(), "\n");
        for (int i = 0; i < value.size(); ++i) {
            this.printCOMMethodParmInfo(indent + tab, null, value.get(i));
        }
        this.printNewLine();
    }

    public void printCOMMethodParmInfo(String indent, String header, COMMethodParmInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printString(indent + tab, "Parameter Name: ", value.getParmName(), "\n");
        this.printLong(indent + tab, "Parameter Type: ", value.getParmType(), "\n");
        this.printCOMValueInfo(indent + tab, "Parameter: ", value.getParmValue());
    }

    public void printOpenWindowAction(String indent, String header, OpenWindowAction value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printString(indent + tab, "Server Name: ", value.getServerName(), "\n");
        this.printString(indent + tab, "Form Name: ", value.getFormName(), "\n");
        this.printString(indent + tab, "Vui Label: ", value.getVuiLabel(), "\n");
        this.printBoolean(indent + tab, "Close Box Showing flag : ", value.isCloseBox(), "\n");
        this.print(indent + tab, "Input Value Fields : ", value.getInputValueFieldPairs());
        this.print(indent + tab, "Output Value Fields : ", value.getOutputValueFieldPairs());
        this.printInt(indent + tab, "Window Mode: ", value.getWindowMode(), "\n");
        this.printString(indent + tab, "Target Location: ", value.getTargetLocation(), "\n");
        this.printQualifierInfo(indent + tab, "Query: ", value.getQuery());
        this.printBoolean(indent + tab, "No Match Continue: ", value.isNoMatchContinue(), "\n");
        this.printBoolean(indent + tab, "Suppress Empty List: ", value.isSuppressEmptyLst(), "\n");
        this.printMessageInfo(indent + tab, "Message: ", value.getMsg());
        this.printLong(indent + tab, "Polling Interval: ", value.getPollinginterval(), "\n");
        this.printString(indent + tab, "Report String: ", value.getReportString(), "\n");
        this.print(indent + tab, "Sort Order List: ", value.getSortOrderList());
        this.printNewLine();
    }

    public void printCallGuideInfo(String indent, String header, CallGuideAction value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printString(indent + tab, "Server Name: ", value.getServerName(), "\n");
        this.printString(indent + tab, "Guide Name: ", value.getGuideName(), "\n");
        this.printInt(indent + tab, "Guide Mode: ", value.getGuideMode(), "\n");
        this.printInt(indent + tab, "Table Field: ", value.getGuideTableId(), "\n");
        this.print(indent + tab, "Input Value Fields : ", value.getInputValueFieldPairs());
        this.print(indent + tab, "Output Value Fields : ", value.getOutputValueFieldPairs());
        this.printString(indent + tab, "Sample Server Name: ", value.getSampleServer(), "\n");
        this.printString(indent + tab, "Sample Guide Name: ", value.getSampleGuide(), "\n");
        this.printNewLine();
    }

    public void printExitGuideInfo(String indent, String header, ExitGuideAction value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printBoolean(indent + tab, "Close All Windows : ", value.isCloseAll(), "\n");
        this.printNewLine();
    }

    public void printGotoGuideLabelInfo(String indent, String header, GotoGuideLabelAction value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printString(indent + tab, "Label: ", value.getLabel(), "\n");
        this.printNewLine();
    }

    public void printWaitAction(String indent, String header, WaitAction value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printString(indent + tab, "Continue Button Title: ", value.getContinueButtonTitle(), "\n");
        this.printNewLine();
    }

    public void printCloseWindowAction(String indent, String header, CloseWindowAction value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printBoolean(indent + tab, "Close All: ", value.isCloseAll(), "\n");
        this.printNewLine();
    }

    public void printActiveLinkActionName(String indent, String header, long value) {
        switch ((int)value) {
            case 1: {
                this.printString(indent + "Action Name: RUN MACRO");
                break;
            }
            case 2: {
                this.printString(indent + "Action Name: SET FIELDS");
                break;
            }
            case 3: {
                this.printString(indent + "Action Name: RUN PROCESS");
                break;
            }
            case 4: {
                this.printString(indent + "Action Name: MESSAGE");
                break;
            }
            case 5: {
                this.printString(indent + "Action Name: CHANGE FILED");
                break;
            }
            case 6: {
                this.printString(indent + "Action Name: DDE");
                break;
            }
            case 7: {
                this.printString(indent + "Action Name: PUSH FIELDS");
                break;
            }
            case 8: {
                this.printString(indent + "Action Name: DIRECT SQL");
                break;
            }
            case 9: {
                this.printString(indent + "Action Name: OLE AUTOMATION");
                break;
            }
            case 10: {
                this.printString(indent + "Action Name: OPEN DIALOG/WINDOW");
                break;
            }
            case 11: {
                this.printString(indent + "Action Name: CCOMMIT CHANGES");
                break;
            }
            case 12: {
                this.printString(indent + "Action Name: CLOSE WINDOW");
                break;
            }
            case 13: {
                this.printString(indent + "Action Name: CALL GUIDE");
                break;
            }
            case 14: {
                this.printString(indent + "Action Name: EXIT GUIDE");
                break;
            }
            case 15: {
                this.printString(indent + "Action Name: GOTO GUIDE LABEL");
                break;
            }
            case 16: {
                this.printString(indent + "Action Name: WAIT");
                break;
            }
            case 17: {
                this.printString(indent + "Action Name: GOTO");
                break;
            }
            default: {
                this.printString(indent + "Action Name:    <undefined action > " + value);
            }
        }
        this.printNewLine();
    }

    public void printActiveLinkActionInfo(String indent, String header, ActiveLinkAction value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printString(indent + tab, "Action : ", value.getClass().getSimpleName());
        if (value instanceof CallGuideAction) {
            this.printCallGuideInfo(indent + tab, "Call Guide : ", (CallGuideAction)value);
        } else if (value instanceof ChangeFieldAction) {
            this.printChangeFieldAction(indent + tab, "Change Field : ", (ChangeFieldAction)value);
        } else if (value instanceof CloseWindowAction) {
            this.printCloseWindowAction(indent + tab, "Close Window : ", (CloseWindowAction)value);
        } else if (value instanceof OleAutomationAction) {
            this.printOleAutomationAction(indent + tab, "OLE Automation Action: ", (OleAutomationAction)value);
        } else if (value instanceof DDEAction) {
            this.printDDEAction(indent + tab, "DDE : ", (DDEAction)value);
        } else if (value instanceof OpenWindowAction) {
            this.printOpenWindowAction(indent + tab, "Open Window : ", (OpenWindowAction)value);
        } else if (value instanceof DirectSqlAction) {
            this.printSQLInfo(indent + tab, "Direct SQL : ", (DirectSqlAction)value);
        } else if (value instanceof GotoAction) {
            this.printGotoActionInfo(indent + tab, "Goto : ", (GotoAction)value);
        } else if (value instanceof RunMacroAction) {
            this.printRunMacroAction(indent + tab, "Run Macro : ", (RunMacroAction)value);
        } else if (value instanceof MessageAction) {
            this.printMessageInfo(indent + tab, "Message: ", (MessageAction)value);
        } else if (value instanceof NotifyAction) {
            this.printNotifyActionInfo(indent + tab, "Notify: ", (NotifyAction)((Object)value));
        } else if (value instanceof PushFieldsAction) {
            this.printPushFieldsAction(indent + tab, "Push Fields: ", (PushFieldsAction)value);
        } else if (value instanceof RunProcessAction) {
            this.printString(indent + tab, "Run Process : ", ((RunProcessAction)value).getCommandLine(), "\n");
        } else if (value instanceof SetFieldsAction) {
            this.printSetFieldsActionInfo(indent + tab, "Set Fields: ", (SetFieldsAction)value);
        } else if (value instanceof WaitAction) {
            this.printWaitAction(indent + tab, "Set Fields: ", (WaitAction)value);
        }
        this.printNewLine();
    }

    public void printActiveLinkActionInfoList(String indent, String header, List<ActiveLinkAction> value, boolean flag) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        if (flag) {
            this.printInt(indent + tab, "Active Link Action List items: ", value.size(), "\n");
        } else {
            this.printInt(indent + tab, "Active Link Else List items: ", value.size(), "\n");
        }
        for (int i = 0; i < value.size(); ++i) {
            this.printActiveLinkActionInfo(indent + tab, null, value.get(i));
        }
        this.printNewLine();
    }

    public void printActiveLinkList(String indent, String header, ActiveLink[] activeLinkList) {
        this.printHeader(indent, header, "\n");
        if (activeLinkList == null) {
            return;
        }
        this.printInt(indent + tab, "Number of Items : ", activeLinkList.length, "\n");
        for (int i = 0; i < activeLinkList.length; ++i) {
            this.printActiveLink(indent + tab, "ActiveLink Info:", activeLinkList[i]);
        }
        this.printNewLine();
    }

    public void printActiveLinkListNames(String indent, String header, List<ActiveLink> activeLinkList) {
        this.printHeader(indent, header, "\n");
        if (activeLinkList == null) {
            return;
        }
        this.printInt(indent + tab, "Number of Items : ", activeLinkList.size(), "\n");
        for (int i = 0; i < activeLinkList.size(); ++i) {
            this.printActiveLinkName(indent + tab, "", activeLinkList.get(i));
        }
        this.printNewLine();
    }

    public <T> void print(String indent, String header, T obj) {
        if (obj == null) {
            this.printHeader(indent, "Null object...", "\n");
            return;
        }
        if (Map.class.isAssignableFrom(obj.getClass())) {
            this.print(indent, header, ((Map)obj).entrySet());
            return;
        }
        if (Map.Entry.class.isAssignableFrom(obj.getClass())) {
            this.print(indent, header, ((Map.Entry)obj).getKey());
            this.print(indent, header, ((Map.Entry)obj).getValue());
            return;
        }
        if (Set.class.isAssignableFrom(obj.getClass())) {
            this.print(indent, header, (Set)obj);
            return;
        }
        if (List.class.isAssignableFrom(obj.getClass())) {
            this.print(indent, header, (List)obj);
            return;
        }
        if (ActiveLink.class.isAssignableFrom(obj.getClass())) {
            this.printActiveLink(indent, header, (ActiveLink)obj);
        } else if (Filter.class.isAssignableFrom(obj.getClass())) {
            this.printFilter(indent, header, (Filter)obj);
        } else if (Escalation.class.isAssignableFrom(obj.getClass())) {
            this.printEscalation(indent, header, (Escalation)obj);
        } else if (FieldAssignInfo.class.isAssignableFrom(obj.getClass())) {
            this.printFieldAssignInfo(indent, header, (FieldAssignInfo)obj);
        } else if (COMMethodInfo.class.isAssignableFrom(obj.getClass())) {
            this.printCOMMethodInfo(indent, header, (COMMethodInfo)obj);
        } else if (SortInfo.class.isAssignableFrom(obj.getClass())) {
            this.printSortInfo(indent, header, (SortInfo)obj);
        } else if (Value.class.isAssignableFrom(obj.getClass())) {
            this.printValue(indent, header, (Value)obj);
        } else if (AssignInfo.class.isAssignableFrom(obj.getClass())) {
            this.printAssignInfo(indent, header, (AssignInfo)obj);
        } else if (FilterAction.class.isAssignableFrom(obj.getClass())) {
            this.printFilterAction(indent, header, (FilterAction)obj);
        } else if (View.class.isAssignableFrom(obj.getClass())) {
            this.printView(indent, header, (View)obj);
        } else if (ExtFormCandidatesInfo.class.isAssignableFrom(obj.getClass())) {
            this.printExtFormCandidatesInfo(indent, header, (ExtFormCandidatesInfo)obj);
        } else if (ExtFieldCandidatesInfo.class.isAssignableFrom(obj.getClass())) {
            this.printExtFieldCandidatesInfo(indent, header, (ExtFieldCandidatesInfo)obj);
        } else if (PermissionInfo.class.isAssignableFrom(obj.getClass())) {
            this.printPermissionInfo(indent, header, (PermissionInfo)obj);
        } else if (ContainerOwner.class.isAssignableFrom(obj.getClass())) {
            this.printContainerOwner(indent, header, (ContainerOwner)obj);
        } else if (ExternalReference.class.isAssignableFrom(obj.getClass())) {
            this.printExternalReference(indent, header, (ExternalReference)obj);
        } else if (Reference.class.isAssignableFrom(obj.getClass())) {
            this.printReference(indent, header, (Reference)obj);
        } else if (Container.class.isAssignableFrom(obj.getClass())) {
            this.printContainer(indent, header, (Container)obj);
        } else if (Menu.class.isAssignableFrom(obj.getClass())) {
            this.printMenu(indent, header, (Menu)obj);
        } else if (EnumItem.class.isAssignableFrom(obj.getClass())) {
            this.printEnumItem(indent, header, (EnumItem)obj);
        } else if (Field.class.isAssignableFrom(obj.getClass())) {
            this.printField(indent, header, (Field)obj);
        } else if (Form.class.isAssignableFrom(obj.getClass())) {
            this.printForm(indent, header, (Form)obj);
        } else if (EntryListInfo.class.isAssignableFrom(obj.getClass())) {
            this.printEntryListInfo(indent, header, (EntryListInfo)obj);
        } else if (FormAliasInfo.class.isAssignableFrom(obj.getClass())) {
            this.printFormAliasInfo(indent, header, (FormAliasInfo)obj);
        } else if (EntryPointInfo.class.isAssignableFrom(obj.getClass())) {
            this.printEntryPoint(indent, header, (EntryPointInfo)obj);
        } else if (SupportFile.class.isAssignableFrom(obj.getClass())) {
            this.printSupportFile(indent, header, (SupportFile)obj);
        } else if (LicenseInfo.class.isAssignableFrom(obj.getClass())) {
            this.printLicenseInfo(indent, header, (LicenseInfo)obj);
        } else if (UserInfo.class.isAssignableFrom(obj.getClass())) {
            this.printUserInfo(indent, header, (UserInfo)obj);
        } else if (GroupInfo.class.isAssignableFrom(obj.getClass())) {
            this.printGroupInfo(indent, header, (GroupInfo)obj);
        } else if (RoleInfo.class.isAssignableFrom(obj.getClass())) {
            this.printRoleInfo(indent, header, (RoleInfo)obj);
        } else if (RoleInfo.class.isAssignableFrom(obj.getClass())) {
            this.printRoleInfo(indent, header, (RoleInfo)obj);
        } else if (SQLResult.class.isAssignableFrom(obj.getClass())) {
            this.printSQLResult(indent, header, (SQLResult)obj);
        } else if (StatisticsResultInfo.class.isAssignableFrom(obj.getClass())) {
            this.printStatisticsResultInfo(indent, header, (StatisticsResultInfo)obj);
        } else if (ARServerUser.class.isAssignableFrom(obj.getClass())) {
            this.printARServerUser(indent, header, (ARServerUser)obj);
        } else if (MenuItem.class.isAssignableFrom(obj.getClass())) {
            this.printCharMenuItemInfo(indent, header, (MenuItem)obj);
        } else if (PushFieldsInfo.class.isAssignableFrom(obj.getClass())) {
            this.printPushFieldsInfo(indent, header, (PushFieldsInfo)obj);
        } else if (UserLicenseInfo.class.isAssignableFrom(obj.getClass())) {
            this.printUserLicenseInfo(indent, header, (UserLicenseInfo)obj);
        } else if (Image.class.isAssignableFrom(obj.getClass())) {
            this.printImage(indent, header, (Image)obj);
        } else if (IQuerySource.class.isAssignableFrom(obj.getClass())) {
            this.printQuerySource(indent, header, (IQuerySource)obj);
        } else if (QualifierInfo.class.isAssignableFrom(obj.getClass())) {
            this.printQualifierInfo(indent, header, (QualifierInfo)obj);
        } else if (LicenseValidInfo.class.isAssignableFrom(obj.getClass())) {
            this.printLicenseValidInfo(indent, header, (LicenseValidInfo)obj);
        } else if (ProcessResult.class.isAssignableFrom(obj.getClass())) {
            this.printProcessResult(indent, header, (ProcessResult)obj);
        } else if (Association.class.isAssignableFrom(obj.getClass())) {
            this.printAssociation(indent, header, (Association)obj);
        } else {
            this.printString(indent, header, obj.toString());
        }
    }

    public <T> void print(String indent, String header, List<T> list) {
        this.printHeader(indent, header, "\n");
        if (list == null) {
            this.printHeader(indent, "Null list..", "\n");
            return;
        }
        this.printInt(indent, "Number of Items : ", list.size(), "\n");
        for (T t : list) {
            this.print(indent + tab, "", t);
        }
    }

    public <T> void print(String indent, String header, Set<T> set) {
        this.printHeader(indent, header, "\n");
        if (set == null) {
            this.printHeader(indent, "Null list..", "\n");
            return;
        }
        this.printInt(indent, "Number of Items : ", set.size(), "\n");
        for (T t : set) {
            this.print(indent + tab, "", t);
        }
    }

    public void printActiveLink(String indent, String header, ActiveLink activeLink) {
        this.printHeader(indent, header, "\n");
        if (activeLink == null) {
            return;
        }
        if (activeLink.getName() != null) {
            this.printString(indent + tab, "Name: ", activeLink.getName(), "\n");
        } else {
            this.printString(indent + tab, "Name: <null>", "", "\n");
        }
        this.printLong(indent + tab, "Execution order: ", activeLink.getOrder(), "\n");
        this.print(indent + tab, "Form ", activeLink.getFormList());
        this.print(indent + tab, "Assigned Group List: ", activeLink.getAssignedGroup());
        this.print(indent + tab, "Complete Group List: ", activeLink.getGroupList());
        this.printLong(indent + tab, "Execute bitmask: ", activeLink.getExecuteMask(), "\n");
        this.printLong(indent + tab, "Control Field: ", activeLink.getControlField(), "\n");
        this.printLong(indent + tab, "Focus Field: ", activeLink.getFocusField(), "\n");
        this.printBoolean(indent + tab, "Enable flag: ", activeLink.isEnable(), "\n");
        this.printQualifierInfo(indent + tab, "", activeLink.getQualifier());
        this.printActiveLinkActionInfoList(indent + tab, "", activeLink.getActionList(), true);
        this.printActiveLinkActionInfoList(indent + tab, "", activeLink.getElseList(), false);
        if (activeLink.getHelpText() != null) {
            this.printString(indent + tab, "Help Text: ", activeLink.getHelpText(), "\n");
        } else {
            this.printString(indent + tab + "HelpText: <null>");
        }
        if (activeLink.getOwner() != null) {
            this.printString(indent + tab, "Owner: ", activeLink.getOwner(), "\n");
        } else {
            this.printString(indent + tab + "Owner: null");
        }
        if (activeLink.getLastChangedBy() != null) {
            this.printString(indent + tab + "Last Changed: " + activeLink.getLastChangedBy());
        } else {
            this.printString(indent + tab + "Last Changed: <null>");
        }
        if (activeLink.getDiary() != null) {
            this.printDiaryList(indent + tab, "Change DiaryList: ", activeLink.getDiary());
        } else {
            this.printString(indent + tab + "Change DiaryList: null ");
        }
        this.printPropertyMap(indent + tab, "Properties List: ", activeLink.getProperties());
        this.printInt(indent + tab, "Error Handler Activelink Options: ", activeLink.getErrorActlinkOptions(), "\n");
        if (activeLink.getErrorActlinkName() != null) {
            this.printString(indent + tab, "Error Handler Name: ", activeLink.getErrorActlinkName(), "\n");
        } else {
            this.printString(indent + tab, "Error Handler Name: null", "\n");
        }
        this.printNewLine();
    }

    public void printActiveLinkName(String indent, String header, ActiveLink activeLink) {
        if (activeLink == null) {
            this.printHeader(indent, "Null ActiveLink...", "\n");
            return;
        }
        if (activeLink.getName() != null) {
            this.printString(indent, "", activeLink.getName(), "\n");
        } else {
            this.printString(indent, "<null>", "", "\n");
        }
    }

    public void printPermissionInfo(String indent, String header, PermissionInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Group id:", value.getGroupID(), "\n");
        switch (value.getPermissionValue()) {
            case 0: {
                this.printString(indent + tab + "Permissions: NONE");
                break;
            }
            case 1: {
                this.printString(indent + tab + "Permissions: VISIBLE");
                break;
            }
            case 2: {
                this.printString(indent + tab + "Permissions: HIDDEN");
            }
        }
        this.printNewLine();
    }

    public void printPermissionInfoList(String indent, String header, List<PermissionInfo> value, boolean fieldFlag) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + tab, "Null PermissionInfo list..", "\n");
            return;
        }
        this.printInt(indent + tab, "Number of Items: ", value.size(), "\n");
        for (int i = 0; i < value.size(); ++i) {
            if (fieldFlag) {
                this.printFieldPermissionInfo(indent + tab, null, value.get(i));
                continue;
            }
            this.printPermissionInfo(indent + tab, null, value.get(i));
        }
        this.printNewLine();
    }

    public void printPKFKMappingSet(String indent, String header, Set<PKFKMapping> value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + tab, "Null pkfkMapping set..", "\n");
            return;
        }
        this.printInt(indent + tab, "Number of Items: ", value.size(), "\n");
        for (PKFKMapping mapping : value) {
            this.printPKFKMapping(indent + tab, null, mapping);
        }
        this.printNewLine();
    }

    public void printAssociationTagList(String indent, String header, List<AssociationTag> value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + tab, "Null pkfkMapping set..", "\n");
            return;
        }
        this.printInt(indent + tab, "Number of Items: ", value.size(), "\n");
        for (AssociationTag tag : value) {
            this.printAssocTag(indent + tab, null, tag);
        }
        this.printNewLine();
    }

    public void printAssocTag(String indent, String header, AssociationTag value) {
        if (value == null) {
            return;
        }
        this.printString(indent + tab, "Tag Name : ", value.getName(), "\n");
        this.printString(indent + tab, "Tag Description : ", value.getDescription(), "\n");
        this.printNewLine();
    }

    public void printPKFKMapping(String indent, String header, PKFKMapping value) {
        if (value == null) {
            return;
        }
        this.printString(indent + tab, "Primary Key Field ID:" + value.getPrimaryKeyFieldId(), "\n");
        this.printString(indent + tab, "Foreign Key Field ID:" + value.getForeignKeyFieldId(), "\n");
        this.printNewLine();
    }

    public void printFieldPermissionInfo(String indent, String header, PermissionInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Group id:", value.getGroupID(), "\n");
        switch (value.getPermissionValue()) {
            case 0: {
                this.printString(indent + tab + "Permissions: NONE");
                break;
            }
            case 1: {
                this.printString(indent + tab + "Permissions: VIEW");
                break;
            }
            case 2: {
                this.printString(indent + tab + "Permissions: CHANGE");
            }
        }
        this.printNewLine();
    }

    public void printPermissionInfoList(String indent, String header, PermissionInfo[] value, boolean fieldFlag) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + tab, "Null PermissionInfo list..", "\n");
            return;
        }
        this.printInt(indent + tab, "Number of Items: ", value.length, "\n");
        for (int i = 0; i < value.length; ++i) {
            if (fieldFlag) {
                this.printFieldPermissionInfo(indent + tab, null, value[i]);
                continue;
            }
            this.printPermissionInfo(indent + tab, null, value[i]);
        }
        this.printNewLine();
    }

    public void printGroupInfo(String indent, String header, GroupInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Group ID: ", value.getId(), "\n");
        this.printInt(indent + tab, "Group Type: ", value.getGroupType(), "\n");
        this.printInt(indent + tab, "Group Category: ", value.getCategory(), "\n");
        this.printInt(indent + tab, "Group Parent: ", value.getGroupParent(), "\n");
        int overlay = value.getGroupOverLay();
        if (overlay == -2) {
            this.printString(indent + tab, "Group Overlay: ", "NULL");
        } else if (overlay == -1) {
            this.printString(indent + tab, "Group Overlay: ", "INVALID");
        } else {
            this.printInt(indent + tab, "Group Overlay: ", overlay, "\n");
        }
        this.printString(indent, "Group name(s): ", value.getName());
        this.printNewLine();
    }

    public void printGroupInfoList(String indent, String header, GroupInfo[] value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + tab, "Null GroupInfo List..", "\n");
            return;
        }
        this.printInt(indent + tab, "Number of Items: ", value.length, "\n");
        for (int i = 0; i < value.length; ++i) {
            this.printGroupInfo(indent + tab, null, value[i]);
        }
        this.printNewLine();
    }

    public void printRoleInfo(String indent, String header, RoleInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printLong(indent + tab, "Role ID: ", value.getId(), "\n");
        this.printString(indent + tab, "Role name: ", value.getName(), "\n");
        this.printLong(indent + tab, "Role Type: ", value.getRoleType(), "\n");
    }

    public void printRoleInfoList(String indent, String header, RoleInfo[] value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + tab, "Null RoleInfo List..", "\n");
            return;
        }
        this.printInt(indent + tab, "Number of Items: ", value.length, "\n");
        for (int i = 0; i < value.length; ++i) {
            this.printRoleInfo(indent + tab, null, value[i]);
        }
        this.printNewLine();
    }

    private String getLicenseType1String(int type) {
        switch (type) {
            case 0: {
                return "READ";
            }
            case 1: {
                return "FIXED";
            }
            case 2: {
                return "FLOATING";
            }
            case 3: {
                return "RESTRICTED READ";
            }
        }
        return "<undefined>";
    }

    private String getLicenseType2String(int type) {
        switch (type) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "FIXED";
            }
            case 2: {
                return "FLOATING";
            }
        }
        return "<undefined>";
    }

    private String getLicenseType3String(int type) {
        switch (type) {
            case 0: {
                return "READ";
            }
            case 1: {
                return "FIXED";
            }
            case 2: {
                return "FLOATING";
            }
        }
        return "<undefined>";
    }

    public void printUserLicenseInfo(String indent, String header, UserLicenseInfo value) {
        String type2;
        String type1;
        String tag;
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + tab, " Null UserLicenseInfo.....", "\n");
            return;
        }
        switch (value.getLicenseTag()) {
            case 1: {
                tag = "WRITE";
                type1 = this.getLicenseType1String(value.getLicenseType());
                type2 = this.getLicenseType1String(value.getCurrentLicenseType());
                break;
            }
            case 2: {
                tag = "FULL TEXT";
                type1 = this.getLicenseType2String(value.getLicenseType());
                type2 = this.getLicenseType2String(value.getCurrentLicenseType());
                break;
            }
            case 3: {
                tag = "RESERVED";
                type1 = this.getLicenseType3String(value.getLicenseType());
                type2 = this.getLicenseType3String(value.getCurrentLicenseType());
                break;
            }
            case 4: {
                tag = "APPLICATION";
                type1 = this.getLicenseType3String(value.getLicenseType());
                type2 = this.getLicenseType3String(value.getCurrentLicenseType());
                break;
            }
            default: {
                tag = "   <undefined operation = " + value.getLicenseTag();
                type1 = "";
                type2 = "";
            }
        }
        this.printString(indent + tab, "License Tag: ", tag, "\n");
        this.printString(indent + tab, "License Type: ", type1, "\n");
        this.printString(indent + tab, "Current License Type: ", type2, "\n");
        this.printInt(indent + tab, "    License Pool: ", value.getLicensePool(), "\n");
        this.printString(indent + tab, "License Descriptor: ", value.getAppLicenseDescriptor(), "\n");
        this.printNewLine();
    }

    public void printUserLicenseInfoList(String indent, String header, UserLicenseInfo[] value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + tab, "Null UserLicenseInfo list..", "\n");
            return;
        }
        this.printInt(indent + tab, "Number of Items: ", value.length, "\n");
        for (int i = 0; i < value.length; ++i) {
            this.printUserLicenseInfo(indent + tab, null, value[i]);
        }
        this.printNewLine();
    }

    public void printUserInfo(String indent, String header, UserInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printString(indent + tab, "User name: ", value.getUserName(), "\n");
        this.print(indent + tab, "license List: ", value.getLicenseInfo());
        this.printTimestamp(indent + tab, "Last Access Time: ", value.getLastAccessTime());
        this.printString(indent + tab, "Email Address: ", value.getEmailAddress(), "\n");
        this.printInt(indent + tab, "Default notify mechanism: ", value.getDefaultNotifyMechanism(), "\n");
        this.printTimestamp(indent + tab, "Connection Time: ", value.getConnectionTime());
        this.printNewLine();
    }

    public void printARServerUser(String indent, String header, ARServerUser value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent, " Null UserInfo....", "\n");
            return;
        }
        try {
            this.printBoolean(indent, "Admin Flag: ", value.isAdministrator(), "\n");
            this.printBoolean(indent, "SubAdmin Flag: ", value.isSubAdministrator(), "\n");
            this.printBoolean(indent, "Custom Flag: ", value.isMemberOfCustomizeGroup(), "\n");
        }
        catch (ARException e) {
            e.toString();
        }
    }

    public void printUserInfoList(String indent, String header, UserInfo[] value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + tab, "Null UserInfo list..", "\n");
            return;
        }
        this.printInt(indent + tab, "Number of Items: ", value.length, "\n");
        for (int i = 0; i < value.length; ++i) {
            this.printUserInfo(indent + tab, null, value[i]);
        }
        this.printNewLine();
    }

    public void printIntegerLimitInfo(String indent, String header, IntegerFieldLimit value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printLong(indent + tab, "High Range: ", value.getHighRange(), "\n");
        this.printLong(indent + tab, "Low Range : ", value.getLowRange(), "\n");
        this.printNewLine();
    }

    public void printRealLimitInfo(String indent, String header, RealFieldLimit value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printHeader(indent + tab, "High Range: " + value.getHighRange(), "\n");
        this.printHeader(indent + tab, "Low  Range: " + value.getLowRange(), "\n");
        this.printInt(indent + tab, "Precision: ", value.getPrecision(), "\n");
        this.printNewLine();
    }

    public void printCharLimitInfo(String indent, String header, CharacterFieldLimit value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Length Units:", value.getLengthUnits(), "\n");
        this.printInt(indent + tab, "CLOB Storage Option:", value.getStorageOptionForCLOB(), "\n");
        this.printInt(indent + tab, "Maximum length: ", value.getMaxLength(), "\n");
        this.printInt(indent + tab, "Menu style: ", value.getMenuStyle(), "\n");
        this.printInt(indent + tab, "QBE match operation: ", value.getQBEMatch(), "\n");
        this.printInt(indent + tab, "FullText Options:", value.getFullTextOption(), "\n");
        this.printString(indent + tab, "Character menu:", value.getCharMenu(), "\n");
        this.printString(indent + tab, "Pattern:", value.getPattern(), "\n");
        this.printNewLine();
    }

    public void printDiaryLimitInfo(String indent, String header, DiaryFieldLimit value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "FullText Options:", value.getFullTextOption(), "\n");
        this.printNewLine();
    }

    public void printAttachmentLimitInfo(String indent, String header, AttachmentFieldLimit value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printLong(indent + tab, "Maximum Size: ", value.getMaxSize(), "\n");
        this.printInt(indent + tab, "Attachment Type: ", value.getAttachType(), "\n");
        this.printInt(indent + tab, "FullText Options:", value.getFullTextOption(), "\n");
        this.printNewLine();
    }

    public void printTableLimitInfo(String indent, String header, TableFieldLimit value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printString(indent + tab, "Form: ", value.getForm(), "\n");
        this.printString(indent + tab, "Server: ", value.getServer(), "\n");
        this.printQualifierInfo(indent + tab, "Qualifier: ", value.getQualifier());
        this.printInt(indent + tab, "numColumns: ", value.getColumnCount(), "\n");
        this.printInt(indent + tab, "MaxRetrieve: ", value.getMaxRetrieve(), "\n");
        this.printString(indent + tab, "Sample Form: ", value.getSampleForm(), "\n");
        this.printString(indent + tab, "Sample Server: ", value.getSampleServer(), "\n");
        this.printNewLine();
    }

    public void printViewLimits(String indent, String header, ViewFieldLimit value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Maximum field Length: ", value.getMaxLength(), "\n");
        this.printNewLine();
    }

    public void printDisplayLimits(String indent, String header, DisplayFieldLimit value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Length Units: ", value.getLengthUnits(), "\n");
        this.printInt(indent + tab, "Maximum field Length: ", value.getMaxLength(), "\n");
        this.printNewLine();
    }

    public void printEnumItem(String indent, String header, EnumItem value) {
        if (value != null) {
            this.printString(indent + tab, "Name: ", value.getEnumItemName(), "\n");
            this.printLong(indent + tab, "Number: ", value.getEnumItemNumber(), "\n");
        } else {
            this.printString(indent + tab, "Enum Item: ", "null", "\n");
        }
    }

    public void printEnumItemList(String indent, String header, EnumItem[] value) {
        this.printHeader(indent, header, "\n");
        this.printInt(indent + tab, "Number of enum items: ", value.length, "\n");
        for (int i = 0; i < value.length; ++i) {
            this.printEnumItem(indent, header, value[i]);
        }
        this.printNewLine();
    }

    public void printEnumLimitInfo(String indent, String header, SelectionFieldLimit value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        int listStyle = value.getListStyle();
        this.printInt(indent + tab, "EnumList Style: ", value.getListStyle(), "\n");
        switch (listStyle) {
            case 1: {
                this.print(indent + tab, "Enum Values: ", value.getValues());
                this.printNewLine();
                break;
            }
            case 2: {
                this.print(indent + tab, "Enum Items: ", value.getValues());
                this.printNewLine();
                break;
            }
        }
    }

    public void printColumnLimitInfo(String indent, String header, ColumnFieldLimit value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Column Length: ", value.getColumnLength(), "\n");
        this.printInt(indent + tab, "Parent (Field ID ): ", value.getParent(), "\n");
        this.printInt(indent + tab, "Data Field: ", value.getDataField(), "\n");
        this.printNewLine();
    }

    public void printDecimalLimitInfo(String indent, String header, DecimalFieldLimit value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printHeader(indent + tab, "Low Range: " + value.getLowRange(), "\n");
        this.printHeader(indent + tab, "High Range: " + value.getHighRange(), "\n");
        this.printInt(indent + tab, "Precision: ", value.getPrecision(), "\n");
        this.printNewLine();
    }

    public void printCurrencyLimitInfo(String indent, String header, CurrencyFieldLimit value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printHeader(indent + tab, "Low Range: " + value.getLowRange(), "\n");
        this.printHeader(indent + tab, "High Range: " + value.getHighRange(), "\n");
        this.printInt(indent + tab, "Precision: ", value.getPrecision(), "\n");
        List<CurrencyDetail> functional = value.getFunctional();
        this.printResult("   Functional Currencies: " + functional.size() + "  items\n");
        for (int i = 0; i < functional.size(); ++i) {
            this.printString(indent + tab, "  Currency Code: ", functional.get(i).getCurrencyCode(), "\n");
            this.printInt(indent + tab, "   Precision:", functional.get(i).getPrecision(), "\n");
        }
        List<CurrencyDetail> allowable = value.getAllowable();
        this.printResult("   Allowable Currencies: " + allowable.size() + "  items\n");
        for (int i = 0; i < allowable.size(); ++i) {
            this.printString(indent + tab, " Currency Code: ", allowable.get(i).getCurrencyCode(), "\n");
            this.printInt(indent + tab, " Precision: ", allowable.get(i).getPrecision(), "\n");
        }
        this.printNewLine();
    }

    public void printCharMenuQueryInfo(String indent, String header, QueryMenu value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printString(indent + tab, "Form name: ", value.getForm(), "\n");
        this.printString(indent + tab, "Server name: ", value.getServer(), "\n");
        this.printIntList(indent + tab, "Label Field Id: ", value.getLabelField());
        this.printInt(indent + tab, "Value Field Id: ", value.getValueField(), "\n");
        this.printBoolean(indent + tab, "Sort on Label: ", value.isSortOnLabel(), "\n");
        this.printQualifierInfo(indent + tab, "Qualifier: ", value.getQualification());
        this.printString(indent + tab, "Sample Form name: ", value.getSampleForm(), "\n");
        this.printString(indent + tab, "Sample Server name: ", value.getSampleServer(), "\n");
        this.printNewLine();
    }

    public void printCharMenuSQLInfo(String indent, String header, SqlMenu value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printString(indent + tab, "Server name: ", value.getServer(), "\n");
        this.printString(indent + tab + "Label Index: ");
        List<Integer> LabelIndex = value.getLabelIndex();
        for (int i = 0; i < LabelIndex.size(); ++i) {
            if (LabelIndex.get(i) == 0) continue;
            if (i > 0) {
                this.printString(",");
            }
            this.printResult("" + LabelIndex.get(i));
        }
        this.printString("\n");
        this.printInt(indent + tab, "Value Index: ", value.getValueIndex(), "\n");
        this.printString(indent + tab, "SQL Command: ", value.getSQLCommand(), "\n");
        this.printNewLine();
    }

    public void printCharMenuItemInfo(String indent, String header, MenuItem value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + tab, "Null Char Menu list Info..", "\n");
            return;
        }
        this.printInt(indent + tab, "Type: ", value.getType(), "\n");
        this.printString(indent + tab, "Label: ", value.getLabel(), "\n");
        switch (value.getType()) {
            case 1: {
                String menuItem = value.getValue();
                this.printString(indent + tab, "Menu Item: ", menuItem, "\n");
                break;
            }
            case 2: {
                this.printCharMenuItemInfoList(indent + tab, "Char Menu List : ", value.getSubMenu());
                break;
            }
            default: {
                this.printString(indent + tab + "Invalid Menu Type : " + value.getType());
            }
        }
        this.printNewLine();
    }

    public void printCharMenuInfo(String indent, String header, Menu menu) {
        this.printHeader(indent, header, "\n");
        if (menu == null) {
            this.printHeader(indent + tab, "Null CharMenuInfo..", "\n");
            return;
        }
        this.printString(indent + tab + "Menu Type: ");
        switch (menu.getMenuType()) {
            case 1: {
                this.printString("", "", "LIST", "\n");
                this.printCharMenuListInfo(indent + tab, null, (ListMenu)menu);
                break;
            }
            case 2: {
                this.printString("", "", "QUERY", "\n");
                this.printCharMenuQueryInfo(indent + tab, null, (QueryMenu)menu);
                break;
            }
            case 3: {
                this.printString("", "", "FILE", "\n");
                this.printCharMenuFileInfo(indent + tab, null, (FileMenu)menu);
                break;
            }
            case 4: {
                this.printString("", "", "SQL", "\n");
                this.printCharMenuSQLInfo(indent + tab, null, (SqlMenu)menu);
                break;
            }
            default: {
                this.printString("", "", "Invalid menu type : " + menu.getMenuType(), "\n");
            }
        }
        this.printNewLine();
    }

    public void printCharMenuItemInfoList(String indent, String header, List<MenuItem> value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + tab, "Null CharMenuItemInfo list..", "\n");
            return;
        }
        this.printInt(indent + tab, "Number of Items: ", value.size(), "\n");
        for (int i = 0; i < value.size(); ++i) {
            this.printCharMenuItemInfo(indent + tab, null, value.get(i));
        }
        this.printNewLine();
    }

    public void printCharMenuListInfo(String indent, String header, ListMenu value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + tab, "Null Char Menu list Info..", "\n");
            return;
        }
        this.printCharMenuItemInfoList(indent + tab, "Char Menu List : ", value.getItems());
        this.printNewLine();
    }

    public void printCharMenuFileInfo(String indent, String header, FileMenu value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + tab, "Null Char Menu File Info..", "\n");
            return;
        }
        this.printString(indent + tab, "File Location: ", value.getLocation() == 1 ? "SERVER" : "CLIENT", "\n");
        if (value.getFileName() != null) {
            this.printString(indent + tab, "File Name: ", value.getFileName(), "\n");
        } else {
            this.printString(indent + tab, "File Name: ", "Null", "\n");
        }
        this.printNewLine();
    }

    public void printMenu(String indent, String header, Menu menu) {
        if (menu == null) {
            this.printString(indent + header + ": Null Menu");
            return;
        }
        if (menu.getName() != null) {
            this.printString(indent + tab, "Menu name : ", menu.getName(), "\n");
        }
        this.printInt(indent + tab, "Refresh Code: ", menu.getRefreshCode(), "\n");
        this.printCharMenuInfo(indent + tab, "Menu Information: ", menu);
        if (menu.getHelpText() != null) {
            this.printString(indent + tab, "Help Text: ", menu.getHelpText(), "\n");
        } else {
            this.printString(indent + tab + "Help Text: <null>");
        }
        if (menu.getOwner() != null) {
            this.printString(indent + tab, "Owner: ", menu.getOwner(), "\n");
        } else {
            this.printString(indent + tab + "Owner: null");
        }
        if (menu.getLastChangedBy() != null) {
            this.printString(indent + tab, "Last Changed: ", menu.getLastChangedBy(), "\n");
        } else {
            this.printString(indent + tab + "Last Changed: <null>");
        }
        if (menu.getDiary() != null) {
            this.printDiaryList(indent + tab, "Change DiaryList: ", menu.getDiary());
        } else {
            this.printString(indent + tab + "Change DiaryList: null ");
        }
        this.printPropertyMap(indent + tab, "Properties: ", menu.getProperties());
        this.printNewLine();
    }

    public void printMenuList(String indent, String header, Menu[] menuList) {
        this.printHeader(indent, header, "\n");
        if (menuList == null) {
            this.printHeader(indent + tab, "Null Menu list..", "\n");
            return;
        }
        this.printInt(indent + tab, "Number of Items: ", menuList.length, "\n");
        for (int i = 0; i < menuList.length; ++i) {
            this.printMenu(indent + tab, null, menuList[i]);
        }
        this.printNewLine();
    }

    public void printServerInfo(String indent, String header, ServerInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Operation: ", value.getOperation(), "\n");
        this.printValue(indent + tab, "Value: ", value.getValue());
        this.printNewLine();
    }

    public void printServerInfoList(String indent, String header, ServerInfo[] value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + tab, "Null ServerInfo list..", "\n");
            return;
        }
        this.printInt(indent + tab, "Number of Items: ", value.length, "\n");
        for (int i = 0; i < value.length; ++i) {
            this.printServerInfo(indent + tab, null, value[i]);
        }
        this.printNewLine();
    }

    public void printProcessResult(String indent, String header, ProcessResult result) {
        this.printHeader(indent, header, "\n");
        if (result == null) {
            this.printHeader(indent + tab, " Process Result is null....", "\n");
            return;
        }
        this.printInt(indent + tab, "Operation Status: ", result.getStatus(), "\n");
        this.printString(indent + tab, "Process Output: ", result.getOutput(), "\n");
        this.printNewLine();
    }

    public void printFieldMappingInfo(String indent, String header, FieldMapping value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        switch (value.getMappingType()) {
            case 0: {
                this.printHeader(indent + tab, "Field Type : NONE", "\n");
                break;
            }
            case 1: {
                this.printHeader(indent + tab, "Field Type : REGULAR", "\n");
                break;
            }
            case 2: {
                this.printHeader(indent + tab, "Field Type : JOIN", "\n");
                JoinFieldMapping joinMap = (JoinFieldMapping)value;
                this.printInt(indent + tab, "Form Index : ", joinMap.getIndex(), "\n");
                this.printInt(indent + tab, "Field ID     : ", joinMap.getFieldID(), "\n");
                break;
            }
            case 3: {
                this.printHeader(indent + tab, "Field Type : VIEW", "\n");
                ViewFieldMapping viewMap = (ViewFieldMapping)value;
                String viewFieldName = viewMap.getFieldName();
                this.printString(indent + tab, "Field Name : ", viewFieldName, "\n");
                break;
            }
            case 4: {
                this.printHeader(indent + tab, "Field Type : VENDOR", "\n");
                VendorFieldMapping vendorMap = (VendorFieldMapping)value;
                String vendorFieldName = vendorMap.getFieldName();
                this.printString(indent + tab, "Field Name : ", vendorFieldName, "\n");
                break;
            }
            default: {
                this.printInt(indent + tab, " Field Type: bad type - ", value.getMappingType(), "\n");
            }
        }
        this.printNewLine();
    }

    public void printFieldMappingInfoList(String indent, String header, FieldMapping[] value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + tab, "Null Field MappingInfo list..", "\n");
            return;
        }
        this.printInt(indent + tab, "Number of Items: ", value.length, "\n");
        for (int i = 0; i < value.length; ++i) {
            this.printFieldMappingInfo(indent + tab, null, value[i]);
        }
        this.printNewLine();
    }

    public void printContainerType(String indent, String header, ContainerType value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Container Type: ", value.toInt(), "\n");
        this.printNewLine();
    }

    public void printContainer(String indent, String header, Container value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        if (value.getName() != null) {
            this.printString(indent + tab, "Container Name: ", value.getName(), "\n");
        } else {
            this.printString(indent + tab + "Container Name: <null>");
        }
        if (value.getLabel() != null) {
            this.printString(indent + tab, "Label: ", value.getLabel(), "\n");
        } else {
            this.printString(indent + tab + "Container Label:<null> ");
        }
        if (value.getDescription() != null) {
            this.printString(indent + tab, "Description: ", value.getDescription(), "\n");
        } else {
            this.printString(indent + tab + "Container Description:<null> ");
        }
        this.print(indent, "Assigned Permission List:", value.getAssignedGroup());
        this.print(indent, "Complete Permission List:", value.getPermissions());
        this.printIntList(indent, "Sub Admin Group List: ", value.getAdminGroupList());
        this.print(indent + tab, "Container Owner: ", value.getContainerOwner());
        this.printString("", "Container Type: ", value.getClass().getSimpleName());
        if (value.getHelpText() != null) {
            this.printString(indent + tab, "Help Text: ", value.getHelpText(), "\n");
        } else {
            this.printString(indent + tab + "HelpText: <null>");
        }
        if (value.getOwner() != null) {
            this.printString(indent + tab, "Owner: ", value.getOwner(), "\n");
        } else {
            this.printString(indent + tab + "Owner: null");
        }
        if (value.getLastChangedBy() != null) {
            this.printString(indent + tab + "Last Changed: " + value.getLastChangedBy());
        } else {
            this.printString(indent + tab + "Last Changed: <null>");
        }
        if (value.getDiary() != null) {
            this.printDiaryList(indent + tab, "Change DiaryList: ", value.getDiary());
        } else {
            this.printString(indent + tab + "Change DiaryList: null ");
        }
        this.printPropertyMap(indent + tab, "Properties List: ", value.getProperties());
        this.print(indent + tab, "Reference Base List: ", value.getReferences());
        this.printNewLine();
    }

    public void printContainerList(String indent, String header, Container[] containerList) {
        this.printHeader(indent, header, "\n");
        if (containerList == null) {
            this.printHeader(indent + tab, "No Containers...", "\n");
            return;
        }
        this.printInt(indent + tab, "Number of Containers: ", containerList.length, "\n");
        for (int i = 0; i < containerList.length; ++i) {
            this.printContainer(indent + tab, "Container " + i + ":", containerList[i]);
        }
        this.printNewLine();
    }

    public void printContainerOwner(String indent, String header, ContainerOwner value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Owner Type: ", value.getType(), "\n");
        this.printString(indent + tab, "Owner Name: ", value.getName(), "\n");
        this.printNewLine();
    }

    public void printContainerOwnerList(String indent, String header, ContainerOwner[] value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        for (int i = 0; i < value.length; ++i) {
            this.printContainerOwner(indent + tab, "Container Owner" + i + ":", value[i]);
        }
        this.printNewLine();
    }

    public void printReference(String indent, String header, Reference value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + tab, "Null Reference....", "\n");
            return;
        }
        this.printString(indent + tab, "Name: ", value.getName(), "\n");
        this.printString(indent + tab, "Label: ", value.getLabel(), "\n");
        this.printString(indent + tab, "Description: ", value.getDescription(), "\n");
        this.printString(indent + tab, "Data Type: ", value.getClass().getSimpleName(), "\n");
        this.printReferenceType(indent + tab, "Reference Type : ", value.getReferenceType());
        if (value instanceof ExternalReference) {
            this.printExternalReference(indent, "External Reference Info:", (ExternalReference)value);
        } else {
            this.printString(indent, "Reference Name :", value.getName());
        }
        this.printNewLine();
    }

    public void printReferenceList(String indent, String header, Reference[] value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + tab, "Null Reference Base list..", "\n");
            return;
        }
        this.printInt(indent + tab, "Number of Items: ", value.length, "\n");
        for (int i = 0; i < value.length; ++i) {
            this.print(indent + tab, null, value[i]);
        }
        this.printNewLine();
    }

    public void printReferenceType(String indent, String header, ReferenceType value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        switch (value.toInt()) {
            case 0: {
                this.printHeader(indent + tab, "Type: NONE", "\n");
                break;
            }
            case 1: {
                this.printHeader(indent + tab, "Type: ALL", "\n");
                break;
            }
            case 2: {
                this.printHeader(indent + tab, "Type: SCHEMA", "\n");
                break;
            }
            case 3: {
                this.printHeader(indent + tab, "Type: FILTER", "\n");
                break;
            }
            case 4: {
                this.printHeader(indent + tab, "Type: ESCALATION", "\n");
                break;
            }
            case 5: {
                this.printHeader(indent + tab, "Type: ACTIVELINK", "\n");
                break;
            }
            case 6: {
                this.printHeader(indent + tab, "Type: CONTAINER", "\n");
                break;
            }
            case 7: {
                this.printHeader(indent + tab, "Type: CHAR_MENU", "\n");
                break;
            }
            case 8: {
                this.printHeader(indent + tab, "Type: IMAGE", "\n");
                break;
            }
            case 10: {
                this.printHeader(indent + tab, "Type: ASSOCIATION", "\n");
                break;
            }
            case 32788: {
                this.printHeader(indent + tab, "Type: APPLICATION_HAS_EXT_HELP", "\n");
                break;
            }
            case 32787: {
                this.printHeader(indent + tab, "Type: DISTMAPPING_DATA", "\n");
                break;
            }
            case 32786: {
                this.printHeader(indent + tab, "Type: GROUP_DATA", "\n");
                break;
            }
            case 32785: {
                this.printHeader(indent + tab, "Type: PACKINGLIST_PACK", "\n");
                break;
            }
            case 32784: {
                this.printHeader(indent + tab, "Type: PACKINGLIST_APP", "\n");
                break;
            }
            case 32783: {
                this.printHeader(indent + tab, "Type: PACKINGLIST_GUIDE", "\n");
                break;
            }
            case 32782: {
                this.printHeader(indent + tab, "Type: APPLICATION_HELP_FILE_NAME", "\n");
                break;
            }
            case 32781: {
                this.printHeader(indent + tab, "Type: APPLICATION_HELP_INDEX_FILE", "\n");
                break;
            }
            case 32780: {
                this.printHeader(indent + tab, "Type: APPLICATION_HELP_INDEX_EXT", "\n");
                break;
            }
            case 32779: {
                this.printHeader(indent + tab, "Type: APPLICATION_DISABLE_BEGIN_TASK", "\n");
                break;
            }
            case 32778: {
                this.printHeader(indent + tab, "Type: APPLICATION_FORM_VUI", "\n");
                break;
            }
            case 32777: {
                this.printHeader(indent + tab, "Type: APPLICATION_PRIMARY_FORM", "\n");
                break;
            }
            case 32776: {
                this.printHeader(indent + tab, "Type: APPLICATION_HELP_FILE", "\n");
                break;
            }
            case 32775: {
                this.printHeader(indent + tab, "Type: APPLICATION_HELP_EXT", "\n");
                break;
            }
            case 32774: {
                this.printHeader(indent + tab, "Type: NULL_STRING", "\n");
                break;
            }
            case 32773: {
                this.printHeader(indent + tab, "Type: ABOUT_BOX_FORM", "\n");
                break;
            }
            case 32772: {
                this.printHeader(indent + tab, "Type: ABOUT_BOX_IMAGE", "\n");
                break;
            }
            case 32771: {
                this.printHeader(indent + tab, "Type: APPLICATION_FORMS", "\n");
                break;
            }
            case 32770: {
                this.printHeader(indent + tab, "Type: MAXIMIZE_FORMS", "\n");
                break;
            }
            case 32768: {
                this.printHeader(indent + tab, "Type: ICON", "\n");
                break;
            }
            case 32769: {
                this.printHeader(indent + tab, "Type: SMALL_ICON", "\n");
                break;
            }
            case 32833: {
                this.printHeader(indent + tab, "Type: ARREF_ENCAPSULATED_APP_DATA", "\n");
                break;
            }
            case 32840: {
                this.printHeader(indent + tab, "Type: ARREF_APP_PACKING_LISTS", "\n");
                break;
            }
            case 32841: {
                this.printHeader(indent + tab, "Type: ARREF_APP_DATA_MERGE_IMP_QUAL", "\n");
                break;
            }
            case 32842: {
                this.printHeader(indent + tab, "Type: ARREF_APP_DATA_MERGE_IMP_OPTION", "\n");
                break;
            }
            default: {
                this.printInt(indent + tab, " Type: bad referencetype - ", value.toInt(), "\n");
            }
        }
    }

    public void printExternalReference(String indent, String header, ExternalReference value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printIntList(indent, "Admin Group List: ", value.getAdminGroupList());
        this.printValue(indent, "Value: ", value.getValue());
        this.printString(indent + tab, "Label: ", value.getLabel(), "\n");
        this.printString(indent + tab, "Description: ", value.getDescription(), "\n");
        this.printString(indent + tab, "Data Type: ", value.getClass().getSimpleName(), "\n");
        this.printReferenceType(indent + tab, "Reference Type : ", value.getReferenceType());
        this.printNewLine();
    }

    public void printReferenceList(String indent, String header, List<Reference> value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + tab, "Null Reference list..", "\n");
            return;
        }
        this.printInt(indent + tab, "Number of Items: ", value.size(), "\n");
        for (int i = 0; i < value.size(); ++i) {
            this.print(indent + tab, null, value.get(i));
        }
        this.printNewLine();
    }

    public void printReturnCode(String indent, int returnCode) {
        this.printHeader(indent + tab, "ReturnCode:  ", "\n");
        switch (returnCode) {
            case 0: {
                this.printHeader(indent + tab, "OK", "\n");
                break;
            }
            case 1: {
                this.printHeader(indent + tab, "WARNING", "\n");
                break;
            }
            case 2: {
                this.printHeader(indent + tab, "ERROR", "\n");
                break;
            }
            case 3: {
                this.printHeader(indent + tab, "FATAL", "\n");
                break;
            }
            case 4: {
                this.printHeader(indent + tab, "BAD STATUS", "\n");
                break;
            }
            default: {
                this.printInt(indent + tab, "<unknown return> : ", returnCode, "\n");
            }
        }
    }

    public void printView(String indent, String header, View view) {
        this.printHeader(indent, header, "\n");
        if (view == null) {
            this.printHeader(indent + tab, "Null View..", "\n");
            return;
        }
        if (view.getName() != null) {
            this.printString(indent + tab, "View name: ", view.getName(), "\n");
        } else {
            this.printString(indent + tab + "View name: <null>");
        }
        if (view.getVUIId() != 0) {
            this.printString(indent + tab, "View id: ", view.getVUIId() + "", "\n");
        } else {
            this.printString(indent + tab + "View id: <null>");
        }
        this.printPropertyMap(indent + tab, "Display Properties List: ", view.getDisplayProperties());
        if (view.getHelpText() != null) {
            this.printString(indent + tab, "Help Text: ", view.getHelpText(), "\n");
        } else {
            this.printString(indent + tab + "Help Text: <null>");
        }
        if (view.getOwner() != null) {
            this.printString(indent + tab, "Owner: ", view.getOwner(), "\n");
        } else {
            this.printString(indent + tab + "Owner: null");
        }
        if (view.getLastChangedBy() != null) {
            this.printString(indent + tab + "Last Changed: " + view.getLastChangedBy());
        } else {
            this.printString(indent + tab + "Last Changed: <null>");
        }
        if (view.getDiary() != null) {
            this.printDiaryList(indent + tab, "Change DiaryList: ", view.getDiary());
        } else {
            this.printString(indent + tab + "Change DiaryList: null ");
        }
        this.printPropertyMap(indent + tab, "Object Properties List: ", view.getObjectProperties());
        this.printNewLine();
    }

    public void printViewList(String indent, String header, View[] viewList) {
        this.printHeader(indent, header, "\n");
        if (viewList == null) {
            this.printHeader(indent + tab, "Null View list..", "\n");
            return;
        }
        this.printInt(indent + tab, "Number of Views: ", viewList.length, "\n");
        for (int i = 0; i < viewList.length; ++i) {
            this.printView(indent + tab, "View (" + i + ") :", viewList[i]);
        }
        this.printNewLine();
    }

    public void printFilter(String indent, String header, Filter filter) {
        this.printHeader(indent, header, "\n");
        if (filter == null) {
            this.printHeader(indent + tab, "Null Filter...", "\n");
            return;
        }
        if (filter.getName() != null) {
            this.printString(indent + tab, "Name: ", filter.getName(), "\n");
        } else {
            this.printString(indent + tab, "Name: <null>", "", "\n");
        }
        this.printLong(indent + tab, "Order: ", filter.getOrder(), "\n");
        this.print(indent + tab, "Form ", filter.getFormList());
        this.printLong(indent + tab, "Operation bit bitmask: ", filter.getOpSet(), "\n");
        this.printBoolean(indent + tab, "Enable flag: ", filter.isEnable(), "\n");
        this.printQualifierInfo(indent + tab, "", filter.getQualifier());
        this.print(indent + tab, "Filter Action List:", filter.getActionList());
        this.print(indent + tab, "Filter Action else list:", filter.getElseList());
        if (filter.getHelpText() != null) {
            this.printString(indent + tab, "Help Text: ", filter.getHelpText(), "\n");
        } else {
            this.printString(indent + tab + "HelpText: <null>");
        }
        if (filter.getOwner() != null) {
            this.printString(indent + tab, "Owner: ", filter.getOwner(), "\n");
        } else {
            this.printString(indent + tab + "Owner: null");
        }
        if (filter.getLastChangedBy() != null) {
            this.printString(indent + tab + "Last Changed: " + filter.getLastChangedBy());
        } else {
            this.printString(indent + tab + "Last Changed: <null>");
        }
        if (filter.getDiary() != null) {
            this.printDiaryList(indent + tab, "Change DiaryList: ", filter.getDiary());
        } else {
            this.printString(indent + tab + "Change DiaryList: null ");
        }
        this.printPropertyMap(indent + tab, "Properties List: ", filter.getProperties());
        this.printInt(indent + tab, "Error Handler Filter Options: ", filter.getErrorFilterOptions(), "\n");
        if (filter.getErrorHandlingFilter() != null) {
            this.printString(indent + tab, "Error Handler Name: ", filter.getErrorHandlingFilter(), "\n");
        } else {
            this.printString(indent + tab, "Error Handler Name: null", "\n");
        }
        this.printNewLine();
    }

    public void printFilterName(String indent, String header, Filter filter) {
        if (filter == null) {
            this.printHeader(indent, "Null Filter...", "\n");
            return;
        }
        if (filter.getName() != null) {
            this.printString(indent, "", filter.getName(), "\n");
        } else {
            this.printString(indent, "<null>", "", "\n");
        }
    }

    public void printFilterList(String indent, String header, Filter[] filterList) {
        this.printHeader(indent, header, "\n");
        if (filterList == null) {
            this.printHeader(indent + tab, "Null Filter list..", "\n");
            return;
        }
        this.printInt(indent + tab, "Number of Filters: ", filterList.length, "\n");
        for (int i = 0; i < filterList.length; ++i) {
            this.printFilter(indent + tab, "Filter " + i + " :", filterList[i]);
        }
        this.printNewLine();
    }

    public void printFilterListNames(String indent, String header, List<Filter> filterList) {
        this.printHeader(indent, header, "\n");
        if (filterList == null) {
            this.printHeader(indent + tab, "Null Filter list..", "\n");
            return;
        }
        this.printInt(indent + tab, "Number of Filters: ", filterList.size(), "\n");
        for (int i = 0; i < filterList.size(); ++i) {
            this.printFilterName(indent + tab, "Filter " + i + " :", filterList.get(i));
        }
        this.printNewLine();
    }

    public void printEscalation(String indent, String header, Escalation escalation) {
        this.printHeader(indent, header, "\n");
        if (escalation == null) {
            this.printHeader(indent + tab, "Null Escalation...", "\n");
            return;
        }
        if (escalation.getName() != null) {
            this.printString(indent + tab, "Name: ", escalation.getName(), "\n");
        } else {
            this.printString(indent + tab, "Name: <null>", "", "\n");
        }
        this.printEscalationTmInfo(indent + tab, "Escalation Time Information: ", escalation.getEscalationTm());
        this.print(indent + tab, "Form ", escalation.getFormList());
        this.printBoolean(indent + tab, "Enable flag: ", escalation.isEnable(), "\n");
        this.printQualifierInfo(indent + tab, "", escalation.getQualifier());
        this.print(indent + tab, "Filter Action List:", escalation.getActionList());
        this.print(indent + tab, "Filter Action else list:", escalation.getElseList());
        if (escalation.getHelpText() != null) {
            this.printString(indent + tab, "Help Text: ", escalation.getHelpText(), "\n");
        } else {
            this.printString(indent + tab + "HelpText: <null>");
        }
        if (escalation.getOwner() != null) {
            this.printString(indent + tab, "Owner: ", escalation.getOwner(), "\n");
        } else {
            this.printString(indent + tab + "Owner: null");
        }
        if (escalation.getLastChangedBy() != null) {
            this.printString(indent + tab + "Last Changed: " + escalation.getLastChangedBy());
        } else {
            this.printString(indent + tab + "Last Changed: <null>");
        }
        if (escalation.getDiary() != null) {
            this.printDiaryList(indent + tab, "Change DiaryList: ", escalation.getDiary());
        } else {
            this.printString(indent + tab + "Change DiaryList: null ");
        }
        this.printPropertyMap(indent + tab, "Properties List: ", escalation.getProperties());
        this.printNewLine();
    }

    public void printValidateFormCache(String indent, String header, ValidateFormCacheInfo fci) {
        this.printHeader(indent, header, "\n");
        if (fci == null) {
            this.printHeader(indent + tab, "Null ValidateFormCacheInfo...", "\n");
            return;
        }
        if (fci.getFormLastModified() != null) {
            this.printString(indent + tab, "Form last modified:", fci.getFormLastModified() + " (" + fci.getFormLastModified().toDate() + ")", "\n");
        } else {
            this.printString(indent + tab, "Form last modified: <null>", "", "\n");
        }
        if (fci.getGroupsLastChanged() != null) {
            this.printString(indent + tab, "Groups last changed:", fci.getGroupsLastChanged() + " (" + fci.getGroupsLastChanged().toDate() + ")", "\n");
        } else {
            this.printString(indent + tab, "Groups last changed: <null>", "", "\n");
        }
        if (fci.getUserLastChanged() != null) {
            this.printString(indent + tab, "User last changed:", fci.getUserLastChanged() + " (" + fci.getUserLastChanged().toDate() + ")", "\n");
        } else {
            this.printString(indent + tab, "User last changed: <null>", "", "\n");
        }
        this.printInt(indent + tab, "Number of active links for form:", fci.getNumActLinkOnForm(), "\n");
        this.printInt(indent + tab, "Number of active links changed:", fci.getNumActLinkSince(), "\n");
        if (fci.getMenuSinceList() != null) {
            this.print(indent + tab, "Character menus changed: ", fci.getMenuSinceList());
        } else {
            this.printString(indent + tab + "Character menus changed: <null>");
        }
        if (fci.getGuideSinceList() != null) {
            this.print(indent + tab, "Guides changed: ", fci.getGuideSinceList());
        } else {
            this.printString(indent + tab + "Guides changed: <null>");
        }
        this.printNewLine();
    }

    public void printEscalationName(String indent, String header, Escalation escalation) {
        if (escalation == null) {
            this.printHeader(indent, "Null Escalation...", "\n");
            return;
        }
        if (escalation.getName() != null) {
            this.printString(indent, "", escalation.getName(), "\n");
        } else {
            this.printString(indent, "<null>", "", "\n");
        }
    }

    public void printEscalationList(String indent, String header, List<Escalation> escalationList) {
        this.printHeader(indent, header, "\n");
        if (escalationList == null) {
            this.printHeader(indent + tab, "Null Escalation list..", "\n");
            return;
        }
        this.printInt(indent + tab, "Number of Escalations: ", escalationList.size(), "\n");
        for (int i = 0; i < escalationList.size(); ++i) {
            this.printEscalation(indent + tab, "Escalation " + i + " :", escalationList.get(i));
        }
        this.printNewLine();
    }

    public void printEscalationListNames(String indent, String header, List<Escalation> escalationList) {
        this.printHeader(indent, header, "\n");
        if (escalationList == null) {
            this.printHeader(indent + tab, "Null Escalation list..", "\n");
            return;
        }
        this.printInt(indent + tab, "Number of Escalations: ", escalationList.size(), "\n");
        for (int i = 0; i < escalationList.size(); ++i) {
            this.printEscalationName(indent + tab, "Escalation " + i + " :", escalationList.get(i));
        }
        this.printNewLine();
    }

    public void printEntryKey(String indent, String header, EntryKey key) {
        this.printHeader(indent, header, "\n");
        if (key == null) {
            return;
        }
        this.printString(indent + header + "Form:  " + key.getFormName() + "   EntryId: " + key.getEntryID());
    }

    public void printEntryKeyList(String indent, String header, EntryKey[] list) {
        this.printHeader(indent, header, "\n");
        if (list == null) {
            this.printHeader(indent + tab, "Null EntryKey list..", "\n");
            return;
        }
        this.printInt(indent + tab, "Number of Entries: ", list.length, "\n");
        for (int i = 0; i < list.length; ++i) {
            this.printEntryKey(indent + tab, "EntryKey " + (i + 1) + " :", list[i]);
        }
        this.printNewLine();
    }

    public void printFieldLimitInfo(String indent, String header, FieldLimit info) {
        this.printHeader(indent, header, "\n");
        if (info == null) {
            this.printHeader(indent + tab, "Null FieldLimitInfo..", "\n");
            return;
        }
        switch (info.getDataType()) {
            case 0: {
                this.printString("   NO LIMITS\n");
                break;
            }
            case 12: {
                this.printCurrencyLimitInfo(indent + tab, "Currency Field Limits:", (CurrencyFieldLimit)info);
                break;
            }
            case 2: {
                this.printIntegerLimitInfo(indent + tab, "Integer Field Limits:", (IntegerFieldLimit)info);
                break;
            }
            case 3: {
                this.printRealLimitInfo(indent + tab, "Real Field Limits:", (RealFieldLimit)info);
                break;
            }
            case 4: {
                this.printCharLimitInfo(indent + tab, "Char Field Limits:", (CharacterFieldLimit)info);
                break;
            }
            case 5: {
                this.printDiaryLimitInfo(indent + tab, "DiaryList Field Limits:", (DiaryFieldLimit)info);
                break;
            }
            case 6: {
                this.printEnumLimitInfo(indent + tab, "Enum Field Limits:", (SelectionFieldLimit)info);
                break;
            }
            case 7: {
                this.printString(indent + tab + "TIMESTAMP");
                break;
            }
            case 11: {
                this.printAttachmentLimitInfo(indent + tab, "Attach Field Limits:", (AttachmentFieldLimit)info);
                break;
            }
            case 10: {
                this.printDecimalLimitInfo(indent + tab, "Decimal Field Limits:", (DecimalFieldLimit)info);
                break;
            }
            case 33: {
                this.printTableLimitInfo(indent + tab, "Table Field Limits:", (TableFieldLimit)info);
                break;
            }
            case 34: {
                this.printColumnLimitInfo(indent + tab, "Column Field Limits:", (ColumnFieldLimit)info);
                break;
            }
            case 42: {
                this.printViewLimits(indent + tab, "View Field Limits:", (ViewFieldLimit)info);
                break;
            }
            case 43: {
                this.printDisplayLimits(indent + tab, "Display Field Limits:", (DisplayFieldLimit)info);
                break;
            }
            default: {
                this.printInt(indent + tab, "   <undefined datatype >:", info.getDataType(), "\n");
            }
        }
    }

    public void printDayInfo(String indent, String header, DayInfo dateInfo) {
        this.printHeader(indent, header, "\n");
        if (dateInfo == null) {
            return;
        }
        this.printLong(indent + tab, "Hour Mask: ", dateInfo.getHourmask(), "\n");
        this.printLong(indent + tab, "Minutes: ", dateInfo.getMinute(), "\n");
        this.printLong(indent + tab, "Month day: ", dateInfo.getMonthday(), "\n");
        this.printLong(indent + tab, "Week day: ", dateInfo.getWeekday(), "\n");
        this.printNewLine();
    }

    public void printEscalationTime(String indent, String header, EscalationTime value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printLong(indent + tab, "Hour Mask: ", value.getHourMask(), "\n");
        this.printLong(indent + tab, "Minutes: ", value.getMinute(), "\n");
        this.printLong(indent + tab, "Month day: ", value.getMonthDayMask(), "\n");
        this.printLong(indent + tab, "Week day: ", value.getWeekDayMask(), "\n");
        this.printNewLine();
    }

    public void printEscalationTmInfo(String indent, String header, EscalationTimeCriteria timeInfo) {
        this.printHeader(indent, header, "\n");
        if (timeInfo == null) {
            return;
        }
        if (timeInfo instanceof EscalationInterval) {
            this.printLong(indent + tab, "Time Interval: ", ((EscalationInterval)timeInfo).getValue(), "\n");
        } else if (timeInfo instanceof EscalationTime) {
            this.printEscalationTime(indent + tab, "Date Information:", (EscalationTime)timeInfo);
        } else {
            this.printString(indent + tab, "Wrong Time type: ", timeInfo.getClass().getSimpleName(), "\n");
        }
        this.printNewLine();
    }

    public void printSQLResult(String indent, String header, SQLResult result) {
        this.printHeader(indent, header, "\n");
        if (result == null) {
            return;
        }
        List<List<Value>> valueListList = result.getContents();
        this.printInt(indent + tab, "Number of Items: ", valueListList.size(), "\n");
        for (int i = 0; i < valueListList.size(); ++i) {
            this.print(indent + tab, "ValueList " + i + ": ", valueListList.get(i));
            this.printNewLine();
        }
        this.printInt(indent + tab, "Number of Matches: ", result.getTotalNumberOfMatches(), "\n");
    }

    public void printStatisticsResultInfo(String indent, String header, StatisticsResultInfo result) {
        this.printHeader(indent, header, "\n");
        if (result == null) {
            return;
        }
        this.printValue(indent + tab, "Stat value :", result.getResult());
        this.print(indent + tab, "Grouped By :", result.getGroupByValues());
        this.printNewLine();
    }

    public void printStatisticsResultInfoList(String indent, String header, StatisticsResultInfo[] list) {
        this.printHeader(indent, header, "\n");
        if (list == null) {
            return;
        }
        this.printInt(indent + tab, "Number of Items: ", list.length, "\n");
        for (int i = 0; i < list.length; ++i) {
            this.printStatisticsResultInfo(indent + tab, "StatisticsResultInfo " + i + " :", list[i]);
        }
        this.printNewLine();
    }

    public void printEntryList(String indent, String header, Entry[] entryList, boolean[] isPresent) {
        this.printHeader(indent, header, "\n");
        if (entryList == null) {
            return;
        }
        this.printInt(indent + tab, "Number of Entries: ", entryList.length, "\n");
        for (int i = 0; i < entryList.length; ++i) {
            if (isPresent[i]) {
                String entryId = entryList[i].getEntryId();
                this.print(indent + tab, "Entry Items of entry Id " + entryId + " : ", entryList[i]);
                continue;
            }
            this.printString(indent + tab, "Entry Id ", entryList[i].getEntryId() + "  is not present", "\n");
        }
    }

    public void printStatusHistoryString(String indent, String header, String historyString) {
        try {
            this.printHeader(indent, header, "\n");
            if (historyString == null) {
                return;
            }
            StatusHistoryValue statHistory = StatusHistoryValue.decode(historyString);
            int count = statHistory.size();
            for (int i = 0; i < count; ++i) {
                StatusHistoryItem item = (StatusHistoryItem)statHistory.get(i);
                this.printHeader(indent, "Status History Item " + i + " :", "\n");
                if (item.getUser() != null) {
                    this.printString(indent + tab, "User: ", item.getUser(), "\n");
                } else {
                    this.printString(indent + tab, "Null User Name ", "  ", "\n");
                }
                this.printTimestamp(indent + tab, "Time stamp: ", item.getTimestamp());
                this.printNewLine();
            }
            this.printNewLine();
        }
        catch (ARException e) {
            e.toString();
        }
    }

    public void printDiaryList(String indent, String header, String diaryString) {
        try {
            this.printHeader(indent, header, "\n");
            if (diaryString == null) {
                return;
            }
            DiaryListValue diaryList = DiaryListValue.decode(diaryString);
            this.printDiaryList(indent, header, diaryList);
        }
        catch (ARException e) {
            e.toString();
        }
    }

    public void printSupportFileKey(String indent, String header, SupportFileKey key) {
        this.printHeader(indent, header, "\n");
        if (key == null) {
            return;
        }
        this.printLong(indent + tab, "File Type:", key.getFileType(), "\n");
        String name = key.getName();
        if (name != null) {
            this.printString(indent + tab, "Name ID: ", name, "\n");
        } else {
            this.printString(indent + tab, "Name ID: ", "null", "\n");
        }
        this.printInt(indent + tab, "Field ID: ", key.getFieldId(), "\n");
        this.printLong(indent + tab, "File ID: ", key.getFileId(), "\n");
        this.printNewLine();
    }

    public void printSupportFile(String indent, String header, SupportFile supportFile) {
        this.printHeader(indent, header, "\n");
        if (supportFile == null) {
            this.printHeader(indent + tab, "Null supportFile...", "\n");
            return;
        }
        this.printSupportFileKey(indent + tab, "Support File Key:", supportFile.getKey());
        if (supportFile.getFilePath() != null) {
            this.printString(indent + tab, "FilePath: ", supportFile.getFilePath(), "\n");
        } else {
            this.printString(indent + tab, "FilePath: <null>", "", "\n");
        }
        this.printNewLine();
    }

    public void printSupportFileList(String indent, String header, SupportFile[] SupportFileList) {
        this.printHeader(indent, header, "\n");
        if (SupportFileList == null) {
            this.printHeader(indent + tab, "Null SupportFile list..", "\n");
            return;
        }
        this.printInt(indent + tab, "Number of Items : ", SupportFileList.length, "\n");
        for (int i = 0; i < SupportFileList.length; ++i) {
            this.printSupportFile(indent + tab, "SupportFile Info:", SupportFileList[i]);
        }
        this.printNewLine();
    }

    void printJoinForm(String indent, String header, JoinForm formInfo) {
        this.printHeader(indent, header, "\n");
        if (formInfo == null) {
            this.printHeader(indent + tab, "Join Form Info is not present < NULL >", "\n");
            return;
        }
        if (formInfo.getMemberA() == null) {
            this.printString(indent + tab + "Join MemberA is not present < NULL > ");
        } else {
            this.printString(indent + tab, "Join MemberA: ", formInfo.getMemberA(), "\n");
        }
        if (formInfo.getMemberB() == null) {
            this.printString(indent + tab + "Join MemberB is not present < NULL > ");
        } else {
            this.printString(indent + tab, "Join MemberB: ", formInfo.getMemberB(), "\n");
        }
        this.printInt(indent + tab, "Join Option: ", formInfo.getJoinOption(), "\n");
        this.printQualifierInfo(indent + tab, "Join Qualification: ", formInfo.getJoinQualification());
        this.printNewLine();
    }

    void printVendorForm(String indent, String header, VendorForm formInfo) {
        this.printHeader(indent, header, "\n");
        if (formInfo == null) {
            this.printHeader(indent + tab, "Vendor Form Info is not present < NULL >", "\n");
            return;
        }
        if (formInfo.getVendorName() == null) {
            this.printString(indent + tab + " Vendor Name is not present < NULL > ");
        } else {
            this.printString(indent + tab, "Vendor Name: ", formInfo.getVendorName(), "\n");
        }
        if (formInfo.getTableName() == null) {
            this.printString(indent + tab + "Vendor Table Name is not present < NULL > ");
        } else {
            this.printString(indent + tab, "Vendor Table Name: ", formInfo.getTableName(), "\n");
        }
        this.printNewLine();
    }

    void printViewForm(String indent, String header, ViewForm formInfo) {
        this.printHeader(indent, header, "\n");
        if (formInfo == null) {
            this.printHeader(indent + tab, "View Form Info is not present < NULL >", "\n");
            return;
        }
        if (formInfo.getTableName() == null) {
            this.printString(indent + tab + "View Table Name is not present < NULL > ");
        } else {
            this.printString(indent + tab, "View Table Name: ", formInfo.getTableName(), "\n");
        }
        if (formInfo.getKeyField() == null) {
            this.printString(indent + tab + "KeyField is not present < NULL > ");
        } else {
            this.printString(indent + tab, "KeyField: ", formInfo.getKeyField(), "\n");
        }
        this.printNewLine();
    }

    public void printForm(String indent, String header, Form form) {
        this.printHeader(indent, header, "\n");
        if (form == null) {
            this.printHeader(indent + tab, "Form is not present....", "\n");
            return;
        }
        this.printString("", "form name is: ", form.getName(), "\n");
        switch (form.getFormType()) {
            case 1: {
                this.printString("", "Form Type: ", "<REGULAR>", "\n");
                break;
            }
            case 2: {
                this.printString("", "Form Type: ", "<JOIN>", "\n");
                this.printJoinForm("", "Join Form Info:", (JoinForm)form);
                break;
            }
            case 3: {
                this.printString("", "Form Type: ", "<VIEW>", "\n");
                this.printViewForm("", "View Form Info:", (ViewForm)form);
                break;
            }
            case 5: {
                this.printString("", "Form Type: ", "<VENDOR>", "\n");
                this.printVendorForm("", "Vendor Form Info:", (VendorForm)form);
                break;
            }
            case 4: {
                this.printString("", "Form Type: ", "<DIALOG>", "\n");
            }
        }
        List<PermissionInfo> permissionList = form.getPermissions();
        this.printPermissionInfoList("", "Complete Permission List: ", permissionList, false);
        permissionList = form.getAssignedGroup();
        this.printPermissionInfoList("", "Assigned Permission List: ", permissionList, false);
        List<Integer> admingrp = form.getAdminGrpList();
        this.printIntList("", "Sub Admin Group List :", admingrp);
        List<EntryListFieldInfo> entrylist = form.getEntryListFieldInfo();
        this.printEntryListFieldInfoList("", "Entry List Field List: ", entrylist);
        List<SortInfo> sort = form.getSortInfo();
        this.print("", "Sort List :", sort);
        List<IndexInfo> index = form.getIndexInfo();
        this.printIndexInfoList("", "Index List : ", index);
        AssociationsToFollow assocToFollowForArchive = form.getAssociationToFollowForArchive();
        this.printAssociationsToFollow("", "Associations to follow for archive: ", assocToFollowForArchive);
        ArchiveInfo archive = form.getArchiveInfo();
        this.printArchiveInfo("", "Archive Info : ", archive);
        AuditInfo audit = form.getAuditInfo();
        this.printAuditInfo("", "Audit Info : ", audit);
        this.printString("Help text: " + form.getHelpText());
        this.printNewLine();
        long formModifedTime = form.getLastUpdateTime().getValue();
        this.printString("Last update time: " + formModifedTime);
        this.printNewLine();
        String owner = form.getOwner();
        this.printString("Owner: " + owner);
        this.printNewLine();
        this.printString("last changed by: " + form.getLastChangedBy());
        this.printNewLine();
        this.printDiaryList("", "Change History:", form.getDiary());
        ObjectPropertyMap props = form.getProperties();
        this.printPropertyMap("", "Prop List : ", props);
    }

    public void printAssociationsToFollow(String indent, String header, AssociationsToFollow assocToFollowForArchive) {
        if (assocToFollowForArchive == null) {
            assocToFollowForArchive = new AssociationsToFollow(AssociationSelectionType.NONE, null);
        }
        this.printHeader(indent, header, "\n");
        switch (assocToFollowForArchive.getSelectionType()) {
            case NONE: {
                this.printString(indent + tab, "Selection Type: ", "<NONE>", "\n");
                break;
            }
            case SPECIFIC_ONLY: {
                this.printString(indent + tab, "Selection Type: ", "<Specific Only>", "\n");
                break;
            }
            case ALL_ENFORCED: {
                this.printString(indent + tab, "Selection Type: ", "<All Enforced>", "\n");
                break;
            }
            case ALL: {
                this.printString(indent + tab, "Selection Type: ", "<ALL>", "\n");
            }
        }
        this.printAssociationNames(indent + tab, "Specific Association Names : ", assocToFollowForArchive.getSpecificAssociationNames());
    }

    public void printAssociationNames(String indent, String header, List<String> specificAssociationNames) {
        this.printHeader(indent, header, "\n");
        if (specificAssociationNames == null) {
            return;
        }
        this.printInt(indent + tab, "Number of associations: ", specificAssociationNames.size(), "\n");
        for (String assocName : specificAssociationNames) {
            this.printString(indent + tab + tab + "Association Name: " + assocName + "\n");
        }
    }

    public void printAssociation(String indent, String header, Association association) {
        this.printHeader(indent, header, "\n");
        if (association == null) {
            this.printHeader(indent + tab, "Association is not present....", "\n");
            return;
        }
        this.printString("", "association name : ", association.getName(), "\n");
        this.printString("", "Description: ", association.getDescription(), "\n");
        this.printString("Primary Form Name : " + association.getPrimaryFormName());
        this.printNewLine();
        this.printString("Secondary Form Name : " + association.getSecondaryFormName());
        this.printNewLine();
        this.printQualifierInfo("", "Primary Form Qualification: ", association.getPrimaryFormQualification());
        this.printQualifierInfo("", "Secondary Form Qualification: ", association.getSecondaryFormQualification());
        switch (association.getAssociationType()) {
            case 1: {
                this.printString("", "ASSOCIATION Type: ", "<DIRECT ASSOCIATION>", "\n");
                this.printDirectAssociation("", "Direct Association Info:", (DirectAssociation)association);
                break;
            }
            case 2: {
                this.printString("", "ASSOCIATION Type: ", "<INDIRECT ASSOCIATION>", "\n");
                this.printIndirectAssociation("", "INDIRECT Association Info:", (IndirectAssociation)association);
            }
        }
        this.printString("Cardinality : " + (Object)((Object)association.getCardinality()));
        this.printNewLine();
        this.printString("Enabled : " + association.isEnable());
        this.printNewLine();
        this.printString("Enforcement : " + (Object)((Object)association.getEnforcement()));
        this.printNewLine();
        this.printString("Help text: " + association.getHelpText());
        this.printNewLine();
        long formModifedTime = association.getLastUpdateTime().getValue();
        this.printString("Last update time: " + formModifedTime);
        this.printNewLine();
        String owner = association.getOwner();
        this.printString("Owner: " + owner);
        this.printNewLine();
        this.printString("last changed by: " + association.getLastChangedBy());
        this.printNewLine();
        this.printDiaryList("", "Change History:", association.getDiary());
        ObjectPropertyMap props = association.getProperties();
        this.printPropertyMap("", "Prop List : ", props);
    }

    public void printDirectAssociation(String indent, String header, DirectAssociation directAssoc) {
        this.printHeader(indent, header, "\n");
        if (directAssoc == null) {
            this.printHeader(indent + tab, "Null Field....", "\n");
            return;
        }
        this.printPKFKMappingSet(indent + tab, "PKFK Mapping Set", directAssoc.getPkfkMappingSet());
        this.printNewLine();
    }

    public void printIndirectAssociation(String indent, String header, IndirectAssociation indirectAssoc) {
        this.printHeader(indent, header, "\n");
        if (indirectAssoc == null) {
            this.printHeader(indent + tab, "Null Field....", "\n");
            return;
        }
        this.printString(indent + tab, "Association Form Name : ", indirectAssoc.getAssociationFormName(), "\n");
        this.printPKFKMappingSet(indent + tab, "PKFK Mapping Primary To AssociationForm", indirectAssoc.getKeyMappingToAssociationForm().getPrimaryFormKeyMapping());
        this.printPKFKMappingSet(indent + tab, "PKFK Mapping Secondary To Association Form", indirectAssoc.getKeyMappingToAssociationForm().getSecondaryFormKeyMapping());
        this.printQualifierInfo(indent + tab, "Association Form Qualification: ", indirectAssoc.getAssociationFormQualification());
        this.printNewLine();
    }

    public void printField(String indent, String header, Field field) {
        this.printHeader(indent, header, "\n");
        if (field == null) {
            this.printHeader(indent + tab, "Null Field....", "\n");
            return;
        }
        String fieldName = field.getName();
        this.printString(indent + tab, "Field Name: ", fieldName, "\n");
        this.printInt(indent + tab, "Field ID: ", field.getFieldID(), "\n");
        FieldMapping mapInfo = field.getFieldMap();
        this.printFieldMappingInfo(indent + tab, "FieldMapping:", mapInfo);
        DataType type = DataType.toDataType(field.getDataType());
        this.printDataType(tab, "DataType:", type);
        this.printInt(indent + tab, "Field Option: ", field.getFieldOption(), "\n");
        this.printInt(indent + tab, "Field Create Mode: ", field.getCreateMode(), "\n");
        this.printInt(indent + tab, "Field Bit Option: ", field.getAuditOption(), "\n");
        this.printFieldLimitInfo(indent + tab, "Field Limits:", field.getFieldLimit());
        this.printValue(indent + tab, "Default Value: ", field.getDefaultValue());
        this.printPermissionInfoList(indent + tab, "Assigned Group List: ", field.getAssignedGroup(), true);
        this.printPermissionInfoList(indent + tab, "Complete Group List: ", field.getPermissions(), true);
        this.printString(indent + tab, "Help Text: ", field.getHelpText(), "\n");
        this.printTimestamp(indent + tab, "Last changed: ", field.getLastUpdateTime());
        this.printString(indent + tab, "Owner: ", field.getOwner(), "\n");
        this.printDiaryList(indent + tab, "DiaryList: ", field.getDiary());
        this.print(indent + tab, "Display Instance List: ", field.getDisplayInstance());
        this.printPropertyMap(indent + tab, "Field Object Props: ", field.getObjectProperty());
    }

    public void printFieldList(String indent, String header, Field[] fieldList) {
        this.printHeader(indent, header, "\n");
        if (fieldList == null) {
            return;
        }
        this.printInt(indent + tab, "Number of Fields: ", fieldList.length, "\n");
        for (int i = 0; i < fieldList.length; ++i) {
            this.printField(indent + tab, "Field (" + i + ") Information: ", fieldList[i]);
        }
    }

    public void printFormAliasInfo(String indent, String header, FormAliasInfo value) {
        if (value == null) {
            return;
        }
        this.printString(indent + tab, "Name ID: ", value.getFormKey(), "\n");
        this.printString(indent + tab, "Alias  : ", value.getAlias(), "\n");
        this.printNewLine();
    }

    public void printAlertMessageInfo(String indent, String header, AlertMessageInfo message) {
        this.printHeader(indent, header, "\n");
        if (message == null) {
            this.printHeader(indent + tab, " NULL Message....", "\n");
            return;
        }
        this.printInt(indent + tab, "sourceType: ", message.getSourceType(), "\n");
        this.printInt(indent + tab, "priority: ", message.getPriority(), "\n");
        this.printString(indent + tab, "  alertText: ", message.getAlertText(), "\n");
        this.printString(indent + tab, "  sourceTag: ", message.getSourceTag(), "\n");
        this.printString(indent + tab, "  serverName: ", message.getServerName(), "\n");
        this.printString(indent + tab, "ServerAddress: ", message.getServerAddr(), "\n");
        this.printString(indent + tab, "  formName : ", message.getFormName(), "\n");
        this.printString(indent + tab, "  objectId : ", message.getObjectId(), "\n");
        this.printNewLine();
    }

    void printExtFormCandidatesInfo(String indent, String header, ExtFormCandidatesInfo result) {
        this.printHeader(indent, header, "\n");
        if (result == null) {
            this.printHeader(indent + tab, "External Form Info is not present <NULL>", "\n");
            return;
        }
        int type = 5;
        if (result.getVendorName().length() == 0 && result.getTableName() != null) {
            type = 3;
        }
        if (type == 5) {
            this.printString("", "Form Type: ", "VENDOR", "\n");
            this.printString(indent + tab, "Vendor Name: ", result.getVendorName(), "\n");
            this.printString(indent + tab, "Vendor Table Name: ", result.getTableName(), "\n");
        } else if (type == 3) {
            this.printString("", "Form Type: ", "VIEW", "\n");
            this.printString(indent + tab, "View Table Name: ", result.getTableName(), "\n");
        }
    }

    public void printExtFieldCandidatesInfo(String indent, String header, ExtFieldCandidatesInfo result) {
        this.printHeader(indent, header, "\n");
        if (result == null) {
            this.printHeader(indent + tab, " NULL result....", "\n");
            return;
        }
        this.printFieldMappingInfo(indent + tab, "FieldMapping:", result.getFieldMappingInfo());
        this.printFieldLimitInfo(indent + tab, "Field Limit Info: ", result.getFieldLimitInfo());
        this.printDataType(indent + tab, "DataType:", result.getDataType());
    }

    private String convertToHexadecimalString(byte b) {
        int number = b & 0xFF;
        StringBuilder hexString = new StringBuilder();
        String hexAlphas = "0123456789abcdef";
        hexString.append(hexAlphas.charAt(0xF & number >> 4));
        hexString.append(hexAlphas.charAt(0xF & number));
        return hexString.toString();
    }

    public void print(String indent, String header, String[] value) {
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Number of values: ", value.length, "\n");
        for (int i = 0; i < value.length; ++i) {
            this.printString(indent + tab, header, value[i], "\n");
        }
        this.printNewLine();
    }

    public void printString(String indent, String header, String value) {
        if (value == null) {
            return;
        }
        this.printString(indent + tab, header, value, "\n");
    }

    public void printLicensKeyIDList(String indent, String header, String[] value) {
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, header, value.length, "\n");
        for (int i = 0; i < value.length; ++i) {
            this.printString(indent + tab, "License Key ID: ", value[i], "\n");
        }
        this.printNewLine();
    }

    public void printLicenseValidInfo(String indent, String header, LicenseValidInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + tab, "Null LicenseValidInfo value...", "\n");
            return;
        }
        this.printInt(indent + tab, "Number Of Licenses: ", value.getNumLicenses(), "\n");
        this.printBoolean(indent + tab, "Is Demo: ", value.isDemo(), "\n");
        this.printString(indent + tab, "Expire Date: ", value.getExpireDate().toString(), "\n");
        this.printString(indent + tab, "Token List: ", value.getTokenList(), "\n");
        this.printNewLine();
    }

    public void printLicenseValidList(String indent, String header, LicenseValidInfo[] value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Number of values: ", value.length, "\n");
        for (int i = 0; i < value.length; ++i) {
            this.printLicenseValidInfo(indent + tab, "", value[i]);
        }
        this.printNewLine();
    }

    public void printLicenseInfo(String indent, String header, LicenseInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            this.printHeader(indent + tab, "Null LicenseInfo value...", "\n");
            return;
        }
        this.printString(indent, "License Type: ", value.getlicType());
        this.printString(indent, "License Key: ", value.getlicKey());
        this.printString(indent, "License Sub Type: ", value.getlicSubtype());
        this.printString(indent + tab, "Expire Date: ", value.getExpireDate().toString(), "\n");
        this.printString(indent + tab, "Expire Date: ", value.getIssuedDate().toString(), "\n");
        this.printString(indent + tab, "Site Name: ", value.getSiteName(), "\n");
        this.printString(indent + tab, "Host ID: ", value.getHostId(), "\n");
        this.printInt(indent + tab, "Number Of Licenses: ", value.getNumLicenses(), "\n");
        this.printString(indent + tab, "Token List: ", value.getTokenList(), "\n");
        this.printString(indent + tab, "Comment: ", value.getComment(), "\n");
        this.printNewLine();
    }

    public void printLicenseInfoList(String indent, String header, LicenseInfo[] value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        this.printInt(indent + tab, "Number of values: ", value.length, "\n");
        for (int i = 0; i < value.length; ++i) {
            this.printLicenseInfo(indent + tab, "", value[i]);
        }
        this.printNewLine();
    }

    public void printEntryPoint(String indent, String header, EntryPointInfo value) {
        this.printHeader(indent, header, "\n");
        if (value == null) {
            return;
        }
        if (value.getName() != null) {
            this.printString(indent + tab, "Entry Point Name: ", value.getName(), "\n");
        } else {
            this.printString(indent + tab + "Entry Point Name: <null>\n");
        }
        this.printInt(indent + tab, "Entry Point Type: ", value.getType(), "\n");
        if (value.getEntryPointDisplayLabel() != null) {
            this.printString(indent + tab, "Entry Point Display Label: ", value.getEntryPointDisplayLabel(), "\n");
        } else {
            this.printString(indent + tab + "Entry Point Display Label:<null> \n");
        }
        if (value.getOwnerAppName() != null) {
            this.printString(indent + tab, "Entry Point Owner Application Name: ", value.getOwnerAppName(), "\n");
        } else {
            this.printString(indent + tab + "Entry Point Owner Application Name: <null>\n");
        }
        if (value.getOwnerAppDisplayLabel() != null) {
            this.printString(indent + tab, "Entry Point Owner Application Display Label: ", value.getOwnerAppDisplayLabel(), "\n");
        } else {
            this.printString(indent + tab + "Entry Point Owner Application Display Label:<null>\n");
        }
        this.printPermissionInfoList(indent, "Permission List:", value.getPermissions(), false);
        this.print(indent + tab, "Entry Point Owner: ", value.getOwnerObjList());
        if (value.getDescription() != null) {
            this.printString(indent + tab, "Description: ", value.getDescription(), "\n");
        } else {
            this.printString(indent + tab + "Entry Point Description:<null>\n");
        }
        this.printReferenceList(indent + tab, "Reference Base List: ", value.getReferences());
        if (value.getHelpText() != null) {
            this.printString(indent + tab, "Help Text: ", value.getHelpText(), "\n");
        } else {
            this.printString(indent + tab + "HelpText: <null>\n");
        }
        this.print(indent + tab, "Properties List: ", value.getProps());
        this.printNewLine();
    }

    public void printBulkEntryReturnList(String indent, String header, List<BulkEntryReturn> returnList) {
        this.printHeader(indent, header, "\n");
        if (returnList == null) {
            return;
        }
        this.printInt(indent, "Number of calls: ", returnList.size(), "\n");
        block5: for (int i = 0; i < returnList.size(); ++i) {
            List<StatusInfo> statusList = returnList.get(i).getStatusList();
            this.printInt(indent, "Call type: ", returnList.get(i).getCallType(), "\n");
            switch (returnList.get(i).getCallType()) {
                case 1: 
                case 4: {
                    this.printEntryReturn(indent + "   ", (EntryReturn)returnList.get(i));
                    this.printStatusInfoList("      ", "Call Status", statusList);
                    continue block5;
                }
                case 2: 
                case 3: 
                case 7: {
                    this.printStatusInfoList("      ", "Call Status", statusList);
                    continue block5;
                }
                case 5: 
                case 6: {
                    this.printXMLEntryReturn(indent + "   ", (XMLEntryReturn)returnList.get(i));
                    this.printStatusInfoList("      ", "Call Status", statusList);
                }
                default: {
                    this.printString(indent + "<undefined call type> ");
                }
            }
        }
        this.printNewLine();
    }

    public void printEntryReturn(String indent, EntryReturn value) {
        this.printString(indent + "Entry Id: " + value.getEntryId());
        this.printNewLine();
    }

    public void printXMLEntryReturn(String indent, XMLEntryReturn value) {
        if (value.getOutputDoc() != null) {
            this.printString(indent + "Output Doc: " + value.getOutputDoc());
        } else {
            this.printString(indent + "Output Doc is null\n");
        }
        this.printNewLine();
    }

    public String WfdGetStageText(int stage) {
        switch (stage) {
            case 0: {
                return "Idle...";
            }
            case 1: {
                return "Busy...";
            }
            case 2: {
                return "pre-API";
            }
            case 3: {
                return "pre-Qual";
            }
            case 4: {
                return "Phase 1";
            }
            case 5: {
                return "Phase 2";
            }
            case 6: {
                return "Phase 3";
            }
            case 7: {
                return "Escalation";
            }
            case 9: {
                return "post-API";
            }
            case 8: {
                return "CMDB";
            }
        }
        return "????";
    }

    public void printCurrentLocation(String header, WfdDebugLocation location) {
        this.printString(header);
        switch (location.Stage) {
            case 0: {
                this.printString("Idle...\n");
                break;
            }
            case 1: {
                this.printString("Busy...\n");
                break;
            }
            case 2: 
            case 9: {
                this.printString("(" + this.WfdGetStageText(location.Stage) + ")" + location.ApiCall + "\n");
                break;
            }
            case 3: {
                this.printString("(" + this.WfdGetStageText(location.Stage) + ") " + location.ApiCall + "->" + location.SchemaName + "->" + location.Filter + "\n");
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.printString("(" + this.WfdGetStageText(location.Stage) + ") " + location.ApiCall + "->" + location.SchemaName + "->" + location.Filter + "->action #" + location.ActionNo + " (" + location.ActionStr + ")" + (location.ActionDeferred ? " - deferred" : "") + "\n");
                break;
            }
            case 8: {
                this.printString("(" + this.WfdGetStageText(location.Stage) + ")" + location.ApiCall + "->" + location.SchemaName + "\n");
                break;
            }
            default: {
                this.printString("????...\n");
            }
        }
    }

    public void printWfdUserContext(String header, WfdUserContext userInfo) {
        if (userInfo.user == null || userInfo.user.equals("")) {
            this.print("", "", "   ...Not Available...");
            return;
        }
        this.printString(header);
        this.printString("      User name : " + userInfo.user + "\n");
        this.printString("      Default notify mechanism : " + userInfo.notifyMech + "\n");
        UserLicenseInfo[] a = userInfo.licenseList.toArray(new UserLicenseInfo[userInfo.licenseList.size()]);
        this.printUserLicenseInfoList("", "License List : ", a);
        this.printString("      License Type : " + this.getLicenseType1String(userInfo.licenseType) + "\n");
        this.printString("      Current License Type : " + this.getLicenseType1String(userInfo.currentLicenseType) + "\n");
        this.printString("      Full License Type : " + this.getLicenseType1String(userInfo.fullLicType) + "\n");
        this.printString("      Current Full License Type : " + this.getLicenseType1String(userInfo.currentFullLicType) + "\n");
        this.print("      Group List : ", "", userInfo.groupList);
        this.printString("      Administrator Flag : " + userInfo.adminFlag + "\n");
        this.printString("      SubAdministrator Flag : " + userInfo.subadminFlag + "\n");
    }

    public void printBreakpoint(String header, WfdBreakpoint bp, boolean local) {
        this.printString(" -- " + (local ? "Local Bkpt " : "BreakPoint ") + bp.id + ":" + (bp.disable ? "[disabled]" : "") + (bp.passcount > 0 ? "[passcnt=%d]" : "") + "\n");
        this.printString("   Filter:\"" + bp.filter + "\"  Schema:\"" + bp.schema + "\"" + " (" + this.WfdGetStageText(bp.stage) + ") (" + (bp.elsePath ? "else" : "if") + ") action #" + bp.actionNo + "\n");
        if (bp.bpQualifier != null && bp.bpQualifier.getOperation() != 0) {
            this.printQualifierInfo("", "", bp.bpQualifier);
        }
        this.printString("\n");
    }

    public void printQuerySource(String indent, String header, IQuerySource source) {
        if (source == null) {
            return;
        }
        this.printString(indent + source.toStringShort());
    }

    public void printARSetGetStatusException(ARSetGetEntryException e) {
        this.printString("Set Get Entry Status...\n");
        this.printStatusInfoList("", "seStatus", e.getStatus1());
        this.printNewLine();
        this.printStatusInfoList("", "geStatus", e.getStatus2());
        this.printNewLine();
    }

    public void printOverlayPropInfo(String indent, String header, OverlayPropInfo overlayProps) {
        this.printHeader(indent, header, "\n");
        if (overlayProps == null) {
            this.printHeader(indent + tab, "Null Overlay object Info...", "\n");
            return;
        }
        if (overlayProps.getName() != null) {
            this.printString(indent + tab, "Name: ", overlayProps.getName(), "\n");
        } else {
            this.printString(indent + tab, "Name: <null>", "", "\n");
        }
        this.printInt(indent + tab, "Id: ", overlayProps.getId(), "\n");
    }

    private String getObjectType(int e) {
        switch (e) {
            case 1: {
                return "Form";
            }
            case 20: {
                return "Association";
            }
            case 5: {
                return "Filter";
            }
            case 9: {
                return "Escalation";
            }
            case 12: {
                return "Container";
            }
            case 15: {
                return "Field";
            }
            case 17: {
                return "Image";
            }
            case 6: {
                return "Active Link";
            }
            case 8: {
                return "Menu";
            }
        }
        return "Unknown Object";
    }
}

