/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.internal.ARStructMemTypeInfo;
import com.bmc.arsys.api.internal.ARStructTypeInfo;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@ARStructTypeInfo(Name="ARGroupInfoStruct", NumberOfMembers=6)
public class GroupInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -8040538351346515271L;
    @ARStructMemTypeInfo(Name="groupId", Offset=0)
    private int m_groupId;
    @ARStructMemTypeInfo(Name="groupType", Offset=1)
    private int m_groupType;
    @ARStructMemTypeInfo(Name="groupName", Offset=2)
    private List<String> m_groupNames;
    @ARStructMemTypeInfo(Name="groupCategory", Offset=3)
    private int m_groupCategory;
    @ARStructMemTypeInfo(Name="groupParent", Offset=4)
    private int m_groupParent;
    @ARStructMemTypeInfo(Name="groupOverlay", Offset=5)
    private int m_groupOverlay = -2;

    protected GroupInfo() {
    }

    protected GroupInfo(int groupId, int groupType, List<String> groupNames, int groupCategory, int arInternalId, int groupOverlay) {
        this.m_groupId = groupId;
        this.m_groupType = groupType;
        this.m_groupNames = groupNames;
        this.m_groupCategory = groupCategory;
        this.m_groupParent = arInternalId;
        this.m_groupOverlay = groupOverlay;
    }

    protected GroupInfo(int groupId, int groupType, List<String> groupNames, int groupCategory) {
        this.m_groupId = groupId;
        this.m_groupType = groupType;
        this.m_groupNames = groupNames;
        this.m_groupCategory = groupCategory;
    }

    public int getId() {
        return this.m_groupId;
    }

    public int getGroupType() {
        return this.m_groupType;
    }

    public int getCategory() {
        return this.m_groupCategory;
    }

    public String getName() {
        if (this.m_groupNames != null && !this.m_groupNames.isEmpty()) {
            return this.m_groupNames.get(0);
        }
        return "";
    }

    public List<String> getGroupNames() {
        return this.m_groupNames;
    }

    public int getGroupParent() {
        return this.m_groupParent;
    }

    public int getGroupOverLay() {
        return this.m_groupOverlay;
    }

    public Object clone() throws CloneNotSupportedException {
        GroupInfo info = null;
        info = (GroupInfo)super.clone();
        if (this.m_groupNames != null) {
            int nLen = this.m_groupNames.size();
            info.m_groupNames = new ArrayList<String>(nLen);
            for (int i = 0; i < nLen; ++i) {
                info.m_groupNames.add(i, this.m_groupNames.get(i));
            }
        }
        return info;
    }

    public String toString() {
        ToStringBuilder t = new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Group Id", this.m_groupId).append("Group Type", this.m_groupType).append("Group Names", this.m_groupNames).append("Group Category", this.m_groupCategory).append("Group Parent", this.m_groupParent);
        if (this.m_groupOverlay == -2) {
            t.append("Group Overlay", "NULL");
        } else if (this.m_groupOverlay == -1) {
            t.append("Group Overlay", "INVALID");
        } else {
            t.append("Group Overlay", this.m_groupOverlay);
        }
        return t.toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.m_groupId).append(this.m_groupType).append(this.m_groupNames).append(this.m_groupCategory).append(this.m_groupParent).append(this.m_groupOverlay).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GroupInfo)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GroupInfo rhs = (GroupInfo)obj;
        return new EqualsBuilder().append(this.m_groupId, rhs.m_groupId).append(this.m_groupType, rhs.m_groupType).append(this.m_groupNames, rhs.m_groupNames).append(this.m_groupCategory, rhs.m_groupCategory).append(this.m_groupParent, rhs.m_groupParent).append(this.m_groupOverlay, rhs.m_groupOverlay).isEquals();
    }
}

