/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.apitransport.ApiProxyI;
import com.bmc.arsys.apitransport.ApiUserContextBase;
import com.bmc.arsys.apitransport.ApiUserContextI;
import com.bmc.arsys.apitransport.connection.ApiDefaultProxyAbstractManager;
import com.bmc.arsys.apitransport.session.ApiThreadLocalStorageBlock;
import com.bmc.arsys.utils.ProcessUtil;
import org.apache.log4j.Logger;

public class DefaultProxyManager
extends ApiDefaultProxyAbstractManager {
    private static Logger logger = Logger.getLogger(DefaultProxyManager.class);

    DefaultProxyManager() {
    }

    @Override
    public synchronized ApiProxyI getProxy(ApiUserContextI context) throws ARException {
        boolean isCMDBCall;
        ApiProxyI proxy;
        if (context instanceof ApiUserContextBase && !((ApiUserContextBase)context).isProxyInMultiThreadTransaction()) {
            ((ApiUserContextBase)context).proxyILock.lock();
        }
        if ((proxy = (isCMDBCall = ApiThreadLocalStorageBlock.getTLB().isCMDBCall()) ? context.getCMDBProxyI() : context.getProxyI()) == null) {
            if (context.getServer() == null || context.getServer().length() == 0) {
                throw new ARException(2, 150);
            }
            logger.trace("Created none pooling proxy for " + context.getUser() + "; current thread = " + Thread.currentThread() + "; total activeThread = " + Thread.activeCount());
            proxy = this.createProxy(context);
            if (context.getPort() != 0 || context.getServerRpcQueueNumber() != 0) {
                proxy.ARSetServerPort(context, context.getPort(), context.getServerRpcQueueNumber());
            }
            if (isCMDBCall) {
                context.setCMDBProxyI(proxy);
            } else {
                context.setProxyI(proxy);
            }
        }
        proxy.setProxyProperties(context);
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void releaseProxy(ApiProxyI proxy, ApiUserContextI context) {
        if (proxy == null) {
            return;
        }
        try {
            long connectionLifespan = DefaultProxyManager.getConnectionLifespanMilliSec();
            long establishedTime = proxy.getEstablishTime();
            boolean isARProxy = context.isProxyInContext();
            boolean isCMDBProxy = ApiThreadLocalStorageBlock.getTLB().isCMDBCall();
            String proxyId = null;
            if (logger.isInfoEnabled()) {
                proxyId = proxy.toString();
            }
            long c = System.currentTimeMillis();
            if ((proxy = this.checkAndTerminateProxyIfNeededForLoadBalance(null, proxy, context, connectionLifespan)) == null) {
                if (isARProxy) {
                    context.setProxyI(proxy);
                    if (logger.isInfoEnabled()) {
                        logger.info("terminated an AR connection " + proxyId + " in " + context.getUser() + " for load_balance after establed for " + ProcessUtil.getElapsedTimeToFormatedString(c - establishedTime));
                    }
                } else if (isCMDBProxy) {
                    context.setCMDBProxyI(proxy);
                    if (logger.isInfoEnabled()) {
                        logger.info("terminated an CMDB connection " + proxyId + " in " + context + " for load_balance after establed for " + ProcessUtil.getElapsedTimeToFormatedString(c - establishedTime));
                    }
                }
            }
        }
        finally {
            int cnt;
            if (context instanceof ApiUserContextBase && (cnt = ((ApiUserContextBase)context).proxyILock.getHoldCount()) > 0) {
                ((ApiUserContextBase)context).proxyILock.unlock();
            }
        }
    }
}

