/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.FieldOperandInfo;
import com.bmc.arsys.api.FunctionCode;
import com.bmc.arsys.api.FunctionOperandInfo;
import com.bmc.arsys.api.IQuerySource;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.util.ArrayList;
import java.util.List;

public abstract class ComplexQueryBase {
    private List<IQuerySource> sources;
    private List<ArithmeticOrRelationalOperand> selectionList;
    private QualifierInfo qualifier;
    private List<QualifierInfo> having;
    private List<ArithmeticOrRelationalOperand> groupBy;
    private boolean distinct;

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public List<IQuerySource> getFromSources() {
        if (this.sources == null) {
            this.sources = new ArrayList<IQuerySource>();
        }
        return this.sources;
    }

    public void setFromSources(List<IQuerySource> sources) {
        this.sources = sources;
    }

    public List<ArithmeticOrRelationalOperand> getSelectionList() {
        if (this.selectionList == null) {
            this.selectionList = new ArrayList<ArithmeticOrRelationalOperand>();
        }
        return this.selectionList;
    }

    public void setSelectionList(List<ArithmeticOrRelationalOperand> selectionList) {
        this.selectionList = selectionList;
    }

    public QualifierInfo getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(QualifierInfo qualifier) {
        this.qualifier = qualifier;
    }

    public boolean addFromSource(IQuerySource source) {
        return this.getFromSources().add(source);
    }

    public boolean addFromOperand(ArithmeticOrRelationalOperand operand) {
        return this.getSelectionList().add(operand);
    }

    public boolean addFromFunctionOperand(int funcCode, List<ArithmeticOrRelationalOperand> params) {
        FunctionOperandInfo function = new FunctionOperandInfo(FunctionCode.getFunctionCode(funcCode), params);
        return this.getSelectionList().add(new ArithmeticOrRelationalOperand(function));
    }

    public boolean addFromFieldOperand(int fieldId, IQuerySource source) {
        FieldOperandInfo field = new FieldOperandInfo(fieldId, source);
        ArithmeticOrRelationalOperand operand = new ArithmeticOrRelationalOperand(field);
        return this.getSelectionList().add(operand);
    }

    public void setHaving(List<QualifierInfo> having) {
        this.having = having;
    }

    public void setGroupBy(List<ArithmeticOrRelationalOperand> groupBy) {
        this.groupBy = groupBy;
    }

    public List<QualifierInfo> getHavingList() {
        return this.having;
    }

    public QualifierInfo getHaving() {
        if (this.having == null) {
            return null;
        }
        return this.having.get(0);
    }

    public List<ArithmeticOrRelationalOperand> getGroupBy() {
        return this.groupBy;
    }

    public boolean addHaving(QualifierInfo having) {
        if (having != null) {
            if (this.having == null) {
                this.having = new ArrayList<QualifierInfo>();
            }
            return this.having.add(having);
        }
        return false;
    }

    public boolean addGroupBy(ArithmeticOrRelationalOperand groupBy) {
        if (groupBy != null) {
            if (this.groupBy == null) {
                this.groupBy = new ArrayList<ArithmeticOrRelationalOperand>();
            }
            return this.groupBy.add(groupBy);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        int i;
        ComplexQueryBase obj = (ComplexQueryBase)super.clone();
        if (this.selectionList != null) {
            ArrayList<ArithmeticOrRelationalOperand> fromFieldsCloned = new ArrayList<ArithmeticOrRelationalOperand>();
            for (i = 0; i < this.selectionList.size(); ++i) {
                ArithmeticOrRelationalOperand field = this.selectionList.get(i);
                if (field != null) {
                    fromFieldsCloned.add((ArithmeticOrRelationalOperand)field.clone());
                    continue;
                }
                fromFieldsCloned.add(null);
            }
            obj.selectionList = fromFieldsCloned;
        }
        if (this.sources != null) {
            ArrayList<IQuerySource> sourcesCloned = new ArrayList<IQuerySource>();
            for (i = 0; i < this.sources.size(); ++i) {
                IQuerySource source = this.sources.get(i);
                if (source != null) {
                    sourcesCloned.add((IQuerySource)source.clone());
                    continue;
                }
                sourcesCloned.add(null);
            }
            obj.sources = sourcesCloned;
        }
        if (this.qualifier != null) {
            obj.qualifier = (QualifierInfo)this.qualifier.clone();
        }
        if (this.having != null) {
            ArrayList<QualifierInfo> havingCloned = new ArrayList<QualifierInfo>();
            for (i = 0; i < this.having.size(); ++i) {
                QualifierInfo havingItem = this.having.get(i);
                if (havingItem != null) {
                    havingCloned.add((QualifierInfo)havingItem.clone());
                    continue;
                }
                havingCloned.add(null);
            }
            obj.having = havingCloned;
        }
        if (this.groupBy != null) {
            ArrayList<ArithmeticOrRelationalOperand> groupByClones = new ArrayList<ArithmeticOrRelationalOperand>();
            for (i = 0; i < this.groupBy.size(); ++i) {
                ArithmeticOrRelationalOperand groupByItem = this.groupBy.get(i);
                if (groupByItem != null) {
                    groupByClones.add((ArithmeticOrRelationalOperand)groupByItem.clone());
                    continue;
                }
                groupByClones.add(null);
            }
            obj.groupBy = groupByClones;
        }
        return obj;
    }

    public String toString() {
        ToStringBuilder sb = new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Field List", this.selectionList).append("Sources", this.sources).append("Qualifier", this.qualifier);
        if (this.having != null || this.groupBy != null) {
            sb.append("Having", this.having).append("GroupBy", this.groupBy);
        }
        return sb.toString();
    }
}

