/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.common;

import com.bmc.arsys.common.AppException;
import com.bmc.arsys.common.CommonErrors;

public class PropertyDefinition {
    private static final String TRUE_STRING = "T";
    private String propName;
    private Class propType;
    private Object defaultValue;

    public PropertyDefinition(String string, Class clazz, Object object) {
        this.propName = string;
        this.propType = clazz;
        this.defaultValue = object;
    }

    public String getPropertyName() {
        return this.propName;
    }

    public Class getPropertyType() {
        return this.propType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return this.propName;
    }

    public Object getConvertedValue(String string) throws AppException {
        Object object = string;
        if (this.propType == null) {
            return object;
        }
        if (this.propType == Long.TYPE || this.propType == Long.class) {
            try {
                long l = 0L;
                object = string != null && string.trim().length() > 0 ? Long.parseLong(string) : l;
            }
            catch (NumberFormatException numberFormatException) {
                throw new AppException(CommonErrors.MSG_SET.toDefMsg(), CommonErrors.WRONG_DATA_TYPE.toIntValue(), CommonErrors.WRONG_DATA_TYPE.toDefMsg(), new Object[]{this.toString(), "long"});
            }
        }
        if (this.propType == Boolean.TYPE || this.propType == Boolean.class) {
            object = TRUE_STRING.equalsIgnoreCase(string) ? Boolean.TRUE : Boolean.FALSE;
        } else {
            if (this.propType == Integer.TYPE || this.propType == Integer.class) {
                try {
                    int n = 0;
                    object = string != null && string.trim().length() > 0 ? Integer.parseInt(string) : n;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new AppException(CommonErrors.MSG_SET.toDefMsg(), CommonErrors.WRONG_DATA_TYPE.toIntValue(), CommonErrors.WRONG_DATA_TYPE.toDefMsg(), new Object[]{this.toString(), "integer"});
                }
            }
            if (this.propType == Float.TYPE || this.propType == Float.class) {
                try {
                    float f = 0.0f;
                    object = Float.valueOf(string != null && string.trim().length() > 0 ? Float.parseFloat(string) : f);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new AppException(CommonErrors.MSG_SET.toDefMsg(), CommonErrors.WRONG_DATA_TYPE.toIntValue(), CommonErrors.WRONG_DATA_TYPE.toDefMsg(), new Object[]{this.toString(), "float"});
                }
            }
            if (this.propType == Double.TYPE || this.propType == Double.class) {
                try {
                    double d = 0.0;
                    object = string != null && string.trim().length() > 0 ? Double.parseDouble(string) : d;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new AppException(CommonErrors.MSG_SET.toDefMsg(), CommonErrors.WRONG_DATA_TYPE.toIntValue(), CommonErrors.WRONG_DATA_TYPE.toDefMsg(), new Object[]{this.toString(), "double"});
                }
            }
        }
        return object;
    }
}

