/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.definition;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DiaryListValue;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListInfo;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.ServerInfoMap;
import com.bmc.arsys.api.StructItemInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.WorkflowLockInfo;
import com.bmc.arsys.apiext.definition.BaseItemData;
import com.bmc.arsys.apiext.definition.CommandLineBase;
import com.bmc.arsys.apiext.definition.CompletionEvent;
import com.bmc.arsys.apiext.definition.DefinitionEvent;
import com.bmc.arsys.apiext.definition.DefinitionException;
import com.bmc.arsys.apiext.definition.DefinitionItemData;
import com.bmc.arsys.apiext.definition.DefinitionItemType;
import com.bmc.arsys.apiext.definition.DefinitionOptions;
import com.bmc.arsys.apiext.definition.ExpansionEvent;
import com.bmc.arsys.apiext.definition.ExportCommandParser;
import com.bmc.arsys.apiext.definition.IDefinitionListener;
import com.bmc.arsys.apiext.definition.InitializationEvent;
import com.bmc.arsys.apiext.definition.ProcessEvent;
import com.bmc.arsys.apiext.definition.RelatedExpander;
import com.bmc.arsys.apiext.definition.RelatedObjects;
import com.bmc.arsys.apiext.definition.RelatedType;
import com.bmc.arsys.apiext.definition.ViewItemData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DefinitionExport
extends CommandLineBase {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final int AR_RETRIEVE_ALL_ENTRIES = 999999999;
    private static final int MINIMUM_ARGS = 5;
    private static final ArrayList<Integer> exportOrder = new ArrayList();
    private static Logger logger;
    private final RelatedObjects serverContent = new RelatedObjects();
    private boolean developerCacheMode = false;
    private final int failed = 0;
    private final List<IDefinitionListener> listeners = new ArrayList<IDefinitionListener>();
    private final int successful = 0;
    private final int warnings = 0;

    public DefinitionExport() {
        this.parseDeveloperCacheMode();
    }

    private void parseDeveloperCacheMode() {
        try {
            ServerInfoMap devCacheModeResult = this.getOptions().getContext().getServerInfo(new int[]{208});
            if (devCacheModeResult != null && devCacheModeResult.size() > 0 && ((Value)devCacheModeResult.get((Object)208)).getValue() != null) {
                Integer cacheMode = (Integer)((Value)devCacheModeResult.get((Object)208)).getValue();
                this.developerCacheMode = cacheMode == 1;
            }
        }
        catch (Exception ex) {
            this.developerCacheMode = false;
        }
    }

    public static void main(String[] args) {
        DefinitionExport instance = new DefinitionExport();
        instance.createListener();
        if (args.length == 1 && args[0].equals("--version")) {
            instance.printVersion();
        } else if (args.length > 5) {
            DefinitionOptions options = null;
            try {
                options = instance.parseCommandLine(args);
                instance.validateCommandLine(options, true);
            }
            catch (Exception e) {
                System.err.println("Unable to parse command line parameters. Please verify your parameters.");
                System.err.println(e.getMessage());
            }
            if (options != null) {
                try {
                    instance.setOptions(options);
                    options.validate();
                    options.connect();
                    if (options.getContext().isAdministrator() || options.getContext().isSubAdministrator()) {
                        if (options.getCommandSetFile() != null) {
                            File file = new File(options.getCommandSetFile());
                            ExportCommandParser parser = new ExportCommandParser(options);
                            parser.populateFromFile(file, true);
                        }
                        instance.getOptions().setOverwrite(true);
                        instance.expandObjects();
                        instance.exportObjects();
                    } else if (logger.isEnabledFor((Priority)Level.ERROR)) {
                        logger.error((Object)"Only users that belong to the Administrator or Sub Administrator groups can export definitions.");
                    }
                }
                catch (UnsatisfiedLinkError e) {
                    if (logger.isEnabledFor((Priority)Level.ERROR)) {
                        logger.error((Object)"Export failed: Unable to load the AR System JNI interface. Please make sure your environment includes the location of the AR System native libraries");
                    }
                }
                catch (Error e) {
                    if (logger.isEnabledFor((Priority)Level.ERROR)) {
                        logger.error((Object)MessageFormat.format("Export failed: {0}", e.getMessage()));
                    }
                }
                catch (Exception e) {
                    if (!(e instanceof ARException) && logger.isEnabledFor((Priority)Level.ERROR)) {
                        logger.error((Object)MessageFormat.format("Export failed: {0}", e.getMessage()));
                    }
                }
            }
        } else {
            instance.printUsage(true);
        }
    }

    public void addListener(IDefinitionListener listener) {
        this.listeners.add(listener);
    }

    private void expandAll() throws ARException {
        for (DefinitionItemType type : this.getOptions().getAllFlags().keySet()) {
            Boolean flag = this.getOptions().getAllFlags().get((Object)type);
            RelatedType related = RelatedType.NONE;
            if (!(this.getOptions().isDsoLicensed() || type != DefinitionItemType.DISTRIBUTED_MAPPING && type != DefinitionItemType.DISTRIBUTED_POOL)) {
                flag = false;
                if (logger.isEnabledFor((Priority)Level.INFO)) {
                    logger.info((Object)MessageFormat.format("{0} objects can not be exported. Server {1} does not have a Distributed Server Option license.", type.getTypeName(), this.getOptions().getServer()));
                }
            }
            if (flag == null || !flag.booleanValue()) continue;
            Set<String> serverNames = (Set<String>)this.serverContent.get((Object)type);
            if (serverNames == null || serverNames.isEmpty()) {
                serverNames = this.getNameList(type);
                this.serverContent.put(type, serverNames);
            }
            for (String name : serverNames) {
                DefinitionItemData data = new DefinitionItemData(type, name, related);
                this.getOptions().add(data);
            }
        }
    }

    private void expandObjects() throws ARException {
        this.getOptions().connect();
        ARServerUser context = this.getOptions().getContext();
        RelatedExpander expander = new RelatedExpander(context);
        for (IDefinitionListener listener : this.listeners) {
            expander.addListener(listener);
        }
        RelatedObjects related = new RelatedObjects();
        for (DefinitionItemType key : this.getOptions().getItems().keySet()) {
            List<BaseItemData> itemList = this.getOptions().getItems().get((Object)key);
            if (itemList == null) continue;
            for (BaseItemData item : itemList) {
                if (!(item instanceof DefinitionItemData)) continue;
                DefinitionItemData data = (DefinitionItemData)item;
                if (!(item instanceof DefinitionItemData) || data.getRelated() == RelatedType.NONE || data.getRelated() == RelatedType.FULL) continue;
                RelatedObjects itemRelated = expander.expandObject(data.getType(), data.getName(), data.getRelated());
                related.addAll(itemRelated);
                data.setRelated(RelatedType.NONE);
            }
        }
        for (DefinitionItemType type : related.keySet()) {
            Set names = (Set)related.get((Object)type);
            if (names == null || names.isEmpty()) continue;
            for (String name : names) {
                if (this.getOptions().getItems().get((Object)type) == null) {
                    this.getOptions().getItems().put(type, new ArrayList());
                }
                this.getOptions().getItems().get((Object)type).add(new DefinitionItemData(type, name, RelatedType.NONE));
            }
        }
        for (IDefinitionListener listener : this.listeners) {
            expander.removeListener(listener);
        }
    }

    public void exportObjects() throws DefinitionException, ARException, IOException {
        this.expandObjects();
        this.checkDSOLicense();
        this.expandAll();
        this.stripDuplicates();
        this.checkExistence();
        if (this.getOptions().getObjectCount() < 1) {
            for (IDefinitionListener listener : this.listeners) {
                listener.event(new CompletionEvent(0, 0, 0, null));
            }
            return;
        }
        for (IDefinitionListener listener : this.listeners) {
            listener.event(new InitializationEvent(3, null, null, this.getOptions().getServer(), this.getOptions().getObjectCount()));
        }
        List statusList = null;
        try {
            boolean appendFlashboards = true;
            boolean toXML = this.getOptions().isXML();
            List<StructItemInfo> items = this.convertToItemList(toXML);
            if (items != null && !items.isEmpty()) {
                WorkflowLockInfo lockInfo = null;
                if (this.getOptions().getLockType() != 0 && this.getOptions().getLockKey() != null && this.getOptions().getLockKey().length() > 0) {
                    lockInfo = new WorkflowLockInfo(this.getOptions().getLockType(), this.getOptions().getLockKey());
                }
                Collections.sort(items, new ExportOrderComparator());
                this.getOptions().getContext().exportDefToFile(items, toXML, lockInfo, this.getOptions().getFileName(), this.getOptions().isOverwrite(), this.getOptions().exportOption);
            } else {
                boolean bl = appendFlashboards = !this.getOptions().isOverwrite();
            }
            if (!this.getOptions().isXML()) {
                this.exportFlashboards(appendFlashboards);
            } else {
                System.err.println("Exporting flashboard objects in XML is not supported.\nSelected flashboard objects will not be exported");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (ARException e) {
            statusList = e.getLastStatus();
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            for (IDefinitionListener listener : this.listeners) {
                listener.event(new CompletionEvent(0, 0, 0, statusList));
            }
        }
    }

    private void exportFlashboards(boolean append) throws ARException, DefinitionException {
        String formName = this.getDataVisualizationForm();
        if (formName != null) {
            DefinitionItemData data;
            StringBuilder result = new StringBuilder();
            if (this.getOptions().getItems(DefinitionItemType.FLASHBOARD) != null) {
                for (BaseItemData item : this.getOptions().getItems(DefinitionItemType.FLASHBOARD)) {
                    if (!(item instanceof DefinitionItemData)) continue;
                    data = (DefinitionItemData)item;
                    this.prepareDataVisualization(result, "Flashboard", "FLASHBOARD", data.getName());
                }
            }
            if (this.getOptions().getItems(DefinitionItemType.FLASHBOARD_ALARM) != null) {
                for (BaseItemData item : this.getOptions().getItems(DefinitionItemType.FLASHBOARD_ALARM)) {
                    if (!(item instanceof DefinitionItemData)) continue;
                    data = (DefinitionItemData)item;
                    this.prepareDataVisualization(result, "Flashboard", "ALARM", data.getName());
                }
            }
            if (this.getOptions().getItems(DefinitionItemType.FLASHBOARD_VARIABLE) != null) {
                for (BaseItemData item : this.getOptions().getItems(DefinitionItemType.FLASHBOARD_VARIABLE)) {
                    if (!(item instanceof DefinitionItemData)) continue;
                    data = (DefinitionItemData)item;
                    this.prepareDataVisualization(result, "Flashboard", "VARIABLE", data.getName());
                }
            }
            this.writeFlashboardsToFile(result, append);
        }
    }

    private void writeFlashboardsToFile(StringBuilder result, boolean append) throws DefinitionException {
        String charSet = null;
        BufferedWriter fileWriter = null;
        boolean newFile = false;
        File fileCheck = new File(this.getOptions().getFileName());
        if (append && fileCheck.exists()) {
            charSet = this.getDefFileCharSet();
        } else {
            newFile = true;
            charSet = "UTF-8";
        }
        try {
            FileOutputStream outStream = new FileOutputStream(this.getOptions().getFileName(), append);
            OutputStreamWriter streamWriter = null;
            streamWriter = charSet != null ? new OutputStreamWriter((OutputStream)outStream, charSet) : new OutputStreamWriter(outStream);
            fileWriter = new BufferedWriter(streamWriter);
            if (newFile) {
                fileWriter.write("char-set: " + charSet + NEWLINE);
            }
            fileWriter.write(result.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new DefinitionException("Unable to open export file", e);
        }
        catch (FileNotFoundException e) {
            throw new DefinitionException("Unable to open export file", e);
        }
        catch (IOException e) {
            throw new DefinitionException("Unable to write to export file", e);
        }
        finally {
            try {
                fileWriter.close();
            }
            catch (IOException e) {
                throw new DefinitionException("Unable to close export file", e);
            }
        }
    }

    public String getDefFileCharSet() throws DefinitionException {
        String charSet = null;
        BufferedReader fileReader = null;
        try {
            FileInputStream inStream = new FileInputStream(this.getOptions().getFileName());
            InputStreamReader streamReader = new InputStreamReader(inStream);
            fileReader = new BufferedReader(streamReader);
            String line = fileReader.readLine();
            if (line != null && line.startsWith("char-set: ")) {
                charSet = line.substring("char-set: ".length());
                fileReader.close();
            }
        }
        catch (FileNotFoundException e) {
            throw new DefinitionException("Unable to open export file", e);
        }
        catch (IOException e) {
            throw new DefinitionException("Unable to open export file", e);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException e) {
                    throw new DefinitionException("Unable to close export file", e);
                }
            }
        }
        return charSet;
    }

    private void prepareDataVisualization(StringBuilder result, String module, String subType, String name) throws ARException {
        QualifierInfo qualInfo = this.getDataVisualizationQualifier(module, subType, name);
        List listEntry = this.getOptions().getContext().getListEntry(this.getDataVisualizationForm(), qualInfo, 0, 1, null, null, false, null);
        if (listEntry != null && !listEntry.isEmpty()) {
            Entry entry = this.getOptions().getContext().getEntry(this.getDataVisualizationForm(), ((EntryListInfo)listEntry.get(0)).getEntryID(), null);
            this.formatDataVisualizationForExport(result, entry);
        }
    }

    private void formatDataVisualizationForExport(StringBuilder result, Entry entry) {
        String objectData = this.encodeDataVisualizationEntry(entry);
        result.append("begin Data Visualization Definition").append(NEWLINE);
        result.append("   name           : ").append(((Value)entry.get((Object)41050)).getValue()).append(NEWLINE);
        result.append("   module         : ").append(((Value)entry.get((Object)41000)).getValue()).append(NEWLINE);
        result.append("   subtype        : ").append(((Value)entry.get((Object)41052)).getValue()).append(NEWLINE);
        int length = objectData.length();
        int chunkSize = 286;
        int start = 0;
        int end = chunkSize;
        ArrayList<String> sections = new ArrayList<String>();
        if (length < chunkSize) {
            sections.add(objectData);
        } else {
            while (end < length) {
                sections.add(objectData.substring(start, end));
                start = end;
                if ((end += chunkSize) <= length) continue;
                sections.add(objectData.substring(start));
            }
        }
        if (!sections.isEmpty()) {
            result.append("   objectdata     :").append((String)sections.get(0)).append(NEWLINE);
            for (int iLoop = 1; iLoop < sections.size(); ++iLoop) {
                result.append("   objectdata     :").append("+").append((String)sections.get(iLoop)).append(NEWLINE);
            }
        }
        result.append("end").append(NEWLINE);
    }

    private String encodeDataVisualizationEntry(Entry entry) {
        StringBuilder result = new StringBuilder();
        for (Integer fieldId : entry.keySet()) {
            Value value;
            if (fieldId == 15 || fieldId == 1 || fieldId == 2 || fieldId == 3 || fieldId == 112 || (value = (Value)entry.get((Object)fieldId)) == null || value.getDataType().toInt() == 0) continue;
            String valueString = null;
            switch (value.getDataType().toInt()) {
                case 4: {
                    valueString = (String)value.getValue();
                    break;
                }
                case 5: {
                    if (value.getValue() instanceof String) {
                        valueString = (String)value.getValue();
                        break;
                    }
                    if (value.getValue() instanceof DiaryListValue) {
                        valueString = ((DiaryListValue)value.getValue()).encode();
                        break;
                    }
                    valueString = "";
                    break;
                }
                case 10: {
                    valueString = ((BigDecimal)value.getValue()).toString();
                    break;
                }
                case 2: {
                    valueString = ((Integer)value.getValue()).toString();
                    break;
                }
                case 6: {
                    if (fieldId == 41051) {
                        valueString = "1";
                        break;
                    }
                    valueString = ((Number)value.getValue()).toString();
                    break;
                }
                case 40: {
                    valueString = ((Long)value.getValue()).toString();
                    break;
                }
                case 7: {
                    valueString = Long.toString(((Timestamp)value.getValue()).getValue());
                    break;
                }
                case 3: {
                    valueString = ((Double)value.getValue()).toString();
                }
            }
            if (valueString == null) continue;
            result.append(" ").append(fieldId).append(",").append(value.getDataType().toInt()).append(",\"").append(valueString).append("\";");
        }
        return result.toString();
    }

    private void checkExistence() throws ARException {
        for (DefinitionItemType type : this.getOptions().getItems().keySet()) {
            Set<String> serverNames;
            List<BaseItemData> items;
            if (type == DefinitionItemType.FLASHBOARD || type == DefinitionItemType.FLASHBOARD_ALARM || type == DefinitionItemType.FLASHBOARD_VARIABLE || (items = this.getOptions().getItems().get((Object)type)) == null || items.isEmpty()) continue;
            DefinitionItemType serverType = type;
            if (type == DefinitionItemType.FORM_DATA || type == DefinitionItemType.FORM_DEFN || type == DefinitionItemType.FORM_MAIL || type == DefinitionItemType.FORM_VIEW || type == DefinitionItemType.FORM_VIEW_MIN || type == DefinitionItemType.VIEW) {
                serverType = DefinitionItemType.FORM;
            }
            if ((serverNames = (Set<String>)this.serverContent.get((Object)serverType)) == null) {
                for (IDefinitionListener listener : this.listeners) {
                    listener.event(new InitializationEvent(2, serverType, null, this.getOptions().getServer()));
                }
                serverNames = this.getNameList(serverType);
                this.serverContent.put(serverType, serverNames);
            }
            ArrayList<BaseItemData> removeUs = new ArrayList<BaseItemData>();
            for (BaseItemData data : items) {
                if (data instanceof DefinitionItemData) {
                    if (serverNames.contains(data.getName())) continue;
                    for (IDefinitionListener listener : this.listeners) {
                        listener.event(new InitializationEvent(4, data.getType(), data.getName(), this.getOptions().getServer()));
                    }
                    removeUs.add(data);
                    continue;
                }
                if (data instanceof ViewItemData) {
                    if (serverNames.contains(((ViewItemData)data).getForm())) continue;
                    removeUs.add(data);
                    continue;
                }
                removeUs.add(data);
            }
            items.removeAll(removeUs);
            this.getOptions().getItems().put(type, items);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getNameList(DefinitionItemType type) throws ARException {
        Set<String> result = new HashSet<String>();
        switch (type) {
            case FORM: 
            case FORM_DATA: 
            case FORM_DEFN: 
            case FORM_MAIL: 
            case FORM_VIEW: 
            case FORM_VIEW_MIN: 
            case VIEW: {
                result.addAll(this.getOptions().getContext().getListForm());
                break;
            }
            case ACTIVE_LINK: {
                result.addAll(this.getOptions().getContext().getListActiveLink());
                break;
            }
            case FILTER: {
                result.addAll(this.getOptions().getContext().getListFilter());
                break;
            }
            case ESCALATION: {
                result.addAll(this.getOptions().getContext().getListEscalation());
                break;
            }
            case APPLICATION: {
                result.addAll(this.getOptions().getContext().getListContainer(0L, new int[]{2}, true, null, null));
                break;
            }
            case ACTIVE_LINK_GUIDE: {
                result.addAll(this.getOptions().getContext().getListContainer(0L, new int[]{1}, true, null, null));
                break;
            }
            case FILTER_GUIDE: {
                result.addAll(this.getOptions().getContext().getListContainer(0L, new int[]{4}, true, null, null));
                break;
            }
            case PACKING_LIST: {
                result.addAll(this.getOptions().getContext().getListContainer(0L, new int[]{3}, true, null, null));
                break;
            }
            case WEB_SERVICE: {
                result.addAll(this.getOptions().getContext().getListContainer(0L, new int[]{5}, true, null, null));
                break;
            }
            case CONTAINER: {
                result.addAll(this.getOptions().getContext().getListContainer(0L, new int[]{0}, true, null, null));
                break;
            }
            case MENU: {
                result.addAll(this.getOptions().getContext().getListMenu(0L, null, null));
                break;
            }
            case IMAGE: {
                result.addAll(this.getOptions().getContext().getListImage());
                break;
            }
            case ASSOCIATION: {
                result.addAll(this.getOptions().getContext().getListAssociation(null, 0L, null, 0, 0, 0));
                break;
            }
            case DISTRIBUTED_POOL: {
                String licInfo;
                int[] infoRequest = new int[]{43};
                ServerInfoMap serverInfo = this.getOptions().getContext().getServerInfo(infoRequest);
                if (serverInfo == null || ((Value)serverInfo.get((Object)43)).getValue() == null || (licInfo = ((Value)serverInfo.get((Object)43)).getValue().toString()).length() <= 0) break;
                ArithmeticOrRelationalOperand left = new ArithmeticOrRelationalOperand(new Value(1));
                ArithmeticOrRelationalOperand right = new ArithmeticOrRelationalOperand(new Value(1));
                QualifierInfo qualInfo = new QualifierInfo(new RelationalOperationInfo(1, left, right));
                int[] fieldList = new int[]{1, 8};
                List listEntryObjects = null;
                try {
                    if (!this.developerCacheMode) {
                        this.getOptions().getContext().useDefaultRpcQueue();
                    }
                    listEntryObjects = this.getOptions().getContext().getListEntryObjects(this.getDSOPoolForm(), qualInfo, 0, 999999999, null, fieldList, false, null);
                }
                finally {
                    if (!this.developerCacheMode) {
                        this.getOptions().getContext().useAdminRpcQueue();
                    }
                }
                for (Entry entry : listEntryObjects) {
                    result.add((String)((Value)entry.get((Object)8)).getValue());
                }
                break;
            }
            case DISTRIBUTED_MAPPING: {
                String licInfo;
                int[] infoRequest = new int[]{43};
                ServerInfoMap serverInfo = this.getOptions().getContext().getServerInfo(infoRequest);
                if (serverInfo == null || ((Value)serverInfo.get((Object)43)).getValue() == null || (licInfo = ((Value)serverInfo.get((Object)43)).getValue().toString()).length() <= 0) break;
                ArithmeticOrRelationalOperand left = new ArithmeticOrRelationalOperand(new Value(1));
                ArithmeticOrRelationalOperand right = new ArithmeticOrRelationalOperand(new Value(1));
                QualifierInfo qualInfo = new QualifierInfo(new RelationalOperationInfo(1, left, right));
                int[] fieldList = new int[]{1, 8};
                List listEntryObjects = null;
                try {
                    if (!this.developerCacheMode) {
                        this.getOptions().getContext().useDefaultRpcQueue();
                    }
                    listEntryObjects = this.getOptions().getContext().getListEntryObjects(this.getDSOMapForm(), qualInfo, 0, 999999999, null, fieldList, false, null);
                }
                finally {
                    if (!this.developerCacheMode) {
                        this.getOptions().getContext().useAdminRpcQueue();
                    }
                }
                for (Entry entry : listEntryObjects) {
                    result.add((String)((Value)entry.get((Object)8)).getValue());
                }
                break;
            }
            case FLASHBOARD: {
                result = this.getDataVisualizationNameList("Flashboard", "FLASHBOARD");
                break;
            }
            case FLASHBOARD_ALARM: {
                result = this.getDataVisualizationNameList("Flashboard", "ALARM");
                break;
            }
            case FLASHBOARD_VARIABLE: {
                result = this.getDataVisualizationNameList("Flashboard", "VARIABLE");
            }
        }
        return result;
    }

    private Collection<? extends String> getDSONameList(String poolForm, int arCoreShortDescription) {
        return null;
    }

    public void removeListener(IDefinitionListener listener) {
        this.listeners.remove(listener);
    }

    private void createListener() {
        this.listeners.add(new IDefinitionListener(){

            @Override
            public void event(DefinitionEvent event) {
                block14: {
                    block13: {
                        if (!(event instanceof CompletionEvent)) break block13;
                        switch (event.getEvent()) {
                            case 1: {
                                if (logger.isEnabledFor((Priority)Level.INFO)) {
                                    logger.info((Object)"Export Aborted. There are no objects to export");
                                    break;
                                }
                                break block14;
                            }
                            default: {
                                if (logger.isEnabledFor((Priority)Level.INFO)) {
                                    logger.info((Object)"Export Completed");
                                    break;
                                }
                                break block14;
                            }
                        }
                        break block14;
                    }
                    if (event instanceof InitializationEvent) {
                        InitializationEvent init = (InitializationEvent)event;
                        switch (init.getEvent()) {
                            case 1: {
                                if (!logger.isEnabledFor((Priority)Level.INFO)) break;
                                logger.info((Object)"Connecting to server");
                                break;
                            }
                            case 3: {
                                if (!logger.isEnabledFor((Priority)Level.INFO)) break;
                                logger.info((Object)MessageFormat.format("Exporting {0} objects to {1}", init.getNumItems(), DefinitionExport.this.getOptions().getFileName()));
                                break;
                            }
                            case 4: {
                                if (!logger.isEnabledFor((Priority)Level.INFO)) break;
                                logger.info((Object)MessageFormat.format("{0} {1} has been removed from the export. The object does not exist on the server {2}.", init.getItemType().toString(), init.getName(), init.getServer()));
                            }
                        }
                    } else if (event instanceof ExpansionEvent || event instanceof ProcessEvent) {
                        // empty if block
                    }
                }
            }
        });
    }

    private void stripDuplicates() {
        for (DefinitionItemType type : this.getOptions().getItems().keySet()) {
            if (type == DefinitionItemType.VIEW) continue;
            HashSet<String> names = new HashSet<String>();
            ArrayList<BaseItemData> removeUs = new ArrayList<BaseItemData>();
            List<BaseItemData> items = this.getOptions().getItems().get((Object)type);
            for (BaseItemData data : items) {
                if (names.contains(data.getName())) {
                    removeUs.add(data);
                    continue;
                }
                names.add(data.getName());
            }
            items.removeAll(removeUs);
            this.getOptions().getItems().put(type, items);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getDataVisualizationNameList(String module, String subType) throws ARException {
        HashSet<String> result = new HashSet<String>();
        ArithmeticOrRelationalOperand moduleLeft = new ArithmeticOrRelationalOperand(41000);
        ArithmeticOrRelationalOperand moduleRight = new ArithmeticOrRelationalOperand(new Value(module));
        QualifierInfo moduleQualifier = new QualifierInfo(new RelationalOperationInfo(1, moduleLeft, moduleRight));
        ArithmeticOrRelationalOperand subLeft = new ArithmeticOrRelationalOperand(41052);
        ArithmeticOrRelationalOperand subRight = new ArithmeticOrRelationalOperand(new Value(subType));
        QualifierInfo subTypeQual = new QualifierInfo(new RelationalOperationInfo(1, subLeft, subRight));
        QualifierInfo qualInfo = new QualifierInfo(1, moduleQualifier, subTypeQual);
        List listEntry = null;
        try {
            if (!this.developerCacheMode) {
                this.getOptions().getContext().useDefaultRpcQueue();
            }
            listEntry = this.getOptions().getContext().getListEntryObjects(this.getDataVisualizationForm(), qualInfo, 0, 999999999, null, null, false, null);
        }
        finally {
            if (!this.developerCacheMode) {
                this.getOptions().getContext().useAdminRpcQueue();
            }
        }
        if (listEntry != null && !listEntry.isEmpty()) {
            for (Entry entry : listEntry) {
                Value value = (Value)entry.get((Object)41050);
                if (value == null || !DataType.CHAR.equals((Object)value.getDataType()) || value.getValue() == null) continue;
                result.add(value.getValue().toString());
            }
        }
        return result;
    }

    static {
        exportOrder.add(1);
        exportOrder.add(2);
        exportOrder.add(3);
        exportOrder.add(4);
        exportOrder.add(14);
        exportOrder.add(103);
        exportOrder.add(5);
        exportOrder.add(6);
        exportOrder.add(7);
        exportOrder.add(8);
        exportOrder.add(20);
        exportOrder.add(9);
        exportOrder.add(10);
        exportOrder.add(11);
        exportOrder.add(13);
        exportOrder.add(12);
        logger = Logger.getLogger((String)"com.bmc.arsys.api.definition");
    }

    private class ExportOrderComparator
    implements Comparator<StructItemInfo> {
        private ExportOrderComparator() {
        }

        @Override
        public int compare(StructItemInfo o1, StructItemInfo o2) {
            if (exportOrder.indexOf(o1.getType()) > exportOrder.indexOf(o2.getType())) {
                return 1;
            }
            if (exportOrder.indexOf(o1.getType()) < exportOrder.indexOf(o2.getType())) {
                return -1;
            }
            int nameCompare = o1.getName().compareTo(o2.getName());
            if (nameCompare > 0) {
                return 1;
            }
            if (nameCompare < 0) {
                return -1;
            }
            return 0;
        }
    }
}

