/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data.arx;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.apiext.data.ARImportException;
import com.bmc.arsys.apiext.data.FieldInformation;
import com.bmc.arsys.apiext.data.FormInformation;
import com.bmc.arsys.apiext.data.ImportErrors;
import com.bmc.arsys.apiext.data.ImportOptions;
import com.bmc.arsys.apiext.data.ParseEvent;
import com.bmc.arsys.apiext.data.Parser;
import com.bmc.arsys.apiext.data.ThreadLocalStorage;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ARXParser
extends Parser {
    public static final String SCHEMA_TAG = "SCHEMA";
    public static final String CHARSET_TAG = "CHAR-SET";
    public static final String FIELDS_TAG = "FIELDS";
    public static final String FLDID_TAG = "FLD-ID";
    public static final String DATA_TAG = "DATA";
    public static final String DTYPES_TAG = "DTYPES";
    public static final String DTYPE_INT = "INTEGER";
    public static final String DTYPE_REAL = "REAL";
    public static final String DTYPE_CHAR = "CHAR";
    public static final String DTYPE_DIAR = "DIARY";
    public static final String DTYPE_ENUM = "ENUM";
    public static final String DTYPE_TIME = "TIME";
    public static final String DTYPE_TIME_OF_DAY = "TIMEOFDAY";
    public static final String DTYPE_DECIMAL = "DECIMAL";
    public static final String DTYPE_DATE = "DATE";
    public static final String DTYPE_CURRENCY = "CURRENCY";
    public static final String DTYPE_ATTACH = "ATTACH";
    public static String lineSeparator = null;

    public List<String> parseDataSection(String line, int lineNumber) throws ARImportException {
        return this.parseLine(DATA_TAG, line, lineNumber);
    }

    private List<String> parseLine(String tag, String line, int lineNumber) throws ARImportException {
        if (tag == null) {
            throw new ARImportException("Line tag was not supplied.");
        }
        int currentChar = 32;
        int previousChar = 32;
        int oneBefore = 32;
        int twoBefore = 32;
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder currentToken = new StringBuilder();
        boolean startQuote = false;
        boolean endquote = false;
        boolean addToToken = false;
        int bufferLength = line.length();
        for (int index = tag.length() + 1; index <= bufferLength; ++index) {
            addToToken = true;
            if (currentChar == 34) {
                if (!startQuote) {
                    startQuote = true;
                    addToToken = false;
                    endquote = false;
                } else if (previousChar == 92) {
                    if (oneBefore == 92) {
                        if (twoBefore == 92) {
                            int escapeCntr = 0;
                            int tempIndex = index - 2;
                            char tempChar = line.charAt(tempIndex);
                            while (tempChar == '\\') {
                                ++escapeCntr;
                                tempChar = line.charAt(--tempIndex);
                            }
                            if (escapeCntr % 2 == 0) {
                                endquote = true;
                                addToToken = false;
                            }
                        } else {
                            endquote = true;
                            addToToken = false;
                        }
                    }
                } else {
                    endquote = true;
                    addToToken = false;
                }
            }
            if (currentChar == 32) {
                if (!startQuote) {
                    if (currentToken.length() > 0) {
                        if (tag.equals(DATA_TAG)) {
                            result.add(currentToken.toString().replace("\\\"", "\""));
                        } else {
                            result.add(currentToken.toString().replace("\\\"", "\"").replace("\\\\", "\\"));
                        }
                    }
                    currentToken = new StringBuilder();
                    addToToken = false;
                    startQuote = false;
                    endquote = false;
                } else if (endquote) {
                    if (tag.equals(DATA_TAG)) {
                        result.add(currentToken.toString().replace("\\\"", "\""));
                    } else {
                        result.add(currentToken.toString().replace("\\\"", "\"").replace("\\\\", "\\"));
                    }
                    currentToken = new StringBuilder();
                    addToToken = false;
                    startQuote = false;
                    endquote = false;
                }
            }
            if (addToToken) {
                currentToken.append((char)currentChar);
            }
            twoBefore = oneBefore;
            oneBefore = previousChar;
            previousChar = currentChar;
            if (index != bufferLength) {
                currentChar = line.charAt(index);
                continue;
            }
            if (currentChar == 32) continue;
            if (tag.equals(DATA_TAG)) {
                result.add(currentToken.toString().replace("\\\"", "\""));
                continue;
            }
            result.add(currentToken.toString().replace("\\\"", "\"").replace("\\\\", "\\"));
        }
        return result;
    }

    public List<String> parseFieldSection(String line, int lineNumber) throws ARImportException {
        if (!line.startsWith(FIELDS_TAG)) {
            throw new ARImportException("String provided is not a FIELDS element.");
        }
        return this.parseLine(FIELDS_TAG, line, lineNumber);
    }

    public List<String> parseFldIDSection(String line, int lineNumber) throws ARImportException {
        if (!line.startsWith(FLDID_TAG)) {
            throw new ARImportException("String provided is not a FLD-ID element.");
        }
        return this.parseLine(FLDID_TAG, line, lineNumber);
    }

    public List<String> parseCharSetSection(String line, int lineNumber) throws ARImportException {
        if (!line.contains(CHARSET_TAG)) {
            throw new ARImportException("String provided is not a CHAR-SET element.");
        }
        return this.parseLine(CHARSET_TAG, line, lineNumber);
    }

    public List<String> parseSchemaSection(String line, int lineNumber) throws ARImportException {
        if (!line.startsWith(SCHEMA_TAG)) {
            throw new ARImportException("String provided is not a SCHEMA element.");
        }
        return this.parseLine(SCHEMA_TAG, line, lineNumber);
    }

    public List<String> parseDTypesSection(String line, int lineNumber) throws ARImportException {
        if (!line.startsWith(DTYPES_TAG)) {
            throw new ARImportException("String provided is not a DTYPES element.");
        }
        return this.parseLine(DTYPES_TAG, line, lineNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FormInformation> extractFormInformation(String fileName, boolean firstOnly) throws FileNotFoundException, UnsupportedEncodingException, ARImportException, IOException {
        Logger logger = ThreadLocalStorage.getLogger();
        ArrayList<FormInformation> result = new ArrayList<FormInformation>();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)ImportErrors.EXTRACT_FORM_INFO.toDefMsg());
        }
        try (BufferedReader fileReader = null;){
            fileReader = this.openFile(fileName, null);
            String line = null;
            String formName = null;
            List<String> nameTokens = null;
            List<String> idTokens = null;
            List<String> typeTokens = null;
            FormInformation formInfo = null;
            int lineNumber = 0;
            while ((line = fileReader.readLine()) != null) {
                ++lineNumber;
                if (line.startsWith(SCHEMA_TAG)) {
                    if (formName != null) {
                        throw new ARImportException(ImportErrors.PARSE_ERROR_ON_FORM_INFO.toDefMsg() + formName);
                    }
                    formInfo = null;
                    List<String> tokens = this.parseSchemaSection(line, lineNumber);
                    if (tokens != null && tokens.size() > 0) {
                        formName = tokens.get(0);
                    }
                } else if (line.startsWith(FIELDS_TAG)) {
                    nameTokens = this.parseFieldSection(line, lineNumber);
                } else if (line.startsWith(FLDID_TAG)) {
                    idTokens = this.parseFldIDSection(line, lineNumber);
                } else if (line.startsWith(DTYPES_TAG)) {
                    typeTokens = this.parseDTypesSection(line, lineNumber);
                } else if (line.startsWith(DATA_TAG) && formInfo != null) {
                    formInfo.setFileRecords(formInfo.getFileRecords() + 1);
                }
                if (formName == null || nameTokens == null || idTokens == null || typeTokens == null) continue;
                formInfo = this.generateFormInformation(formName, nameTokens, idTokens, typeTokens);
                result.add(formInfo);
                formName = null;
                nameTokens = null;
                idTokens = null;
                typeTokens = null;
            }
        }
        return result;
    }

    private FormInformation generateFormInformation(String formName, List<String> nameTokens, List<String> idTokens, List<String> typeTokens) throws ARImportException {
        if (nameTokens.size() != idTokens.size() || nameTokens.size() != typeTokens.size() || idTokens.size() != typeTokens.size()) {
            throw new ARImportException(ImportErrors.FIELD_COUNT_NOT_MATCHING.toDefMsg());
        }
        FormInformation formInfo = new FormInformation();
        formInfo.setName(formName);
        for (int index = 0; index < idTokens.size(); ++index) {
            String idString = idTokens.get(index);
            String nameString = nameTokens.get(index);
            String typeString = typeTokens.get(index);
            FieldInformation fieldInfo = new FieldInformation();
            fieldInfo.setFieldId(Integer.parseInt(idString));
            fieldInfo.setName(nameString);
            fieldInfo.setDataType(typeString);
            fieldInfo.setTokenIndex(index);
            formInfo.getFields().put(fieldInfo.getFieldId(), fieldInfo);
        }
        return formInfo;
    }

    public BufferedReader openFile(String fileName, String charSet) throws IOException, ARImportException {
        FileInputStream inStream = new FileInputStream(fileName);
        InputStreamReader streamReader = null;
        BufferedReader fileReader = null;
        try {
            if (charSet != null && charSet.length() > 0) {
                streamReader = new InputStreamReader((InputStream)inStream, charSet);
            } else {
                byte[] bom = new byte[3];
                if (inStream.read(bom) != -1) {
                    if (bom[0] == UTF8_BOM[0] && bom[1] == UTF8_BOM[1] && bom[2] == UTF8_BOM[2]) {
                        inStream.close();
                        inStream = new FileInputStream(fileName);
                        streamReader = new InputStreamReader((InputStream)inStream, "utf-8");
                    } else {
                        inStream.close();
                        inStream = new FileInputStream(fileName);
                        streamReader = new InputStreamReader(inStream);
                    }
                }
            }
            fileReader = new BufferedReader(streamReader);
            if (charSet == null) {
                String line = fileReader.readLine();
                String localCharSet = null;
                if (line != null && line.contains(CHARSET_TAG)) {
                    List<String> tokens = this.parseCharSetSection(line, 0);
                    localCharSet = tokens.get(0);
                    fileReader.close();
                    return this.openFile(fileName, localCharSet);
                }
                fileReader.close();
                return this.openFile(fileName, "");
            }
            return fileReader;
        }
        catch (IOException e) {
            if (inStream != null) {
                inStream.close();
            }
            if (streamReader != null) {
                streamReader.close();
            }
            if (fileReader != null) {
                fileReader.close();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseFile(String fileName, String charset, ImportOptions options) throws ARImportException, IOException, ARException {
        Logger logger = ThreadLocalStorage.getLogger();
        try (BufferedReader fileReader = null;){
            fileReader = this.openFile(fileName, charset);
            String line = null;
            FormInformation currentForm = null;
            String formName = null;
            List<String> nameTokens = null;
            List<String> idTokens = null;
            List<String> typeTokens = null;
            int lineNumber = 0;
            while ((line = fileReader.readLine()) != null && (!this.isAbort() || this.isAbort() && this.isCopyToLog())) {
                ++lineNumber;
                if (this.isAbort() && this.isCopyToLog() && line.startsWith(DATA_TAG)) {
                    this.fireEvent(new ParseEvent(1, null, line));
                    continue;
                }
                if (line.startsWith(DATA_TAG)) {
                    List<String> dataTokens = this.parseDataSection(line, lineNumber);
                    this.fireEvent(new ParseEvent(1, dataTokens, line));
                    continue;
                }
                if (line.startsWith(SCHEMA_TAG)) {
                    if (formName != null) {
                        throw new ARImportException(ImportErrors.PARSE_ERROR_ON_FORM_INFO.toDefMsg() + formName);
                    }
                    List<String> tokens = this.parseSchemaSection(line, lineNumber);
                    if (tokens != null && tokens.size() > 0) {
                        formName = tokens.get(0);
                    }
                    if (formName == null || nameTokens == null || idTokens == null || typeTokens == null) continue;
                    currentForm = this.generateFormInformation(formName, nameTokens, idTokens, typeTokens);
                    if (!options.getFileForms().containsKey(formName)) {
                        options.addFileForm(currentForm);
                    }
                    this.fireEvent(new ParseEvent(0, currentForm));
                    formName = null;
                    nameTokens = null;
                    idTokens = null;
                    typeTokens = null;
                    continue;
                }
                if (line.startsWith(FIELDS_TAG)) {
                    nameTokens = this.parseFieldSection(line, lineNumber);
                    if (formName == null || nameTokens == null || idTokens == null || typeTokens == null) continue;
                    currentForm = this.generateFormInformation(formName, nameTokens, idTokens, typeTokens);
                    if (!options.getFileForms().containsKey(formName)) {
                        options.addFileForm(currentForm);
                    }
                    this.fireEvent(new ParseEvent(0, currentForm));
                    formName = null;
                    nameTokens = null;
                    idTokens = null;
                    typeTokens = null;
                    continue;
                }
                if (line.startsWith(FLDID_TAG)) {
                    idTokens = this.parseFldIDSection(line, lineNumber);
                    if (formName == null || nameTokens == null || idTokens == null || typeTokens == null) continue;
                    currentForm = this.generateFormInformation(formName, nameTokens, idTokens, typeTokens);
                    if (!options.getFileForms().containsKey(formName)) {
                        options.addFileForm(currentForm);
                    }
                    this.fireEvent(new ParseEvent(0, currentForm));
                    formName = null;
                    nameTokens = null;
                    idTokens = null;
                    typeTokens = null;
                    continue;
                }
                if (!line.startsWith(DTYPES_TAG)) continue;
                typeTokens = this.parseDTypesSection(line, lineNumber);
                if (formName == null || nameTokens == null || idTokens == null || typeTokens == null) continue;
                currentForm = this.generateFormInformation(formName, nameTokens, idTokens, typeTokens);
                if (!options.getFileForms().containsKey(formName)) {
                    options.addFileForm(currentForm);
                }
                this.fireEvent(new ParseEvent(0, currentForm));
                formName = null;
                nameTokens = null;
                idTokens = null;
                typeTokens = null;
            }
            this.fireEvent(new ParseEvent(2));
        }
    }
}

