/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.security.impl;

import com.kaazing.gateway.client.security.ChallengeRequest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RealmUtils {
    private static final String REALM_REGEX = "(.*)\\s?(?i:realm=)(\"(.*)\")(.*)";
    private static final Pattern REALM_PATTERN = Pattern.compile("(.*)\\s?(?i:realm=)(\"(.*)\")(.*)");

    public static String getRealm(ChallengeRequest challengeRequest) {
        String authenticationParameters = challengeRequest.getAuthenticationParameters();
        if (authenticationParameters == null) {
            return null;
        }
        Matcher m = REALM_PATTERN.matcher(authenticationParameters);
        if (m.matches() && m.groupCount() >= 3) {
            return m.group(3);
        }
        return null;
    }
}

