/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5.impl.wsn;

import com.kaazing.gateway.client.html5.ByteBuffer;
import com.kaazing.gateway.client.html5.WebSocket;
import com.kaazing.gateway.client.html5.impl.WebSocketChannel;
import com.kaazing.gateway.client.html5.impl.WebSocketHandler;
import com.kaazing.gateway.client.html5.impl.WebSocketHandlerAdapter;
import com.kaazing.gateway.client.html5.impl.WebSocketHandlerListener;
import com.kaazing.gateway.client.html5.impl.ws.WebSocketSelectedChannel;
import com.kaazing.gateway.client.html5.util.WSURI;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.logging.Logger;

public class WebSocketNativeHandshakeHandler
extends WebSocketHandlerAdapter {
    private static final String CLASS_NAME = WebSocketNativeHandshakeHandler.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private WSURI uri;
    private static final byte[] GET_BYTES = "GET".getBytes();
    private static final String APPLICATION_PREFIX = "Application ";
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate: ";
    private static final String HTTP_1_1_START = "HTTP/1.1";
    private static final byte[] HTTP_1_1_BYTES = "HTTP/1.1".getBytes();
    private static final byte[] COLON_BYTES = ":".getBytes();
    private static final byte[] SPACE_BYTES = " ".getBytes();
    private static final byte[] CRLF_BYTES = "\r\n".getBytes();
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String HEADER_PROTOCOL = "WebSocket-Protocol";
    private static final String HEADER_SEC_PORTOCOL = "Sec-WebSocket-Protocol";
    private static final String HEADER_SEC_EXTENSIONS = "Sec-WebSocket-Extensions";
    private static final int MAX_HANDSHAKEPAYLOAD = 1000;

    @Override
    public synchronized void processConnect(WebSocketChannel channel, WSURI uri, String protocol) {
        LOG.entering(CLASS_NAME, "connect", new Object[]{uri, protocol});
        String protocols = "x-kaazing-handshake";
        if (protocol != null && protocol.length() > 0) {
            protocols = protocols + "," + protocol;
        }
        this.nextHandler.processConnect(channel, uri, protocols);
    }

    @Override
    public synchronized void processAuthorize(WebSocketChannel channel, String authorizeToken) {
        this.sendHandshakePayload(channel, authorizeToken);
    }

    @Override
    public void setNextHandler(WebSocketHandler handler) {
        super.setNextHandler(handler);
        this.nextHandler.setListener(new WebSocketHandlerListener(){

            @Override
            public void connectionOpened(WebSocketChannel channel, String supportProtocol) {
                if ("x-kaazing-handshake".equals(supportProtocol)) {
                    WebSocketNativeHandshakeHandler.this.sendHandshakePayload(channel, null);
                } else {
                    WebSocketNativeHandshakeHandler.this.listener.connectionOpened(channel, supportProtocol);
                }
            }

            @Override
            public void redirected(WebSocketChannel channel, String location) {
                WebSocketNativeHandshakeHandler.this.listener.redirected(channel, location);
            }

            @Override
            public void authenticationRequested(WebSocketChannel channel, String location, String challenge) {
                WebSocketNativeHandshakeHandler.this.listener.authenticationRequested(channel, location, challenge);
            }

            @Override
            public void messageReceived(WebSocketChannel channel, ByteBuffer buf) {
                WebSocketSelectedChannel selectedChannel = (WebSocketSelectedChannel)channel;
                if (selectedChannel.getReadyState() == WebSocket.ReadyState.OPEN) {
                    WebSocketNativeHandshakeHandler.this.listener.messageReceived(channel, buf);
                } else {
                    WebSocketNativeHandshakeHandler.this.handleHandshakeMessage(channel, buf);
                }
            }

            @Override
            public void connectionClosed(WebSocketChannel channel) {
                WebSocketNativeHandshakeHandler.this.listener.connectionClosed(channel);
            }

            @Override
            public void connectionFailed(WebSocketChannel channel) {
                WebSocketNativeHandshakeHandler.this.listener.connectionClosed(channel);
            }
        });
    }

    protected static String[] getLines(ByteBuffer buf) {
        ArrayList<String> lineList = new ArrayList<String>();
        while (buf.hasRemaining()) {
            byte next = buf.get();
            ArrayList<Byte> lineText = new ArrayList<Byte>();
            while (next != 13) {
                lineText.add(next);
                if (!buf.hasRemaining()) break;
                next = buf.get();
            }
            if (buf.hasRemaining()) {
                next = buf.get();
            }
            byte[] lineTextBytes = new byte[lineText.size()];
            int i = 0;
            for (Byte text : lineText) {
                lineTextBytes[i] = text;
                ++i;
            }
            lineList.add(new String(lineTextBytes, Charset.forName("UTF-8")));
        }
        String[] lines = new String[lineList.size()];
        lineList.toArray(lines);
        return lines;
    }

    private void handleHandshakeMessage(WebSocketChannel channel, ByteBuffer buf) {
        channel.handshakePayload.putBuffer(buf);
        if (buf.capacity() > 0) {
            return;
        }
        channel.handshakePayload.flip();
        String[] lines = WebSocketNativeHandshakeHandler.getLines(channel.handshakePayload);
        channel.handshakePayload.clear();
        String httpCode = "";
        for (int i = lines.length - 1; i >= 0; --i) {
            if (!lines[i].startsWith(HTTP_1_1_START)) continue;
            String[] temp = lines[i].split(" ");
            httpCode = temp[1];
            break;
        }
        if ("101".equals(httpCode)) {
            String extensionsHeader = "";
            for (String line : lines) {
                if (line == null || !line.startsWith(HEADER_SEC_EXTENSIONS)) continue;
                extensionsHeader = line.substring(HEADER_SEC_EXTENSIONS.length() + 1).trim();
                break;
            }
            if (extensionsHeader.length() > 0) {
                String[] extensions;
                for (String extension : extensions = extensionsHeader.split(",")) {
                    String[] tmp = extension.split(";");
                    if (tmp.length <= 1) continue;
                    String escape = tmp[1].trim();
                    channel.controlFrames.put(Integer.parseInt(escape, 16), tmp[0].trim());
                }
            }
            return;
        }
        if ("401".equals(httpCode)) {
            String challenge = "";
            for (String line : lines) {
                if (!line.startsWith(HEADER_WWW_AUTHENTICATE)) continue;
                challenge = line.substring(HEADER_WWW_AUTHENTICATE.length() + 1).trim();
                break;
            }
            this.listener.authenticationRequested(channel, channel.getLocation().toString(), challenge);
        } else {
            this.listener.connectionFailed(channel);
        }
    }

    private void sendHandshakePayload(WebSocketChannel channel, String authToken) {
        String[] headerNames = new String[4];
        String[] headerValues = new String[4];
        headerNames[0] = HEADER_PROTOCOL;
        headerValues[0] = null;
        headerNames[1] = HEADER_SEC_PORTOCOL;
        headerValues[1] = channel.getProtocol();
        headerNames[2] = HEADER_SEC_EXTENSIONS;
        headerValues[2] = "x-kaazing-http-revalidate";
        headerNames[3] = HEADER_AUTHORIZATION;
        headerValues[3] = authToken;
        byte[] payload = this.encodeGetRequest(channel.getLocation().getURI(), headerNames, headerValues);
        this.nextHandler.processBinaryMessage(channel, new ByteBuffer(payload));
    }

    private byte[] encodeGetRequest(URI requestURI, String[] names, String[] values) {
        LOG.entering(CLASS_NAME, "encodeGetRequest", new Object[]{requestURI, names, values});
        int requestSize = this.getEncodeRequestSize(requestURI, names, values);
        java.nio.ByteBuffer buf = java.nio.ByteBuffer.allocate(requestSize);
        buf.put(GET_BYTES);
        buf.put(SPACE_BYTES);
        String path = requestURI.getPath();
        if (requestURI.getQuery() != null) {
            path = path + "?" + requestURI.getQuery();
        }
        buf.put(path.getBytes());
        buf.put(SPACE_BYTES);
        buf.put(HTTP_1_1_BYTES);
        buf.put(CRLF_BYTES);
        for (int i = 0; i < names.length; ++i) {
            String headerName = names[i];
            String headerValue = values[i];
            if (headerName == null || headerValue == null) continue;
            buf.put(headerName.getBytes());
            buf.put(COLON_BYTES);
            buf.put(SPACE_BYTES);
            buf.put(headerValue.getBytes());
            buf.put(CRLF_BYTES);
        }
        buf.put(CRLF_BYTES);
        buf.flip();
        return buf.array();
    }

    private int getEncodeRequestSize(URI requestURI, String[] names, String[] values) {
        int size = 0;
        size += GET_BYTES.length;
        size += SPACE_BYTES.length;
        String path = requestURI.getPath();
        if (requestURI.getQuery() != null) {
            path = path + "?" + requestURI.getQuery();
        }
        size += path.getBytes().length;
        size += SPACE_BYTES.length;
        size += HTTP_1_1_BYTES.length;
        size += CRLF_BYTES.length;
        for (int i = 0; i < names.length; ++i) {
            String headerName = names[i];
            String headerValue = values[i];
            if (headerName == null || headerValue == null) continue;
            size += headerName.getBytes().length;
            size += COLON_BYTES.length;
            size += SPACE_BYTES.length;
            size += headerValue.getBytes().length;
            size += CRLF_BYTES.length;
        }
        LOG.fine("Returning a request size of " + (size += CRLF_BYTES.length));
        return size;
    }
}

