/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5.impl.http;

import com.kaazing.gateway.client.html5.ByteBuffer;
import com.kaazing.gateway.client.html5.impl.http.HttpRequest;
import com.kaazing.gateway.client.html5.impl.http.HttpRequestHandler;
import com.kaazing.gateway.client.html5.impl.http.HttpRequestHandlerAdapter;
import com.kaazing.gateway.client.html5.impl.http.HttpRequestListener;
import com.kaazing.gateway.client.html5.impl.http.HttpResponse;
import com.kaazing.gateway.client.html5.impl.wseb.WebSocketEmulatedChannel;
import com.kaazing.gateway.client.html5.util.HttpURI;
import com.kaazing.gateway.client.html5.util.StringUtils;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpRequestRedirectHandler
extends HttpRequestHandlerAdapter {
    private static final String CLASS_NAME = HttpRequestRedirectHandler.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);

    @Override
    public void setNextHandler(HttpRequestHandler handler) {
        super.setNextHandler(handler);
        handler.setListener(new HttpRequestListener(){

            @Override
            public void requestReady(HttpRequest request) {
                HttpRequestRedirectHandler.this.listener.requestReady(request);
            }

            @Override
            public void requestOpened(HttpRequest request) {
                HttpRequestRedirectHandler.this.listener.requestOpened(request);
            }

            @Override
            public void requestProgressed(HttpRequest request, ByteBuffer payload) {
                HttpRequestRedirectHandler.this.listener.requestProgressed(request, payload);
            }

            @Override
            public void requestLoaded(HttpRequest request, HttpResponse response) {
                int responseCode = response.getStatusCode();
                switch (responseCode) {
                    case 301: 
                    case 302: 
                    case 307: {
                        String redirectedLocation = response.getHeader("Location");
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("redirectedLocation = " + StringUtils.stripControlCharacters(redirectedLocation));
                        }
                        if (redirectedLocation == null) {
                            throw new IllegalStateException("Redirect response missing location header: " + responseCode);
                        }
                        try {
                            HttpURI uri = new HttpURI(redirectedLocation);
                            HttpRequest redirectRequest = new HttpRequest(request.getMethod(), uri, request.isAsync());
                            redirectRequest.parent = request.parent;
                            WebSocketEmulatedChannel channel = (WebSocketEmulatedChannel)request.parent.getParent();
                            channel.redirectUri = uri;
                            for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
                                redirectRequest.setHeader(entry.getKey(), entry.getValue());
                            }
                            HttpRequestRedirectHandler.this.nextHandler.processOpen(redirectRequest);
                            break;
                        }
                        catch (Exception e) {
                            LOG.log(Level.WARNING, e.getMessage(), e);
                            throw new IllegalStateException("Redirect to a malformed URL: " + redirectedLocation);
                        }
                    }
                    default: {
                        HttpRequestRedirectHandler.this.listener.requestLoaded(request, response);
                    }
                }
            }

            @Override
            public void requestClosed(HttpRequest request) {
                HttpRequestRedirectHandler.this.listener.requestClosed(request);
            }

            @Override
            public void requestAborted(HttpRequest request) {
                HttpRequestRedirectHandler.this.listener.requestAborted(request);
            }

            @Override
            public void errorOccurred(HttpRequest request) {
                HttpRequestRedirectHandler.this.listener.errorOccurred(request);
            }
        });
    }
}

