/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5;

import com.kaazing.gateway.client.html5.ByteBuffer;
import com.kaazing.gateway.client.html5.WebSocketEvent;
import com.kaazing.gateway.client.html5.WebSocketListener;
import com.kaazing.gateway.client.html5.impl.WebSocketChannel;
import com.kaazing.gateway.client.html5.impl.WebSocketHandlerListener;
import com.kaazing.gateway.client.html5.impl.ws.WebSocketCompositeChannel;
import com.kaazing.gateway.client.html5.impl.ws.WebSocketCompositeHandler;
import com.kaazing.gateway.client.html5.util.WSCompositeURI;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebSocket {
    private static final String CLASS_NAME = WebSocket.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static WebSocketCompositeHandler handler;
    private WebSocketCompositeChannel channel;
    private final List<WebSocketListener> eventListeners = new ArrayList<WebSocketListener>();
    private static final WebSocketHandlerListener handlerListener;

    public WebSocket() throws Exception {
        LOG.entering(CLASS_NAME, "<init>");
        if (handler == null) {
            handler = new WebSocketCompositeHandler();
            handler.setListener(handlerListener);
        }
    }

    public ReadyState getReadyState() {
        if (this.channel == null) {
            return ReadyState.CONNECTING;
        }
        return this.channel.getReadyState();
    }

    public void connect(URI location, String protocol) throws Exception {
        WSCompositeURI uri = new WSCompositeURI(location);
        this.channel = new WebSocketCompositeChannel(uri, protocol, false);
        this.channel.webSocket = this;
        handler.processConnect(this.channel, uri.getWSEquivalent(), protocol);
    }

    public synchronized void connect(URI location) throws Exception {
        LOG.entering(CLASS_NAME, "connect", location);
        this.connect(location, null);
    }

    public synchronized boolean send(String message) throws Exception {
        LOG.entering(CLASS_NAME, "send", message);
        handler.processTextMessage(this.channel, message);
        return true;
    }

    public synchronized void close() throws Exception {
        handler.processClose(this.channel);
    }

    public int getBufferedAmount() {
        return this.channel.getBufferedAmount();
    }

    public URI getURL() {
        if (this.channel == null) {
            throw new IllegalStateException("Not connected");
        }
        return this.channel.getURL();
    }

    public void addWebSocketListener(WebSocketListener listener) {
        LOG.entering(CLASS_NAME, "addWebSocketListener", listener);
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.eventListeners.add(listener);
    }

    public void removeWebSocketListener(WebSocketListener listener) {
        LOG.entering(CLASS_NAME, "removeWebSocketListener", listener);
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.eventListeners.remove(listener);
    }

    static {
        handlerListener = new WebSocketHandlerListener(){

            @Override
            public void connectionOpened(WebSocketChannel channel, String protocol) {
                LOG.entering(CLASS_NAME, "onOpen");
                WebSocket ws = ((WebSocketCompositeChannel)channel).getWebSocket();
                WebSocketEvent event = new WebSocketEvent(ws, WebSocketEvent.Type.OPEN, null);
                for (WebSocketListener listener : ws.eventListeners) {
                    try {
                        listener.onOpen(event);
                    }
                    catch (RuntimeException e) {
                        LOG.logp(Level.WARNING, CLASS_NAME, "onOpen", "Application threw an exception during onOpen: " + e.getMessage(), e);
                    }
                }
            }

            @Override
            public void messageReceived(WebSocketChannel channel, ByteBuffer buf) {
                LOG.entering(CLASS_NAME, "onMessage");
                String data = buf.getString(UTF_8);
                WebSocket ws = ((WebSocketCompositeChannel)channel).getWebSocket();
                WebSocketEvent event = new WebSocketEvent(ws, WebSocketEvent.Type.MESSAGE, data);
                for (WebSocketListener listener : ws.eventListeners) {
                    try {
                        listener.onMessage(event);
                    }
                    catch (RuntimeException e) {
                        LOG.logp(Level.WARNING, CLASS_NAME, "onMessage", "Application threw an exception during onMessage: " + e.getMessage(), e);
                    }
                }
            }

            @Override
            public void connectionClosed(WebSocketChannel channel) {
                LOG.entering(CLASS_NAME, "onClose");
                WebSocket ws = ((WebSocketCompositeChannel)channel).getWebSocket();
                WebSocketEvent event = new WebSocketEvent(ws, WebSocketEvent.Type.CLOSE, null);
                for (WebSocketListener eventListener : ws.eventListeners) {
                    try {
                        eventListener.onClose(event);
                    }
                    catch (RuntimeException e) {
                        LOG.logp(Level.WARNING, CLASS_NAME, "onClose", "Application threw an exception during onClose: " + e.getMessage(), e);
                    }
                }
            }

            @Override
            public void connectionFailed(WebSocketChannel channel) {
            }

            @Override
            public void authenticationRequested(WebSocketChannel channel, String location, String challenge) {
            }

            @Override
            public void redirected(WebSocketChannel channel, String location) {
            }
        };
    }

    public static enum ReadyState {
        CONNECTING,
        OPEN,
        CLOSED;

    }
}

