/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arrpc.nio;

import com.bmc.arsys.arrpc.nio.ArClientRequestHandler;
import com.bmc.arsys.arrpc.nio.ArRpcCallHandler;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;

public class ArSelectorThread
implements Runnable {
    private static Logger LOGGER = Logger.getLogger(ArSelectorThread.class);
    private Selector selector;
    private CopyOnWriteArrayList<ArRpcCallHandler> handlers = new CopyOnWriteArrayList();

    public ArSelectorThread() throws IOException {
        this.selector = Selector.open();
    }

    public void addHandler(ArRpcCallHandler handler) throws IOException, ClosedChannelException {
        this.handlers.add(handler);
        this.selector.wakeup();
    }

    private void registerNewHandlers() throws IOException {
        if (this.handlers.size() > 0) {
            Iterator<ArRpcCallHandler> it = this.handlers.iterator();
            this.handlers.clear();
            while (it.hasNext()) {
                ArRpcCallHandler handler = it.next();
                try {
                    LOGGER.debug((Object)("Registering a new rpc call handler " + handler.hashCode() + " for selector " + this.selector.hashCode()));
                    handler.register(this.selector);
                }
                catch (Exception cce) {
                    LOGGER.error((Object)("Registering new Handler failed " + cce.getLocalizedMessage()));
                    handler.close();
                }
            }
        }
    }

    private void dispatch(SelectionKey key) {
        ArClientRequestHandler r = (ArClientRequestHandler)key.attachment();
        LOGGER.debug((Object)("dispatch SelectionKey " + key.hashCode() + " to attached request handler: " + (r == null ? null : Integer.valueOf(r.hashCode()))));
        if (r != null) {
            r.handleRequest(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOGGER.debug((Object)("Starting new Selector thread with id " + this.selector.hashCode()));
        try {
            while (!Thread.interrupted()) {
                try {
                    Set<SelectionKey> selected;
                    int event = this.selector.select();
                    this.registerForRead(false, null, false);
                    if (event == 0) {
                        this.registerNewHandlers();
                        continue;
                    }
                    LOGGER.trace((Object)("Selector " + this.selector.hashCode() + " reacting..."));
                    Set<SelectionKey> set = selected = this.selector.selectedKeys();
                    synchronized (set) {
                        Iterator<SelectionKey> it = selected.iterator();
                        ArrayList<Object> keyHandlers = new ArrayList<Object>();
                        while (it.hasNext()) {
                            SelectionKey key = it.next();
                            try {
                                if (!key.isValid() || !key.isReadable()) continue;
                                if (!keyHandlers.contains(key.attachment())) {
                                    keyHandlers.add(key.attachment());
                                    this.dispatch(key);
                                    continue;
                                }
                                LOGGER.trace((Object)("Same selector " + key.selector().hashCode() + " reacted more than one events..."));
                            }
                            catch (CancelledKeyException e) {
                                LOGGER.trace((Object)e.getLocalizedMessage());
                            }
                        }
                        keyHandlers.clear();
                        selected.clear();
                        LOGGER.trace((Object)("Selector " + this.selector.hashCode() + " done react."));
                    }
                }
                catch (Throwable t) {
                    LOGGER.error((Object)("Exception in selector thread loop. Shutting down selector thread" + Thread.currentThread().getId()), t);
                }
            }
        }
        finally {
            LOGGER.debug((Object)("Closing a selector thread with id " + this.selector.hashCode()));
            this.close();
        }
    }

    public void close() {
        try {
            this.selector.close();
            this.handlers.clear();
        }
        catch (Throwable t) {
            LOGGER.error((Object)t.getLocalizedMessage());
        }
    }

    public void registerForRead(boolean register, SelectionKey sk, boolean wakeUpSelector) {
        if (register && sk != null) {
            LOGGER.trace((Object)("+++++++++++++++++++++registerForRead " + register + " " + wakeUpSelector + " " + sk.hashCode()));
            sk.selector().wakeup();
            LOGGER.trace((Object)"+++++++++++++++++++++registerForRead woke up Selector for OP_READ");
            int orgOp = sk.interestOps();
            int op = sk.interestOps() | 1;
            sk.interestOps(op);
            LOGGER.trace((Object)("+++++++++++++++++++++registerForRead has set from " + orgOp + " to " + op + " for selector " + sk.selector().hashCode() + " SelectionKey " + sk.hashCode()));
            if (wakeUpSelector) {
                sk.selector().wakeup();
                LOGGER.trace((Object)"+++++++++++++++++++++registerForRead wakeUpSelector done for next event.");
            }
        }
    }

    public void unregisterForRead(SelectionKey key) {
        if (key != null) {
            LOGGER.trace((Object)"=====================unregisterForRead. Focus on current event.");
            key.selector().wakeup();
            LOGGER.trace((Object)"=====================unregisterForRead woke up Selector for ~OP_READ");
            int orgOp = key.interestOps();
            int op = key.interestOps() & 0xFFFFFFFE;
            key.interestOps(op);
            LOGGER.trace((Object)("=====================unregisterForRead has set from " + orgOp + " to " + op + " for selector " + key.selector().hashCode() + " SelectionKey " + key.hashCode()));
        }
    }
}

