/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.utils;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;

public class StringByteUtil {
    private static Logger logger = Logger.getLogger(StringByteUtil.class);
    private static Base64 base64 = new Base64();

    private StringByteUtil() {
    }

    public static byte[] concatenateByteArrays(byte[] array1, byte[] array2) {
        ByteBuffer buf = ByteBuffer.allocate(array1.length + array2.length);
        buf.put(array1);
        buf.put(array2);
        return buf.array();
    }

    public static byte[] concatenateByteArrays(byte[] array1, byte[] array2, byte[] array3) {
        ByteBuffer buf = ByteBuffer.allocate(array1.length + array2.length + array3.length);
        buf.put(array1);
        buf.put(array2);
        buf.put(array3);
        return buf.array();
    }

    public static byte[] concatenateByteArrays(byte[] array1, byte[] array2, byte[] array3, byte[] array4) {
        ByteBuffer buf = ByteBuffer.allocate(array1.length + array2.length + array3.length + array4.length);
        buf.put(array1);
        buf.put(array2);
        buf.put(array3);
        buf.put(array4);
        return buf.array();
    }

    public static byte[] getByteArrays(byte[] array1, int start, int len) {
        int capacity;
        if (start == 0 && len == array1.length) {
            return array1;
        }
        int n = capacity = array1.length > start + len ? array1.length : start + len;
        if (logger.isDebugEnabled() && capacity > 500000) {
            logger.debug((Object)("getByteArrays needs capacity: " + len));
        }
        ByteBuffer buf = ByteBuffer.allocate(capacity);
        buf.put(array1);
        if (logger.isDebugEnabled() && len > 500000) {
            logger.debug((Object)("getByteArrays needs: " + len));
        }
        byte[] res = new byte[len];
        buf.position(start);
        buf.get(res);
        buf.clear();
        buf = null;
        return res;
    }

    public static byte[] getOctetKey(byte[] orgBytes) {
        int octet = 8;
        int capacity = orgBytes.length > octet << 1 ? orgBytes.length : octet << 1;
        ByteBuffer buf = ByteBuffer.allocate(capacity);
        buf.put(orgBytes);
        buf.position(octet);
        byte[] res = new byte[octet];
        buf.get(res);
        buf.clear();
        buf = null;
        return res;
    }

    public static byte[] resizeByteArray(byte[] orgBytes, int newSize) {
        if (newSize == orgBytes.length) {
            return orgBytes;
        }
        return StringByteUtil.getByteArrays(orgBytes, 0, newSize);
    }

    public static byte[] resizeStringToByteArray(String orgStr, String charSetName, int newSize) throws UnsupportedEncodingException {
        byte[] orgBytes = orgStr.getBytes(charSetName);
        return StringByteUtil.resizeByteArray(orgBytes, newSize);
    }

    public static byte[] stringToMaxByteArray(String value, String charSetName, int size) throws IllegalArgumentException, UnsupportedEncodingException {
        byte[] orgBytes;
        if (value == null) {
            return new byte[size];
        }
        if (charSetName == null) {
            charSetName = "utf-8";
        }
        if (charSetName.equals("EUC_JP")) {
            value = new String(value.getBytes("windows-31j"), "SJIS");
        }
        if ((orgBytes = value.getBytes(charSetName)).length > size) {
            throw new IllegalArgumentException("String is longer than the maximum allowed length, which is " + size + " bytes");
        }
        return StringByteUtil.resizeByteArray(orgBytes, size);
    }

    public static String createNullTerminatedString(byte[] bytes, String charSetName) throws UnsupportedEncodingException {
        String retString = null;
        if (charSetName == null) {
            charSetName = "utf-8";
        }
        int count = 0;
        for (count = 0; count < bytes.length && bytes[count] != 0; ++count) {
        }
        retString = bytes.length == 0 || count < bytes.length ? new String(bytes, 0, count, charSetName) : new String(bytes, charSetName);
        if (charSetName.equals("EUC_JP")) {
            retString = new String(retString.getBytes("SJIS"), "windows-31j");
        }
        return retString;
    }

    public static byte[] generateRandomBytes(int len) {
        if (len < 0) {
            return new byte[0];
        }
        byte[] randBytes = new byte[len];
        Random r = new Random();
        r.nextBytes(randBytes);
        return randBytes;
    }

    public static long uLongToLong(int ulongVal) {
        return (long)ulongVal & 0xFFFFFFFFL;
    }

    public static int longToULong(long longVal) {
        return (int)(longVal & 0xFFFFFFFFFFFFFFFFL);
    }

    public static byte[] hexStrToBytes(String hexStr) throws DecoderException {
        char[] charArray = hexStr.toCharArray();
        return StringByteUtil.hexCharToBytes(charArray);
    }

    public static byte[] hexCharToBytes(char[] hexCharArray) throws DecoderException {
        return Hex.decodeHex((char[])hexCharArray);
    }

    public static String bytesToHexString(byte[] buf) {
        return StringByteUtil.bytesToHexCharArray(buf).toString();
    }

    public static char[] bytesToHexCharArray(byte[] buf) {
        return Hex.encodeHex((byte[])buf);
    }

    public static byte[] base64Encode(byte[] fromBytes) {
        byte[] rst = new byte[]{};
        if (fromBytes != null) {
            rst = base64.encode(fromBytes);
        }
        return rst;
    }

    public static byte[] base64Decode(byte[] fromBytes) {
        byte[] rst = new byte[]{};
        if (fromBytes != null) {
            rst = base64.decode(fromBytes);
        }
        return rst;
    }

    public static ByteBuffer expandDirectByteBufferCapacity(ByteBuffer oldBuffer, int newCapacity) {
        if (newCapacity <= oldBuffer.capacity()) {
            return oldBuffer;
        }
        ByteBuffer newBuffer = ByteBuffer.allocateDirect(newCapacity);
        int oldPosition = oldBuffer.position();
        oldBuffer.flip();
        newBuffer.put(oldBuffer);
        newBuffer.position(oldPosition);
        return newBuffer;
    }

    public static ByteBuffer expandByteBufferCapacity(ByteBuffer oldBuffer, int newCapacity) {
        if (newCapacity <= oldBuffer.capacity()) {
            return oldBuffer;
        }
        ByteBuffer newBuffer = ByteBuffer.allocate(newCapacity);
        int oldPosition = oldBuffer.position();
        oldBuffer.flip();
        newBuffer.put(oldBuffer);
        newBuffer.position(oldPosition);
        return newBuffer;
    }

    public static ByteBuffer checkAndExpandDirectByteBufferCapacity(ByteBuffer oldBuffer, int needSize) {
        if (oldBuffer == null || oldBuffer.remaining() >= needSize) {
            return oldBuffer;
        }
        int newCapacity = StringByteUtil.getNewBufferCapacityForExpanding(oldBuffer.capacity(), needSize);
        return StringByteUtil.expandDirectByteBufferCapacity(oldBuffer, newCapacity);
    }

    public static ByteBuffer checkAndExpandByteBufferCapacity(ByteBuffer oldBuffer, int needSize) {
        if (oldBuffer == null || oldBuffer.remaining() >= needSize) {
            return oldBuffer;
        }
        int newCapacity = StringByteUtil.getNewBufferCapacityForExpanding(oldBuffer.capacity(), needSize);
        return StringByteUtil.expandByteBufferCapacity(oldBuffer, newCapacity);
    }

    public static int getNewBufferCapacityForExpanding(int currentBufSize, int minNeedSize) {
        int capacity = currentBufSize;
        if (currentBufSize > 0x7FFFFF7F || minNeedSize > 0 && 0x7FFFFF7F - Math.max(minNeedSize, 4096) < currentBufSize || minNeedSize == 0 && 2137483519 < currentBufSize) {
            return currentBufSize;
        }
        capacity = minNeedSize > 0 ? (capacity += Math.max(minNeedSize, 4096)) : (currentBufSize < 500000 && currentBufSize < 0x3FFFFFFF ? currentBufSize * 2 : (capacity += 500000));
        return capacity;
    }

    public static byte[] stringToByteArray(String str) {
        byte[] result = new byte[str.length() + 1];
        for (int i = 0; i < str.length(); ++i) {
            result[i] = (byte)str.charAt(i);
        }
        result[str.length()] = 0;
        return result;
    }

    public static String[] splitString(String entryId, int maxBytes, String serverCharSet) {
        ArrayList<String> var = new ArrayList<String>();
        while (entryId.length() > 0) {
            int n = entryId.length();
            if (n > maxBytes) {
                n = StringByteUtil.nextPos(entryId, maxBytes - 1);
            }
            if (StringByteUtil.allASCII(entryId, 0, n)) {
                var.add(entryId.substring(0, n));
            } else {
                while (n > 0) {
                    String ss = entryId.substring(0, n);
                    byte[] b = null;
                    try {
                        b = ss.getBytes(serverCharSet);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new IllegalArgumentException(e.getMessage());
                    }
                    if (b != null && b.length <= maxBytes) {
                        var.add(ss);
                        break;
                    }
                    n = StringByteUtil.prevPos(entryId, n);
                }
            }
            entryId = entryId.substring(n);
        }
        return var.toArray(new String[0]);
    }

    private static boolean allASCII(String s, int start, int len) {
        int n = start + len;
        for (int i = start; i < n; ++i) {
            if ('\u007f' >= s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static int nextPos(String s, int pos) {
        if (65535 < s.codePointAt(pos)) {
            return pos + 2;
        }
        return pos + 1;
    }

    private static int prevPos(String s, int pos) {
        if (pos < 2) {
            return pos == 1 ? 0 : -1;
        }
        if (65535 < s.codePointAt(pos - 2)) {
            return pos - 2;
        }
        return pos - 1;
    }
}

