/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.utils;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ARHostAddressUtil {
    private static final Logger logger = Logger.getLogger(ARHostAddressUtil.class);
    private static final String WORST_CASE_ADDRESS = "127.0.0.1";
    private static final String HOST_PORT_SEPARATOR = ":";
    private static final String BEGIN_HOSTADDRESS = "[";
    private static final String END_HOSTADDRESS = "]";

    public static StringBuilder combineHostPort(String host, int port, StringBuilder sb) {
        if (host.contains(HOST_PORT_SEPARATOR) && !host.contains(END_HOSTADDRESS) && port > 0) {
            sb.append(BEGIN_HOSTADDRESS).append(host).append(END_HOSTADDRESS);
        } else {
            sb.append(host);
        }
        if (port > 0) {
            sb.append(HOST_PORT_SEPARATOR).append(port);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("address_port=" + sb.toString()));
        }
        return sb;
    }

    public static String convertHostPort(String host, int port) {
        StringBuilder sb = new StringBuilder();
        sb = ARHostAddressUtil.combineHostPort(host, port, sb);
        return sb.toString();
    }

    public static String[] parseConfigLine(String line, String[] parameters) {
        StringTokenizer serverTokenizer = new StringTokenizer(line, HOST_PORT_SEPARATOR);
        String host = null;
        String port = null;
        String password = null;
        String portPassword = null;
        if (serverTokenizer.countTokens() >= 2 && line.indexOf(END_HOSTADDRESS) > 1 || serverTokenizer.countTokens() > parameters.length && line.indexOf(END_HOSTADDRESS) < 0) {
            int i = line.indexOf(END_HOSTADDRESS);
            if (serverTokenizer.countTokens() > parameters.length && i < 0) {
                logger.error((Object)("Wrong format for Server-Plugin-Alias with IPv6 address" + line + ", It should be configured in the format of [2001:500:100::fa1f]:9999"));
            } else {
                StringTokenizer portPasswdTokenizer;
                parameters[0] = host = line.substring(1, i);
                if (i < line.length() - 2 && (portPassword = line.substring(i + 2)) != null && portPassword.length() > 1 && (portPasswdTokenizer = new StringTokenizer(portPassword, HOST_PORT_SEPARATOR)).hasMoreTokens() && parameters.length > 1 && (port = portPasswdTokenizer.nextToken()) != null && port.length() > 0) {
                    parameters[1] = port.trim();
                    if (portPasswdTokenizer.hasMoreTokens() && parameters.length > 2) {
                        parameters[2] = password = portPasswdTokenizer.nextToken();
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Plugin Alias IPv6 address host - " + host));
                    logger.debug((Object)("Plugin Alias port - " + port));
                    if (password != null) {
                        logger.debug((Object)("Plugin Alias passwd - " + password));
                    }
                }
            }
        } else {
            parameters[0] = host = serverTokenizer.nextToken();
            if (serverTokenizer.hasMoreTokens() && parameters.length > 1 && (port = serverTokenizer.nextToken()) != null && port.length() > 0) {
                parameters[1] = port.trim().replaceAll("^\"|\"$", "");
                if (serverTokenizer.hasMoreTokens() && parameters.length > 2 && (password = serverTokenizer.nextToken()) != null && password.length() > 0) {
                    parameters[2] = password;
                }
            }
        }
        return parameters;
    }

    public static String getLocalHostName() {
        String hostToCheck = null;
        try {
            hostToCheck = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostToCheck = WORST_CASE_ADDRESS;
        }
        return hostToCheck;
    }

    public static InetAddress getARMonitorSocketAddress() {
        InetAddress addr;
        try {
            addr = InetAddress.getLocalHost();
            if (addr instanceof Inet6Address) {
                addr = InetAddress.getByName(ARHostAddressUtil.getAddressIfHostNameNotResolvable());
            }
        }
        catch (UnknownHostException e) {
            addr = null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ARMonitor - " + addr));
        }
        return addr;
    }

    public static String getFormatedHostIPAddress(String hostName) {
        String hostIpAddress = null;
        Boolean isIPv6 = false;
        if (hostName != null && hostName.length() > 0) {
            try {
                InetAddress inetToCheck = InetAddress.getByName(hostName);
                if (inetToCheck instanceof Inet6Address) {
                    isIPv6 = true;
                }
                hostIpAddress = inetToCheck.getHostAddress();
            }
            catch (UnknownHostException e) {
                hostIpAddress = hostName;
            }
            if (isIPv6.booleanValue() && hostIpAddress.contains(HOST_PORT_SEPARATOR)) {
                hostIpAddress = BEGIN_HOSTADDRESS + hostIpAddress + END_HOSTADDRESS;
            }
        }
        return hostIpAddress;
    }

    public static String getFullyQualifiedServerName(String serverName, String domainName, String fullHostName) {
        StringBuilder sb = new StringBuilder();
        if (serverName != null) {
            sb.append(serverName);
            if (domainName != null) {
                sb.append(".");
                sb.append(domainName);
            } else {
                int dot = fullHostName.indexOf(".");
                if (dot > 0) {
                    sb.append(fullHostName.substring(dot));
                }
            }
        } else if (domainName != null) {
            int dot = fullHostName.indexOf(".");
            if (dot > 0) {
                sb.append(fullHostName.substring(0, dot + 1));
            } else {
                sb.append(fullHostName);
                sb.append(".");
            }
            sb.append(domainName);
        } else {
            sb.append(fullHostName);
        }
        return sb.toString();
    }

    public static InetAddress getInetAddress(String hostName) {
        InetAddress ia = null;
        if (hostName != null && hostName.length() != 0) {
            try {
                ia = InetAddress.getByName(hostName);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (ia == null) {
            try {
                Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
                Pattern hostNamePattern = Pattern.compile("^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])$");
                while (nics.hasMoreElements()) {
                    NetworkInterface networkInterface = nics.nextElement();
                    if (networkInterface != null && networkInterface.getHardwareAddress() != null && networkInterface.getHardwareAddress().length > 0) {
                        Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                        while (inetAddresses != null && inetAddresses.hasMoreElements()) {
                            InetAddress inetAddress = inetAddresses.nextElement();
                            if (!hostNamePattern.matcher(inetAddress.getCanonicalHostName()).matches() || inetAddress.getHostAddress().equals(inetAddress.getCanonicalHostName())) continue;
                            ia = inetAddress;
                            break;
                        }
                    }
                    if (ia == null) continue;
                    break;
                }
            }
            catch (SocketException e) {
                return null;
            }
        }
        return ia;
    }

    public static String getAddressIfHostNameNotResolvable() {
        return WORST_CASE_ADDRESS;
    }
}

