/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.devutility.classAugmenter;

import com.bmc.arsys.devutility.classAugmenter.Argument;
import com.bmc.arsys.devutility.classAugmenter.JavaParser;
import com.bmc.arsys.devutility.classAugmenter.ToStringHintData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class ClassAugmenter {
    private static final Argument[] argTypes = new Argument[]{new Argument("p", "package", "Package", false), new Argument("s", "source-directory", "Input directory of source files", false), new Argument("o", "output-directory", "Output directory for produced files", true), new Argument("f", "source-file.java", "Input source file", false), new Argument("d", "toString.data", "Data file that includes hints for toString generation", true)};
    private Map<String, ToStringHintData> hintDataMap;
    static final String NEW_LINE = System.getProperty("line.separator");
    static final String INDENT_STR = "    ";
    static final String METHOD_TOSTRING_SIG = NEW_LINE + "    " + "@Override" + NEW_LINE + "    " + "public String toString() {";
    static final String METHOD_HASHCODE_SIG = NEW_LINE + "    " + "@Override" + NEW_LINE + "    " + "public int hashCode() {";
    static final String METHOD_EQUALS_SIG = "    public boolean equals(Object obj) {";
    static final String METHOD_BODY_BEGIN = "{";
    static final String METHOD_BODY_END = "    }" + NEW_LINE;
    static final String EQUALS_HEADER_SNIPPET = "        if (obj instanceof %1$s == false) {" + NEW_LINE + "    " + "    " + "    " + "return false;" + NEW_LINE + "    " + "    " + "}" + NEW_LINE + "    " + "    " + "if (this == obj) {" + NEW_LINE + "    " + "    " + "    " + "return true;" + NEW_LINE + "    " + "    " + "}" + NEW_LINE + "    " + "    " + "%1$s rhs = (%1$s) obj;" + NEW_LINE;
    static final String TOSTRING_HINT_FILE_HEADER = "#============================================================================================================" + NEW_LINE + "# toString.data" + NEW_LINE + "#============================================================================================================" + NEW_LINE + "#Class                                                  | Sort  | [FieldLabel/FieldName;]n" + NEW_LINE + "#============================================================================================================" + NEW_LINE + "# Class         " + NEW_LINE + "#       - indicates the class full name" + NEW_LINE + "# Sort" + NEW_LINE + "#       - whether to sort on field display labels. Valid values : true (Default) or false" + NEW_LINE + "# [FieldLabel/FieldName;]n" + NEW_LINE + "#       - Pairs of field display label and actual field name that are separated by '/'," + NEW_LINE + "#         with each pair separated from next one by ';'" + NEW_LINE + "#" + NEW_LINE + "# Example:" + NEW_LINE + "# ========" + NEW_LINE + "# com.bmc.arsys.api.StatusInfo                       | true  | Message Type/m_messageType;Message Number/m_messageNum;Message Text/m_messageText;Appended Text/m_appendedText;" + NEW_LINE + "# (OR)" + NEW_LINE + "# com.bmc.arsys.api.StatusInfo                       | true  | Message Type/m_messageType;" + NEW_LINE + "#                                                       |       | Message Number/m_messageNum;" + NEW_LINE + "#                                                       |       | Message Text/m_messageText;" + NEW_LINE + "#                                                       |       | Appended Text/m_appendedText;" + NEW_LINE + "#" + NEW_LINE + "#============================================================================================================" + NEW_LINE + "#Class                                                  | Sort  | [FieldLabel/FieldName;]n" + NEW_LINE + "#============================================================================================================" + NEW_LINE;

    public static void usage() {
        System.out.println("Class Augmenter V 0.1");
        System.out.println("  This ulitity allows for generating stubs for toString, equals, clone methods based on Apache commons.lang.XXXBuilder classes.");
        System.out.println("Usage:");
        System.out.print("  java com.bmc.arsys.devutility.classAugmenter.ClassAugmenter ");
        for (Argument argument : argTypes) {
            System.out.print(String.format("%s-%s %s%s ", argument.isOptional() ? "[" : "", argument.getIndicator(), argument.getShortName(), argument.isOptional() ? "]" : ""));
        }
        System.out.println("");
        System.out.println("  where");
        for (Argument argument : argTypes) {
            System.out.println(String.format("      %-20s %s ", argument.getShortName(), argument.getDescription()));
        }
        System.out.println("");
    }

    private Map<String, String> loadArguments(String[] argv) {
        int count;
        TreeMap<String, String> map = new TreeMap<String, String>();
        int n = count = argv != null ? argv.length : 0;
        for (int i = 0; i < count; ++i) {
            String arg = argv[i];
            if ((arg = arg.trim()).startsWith("-") || arg.startsWith("/")) {
                arg = arg.substring(1);
            }
            if (map.containsKey(arg)) {
                System.err.println("ERROR: Value for option (" + arg + ") already accepted as" + (String)map.get(arg));
                continue;
            }
            boolean invalidArg = true;
            int validArgs = argTypes.length;
            for (int j = 0; j < validArgs; ++j) {
                if (!arg.equalsIgnoreCase(argTypes[j].getIndicator())) continue;
                invalidArg = false;
                map.put(arg.toLowerCase(), argv[i + 1]);
                ++i;
                break;
            }
            if (!invalidArg) continue;
            System.err.println("WARN: Ignoring unknown option (" + arg + ")");
        }
        return map;
    }

    private void loadToStringDataFile(String filePath) {
        if (filePath == null || filePath.length() == 0 || !new File(filePath).exists()) {
            return;
        }
        this.hintDataMap = new TreeMap<String, ToStringHintData>();
        ToStringHintData prevHint = null;
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(filePath));
            while ((line = in.readLine()) != null) {
                String[] tokens;
                if ((line = line.trim()).length() == 0 || line.startsWith("#") || (tokens = line.split("\\|")) == null || tokens.length != 3) continue;
                if (tokens[0] != null && tokens[0].length() > 0) {
                    if (prevHint != null) {
                        this.hintDataMap.put(prevHint.getOfClass().getName(), prevHint);
                    }
                    try {
                        prevHint = new ToStringHintData(tokens);
                    }
                    catch (ClassNotFoundException e) {
                        System.err.println("ERROR: Failed processing line: (" + line + ")");
                        e.printStackTrace();
                    }
                    continue;
                }
                if (tokens[0].length() != 0 || tokens[1].length() != 0 || tokens[2].length() < 0 || prevHint == null) continue;
                prevHint.addLabelNames(tokens[2]);
            }
            if (prevHint != null) {
                this.hintDataMap.put(prevHint.getOfClass().getName(), prevHint);
            }
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void processFile(String sourceFilePath, Class clazz, String outDirPath, StringBuffer sbHintOut) throws IOException {
        if (clazz.isInterface()) {
            return;
        }
        String oldFilePath = sourceFilePath;
        File temp = File.createTempFile("clsaug", ".tmp");
        temp.deleteOnExit();
        String newFilePath = temp.getAbsolutePath();
        Map<String, String> boundaries = JavaParser.getMethodBoundaries(oldFilePath);
        this.SubstituteFunctionBody(newFilePath, oldFilePath, boundaries, "toString", this.getToStringBody(clazz, sbHintOut), "import org.apache.commons.lang.builder.ToStringBuilder;\n", "^\\s*import\\s*org.apache.commons.lang.builder.ToStringBuilder\\s*;", true, true, METHOD_TOSTRING_SIG, false);
        oldFilePath = newFilePath;
        temp = File.createTempFile("clsaug", ".tmp");
        temp.deleteOnExit();
        newFilePath = temp.getAbsolutePath();
        boundaries = JavaParser.getMethodBoundaries(oldFilePath);
        this.SubstituteFunctionBody(newFilePath, oldFilePath, boundaries, "hashCode", this.getHashCodeBody(clazz), "import org.apache.commons.lang.builder.HashCodeBuilder;\n", "^\\s*import\\s*org.apache.commons.lang.builder.HashCodeBuilder\\s*;", true, true, METHOD_HASHCODE_SIG, false);
        oldFilePath = newFilePath;
        newFilePath = new File(outDirPath, clazz.getSimpleName() + ".java").getAbsolutePath();
        boundaries = JavaParser.getMethodBoundaries(oldFilePath);
        this.SubstituteFunctionBody(newFilePath, oldFilePath, boundaries, "equals", this.getEqualsBody(clazz), "import org.apache.commons.lang.builder.EqualsBuilder;\n", "^\\s*import\\s*org.apache.commons.lang.builder.EqualsBuilder\\s*;", true, true, METHOD_EQUALS_SIG, true);
        oldFilePath = newFilePath;
    }

    public static void main(String[] argv) {
        ClassAugmenter classAugmenter = new ClassAugmenter();
        Map<String, String> argMap = classAugmenter.loadArguments(argv);
        if (argv == null || argv.length == 0 || argMap.containsKey("h")) {
            ClassAugmenter.usage();
            return;
        }
        String pkg = argMap.get("p");
        String srcDirPath = argMap.get("s");
        String outDirPath = argMap.get("o");
        new File(outDirPath).mkdirs();
        String srcFilePath = argMap.get("f");
        String toStringDataFilePath = argMap.get("d");
        classAugmenter.loadToStringDataFile(toStringDataFilePath);
        StringBuffer sbHintOut = new StringBuffer();
        sbHintOut.append(TOSTRING_HINT_FILE_HEADER);
        if (srcFilePath != null && srcFilePath.length() > 0) {
            if (srcFilePath.endsWith(".java")) {
                srcFilePath = srcFilePath.substring(0, srcFilePath.length() - 5);
            }
            String classPath = srcFilePath.concat(".class");
            File inFile = new File(srcDirPath, srcFilePath);
            System.out.println("Processing file : (" + inFile.getAbsolutePath() + ")");
            try {
                classAugmenter.processFile(srcFilePath, Class.forName(classPath), outDirPath, sbHintOut);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            String relPath = pkg.replace(".", "/");
            File inDir = new File(srcDirPath, relPath);
            ArrayList<String> fileList = new ArrayList<String>(Arrays.asList(inDir.list()));
            Collections.sort(fileList);
            Iterator iterator = fileList.iterator();
            while (iterator.hasNext()) {
                String curFilePath;
                srcFilePath = curFilePath = (String)iterator.next();
                String baseName = curFilePath;
                if (baseName.endsWith(".java")) {
                    baseName = baseName.substring(0, baseName.length() - 5);
                }
                String classPath = String.format("%s%s%s", pkg != null && pkg.length() > 0 ? pkg : "", pkg != null && pkg.length() > 0 ? "." : "", baseName);
                relPath = srcFilePath.replace(".", "/");
                File inFile = new File(inDir, srcFilePath);
                System.out.println("Processing file : (" + inFile.getAbsolutePath() + ")");
                try {
                    if (!inFile.isFile()) continue;
                    classAugmenter.processFile(inFile.getAbsolutePath(), Class.forName(classPath), outDirPath, sbHintOut);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        String outHintFilePath = new File(outDirPath, new File(toStringDataFilePath).getName()).getAbsolutePath();
        ClassAugmenter.saveBytesToFile(outHintFilePath, sbHintOut.toString().getBytes());
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] readTextContentFromFile(File file) {
        ArrayList<String> contents = new ArrayList<String>();
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.add(line);
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return contents.toArray(new String[0]);
    }

    private Field getFieldFromArray(Field[] fields, String name) {
        int count;
        int n = count = fields != null ? fields.length : 0;
        for (int i = 0; i < count; ++i) {
            if (!fields[i].getName().equalsIgnoreCase(name)) continue;
            return fields[i];
        }
        return null;
    }

    private String getLabelFromName(String given) {
        StringBuilder sb = new StringBuilder();
        if (given.startsWith("m_")) {
            given = given.substring(2);
        } else if (given.startsWith("_")) {
            given = given.substring(1);
        }
        sb.append(given.substring(0, 1).toUpperCase());
        boolean spaceAdded = true;
        int count = given.length();
        for (int i = 1; i < count; ++i) {
            String current = given.substring(i, i + 1);
            if (current.equals(current.toLowerCase())) {
                spaceAdded = false;
            } else if (!spaceAdded) {
                sb.append(" ");
                spaceAdded = true;
            }
            sb.append(current);
        }
        return sb.toString();
    }

    private String getLabel(Field field) {
        return this.getLabelFromName(field.getName());
    }

    private String getToStringBody(Class clazz, StringBuffer sbHintOut) {
        StringBuilder sb = new StringBuilder();
        sb.append(NEW_LINE).append(INDENT_STR).append(INDENT_STR).append("return new ToStringBuilder(this, Config.getInstance().getToStringStyle())");
        Class superClazz = clazz.getSuperclass();
        if (superClazz != null && !superClazz.equals(Object.class)) {
            sb.append(NEW_LINE).append(INDENT_STR).append(INDENT_STR).append(INDENT_STR).append(".appendSuper(super.toString())");
        }
        Field[] fields = clazz.getDeclaredFields();
        ToStringHintData hint = this.hintDataMap.get(clazz.getName());
        if (hint == null) {
            hint = this.hintDataMap.get(clazz.getSimpleName());
        }
        boolean hasAnyToStrFields = false;
        StringBuffer sbHintLine = new StringBuffer();
        if (hint != null) {
            sbHintLine.append(String.format("%-56s| %-6s| ", clazz.getName(), hint.isSortOnLabel() ? "true" : "false"));
            Map<String, String> lnMap = hint.getLabelNameMap();
            Set<String> labels = lnMap.keySet();
            if (hint.isSortOnLabel()) {
                labels = new TreeSet<String>(labels);
            }
            for (String label : labels) {
                String fieldName = lnMap.get(label);
                Field field = this.getFieldFromArray(fields, fieldName);
                if (field == null || Modifier.isStatic(field.getModifiers())) continue;
                hasAnyToStrFields = true;
                String exprForField = String.format(".append(\"%s\", %s)", label, fieldName);
                sb.append(NEW_LINE).append(INDENT_STR).append(INDENT_STR).append(INDENT_STR).append(exprForField);
                sbHintLine.append(String.format("%s/%s;", label, fieldName));
            }
        } else {
            sbHintLine.append(String.format("#%-55s| %-6s| ", clazz.getName(), "true"));
            int count = fields.length;
            for (int i = 0; i < count; ++i) {
                if (Modifier.isStatic(fields[i].getModifiers())) continue;
                hasAnyToStrFields = true;
                String label = this.getLabel(fields[i]);
                String fieldName = fields[i].getName();
                String exprForField = String.format(".append(\"%s\", %s)", label, fieldName);
                sb.append(NEW_LINE).append(INDENT_STR).append(INDENT_STR).append(INDENT_STR).append(exprForField);
                sbHintLine.append(String.format("%s/%s;", label, fieldName));
            }
        }
        sb.append(".toString();").append(NEW_LINE);
        sbHintLine.append(NEW_LINE);
        if (hasAnyToStrFields) {
            sbHintOut.append(sbHintLine.toString());
        }
        return sb.toString();
    }

    private String getHashCodeBody(Class clazz) {
        StringBuilder sb = new StringBuilder();
        sb.append(NEW_LINE).append(INDENT_STR).append(INDENT_STR).append("return new HashCodeBuilder(17, 37)");
        Field[] fields = clazz.getDeclaredFields();
        Class superClazz = clazz.getSuperclass();
        if (superClazz != null && !superClazz.equals(Object.class)) {
            sb.append(NEW_LINE).append(INDENT_STR).append(INDENT_STR).append(INDENT_STR).append(".appendSuper(super.hashCode())");
        }
        int count = fields.length;
        for (int i = 0; i < count; ++i) {
            if (Modifier.isStatic(fields[i].getModifiers())) continue;
            String exprForField = String.format(".append(%s)", fields[i].getName());
            sb.append(NEW_LINE).append(INDENT_STR).append(INDENT_STR).append(INDENT_STR).append(exprForField);
        }
        sb.append(".toHashCode();").append(NEW_LINE);
        return sb.toString();
    }

    private String getEqualsBody(Class clazz) {
        StringBuilder sb = new StringBuilder();
        sb.append(NEW_LINE).append(String.format(EQUALS_HEADER_SNIPPET, clazz.getSimpleName()));
        sb.append(NEW_LINE).append(INDENT_STR).append(INDENT_STR).append("return new EqualsBuilder()");
        Field[] fields = clazz.getDeclaredFields();
        Class superClazz = clazz.getSuperclass();
        if (superClazz != null && !superClazz.equals(Object.class)) {
            sb.append(NEW_LINE).append(INDENT_STR).append(INDENT_STR).append(INDENT_STR).append(".appendSuper(super.equals())");
        }
        int count = fields.length;
        for (int i = 0; i < count; ++i) {
            if (Modifier.isStatic(fields[i].getModifiers())) continue;
            String exprForField = String.format(".append(%1$s, rhs.%1$s)", fields[i].getName());
            sb.append(NEW_LINE).append(INDENT_STR).append(INDENT_STR).append(INDENT_STR).append(exprForField);
        }
        sb.append(".isEquals();").append(NEW_LINE);
        return sb.toString();
    }

    private int[] getMethodBoundary(Map<String, String> boundaries, String methodName) {
        int[] boundary = null;
        if (boundaries.containsKey(methodName)) {
            String val = boundaries.get(methodName);
            String[] tokens = val.split(";");
            boundary = new int[]{Integer.parseInt(tokens[0]), Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]), Integer.parseInt(tokens[3])};
            return boundary;
        }
        return boundary;
    }

    private void SubstituteFunctionBody(String newFilePath, String origFilePath, Map<String, String> boundaries, String methodName, String newMethodBody, String importSnippet, String importRegEx, boolean addIfMissing, boolean ignoreIfPresent, String newSigLine, boolean useNewSigLine) {
        int methStartCol;
        int methStartLine;
        String[] lines;
        int[] importInsertAt = this.getMethodBoundary(boundaries, "<Import>");
        if (importInsertAt == null) {
            importInsertAt = this.getMethodBoundary(boundaries, "<Package>");
        }
        if ((lines = this.readTextContentFromFile(new File(origFilePath))) == null || lines.length == 0) {
            System.err.println("ERROR: Could not load the file contents. Skipping file (" + origFilePath + ")");
        }
        boolean bImportSnippetFound = false;
        if (importSnippet != null && importSnippet.length() > 0) {
            if (importRegEx == null || importRegEx.length() == 0) {
                importRegEx = "^" + importSnippet;
            }
            Pattern pattern = Pattern.compile(importRegEx, 8);
            for (String line : lines) {
                if (!pattern.matcher(line).matches()) continue;
                bImportSnippetFound = true;
                break;
            }
        }
        StringBuilder sb = new StringBuilder();
        int[] methodBoundary = this.getMethodBoundary(boundaries, methodName);
        if (methodBoundary != null) {
            int i;
            System.out.println(String.format("Found %s method...", methodName));
            methStartLine = methodBoundary[0] - 1;
            methStartCol = methodBoundary[1];
            int methEndLine = methodBoundary[2] - 1;
            int methEndCol = methodBoundary[3];
            int count = importInsertAt[0];
            for (i = 0; i < count; ++i) {
                sb.append(lines[i]).append(System.getProperty("line.separator"));
            }
            if (!bImportSnippetFound) {
                sb.append(importSnippet);
            }
            count = methStartLine;
            for (i = importInsertAt[0]; i < count; ++i) {
                sb.append(lines[i]).append(System.getProperty("line.separator"));
            }
            if (useNewSigLine) {
                sb.append(newSigLine);
            } else {
                sb.append(lines[methStartLine].substring(0, methStartCol));
            }
            sb.append(newMethodBody);
            sb.append(INDENT_STR);
            sb.append(lines[methEndLine].substring(methEndCol - 1));
            sb.append(NEW_LINE);
            count = lines.length;
            for (i = methEndLine + 1; i < count; ++i) {
                sb.append(lines[i]).append(System.getProperty("line.separator"));
            }
            ClassAugmenter.saveBytesToFile(newFilePath, sb.toString().getBytes());
        } else {
            int i;
            System.out.println(String.format("Not Found %s method...", methodName));
            methodBoundary = this.getMethodBoundary(boundaries, "<ClassEnd>");
            methStartLine = methodBoundary[0] - 1;
            methStartCol = methodBoundary[1];
            int count = importInsertAt[0];
            for (i = 0; i < count; ++i) {
                sb.append(lines[i]).append(System.getProperty("line.separator"));
            }
            if (!bImportSnippetFound) {
                sb.append(importSnippet);
            }
            count = methStartLine;
            for (i = importInsertAt[0]; i < count; ++i) {
                sb.append(lines[i]).append(System.getProperty("line.separator"));
            }
            sb.append(newSigLine);
            sb.append(newMethodBody);
            sb.append(METHOD_BODY_END);
            sb.append(lines[methStartLine].substring(methStartCol - 1));
            sb.append(NEW_LINE);
            ClassAugmenter.saveBytesToFile(newFilePath, sb.toString().getBytes());
        }
    }

    public static void saveBytesToFile(String filePath, byte[] buffer) {
        try {
            FileOutputStream fos = new FileOutputStream(filePath);
            fos.write(buffer);
            fos.flush();
            fos.close();
        }
        catch (IOException iOException) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }
}

