/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5.impl.http;

import com.kaazing.gateway.client.html5.impl.Channel;
import com.kaazing.gateway.client.html5.impl.http.HttpRequestFactory;
import com.kaazing.gateway.client.html5.impl.http.HttpResponse;
import com.kaazing.gateway.client.html5.util.HttpURI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class HttpRequest {
    private static final String CLASS_NAME = HttpRequest.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    public static final HttpRequestFactory HTTP_REQUEST_FACTORY = new HttpRequestFactory(){

        @Override
        public HttpRequest createHttpRequest(Method method, HttpURI uri, boolean async) {
            return new HttpRequest(method, uri, async);
        }
    };
    private ReadyState readyState = ReadyState.UNSENT;
    private Method method;
    private HttpURI uri;
    private boolean async;
    private Map<String, String> headers = new HashMap<String, String>();
    private HttpResponse response;
    public Channel parent;
    private Object proxy;

    public HttpRequest(Method method, HttpURI uri) {
        this(method, uri, true);
    }

    public HttpRequest(Method method, HttpURI uri, boolean async) {
        if (uri == null) {
            LOG.severe("HTTP request URL is null");
            throw new IllegalArgumentException("HTTP request URL is null");
        }
        if (method == null) {
            LOG.severe("Invalid Method in an HTTP request");
            throw new IllegalArgumentException("Invalid Method in an HTTP request");
        }
        this.method = method;
        this.uri = uri;
        this.async = async;
    }

    public Method getMethod() {
        return this.method;
    }

    public HttpURI getUri() {
        return this.uri;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setReadyState(ReadyState readyState) {
        this.readyState = readyState;
    }

    public ReadyState getReadyState() {
        return this.readyState;
    }

    public void setHeader(String header, String value) {
        this.headers.put(header, value);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpResponse response) {
        this.response = response;
    }

    public Object getProxy() {
        return this.proxy;
    }

    public void setProxy(Object proxy) {
        this.proxy = proxy;
    }

    public String toString() {
        return "[Request " + (Object)((Object)this.method) + " " + this.uri + " async:" + this.async + "]";
    }

    public static enum Method {
        GET,
        POST;

    }

    public static enum ReadyState {
        UNSENT,
        READY,
        SENDING,
        SENT,
        OPENED,
        LOADING,
        LOADED,
        ERROR;

    }
}

