/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.scheduling.annotation;

import com.bmc.thirdparty.org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import com.bmc.thirdparty.org.springframework.beans.factory.annotation.Autowired;
import com.bmc.thirdparty.org.springframework.context.annotation.Configuration;
import com.bmc.thirdparty.org.springframework.context.annotation.ImportAware;
import com.bmc.thirdparty.org.springframework.core.annotation.AnnotationAttributes;
import com.bmc.thirdparty.org.springframework.core.type.AnnotationMetadata;
import com.bmc.thirdparty.org.springframework.scheduling.annotation.AsyncConfigurer;
import com.bmc.thirdparty.org.springframework.scheduling.annotation.EnableAsync;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.CollectionUtils;
import java.util.Collection;
import java.util.concurrent.Executor;

@Configuration
public abstract class AbstractAsyncConfiguration
implements ImportAware {
    protected AnnotationAttributes enableAsync;
    protected Executor executor;
    protected AsyncUncaughtExceptionHandler exceptionHandler;

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableAsync = AnnotationAttributes.fromMap(importMetadata.getAnnotationAttributes(EnableAsync.class.getName(), false));
        Assert.notNull(this.enableAsync, "@EnableAsync is not present on importing class " + importMetadata.getClassName());
    }

    @Autowired(required=false)
    void setConfigurers(Collection<AsyncConfigurer> configurers) {
        if (CollectionUtils.isEmpty(configurers)) {
            return;
        }
        if (configurers.size() > 1) {
            throw new IllegalStateException("Only one AsyncConfigurer may exist");
        }
        AsyncConfigurer configurer = configurers.iterator().next();
        this.executor = configurer.getAsyncExecutor();
        this.exceptionHandler = configurer.getAsyncUncaughtExceptionHandler();
    }
}

