/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jmx.export.annotation;

import com.bmc.thirdparty.org.springframework.beans.annotation.AnnotationBeanUtils;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanFactoryAware;
import com.bmc.thirdparty.org.springframework.beans.factory.config.ConfigurableBeanFactory;
import com.bmc.thirdparty.org.springframework.core.annotation.AnnotationUtils;
import com.bmc.thirdparty.org.springframework.jmx.export.annotation.ManagedAttribute;
import com.bmc.thirdparty.org.springframework.jmx.export.annotation.ManagedMetric;
import com.bmc.thirdparty.org.springframework.jmx.export.annotation.ManagedNotification;
import com.bmc.thirdparty.org.springframework.jmx.export.annotation.ManagedNotifications;
import com.bmc.thirdparty.org.springframework.jmx.export.annotation.ManagedOperation;
import com.bmc.thirdparty.org.springframework.jmx.export.annotation.ManagedOperationParameter;
import com.bmc.thirdparty.org.springframework.jmx.export.annotation.ManagedOperationParameters;
import com.bmc.thirdparty.org.springframework.jmx.export.annotation.ManagedResource;
import com.bmc.thirdparty.org.springframework.jmx.export.metadata.InvalidMetadataException;
import com.bmc.thirdparty.org.springframework.jmx.export.metadata.JmxAttributeSource;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import com.bmc.thirdparty.org.springframework.util.StringValueResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class AnnotationJmxAttributeSource
implements JmxAttributeSource,
BeanFactoryAware {
    private StringValueResolver embeddedValueResolver;

    @Override
    public void setBeanFactory(final BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.embeddedValueResolver = new StringValueResolver(){

                @Override
                public String resolveStringValue(String strVal) {
                    return ((ConfigurableBeanFactory)beanFactory).resolveEmbeddedValue(strVal);
                }
            };
        }
    }

    @Override
    public com.bmc.thirdparty.org.springframework.jmx.export.metadata.ManagedResource getManagedResource(Class<?> beanClass) throws InvalidMetadataException {
        ManagedResource ann = beanClass.getAnnotation(ManagedResource.class);
        if (ann == null) {
            return null;
        }
        com.bmc.thirdparty.org.springframework.jmx.export.metadata.ManagedResource managedResource = new com.bmc.thirdparty.org.springframework.jmx.export.metadata.ManagedResource();
        AnnotationBeanUtils.copyPropertiesToBean((Annotation)ann, (Object)managedResource, this.embeddedValueResolver, new String[0]);
        if (!"".equals(ann.value()) && !StringUtils.hasLength(managedResource.getObjectName())) {
            String value = ann.value();
            if (this.embeddedValueResolver != null) {
                value = this.embeddedValueResolver.resolveStringValue(value);
            }
            managedResource.setObjectName(value);
        }
        return managedResource;
    }

    @Override
    public com.bmc.thirdparty.org.springframework.jmx.export.metadata.ManagedAttribute getManagedAttribute(Method method) throws InvalidMetadataException {
        ManagedAttribute ann = AnnotationUtils.findAnnotation(method, ManagedAttribute.class);
        if (ann == null) {
            return null;
        }
        com.bmc.thirdparty.org.springframework.jmx.export.metadata.ManagedAttribute managedAttribute = new com.bmc.thirdparty.org.springframework.jmx.export.metadata.ManagedAttribute();
        AnnotationBeanUtils.copyPropertiesToBean((Annotation)ann, (Object)managedAttribute, "defaultValue");
        if (ann.defaultValue().length() > 0) {
            managedAttribute.setDefaultValue(ann.defaultValue());
        }
        return managedAttribute;
    }

    @Override
    public com.bmc.thirdparty.org.springframework.jmx.export.metadata.ManagedMetric getManagedMetric(Method method) throws InvalidMetadataException {
        ManagedMetric ann = AnnotationUtils.findAnnotation(method, ManagedMetric.class);
        if (ann == null) {
            return null;
        }
        com.bmc.thirdparty.org.springframework.jmx.export.metadata.ManagedMetric managedMetric = new com.bmc.thirdparty.org.springframework.jmx.export.metadata.ManagedMetric();
        AnnotationBeanUtils.copyPropertiesToBean((Annotation)ann, (Object)managedMetric, new String[0]);
        return managedMetric;
    }

    @Override
    public com.bmc.thirdparty.org.springframework.jmx.export.metadata.ManagedOperation getManagedOperation(Method method) throws InvalidMetadataException {
        ManagedOperation ann = AnnotationUtils.findAnnotation(method, ManagedOperation.class);
        if (ann == null) {
            return null;
        }
        com.bmc.thirdparty.org.springframework.jmx.export.metadata.ManagedOperation op = new com.bmc.thirdparty.org.springframework.jmx.export.metadata.ManagedOperation();
        AnnotationBeanUtils.copyPropertiesToBean((Annotation)ann, (Object)op, new String[0]);
        return op;
    }

    @Override
    public com.bmc.thirdparty.org.springframework.jmx.export.metadata.ManagedOperationParameter[] getManagedOperationParameters(Method method) throws InvalidMetadataException {
        ManagedOperationParameters params = AnnotationUtils.findAnnotation(method, ManagedOperationParameters.class);
        com.bmc.thirdparty.org.springframework.jmx.export.metadata.ManagedOperationParameter[] result = null;
        if (params == null) {
            result = new com.bmc.thirdparty.org.springframework.jmx.export.metadata.ManagedOperationParameter[]{};
        } else {
            ManagedOperationParameter[] paramData = params.value();
            result = new com.bmc.thirdparty.org.springframework.jmx.export.metadata.ManagedOperationParameter[paramData.length];
            for (int i = 0; i < paramData.length; ++i) {
                ManagedOperationParameter annotation = paramData[i];
                com.bmc.thirdparty.org.springframework.jmx.export.metadata.ManagedOperationParameter managedOperationParameter = new com.bmc.thirdparty.org.springframework.jmx.export.metadata.ManagedOperationParameter();
                AnnotationBeanUtils.copyPropertiesToBean((Annotation)annotation, (Object)managedOperationParameter, new String[0]);
                result[i] = managedOperationParameter;
            }
        }
        return result;
    }

    @Override
    public com.bmc.thirdparty.org.springframework.jmx.export.metadata.ManagedNotification[] getManagedNotifications(Class<?> clazz) throws InvalidMetadataException {
        ManagedNotifications notificationsAnn = clazz.getAnnotation(ManagedNotifications.class);
        if (notificationsAnn == null) {
            return new com.bmc.thirdparty.org.springframework.jmx.export.metadata.ManagedNotification[0];
        }
        ManagedNotification[] notifications = notificationsAnn.value();
        com.bmc.thirdparty.org.springframework.jmx.export.metadata.ManagedNotification[] result = new com.bmc.thirdparty.org.springframework.jmx.export.metadata.ManagedNotification[notifications.length];
        for (int i = 0; i < notifications.length; ++i) {
            ManagedNotification notification = notifications[i];
            com.bmc.thirdparty.org.springframework.jmx.export.metadata.ManagedNotification managedNotification = new com.bmc.thirdparty.org.springframework.jmx.export.metadata.ManagedNotification();
            AnnotationBeanUtils.copyPropertiesToBean((Annotation)notification, (Object)managedNotification, new String[0]);
            result[i] = managedNotification;
        }
        return result;
    }
}

