/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.core.annotation;

import com.bmc.thirdparty.org.springframework.core.annotation.AnnotationUtils;
import com.bmc.thirdparty.org.springframework.core.annotation.Order;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import java.lang.annotation.Annotation;

public abstract class OrderUtils {
    private static Class<? extends Annotation> priorityAnnotationType = null;

    public static Integer getOrder(Class<?> type) {
        return OrderUtils.getOrder(type, null);
    }

    public static Integer getOrder(Class<?> type, Integer defaultOrder) {
        Order order = AnnotationUtils.findAnnotation(type, Order.class);
        if (order != null) {
            return order.value();
        }
        Integer priorityOrder = OrderUtils.getPriority(type);
        if (priorityOrder != null) {
            return priorityOrder;
        }
        return defaultOrder;
    }

    public static Integer getPriority(Class<?> type) {
        Annotation priority;
        if (priorityAnnotationType != null && (priority = AnnotationUtils.findAnnotation(type, priorityAnnotationType)) != null) {
            return (Integer)AnnotationUtils.getValue(priority);
        }
        return null;
    }

    static {
        try {
            priorityAnnotationType = ClassUtils.forName("javax.annotation.Priority", OrderUtils.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

