/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.context.access;

import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.beans.factory.access.BeanFactoryLocator;
import com.bmc.thirdparty.org.springframework.beans.factory.access.BeanFactoryReference;
import com.bmc.thirdparty.org.springframework.beans.factory.access.BootstrapException;
import com.bmc.thirdparty.org.springframework.context.ApplicationContext;
import com.bmc.thirdparty.org.springframework.context.access.ContextBeanFactoryReference;
import com.bmc.thirdparty.org.springframework.context.support.ClassPathXmlApplicationContext;
import com.bmc.thirdparty.org.springframework.jndi.JndiLocatorSupport;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import javax.naming.NamingException;

public class ContextJndiBeanFactoryLocator
extends JndiLocatorSupport
implements BeanFactoryLocator {
    public static final String BEAN_FACTORY_PATH_DELIMITERS = ",; \t\n";

    @Override
    public BeanFactoryReference useBeanFactory(String factoryKey) throws BeansException {
        try {
            String beanFactoryPath = this.lookup(factoryKey, String.class);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Bean factory path from JNDI environment variable [" + factoryKey + "] is: " + beanFactoryPath);
            }
            String[] paths = StringUtils.tokenizeToStringArray(beanFactoryPath, BEAN_FACTORY_PATH_DELIMITERS);
            return this.createBeanFactory(paths);
        }
        catch (NamingException ex) {
            throw new BootstrapException("Define an environment variable [" + factoryKey + "] containing " + "the class path locations of XML bean definition files", ex);
        }
    }

    protected BeanFactoryReference createBeanFactory(String[] resources) throws BeansException {
        ApplicationContext ctx = this.createApplicationContext(resources);
        return new ContextBeanFactoryReference(ctx);
    }

    protected ApplicationContext createApplicationContext(String[] resources) throws BeansException {
        return new ClassPathXmlApplicationContext(resources);
    }
}

