/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arencrypt;

import com.bmc.arsys.arencrypt.ARCryptoConstants;
import com.bmc.arsys.arencrypt.ARDataKey;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.ARKeyMask;
import com.bmc.arsys.arencrypt.ARMdCrypto;
import com.bmc.arsys.arencrypt.SymmetricCipherBase;
import com.bmc.arsys.utils.ARCommonConfig;
import com.bmc.arsys.utils.LogBytes;
import com.bmc.arsys.utils.StringByteUtil;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class CharDataEncryption
extends SymmetricCipherBase {
    private transient boolean embedCRC;
    private transient ARDataKey encKey;
    private transient int keyLen = 8;
    private int MINIMUM_KEY_SIZE = 16;
    private static Logger logger = Logger.getLogger(CharDataEncryption.class);

    @Override
    protected boolean isDebugEnabled() {
        return ARCommonConfig.getInstance().getLogBytes() && logger.isDebugEnabled();
    }

    public CharDataEncryption(boolean CRCFlag, boolean debug) {
        super(debug);
        this.embedCRC = CRCFlag;
    }

    public CharDataEncryption(boolean debug) {
        super(debug);
        this.embedCRC = true;
    }

    protected void prepareDataKey(byte[] passwordKeyForEncryption) {
        int encAlgorithm = 1;
        this.encKey = new ARDataKey();
        this.encKey.setEncAlgorithm(encAlgorithm);
        this.encKey.setEncAlgorithmStr(ARCryptoConstants.AR_DATA_ENC_ALG_STR[encAlgorithm - 1]);
        this.encKey.setEncType(ARCryptoConstants.AR_DATA_ENC_TYPE[encAlgorithm - 1]);
        this.encKey.setEncXForm(ARCryptoConstants.AR_DATA_ENC_XFORM[encAlgorithm - 1]);
        this.encKey.setEncMode(1);
        this.encKey.setKeySize(ARCryptoConstants.AR_DATA_ENC_ENC_BITS[encAlgorithm - 1]);
        this.encKey.setKey(StringByteUtil.resizeByteArray(passwordKeyForEncryption, this.keyLen));
        this.encKey.setIv(StringByteUtil.getOctetKey(passwordKeyForEncryption));
        boolean macMasked = true;
        this.encKey.setMacKey(ARKeyMask.getMaskedKeyBytes(0, ARKeyMask.Idx.M, macMasked));
        this.encKey.setMacMasked(macMasked);
    }

    public byte[] encryptCharData(byte[] bufToEncrypt) throws AREncryptionException {
        if (bufToEncrypt == null) {
            throw new AREncryptionException(9015);
        }
        byte[] encryptedData = this.encryptData(bufToEncrypt);
        return StringByteUtil.base64Encode(encryptedData);
    }

    public byte[] decryptCharData(byte[] bufToDecrypt) throws AREncryptionException {
        if (bufToDecrypt == null) {
            throw new AREncryptionException(9015);
        }
        byte[] base64Decoded = StringByteUtil.base64Decode(bufToDecrypt);
        return this.decryptData(base64Decoded);
    }

    private byte[] encryptData(byte[] data) throws AREncryptionException {
        byte[] actualEncryptBuf = null;
        this.encKey.setEncMode(1);
        byte[] bufToEncrypte = null;
        actualEncryptBuf = this.setUpActualEncryptBuffer(data, this.getPadSize(data.length));
        bufToEncrypte = this.saltData(actualEncryptBuf);
        if (this.logFlag) {
            LogBytes.printByteArrayAsHex(bufToEncrypte, "ARCharDataEncryption.EncryptData- after saltData() saltedData");
        }
        byte[] encryptedCipher = this.encryptBuffer(this.encKey, bufToEncrypte);
        if (this.logFlag) {
            LogBytes.printByteArrayAsHex(encryptedCipher, "ARCharDataEncryption.EncryptData- encryptedCiper");
        }
        return this.embedCRC(encryptedCipher);
    }

    private byte[] embedCRC(byte[] encryptedCipher) throws AREncryptionException {
        byte[] rst;
        byte[] md = null;
        if (this.embedCRC) {
            ARMdCrypto mdCrypto = new ARMdCrypto();
            md = mdCrypto.MD5(encryptedCipher);
            if (this.logFlag) {
                LogBytes.printByteArrayAsHex(md, "ARCharDataEncryption.encryptData- md");
            }
        }
        if (md != null) {
            rst = StringByteUtil.concatenateByteArrays(md, encryptedCipher);
            if (this.logFlag) {
                LogBytes.printByteArrayAsHex(rst, "ARCharDataEncryption.encryptData- encryptedData");
            }
        } else {
            rst = encryptedCipher;
        }
        return rst;
    }

    private byte[] decryptData(byte[] data) throws AREncryptionException {
        this.encKey.setEncMode(2);
        byte[] bytesToDecrypt = this.verifyEmbedCRD(data);
        byte[] decryptedCipher = this.decryptBuffer(this.encKey, bytesToDecrypt);
        byte[] decryptedMessage = null;
        if (this.logFlag) {
            LogBytes.printByteArrayAsHex(decryptedCipher, "ARCharDataEncryption.decryptData- decryptedCiper before unsalt");
        }
        decryptedMessage = this.unsaltData(decryptedCipher);
        if (this.logFlag) {
            LogBytes.printByteArrayAsHex(decryptedMessage, "ARCharDataEncryption.decryptData- decryptedMessage");
        }
        return this.getPlainText(decryptedMessage);
    }

    private byte[] verifyEmbedCRD(byte[] data) throws AREncryptionException {
        byte[] bytesToDecrypt = null;
        byte[] md = null;
        if (this.embedCRC) {
            boolean expected;
            if (data.length < 16) {
                throw new AREncryptionException(9016);
            }
            ARMdCrypto mdCrypto = new ARMdCrypto();
            md = mdCrypto.MD5(data, 16, data.length - 16);
            if (this.logFlag) {
                LogBytes.printByteArrayAsHex(md, "ARCharDataEncryption.DecryptData- md");
            }
            byte[] passingMd = StringByteUtil.getByteArrays(data, 0, 16);
            if (this.logFlag) {
                LogBytes.printByteArrayAsHex(passingMd, "ARCharDataEncryption.decryptData- passingMd");
            }
            if (!(expected = Arrays.equals(md, passingMd))) {
                logger.error("CRC check md failed");
                throw new AREncryptionException(9016);
            }
            if (this.logFlag) {
                LogBytes.printByteArrayAsHex(data, "ARCharDataEncryption.DecryptData full data buffer");
            }
            bytesToDecrypt = StringByteUtil.getByteArrays(data, 16, data.length - 16);
        } else {
            bytesToDecrypt = data;
        }
        return bytesToDecrypt;
    }

    public void setPasswordKeyForEncryption(byte[] passwordKeyForEncryption) throws AREncryptionException {
        if (passwordKeyForEncryption.length < this.MINIMUM_KEY_SIZE) {
            throw new AREncryptionException(9014);
        }
        this.prepareDataKey(passwordKeyForEncryption);
    }

    public void setPasswordKeyForEncryption(int passwordKeyType) throws AREncryptionException {
        if (passwordKeyType > 1) {
            throw new AREncryptionException(9014);
        }
        this.prepareDataKey(ARCryptoConstants.AR_DEFN_LABEL_ENCR[passwordKeyType].getBytes());
    }

    public byte[] decryptWebServiceBody(byte[] bufToDecrypt) throws AREncryptionException {
        this.embedCRC = true;
        this.setPasswordKeyForEncryption(0);
        return this.decryptCharData(bufToDecrypt);
    }

    public byte[] encryptWebServiceBody(byte[] bufToEncrypt) throws AREncryptionException {
        this.embedCRC = true;
        this.setPasswordKeyForEncryption(0);
        return this.encryptCharData(bufToEncrypt);
    }
}

