/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.session;

import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.arrpc.ArStatusList6;
import com.bmc.arsys.arrpc.ArStatusStruct6;
import com.bmc.arsys.arrpc.xdr.ArRpcStatusList;
import com.bmc.arsys.arrpc.xdr.ArRpcXdrOut;
import java.util.ArrayList;

public class ArStatusInfo
extends ArrayList<StatusInfo> {
    private static final long serialVersionUID = -353534829550289562L;

    public ArStatusInfo() {
    }

    public ArStatusInfo(ArRpcStatusList statusList) {
        if (statusList instanceof ArStatusList6) {
            for (ArStatusStruct6 st : ((ArStatusList6)statusList).value) {
                this.add(new StatusInfo(st.getMessageType(), st.getMessageNum(), st.getMessageText(), st.getAppendedText()));
            }
        }
    }

    public void add(ArRpcXdrOut result) {
        if (result == null || result.getStatus() == null) {
            return;
        }
        this.add(result.getStatus());
    }

    public void add(ArRpcStatusList statusList) {
        if (statusList instanceof ArStatusList6) {
            for (ArStatusStruct6 st : ((ArStatusList6)statusList).value) {
                if (this.contains(st.getMessageNum())) continue;
                this.add(new StatusInfo(st.getMessageType(), st.getMessageNum(), st.getMessageText(), st.getAppendedText()));
            }
        }
    }

    public boolean contains(int msgNum) {
        return this.indexOf(msgNum) >= 0;
    }

    private int indexOf(int msgNum) {
        for (int i = 0; i < this.size(); ++i) {
            if ((long)msgNum != ((StatusInfo)this.get(i)).getMessageNum()) continue;
            return i;
        }
        return -1;
    }

    public int getMessageType() {
        int msgType = 0;
        if (this.size() > 0) {
            msgType = ((StatusInfo)this.get(0)).getMessageType();
        }
        return msgType;
    }

    public boolean hasError() {
        boolean error = false;
        if (this.getMessageType() >= 2) {
            error = true;
        }
        return error;
    }

    public boolean hasWarning() {
        boolean warning = false;
        if (this.getMessageType() >= 1) {
            warning = true;
        }
        return warning;
    }
}

