/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api.chunking;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.apitransport.chunking.ARChunkProcessorBase;
import com.bmc.arsys.apitransport.chunking.IARChunkSendable;
import com.bmc.arsys.arrpc.ArSetCreateSupportFile12In;
import com.bmc.arsys.arrpc.xdr.ArRpcXdrIn;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ARChunkSetCreateSupportFile
extends ARChunkProcessorBase
implements IARChunkSendable {
    private static Logger logger = Logger.getLogger(ARChunkSetCreateSupportFile.class);
    private long bytesRemaining;
    private String fileNamePath;
    private BufferedInputStream inputStream;
    private FileInputStream fileStream;

    @Override
    public void init(Object input) {
        this.fileNamePath = (String)input;
        logger.debug("Support File output path is " + this.fileNamePath);
    }

    @Override
    public void loadOneChunkToParamIn(int chunkResponseSize, ArRpcXdrIn params) throws ARException {
        int chunkSize = chunkResponseSize - 500;
        int currentChunkLen = 0;
        byte[] chunkData = null;
        try {
            if (this.inputStream == null) {
                File supportFile = new File(this.fileNamePath);
                this.bytesRemaining = supportFile.length();
                this.fileStream = new FileInputStream(supportFile);
                this.inputStream = new BufferedInputStream(this.fileStream);
                this.setChunkingDone(false, params.getControl());
            }
            if (this.bytesRemaining <= (long)chunkSize) {
                this.setChunkingDone(true, params.getControl());
                currentChunkLen = (int)this.bytesRemaining;
            } else {
                currentChunkLen = chunkSize;
            }
            chunkData = new byte[currentChunkLen];
            this.inputStream.read(chunkData, 0, currentChunkLen);
        }
        catch (IOException e) {
            throw new ARException(2, 295, e.getLocalizedMessage());
        }
        ((ArSetCreateSupportFile12In)params).setImportBuf(chunkData);
        this.bytesRemaining -= (long)currentChunkLen;
    }

    @Override
    public void end() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
                this.fileStream.close();
            }
            catch (IOException e) {
                logger.info("Cannot close the input stream for the support file " + this.fileNamePath);
            }
        }
    }
}

