/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.CriteriaFlags;
import com.bmc.arsys.api.ObjectBaseCriteria;
import com.bmc.arsys.api.ObjectPropertyMap;
import com.bmc.arsys.api.TaskCheckpoint;
import com.bmc.arsys.api.TaskCriteria;
import com.bmc.arsys.api.TaskInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;

class Task
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5267443100710297646L;
    private static Logger logger = Logger.getLogger(Task.class);
    private TaskInfo taskInfo;
    private String newName;
    private TaskCheckpoint baseObjVersions;
    private List<TaskCheckpoint> checkpointList;
    private CriteriaFlags m_changeFlags;
    protected Integer[] hashValues = null;

    protected Task() {
        this.taskInfo = new TaskInfo();
        this.newName = "";
        this.m_changeFlags = this.taskInfo.getChangeFlags();
    }

    public Task(String taskName, String description, ObjectPropertyMap propList) {
        this.taskInfo = new TaskInfo(taskName, description, propList);
        this.newName = "";
        this.m_changeFlags = this.taskInfo.getChangeFlags();
    }

    Task(String taskName, int taskId, int state, String description, ObjectPropertyMap propList) {
        this.taskInfo = new TaskInfo(taskName, taskId, state, description, propList);
        this.newName = "";
        this.m_changeFlags = this.taskInfo.getChangeFlags();
    }

    public Task(TaskInfo taskInfo) {
        this.taskInfo = taskInfo;
        this.newName = "";
        this.m_changeFlags = taskInfo.getChangeFlags();
    }

    public String getName() {
        return this.taskInfo.getName();
    }

    public void setName(String name) {
        this.taskInfo.setName(name);
    }

    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String newName) {
        this.newName = newName;
        this.m_changeFlags.setParameter(1L, true);
    }

    public Timestamp getLastUpdateTime() {
        return this.taskInfo.getLastUpdateTime();
    }

    protected void setLastUpdateTime(Timestamp lastUpdateTime) {
        this.taskInfo.setLastUpdateTime(lastUpdateTime);
    }

    public String getOwner() {
        return this.taskInfo.getOwner();
    }

    public void setOwner(String owner) {
        this.taskInfo.setOwner(owner);
    }

    public String getLastChangedBy() {
        return this.taskInfo.getLastChangedBy();
    }

    void setLastChangedBy(String lastChangedBy) {
        this.taskInfo.setLastChangedBy(lastChangedBy);
    }

    public int getTaskId() {
        return this.taskInfo.getTaskId();
    }

    void setTaskId(int taskId) {
        this.taskInfo.setTaskId(taskId);
    }

    public int getState() {
        return this.taskInfo.getState();
    }

    void setState(int state) {
        this.taskInfo.setState(state);
    }

    public String getDescription() {
        return this.taskInfo.getDescription();
    }

    public void setDescription(String description) {
        this.taskInfo.setDescription(description);
    }

    public ObjectPropertyMap getObjPropList() {
        return this.taskInfo.getObjPropList();
    }

    public void setObjPropList(ObjectPropertyMap objPropList) {
        this.taskInfo.setObjPropList(objPropList);
    }

    public List<TaskCheckpoint> getCheckpointList() {
        return this.checkpointList;
    }

    void setCheckpointList(List<TaskCheckpoint> checkpointList) {
        this.checkpointList = checkpointList;
        this.m_changeFlags.setParameter(10L, true);
    }

    void calculateChangeFlagsOnSet() {
        if (this.hashValues == null) {
            this.hashValues = new Integer[11];
        }
        this.taskInfo.calculateChangeFlagsOnSet();
    }

    void calculateHashCodeOnGet(CriteriaFlags criteria) {
        if (criteria == null) {
            criteria = new TaskCriteria();
        }
        ObjectBaseCriteria resetFlagCrit = null;
        if (criteria != null) {
            try {
                resetFlagCrit = (ObjectBaseCriteria)criteria.clone();
                resetFlagCrit.resetCriteriaFlags();
            }
            catch (CloneNotSupportedException e) {
                logger.debug(e);
            }
        }
        this.setChangeFlags(resetFlagCrit);
        this.calculateHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Task)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Task rhs = (Task)obj;
        return new EqualsBuilder().append(this.taskInfo, rhs.taskInfo).append(this.baseObjVersions, rhs.baseObjVersions).append(this.checkpointList, rhs.checkpointList).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.taskInfo.hashCode()).append(this.baseObjVersions).append(this.checkpointList).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append(this.taskInfo.toString()).append("Baseline ", this.baseObjVersions).append("Check Point List", this.checkpointList).toString();
    }

    void calculateHashCode() {
        if (this.hashValues == null) {
            this.hashValues = new Integer[11];
        }
        this.taskInfo.calculateHashCode();
        this.hashValues[9] = this.baseObjVersions != null ? Integer.valueOf(this.baseObjVersions.hashCode()) : null;
        this.hashValues[10] = this.checkpointList != null ? Integer.valueOf(this.checkpointList.hashCode()) : null;
    }

    protected void resetChangeFlags() {
        this.m_changeFlags.setRetrieveAll(false);
    }

    public void setChangeFlags(CriteriaFlags criteria) {
        try {
            this.taskInfo.setChangeFlags(criteria);
            this.m_changeFlags = (CriteriaFlags)(criteria != null ? criteria.clone() : null);
        }
        catch (CloneNotSupportedException e) {
            logger.debug(e);
        }
    }

    public CriteriaFlags getChangeFlags() {
        return this.m_changeFlags;
    }

    public TaskCheckpoint getBaseObjVersions() {
        return this.baseObjVersions;
    }

    void setBaseObjVersions(TaskCheckpoint baseObjVersions) {
        this.baseObjVersions = baseObjVersions;
    }
}

