/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARTimeUnit;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.ProxyManager;
import com.bmc.arsys.apitransport.ApiProxyI;
import com.bmc.arsys.apitransport.ApiUserContextI;
import com.bmc.arsys.apitransport.connection.ApiProxyPool;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.concurrent.locks.ReentrantLock;

class ProxyPool
extends ApiProxyPool
implements Serializable {
    private static final long serialVersionUID = 341311148943072838L;
    protected final ReentrantLock lock = new ReentrantLock();

    ProxyPool(int maxProxiesPerServer) {
        super(null, maxProxiesPerServer);
    }

    ProxyPool(String key, int maxProxiesPerServer) {
        super(key, maxProxiesPerServer);
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    protected ProxyManager.PoolInfo getInfo(String svrname) {
        int idleSize = this.getIdlePoolSize();
        int poolSize = this.getPoolSize();
        int maxSize = this.getMaximumPoolSize();
        int inUse = poolSize - idleSize;
        int notCreated = maxSize - poolSize;
        long established = this.getEstablishTime();
        long lastUsed = this.getLastUsed();
        int largestReachedPoolSize = this.getLargestPoolSize();
        ProxyManager.PoolInfo poolInfo = new ProxyManager.PoolInfo(svrname, inUse, idleSize, notCreated, established, lastUsed, largestReachedPoolSize, this.getMaxProxiesPerServer(), this.getIdleConnectionsPerServer(), ProxyManager.getConnectionTimeoutMilliSec(), ProxyManager.getConnectionLifespanMilliSec(), ARTimeUnit.MILLISECONDS);
        return poolInfo;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ProxyPool)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return new EqualsBuilder().appendSuper(super.equals(obj)).isEquals();
    }

    @Override
    protected ApiProxyI createProxy(ApiUserContextI context) throws ARException {
        return ProxyManager.getProxyManager().createProxy(context);
    }
}

